/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BlockFluidRenderer;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.ChestRenderer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.color.BlockColors;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.fluid.IFluidState;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;

public class BlockRendererDispatcher
implements IResourceManagerReloadListener {
    private final BlockModelShapes field_175028_a;
    private final BlockModelRenderer field_175027_c;
    private final ChestRenderer field_175024_d = new ChestRenderer();
    private final BlockFluidRenderer field_175025_e;
    private final Random field_195476_e = new Random();

    public BlockRendererDispatcher(BlockModelShapes blockModelShapes, BlockColors blockColors) {
        this.field_175028_a = blockModelShapes;
        this.field_175027_c = new BlockModelRenderer(blockColors);
        this.field_175025_e = new BlockFluidRenderer();
    }

    public BlockModelShapes func_175023_a() {
        return this.field_175028_a;
    }

    public void func_175020_a(IBlockState iBlockState, BlockPos blockPos, TextureAtlasSprite textureAtlasSprite, IWorldReader iWorldReader) {
        if (iBlockState.func_185901_i() != EnumBlockRenderType.MODEL) {
            return;
        }
        IBakedModel iBakedModel = this.field_175028_a.func_178125_b(iBlockState);
        long \u26032 = iBlockState.func_209533_a(blockPos);
        \u2603 = new SimpleBakedModel.Builder(iBlockState, iBakedModel, textureAtlasSprite, this.field_195476_e, \u26032).func_177645_b();
        this.field_175027_c.func_199324_a(iWorldReader, \u2603, iBlockState, blockPos, Tessellator.func_178181_a().func_178180_c(), true, this.field_195476_e, \u26032);
    }

    public boolean func_195475_a(IBlockState iBlockState, BlockPos blockPos, IWorldReader iWorldReader, BufferBuilder bufferBuilder, Random random) {
        try {
            EnumBlockRenderType enumBlockRenderType = iBlockState.func_185901_i();
            if (enumBlockRenderType == EnumBlockRenderType.INVISIBLE) {
                return false;
            }
            switch (enumBlockRenderType) {
                case MODEL: {
                    return this.field_175027_c.func_199324_a(iWorldReader, this.func_184389_a(iBlockState), iBlockState, blockPos, bufferBuilder, true, random, iBlockState.func_209533_a(blockPos));
                }
                case ENTITYBLOCK_ANIMATED: {
                    return false;
                }
            }
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, "Tesselating block in world");
            CrashReportCategory \u26032 = crashReport.func_85058_a("Block being tesselated");
            CrashReportCategory.func_175750_a(\u26032, blockPos, iBlockState);
            throw new ReportedException(crashReport);
        }
        return false;
    }

    public boolean func_205318_a(BlockPos blockPos, IWorldReader iWorldReader, BufferBuilder bufferBuilder, IFluidState iFluidState) {
        try {
            return this.field_175025_e.func_205346_a(iWorldReader, blockPos, bufferBuilder, iFluidState);
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, "Tesselating liquid in world");
            CrashReportCategory \u26032 = crashReport.func_85058_a("Block being tesselated");
            CrashReportCategory.func_175750_a(\u26032, blockPos, null);
            throw new ReportedException(crashReport);
        }
    }

    public BlockModelRenderer func_175019_b() {
        return this.field_175027_c;
    }

    public IBakedModel func_184389_a(IBlockState iBlockState) {
        return this.field_175028_a.func_178125_b(iBlockState);
    }

    public void func_175016_a(IBlockState iBlockState2, float f) {
        EnumBlockRenderType enumBlockRenderType = iBlockState2.func_185901_i();
        if (enumBlockRenderType == EnumBlockRenderType.INVISIBLE) {
            return;
        }
        switch (enumBlockRenderType) {
            case MODEL: {
                IBakedModel iBakedModel = this.func_184389_a(iBlockState2);
                this.field_175027_c.func_178266_a(iBakedModel, iBlockState2, f, true);
                break;
            }
            case ENTITYBLOCK_ANIMATED: {
                IBlockState iBlockState2;
                this.field_175024_d.func_178175_a(iBlockState2.func_177230_c(), f);
            }
        }
    }

    @Override
    public void func_195410_a(IResourceManager iResourceManager) {
        this.field_175025_e.func_178268_a();
    }
}

