/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.gson.JsonSyntaxException;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBed;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.MapItemRenderer;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.client.particle.ParticleManager;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.FirstPersonRenderer;
import net.minecraft.client.renderer.FogRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.culling.ClippingHelperImpl;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.shader.ShaderGroup;
import net.minecraft.client.shader.ShaderLinkHelper;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.monster.EntitySpider;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Blocks;
import net.minecraft.init.MobEffects;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.resources.SimpleResource;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ScreenShotHelper;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceFluidMode;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.GameType;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GameRenderer
implements AutoCloseable,
IResourceManagerReloadListener {
    private static final Logger field_147710_q = LogManager.getLogger();
    private static final ResourceLocation field_110924_q = new ResourceLocation("textures/environment/rain.png");
    private static final ResourceLocation field_110923_r = new ResourceLocation("textures/environment/snow.png");
    private final Minecraft field_78531_r;
    private final IResourceManager field_147711_ac;
    private final Random field_78537_ab = new Random();
    private float field_78530_s;
    public final FirstPersonRenderer field_78516_c;
    private final MapItemRenderer field_147709_v;
    private int field_78529_t;
    private Entity field_78528_u;
    private final float field_78490_B = 4.0f;
    private float field_78491_C = 4.0f;
    private float field_78507_R;
    private float field_78506_S;
    private float field_82831_U;
    private float field_82832_V;
    private boolean field_175074_C = true;
    private boolean field_175073_D = true;
    private long field_184374_E;
    private long field_78508_Y = Util.func_211177_b();
    private final LightTexture field_78513_d;
    private int field_78534_ac;
    private final float[] field_175076_N = new float[1024];
    private final float[] field_175077_O = new float[1024];
    private final FogRenderer field_205003_A;
    private boolean field_175078_W;
    private double field_78503_V = 1.0;
    private double field_78502_W;
    private double field_78509_X;
    private ItemStack field_190566_ab;
    private int field_190567_ac;
    private float field_190568_ad;
    private float field_190569_ae;
    private ShaderGroup field_147707_d;
    private float field_203000_X;
    private float field_203001_Y;
    private static final ResourceLocation[] field_147712_ad = new ResourceLocation[]{new ResourceLocation("shaders/post/notch.json"), new ResourceLocation("shaders/post/fxaa.json"), new ResourceLocation("shaders/post/art.json"), new ResourceLocation("shaders/post/bumpy.json"), new ResourceLocation("shaders/post/blobs2.json"), new ResourceLocation("shaders/post/pencil.json"), new ResourceLocation("shaders/post/color_convolve.json"), new ResourceLocation("shaders/post/deconverge.json"), new ResourceLocation("shaders/post/flip.json"), new ResourceLocation("shaders/post/invert.json"), new ResourceLocation("shaders/post/ntsc.json"), new ResourceLocation("shaders/post/outline.json"), new ResourceLocation("shaders/post/phosphor.json"), new ResourceLocation("shaders/post/scan_pincushion.json"), new ResourceLocation("shaders/post/sobel.json"), new ResourceLocation("shaders/post/bits.json"), new ResourceLocation("shaders/post/desaturate.json"), new ResourceLocation("shaders/post/green.json"), new ResourceLocation("shaders/post/blur.json"), new ResourceLocation("shaders/post/wobble.json"), new ResourceLocation("shaders/post/blobs.json"), new ResourceLocation("shaders/post/antialias.json"), new ResourceLocation("shaders/post/creeper.json"), new ResourceLocation("shaders/post/spider.json")};
    public static final int field_147708_e = field_147712_ad.length;
    private int field_147713_ae = field_147708_e;
    private boolean field_175083_ad;
    private int field_175084_ae;

    public GameRenderer(Minecraft minecraft, IResourceManager iResourceManager) {
        this.field_78531_r = minecraft;
        this.field_147711_ac = iResourceManager;
        this.field_78516_c = minecraft.func_175597_ag();
        this.field_147709_v = new MapItemRenderer(minecraft.func_110434_K());
        this.field_78513_d = new LightTexture(this);
        this.field_205003_A = new FogRenderer(this);
        this.field_147707_d = null;
        for (int i = 0; i < 32; ++i) {
            for (\u2603 = 0; \u2603 < 32; ++\u2603) {
                float f = \u2603 - 16;
                \u2603 = i - 16;
                \u2603 = MathHelper.func_76129_c(f * f + \u2603 * \u2603);
                this.field_175076_N[i << 5 | \u2603] = -\u2603 / \u2603;
                this.field_175077_O[i << 5 | \u2603] = f / \u2603;
            }
        }
    }

    @Override
    public void close() {
        this.field_78513_d.close();
        this.field_147709_v.close();
        this.func_181022_b();
    }

    public boolean func_147702_a() {
        return OpenGlHelper.field_148824_g && this.field_147707_d != null;
    }

    public void func_181022_b() {
        if (this.field_147707_d != null) {
            this.field_147707_d.close();
        }
        this.field_147707_d = null;
        this.field_147713_ae = field_147708_e;
    }

    public void func_175071_c() {
        this.field_175083_ad = !this.field_175083_ad;
    }

    public void func_175066_a(@Nullable Entity entity) {
        if (!OpenGlHelper.field_148824_g) {
            return;
        }
        if (this.field_147707_d != null) {
            this.field_147707_d.close();
        }
        this.field_147707_d = null;
        if (entity instanceof EntityCreeper) {
            this.func_175069_a(new ResourceLocation("shaders/post/creeper.json"));
        } else if (entity instanceof EntitySpider) {
            this.func_175069_a(new ResourceLocation("shaders/post/spider.json"));
        } else if (entity instanceof EntityEnderman) {
            this.func_175069_a(new ResourceLocation("shaders/post/invert.json"));
        }
    }

    private void func_175069_a(ResourceLocation resourceLocation) {
        if (this.field_147707_d != null) {
            this.field_147707_d.close();
        }
        try {
            this.field_147707_d = new ShaderGroup(this.field_78531_r.func_110434_K(), this.field_147711_ac, this.field_78531_r.func_147110_a(), resourceLocation);
            this.field_147707_d.func_148026_a(this.field_78531_r.field_195558_d.func_198109_k(), this.field_78531_r.field_195558_d.func_198091_l());
            this.field_175083_ad = true;
        }
        catch (IOException iOException) {
            field_147710_q.warn("Failed to load shader: {}", (Object)resourceLocation, (Object)iOException);
            this.field_147713_ae = field_147708_e;
            this.field_175083_ad = false;
        }
        catch (JsonSyntaxException jsonSyntaxException) {
            field_147710_q.warn("Failed to load shader: {}", (Object)resourceLocation, (Object)jsonSyntaxException);
            this.field_147713_ae = field_147708_e;
            this.field_175083_ad = false;
        }
    }

    @Override
    public void func_195410_a(IResourceManager iResourceManager) {
        if (this.field_147707_d != null) {
            this.field_147707_d.close();
        }
        this.field_147707_d = null;
        if (this.field_147713_ae == field_147708_e) {
            this.func_175066_a(this.field_78531_r.func_175606_aa());
        } else {
            this.func_175069_a(field_147712_ad[this.field_147713_ae]);
        }
    }

    public void func_78464_a() {
        if (OpenGlHelper.field_148824_g && ShaderLinkHelper.func_148074_b() == null) {
            ShaderLinkHelper.func_148076_a();
        }
        this.func_78477_e();
        this.field_78513_d.func_205107_a();
        this.field_78491_C = 4.0f;
        if (this.field_78531_r.func_175606_aa() == null) {
            this.field_78531_r.func_175607_a(this.field_78531_r.field_71439_g);
        }
        this.field_203001_Y = this.field_203000_X;
        this.field_203000_X += (this.field_78531_r.func_175606_aa().func_70047_e() - this.field_203000_X) * 0.5f;
        ++this.field_78529_t;
        this.field_78516_c.func_78441_a();
        this.func_78484_h();
        this.field_82832_V = this.field_82831_U;
        if (this.field_78531_r.field_71456_v.func_184046_j().func_184053_e()) {
            this.field_82831_U += 0.05f;
            if (this.field_82831_U > 1.0f) {
                this.field_82831_U = 1.0f;
            }
        } else if (this.field_82831_U > 0.0f) {
            this.field_82831_U -= 0.0125f;
        }
        if (this.field_190567_ac > 0) {
            --this.field_190567_ac;
            if (this.field_190567_ac == 0) {
                this.field_190566_ab = null;
            }
        }
    }

    public ShaderGroup func_147706_e() {
        return this.field_147707_d;
    }

    public void func_147704_a(int n, int n2) {
        if (!OpenGlHelper.field_148824_g) {
            return;
        }
        if (this.field_147707_d != null) {
            this.field_147707_d.func_148026_a(n, n2);
        }
        this.field_78531_r.field_71438_f.func_72720_a(n, n2);
    }

    public void func_78473_a(float f) {
        Entity entity = this.field_78531_r.func_175606_aa();
        if (entity == null) {
            return;
        }
        if (this.field_78531_r.field_71441_e == null) {
            return;
        }
        this.field_78531_r.field_71424_I.func_76320_a("pick");
        this.field_78531_r.field_147125_j = null;
        double \u26032 = this.field_78531_r.field_71442_b.func_78757_d();
        this.field_78531_r.field_71476_x = entity.func_174822_a(\u26032, f, RayTraceFluidMode.NEVER);
        Vec3d \u26033 = entity.func_174824_e(f);
        boolean \u26034 = false;
        int \u26035 = 3;
        double \u26036 = \u26032;
        if (this.field_78531_r.field_71442_b.func_78749_i()) {
            \u26032 = \u26036 = 6.0;
        } else {
            if (\u26036 > 3.0) {
                \u26034 = true;
            }
            \u26032 = \u26036;
        }
        if (this.field_78531_r.field_71476_x != null) {
            \u26036 = this.field_78531_r.field_71476_x.field_72307_f.func_72438_d(\u26033);
        }
        Vec3d \u26037 = entity.func_70676_i(1.0f);
        Vec3d \u26038 = \u26033.func_72441_c(\u26037.field_72450_a * \u26032, \u26037.field_72448_b * \u26032, \u26037.field_72449_c * \u26032);
        this.field_78528_u = null;
        Vec3d \u26039 = null;
        float \u260310 = 1.0f;
        List<Entity> \u260311 = this.field_78531_r.field_71441_e.func_175674_a(entity, entity.func_174813_aQ().func_72321_a(\u26037.field_72450_a * \u26032, \u26037.field_72448_b * \u26032, \u26037.field_72449_c * \u26032).func_72314_b(1.0, 1.0, 1.0), EntitySelectors.field_180132_d.and(Entity::func_70067_L));
        double \u260312 = \u26036;
        for (int i = 0; i < \u260311.size(); ++i) {
            Entity entity2 = \u260311.get(i);
            AxisAlignedBB \u260313 = entity2.func_174813_aQ().func_186662_g(entity2.func_70111_Y());
            RayTraceResult \u260314 = \u260313.func_72327_a(\u26033, \u26038);
            if (\u260313.func_72318_a(\u26033)) {
                if (!(\u260312 >= 0.0)) continue;
                this.field_78528_u = entity2;
                \u26039 = \u260314 == null ? \u26033 : \u260314.field_72307_f;
                \u260312 = 0.0;
                continue;
            }
            if (\u260314 == null || !((\u2603 = \u26033.func_72438_d(\u260314.field_72307_f)) < \u260312) && \u260312 != 0.0) continue;
            if (entity2.func_184208_bv() == entity.func_184208_bv()) {
                if (\u260312 != 0.0) continue;
                this.field_78528_u = entity2;
                \u26039 = \u260314.field_72307_f;
                continue;
            }
            this.field_78528_u = entity2;
            \u26039 = \u260314.field_72307_f;
            \u260312 = \u2603;
        }
        if (this.field_78528_u != null && \u26034 && \u26033.func_72438_d(\u26039) > 3.0) {
            this.field_78528_u = null;
            this.field_78531_r.field_71476_x = new RayTraceResult(RayTraceResult.Type.MISS, \u26039, null, new BlockPos(\u26039));
        }
        if (this.field_78528_u != null && (\u260312 < \u26036 || this.field_78531_r.field_71476_x == null)) {
            this.field_78531_r.field_71476_x = new RayTraceResult(this.field_78528_u, \u26039);
            if (this.field_78528_u instanceof EntityLivingBase || this.field_78528_u instanceof EntityItemFrame) {
                this.field_78531_r.field_147125_j = this.field_78528_u;
            }
        }
        this.field_78531_r.field_71424_I.func_76319_b();
    }

    private void func_78477_e() {
        float \u26032 = 1.0f;
        if (this.field_78531_r.func_175606_aa() instanceof AbstractClientPlayer) {
            AbstractClientPlayer abstractClientPlayer = (AbstractClientPlayer)this.field_78531_r.func_175606_aa();
            \u26032 = abstractClientPlayer.func_175156_o();
        }
        this.field_78506_S = this.field_78507_R;
        this.field_78507_R += (\u26032 - this.field_78507_R) * 0.5f;
        if (this.field_78507_R > 1.5f) {
            this.field_78507_R = 1.5f;
        }
        if (this.field_78507_R < 0.1f) {
            this.field_78507_R = 0.1f;
        }
    }

    private double func_195459_a(float f, boolean bl) {
        IFluidState iFluidState;
        if (this.field_175078_W) {
            return 90.0;
        }
        Entity entity = this.field_78531_r.func_175606_aa();
        double \u26032 = 70.0;
        if (bl) {
            \u26032 = this.field_78531_r.field_71474_y.field_74334_X;
            \u26032 *= (double)(this.field_78506_S + (this.field_78507_R - this.field_78506_S) * f);
        }
        if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_110143_aJ() <= 0.0f) {
            float f2 = (float)((EntityLivingBase)entity).field_70725_aQ + f;
            \u26032 /= (double)((1.0f - 500.0f / (f2 + 500.0f)) * 2.0f + 1.0f);
        }
        if (!(iFluidState = ActiveRenderInfo.func_206243_b(this.field_78531_r.field_71441_e, entity, f)).func_206888_e()) {
            \u26032 = \u26032 * 60.0 / 70.0;
        }
        return \u26032;
    }

    private void func_78482_e(float f) {
        if (this.field_78531_r.func_175606_aa() instanceof EntityLivingBase) {
            float \u26033;
            EntityLivingBase entityLivingBase = (EntityLivingBase)this.field_78531_r.func_175606_aa();
            float \u26032 = (float)entityLivingBase.field_70737_aN - f;
            if (entityLivingBase.func_110143_aJ() <= 0.0f) {
                \u26033 = (float)entityLivingBase.field_70725_aQ + f;
                GlStateManager.func_179114_b(40.0f - 8000.0f / (\u26033 + 200.0f), 0.0f, 0.0f, 1.0f);
            }
            if (\u26032 < 0.0f) {
                return;
            }
            \u26032 /= (float)entityLivingBase.field_70738_aO;
            \u26032 = MathHelper.func_76126_a(\u26032 * \u26032 * \u26032 * \u26032 * (float)Math.PI);
            \u26033 = entityLivingBase.field_70739_aP;
            GlStateManager.func_179114_b(-\u26033, 0.0f, 1.0f, 0.0f);
            GlStateManager.func_179114_b(-\u26032 * 14.0f, 0.0f, 0.0f, 1.0f);
            GlStateManager.func_179114_b(\u26033, 0.0f, 1.0f, 0.0f);
        }
    }

    private void func_78475_f(float f) {
        if (!(this.field_78531_r.func_175606_aa() instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer entityPlayer = (EntityPlayer)this.field_78531_r.func_175606_aa();
        float \u26032 = entityPlayer.field_70140_Q - entityPlayer.field_70141_P;
        float \u26033 = -(entityPlayer.field_70140_Q + \u26032 * f);
        float \u26034 = entityPlayer.field_71107_bF + (entityPlayer.field_71109_bG - entityPlayer.field_71107_bF) * f;
        float \u26035 = entityPlayer.field_70727_aS + (entityPlayer.field_70726_aT - entityPlayer.field_70727_aS) * f;
        GlStateManager.func_179109_b(MathHelper.func_76126_a(\u26033 * (float)Math.PI) * \u26034 * 0.5f, -Math.abs(MathHelper.func_76134_b(\u26033 * (float)Math.PI) * \u26034), 0.0f);
        GlStateManager.func_179114_b(MathHelper.func_76126_a(\u26033 * (float)Math.PI) * \u26034 * 3.0f, 0.0f, 0.0f, 1.0f);
        GlStateManager.func_179114_b(Math.abs(MathHelper.func_76134_b(\u26033 * (float)Math.PI - 0.2f) * \u26034) * 5.0f, 1.0f, 0.0f, 0.0f);
        GlStateManager.func_179114_b(\u26035, 1.0f, 0.0f, 0.0f);
    }

    private void func_78467_g(float f) {
        Entity entity = this.field_78531_r.func_175606_aa();
        float \u26032 = this.field_203001_Y + (this.field_203000_X - this.field_203001_Y) * f;
        double \u26033 = entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)f;
        double \u26034 = entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)f + (double)entity.func_70047_e();
        double \u26035 = entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)f;
        if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70608_bn()) {
            \u26032 = (float)((double)\u26032 + 1.0);
            GlStateManager.func_179109_b(0.0f, 0.3f, 0.0f);
            if (!this.field_78531_r.field_71474_y.field_74325_U) {
                BlockPos blockPos = new BlockPos(entity);
                IBlockState \u26036 = this.field_78531_r.field_71441_e.func_180495_p(blockPos);
                Block \u26037 = \u26036.func_177230_c();
                if (\u26037 instanceof BlockBed) {
                    GlStateManager.func_179114_b(\u26036.func_177229_b(BlockBed.field_185512_D).func_185119_l(), 0.0f, 1.0f, 0.0f);
                }
                GlStateManager.func_179114_b(entity.field_70126_B + (entity.field_70177_z - entity.field_70126_B) * f + 180.0f, 0.0f, -1.0f, 0.0f);
                GlStateManager.func_179114_b(entity.field_70127_C + (entity.field_70125_A - entity.field_70127_C) * f, -1.0f, 0.0f, 0.0f);
            }
        } else if (this.field_78531_r.field_71474_y.field_74320_O > 0) {
            double \u260311 = this.field_78491_C + (4.0f - this.field_78491_C) * f;
            if (this.field_78531_r.field_71474_y.field_74325_U) {
                GlStateManager.func_179109_b(0.0f, 0.0f, (float)(-\u260311));
            } else {
                float f2 = entity.field_70177_z;
                \u2603 = entity.field_70125_A;
                if (this.field_78531_r.field_71474_y.field_74320_O == 2) {
                    \u2603 += 180.0f;
                }
                double \u26038 = (double)(-MathHelper.func_76126_a(f2 * ((float)Math.PI / 180)) * MathHelper.func_76134_b(\u2603 * ((float)Math.PI / 180))) * \u260311;
                double \u26039 = (double)(MathHelper.func_76134_b(f2 * ((float)Math.PI / 180)) * MathHelper.func_76134_b(\u2603 * ((float)Math.PI / 180))) * \u260311;
                double \u260310 = (double)(-MathHelper.func_76126_a(\u2603 * ((float)Math.PI / 180))) * \u260311;
                for (int i = 0; i < 8; ++i) {
                    float f3 = (i & 1) * 2 - 1;
                    \u2603 = (i >> 1 & 1) * 2 - 1;
                    \u2603 = (i >> 2 & 1) * 2 - 1;
                    if ((\u2603 = this.field_78531_r.field_71441_e.func_72933_a(new Vec3d(\u26033 + (double)(f3 *= 0.1f), \u26034 + (double)(\u2603 *= 0.1f), \u26035 + (double)(\u2603 *= 0.1f)), new Vec3d(\u26033 - \u26038 + (double)f3 + (double)\u2603, \u26034 - \u260310 + (double)\u2603, \u26035 - \u26039 + (double)\u2603))) == null || !((\u2603 = \u2603.field_72307_f.func_72438_d(new Vec3d(\u26033, \u26034, \u26035))) < \u260311)) continue;
                    \u260311 = \u2603;
                }
                if (this.field_78531_r.field_71474_y.field_74320_O == 2) {
                    GlStateManager.func_179114_b(180.0f, 0.0f, 1.0f, 0.0f);
                }
                GlStateManager.func_179114_b(entity.field_70125_A - \u2603, 1.0f, 0.0f, 0.0f);
                GlStateManager.func_179114_b(entity.field_70177_z - f2, 0.0f, 1.0f, 0.0f);
                GlStateManager.func_179109_b(0.0f, 0.0f, (float)(-\u260311));
                GlStateManager.func_179114_b(f2 - entity.field_70177_z, 0.0f, 1.0f, 0.0f);
                GlStateManager.func_179114_b(\u2603 - entity.field_70125_A, 1.0f, 0.0f, 0.0f);
            }
        } else if (!this.field_175078_W) {
            GlStateManager.func_179109_b(0.0f, 0.0f, 0.05f);
        }
        if (!this.field_78531_r.field_71474_y.field_74325_U) {
            GlStateManager.func_179114_b(entity.func_195050_f(f), 1.0f, 0.0f, 0.0f);
            GlStateManager.func_179114_b(entity.func_195046_g(f) + 180.0f, 0.0f, 1.0f, 0.0f);
        }
        GlStateManager.func_179109_b(0.0f, -\u26032, 0.0f);
    }

    private void func_195460_g(float f) {
        this.field_78530_s = this.field_78531_r.field_71474_y.field_151451_c * 16;
        GlStateManager.func_179128_n(5889);
        GlStateManager.func_179096_D();
        if (this.field_78503_V != 1.0) {
            GlStateManager.func_179109_b((float)this.field_78502_W, (float)(-this.field_78509_X), 0.0f);
            GlStateManager.func_179139_a(this.field_78503_V, this.field_78503_V, 1.0);
        }
        GlStateManager.func_199294_a(Matrix4f.func_195876_a(this.func_195459_a(f, true), (float)this.field_78531_r.field_195558_d.func_198109_k() / (float)this.field_78531_r.field_195558_d.func_198091_l(), 0.05f, this.field_78530_s * MathHelper.field_180189_a));
        GlStateManager.func_179128_n(5888);
        GlStateManager.func_179096_D();
        this.func_78482_e(f);
        if (this.field_78531_r.field_71474_y.field_74336_f) {
            this.func_78475_f(f);
        }
        if ((\u2603 = this.field_78531_r.field_71439_g.field_71080_cy + (this.field_78531_r.field_71439_g.field_71086_bY - this.field_78531_r.field_71439_g.field_71080_cy) * f) > 0.0f) {
            int n = 20;
            if (this.field_78531_r.field_71439_g.func_70644_a(MobEffects.field_76431_k)) {
                n = 7;
            }
            float \u26032 = 5.0f / (\u2603 * \u2603 + 5.0f) - \u2603 * 0.04f;
            \u26032 *= \u26032;
            GlStateManager.func_179114_b(((float)this.field_78529_t + f) * (float)n, 0.0f, 1.0f, 1.0f);
            GlStateManager.func_179152_a(1.0f / \u26032, 1.0f, 1.0f);
            GlStateManager.func_179114_b(-((float)this.field_78529_t + f) * (float)n, 0.0f, 1.0f, 1.0f);
        }
        this.func_78467_g(f);
    }

    private void func_195457_h(float f) {
        if (this.field_175078_W) {
            return;
        }
        GlStateManager.func_179128_n(5889);
        GlStateManager.func_179096_D();
        GlStateManager.func_199294_a(Matrix4f.func_195876_a(this.func_195459_a(f, false), (float)this.field_78531_r.field_195558_d.func_198109_k() / (float)this.field_78531_r.field_195558_d.func_198091_l(), 0.05f, this.field_78530_s * 2.0f));
        GlStateManager.func_179128_n(5888);
        GlStateManager.func_179096_D();
        GlStateManager.func_179094_E();
        this.func_78482_e(f);
        if (this.field_78531_r.field_71474_y.field_74336_f) {
            this.func_78475_f(f);
        }
        boolean bl = \u2603 = this.field_78531_r.func_175606_aa() instanceof EntityLivingBase && ((EntityLivingBase)this.field_78531_r.func_175606_aa()).func_70608_bn();
        if (this.field_78531_r.field_71474_y.field_74320_O == 0 && !\u2603 && !this.field_78531_r.field_71474_y.field_74319_N && this.field_78531_r.field_71442_b.func_178889_l() != GameType.SPECTATOR) {
            this.func_180436_i();
            this.field_78516_c.func_78440_a(f);
            this.func_175072_h();
        }
        GlStateManager.func_179121_F();
        if (this.field_78531_r.field_71474_y.field_74320_O == 0 && !\u2603) {
            this.field_78516_c.func_78447_b(f);
            this.func_78482_e(f);
        }
        if (this.field_78531_r.field_71474_y.field_74336_f) {
            this.func_78475_f(f);
        }
    }

    public void func_175072_h() {
        this.field_78513_d.func_205108_b();
    }

    public void func_180436_i() {
        this.field_78513_d.func_205109_c();
    }

    public float func_180438_a(EntityLivingBase entityLivingBase, float f) {
        int n = entityLivingBase.func_70660_b(MobEffects.field_76439_r).func_76459_b();
        if (n > 200) {
            return 1.0f;
        }
        return 0.7f + MathHelper.func_76126_a(((float)n - f) * (float)Math.PI * 0.2f) * 0.3f;
    }

    public void func_195458_a(float f, long l, boolean bl) {
        if (this.field_78531_r.func_195544_aj() || !this.field_78531_r.field_71474_y.field_82881_y || this.field_78531_r.field_71474_y.field_85185_A && this.field_78531_r.field_71417_B.func_198031_d()) {
            this.field_78508_Y = Util.func_211177_b();
        } else if (Util.func_211177_b() - this.field_78508_Y > 500L) {
            this.field_78531_r.func_71385_j();
        }
        if (this.field_78531_r.field_71454_w) {
            return;
        }
        int n = (int)(this.field_78531_r.field_71417_B.func_198024_e() * (double)this.field_78531_r.field_195558_d.func_198107_o() / (double)this.field_78531_r.field_195558_d.func_198105_m());
        \u2603 = (int)(this.field_78531_r.field_71417_B.func_198026_f() * (double)this.field_78531_r.field_195558_d.func_198087_p() / (double)this.field_78531_r.field_195558_d.func_198083_n());
        \u2603 = this.field_78531_r.field_71474_y.field_74350_i;
        if (bl && this.field_78531_r.field_71441_e != null) {
            this.field_78531_r.field_71424_I.func_76320_a("level");
            \u2603 = Math.min(Minecraft.func_175610_ah(), \u2603);
            \u2603 = Math.max(\u2603, 60);
            long l2 = Util.func_211178_c() - l;
            \u2603 = Math.max((long)(1000000000 / \u2603 / 4) - l2, 0L);
            this.func_78471_a(f, Util.func_211178_c() + \u2603);
            if (this.field_78531_r.func_71356_B() && this.field_184374_E < Util.func_211177_b() - 1000L) {
                this.field_184374_E = Util.func_211177_b();
                if (!this.field_78531_r.func_71401_C().func_184106_y()) {
                    this.func_184373_n();
                }
            }
            if (OpenGlHelper.field_148824_g) {
                this.field_78531_r.field_71438_f.func_174975_c();
                if (this.field_147707_d != null && this.field_175083_ad) {
                    GlStateManager.func_179128_n(5890);
                    GlStateManager.func_179094_E();
                    GlStateManager.func_179096_D();
                    this.field_147707_d.func_148018_a(f);
                    GlStateManager.func_179121_F();
                }
                this.field_78531_r.func_147110_a().func_147610_a(true);
            }
            this.field_78531_r.field_71424_I.func_76318_c("gui");
            if (!this.field_78531_r.field_71474_y.field_74319_N || this.field_78531_r.field_71462_r != null) {
                GlStateManager.func_179092_a(516, 0.1f);
                this.field_78531_r.field_195558_d.func_198094_a();
                this.func_190563_a(this.field_78531_r.field_195558_d.func_198107_o(), this.field_78531_r.field_195558_d.func_198087_p(), f);
                this.field_78531_r.field_71456_v.func_175180_a(f);
            }
            this.field_78531_r.field_71424_I.func_76319_b();
        } else {
            GlStateManager.func_179083_b(0, 0, this.field_78531_r.field_195558_d.func_198109_k(), this.field_78531_r.field_195558_d.func_198091_l());
            GlStateManager.func_179128_n(5889);
            GlStateManager.func_179096_D();
            GlStateManager.func_179128_n(5888);
            GlStateManager.func_179096_D();
            this.field_78531_r.field_195558_d.func_198094_a();
        }
        if (this.field_78531_r.field_71462_r != null) {
            GlStateManager.func_179086_m(256);
            try {
                this.field_78531_r.field_71462_r.func_73863_a(n, \u2603, this.field_78531_r.func_193989_ak());
            }
            catch (Throwable throwable) {
                CrashReport crashReport = CrashReport.func_85055_a(throwable, "Rendering screen");
                CrashReportCategory \u26032 = crashReport.func_85058_a("Screen render details");
                \u26032.func_189529_a("Screen name", () -> this.field_78531_r.field_71462_r.getClass().getCanonicalName());
                \u26032.func_189529_a("Mouse location", () -> String.format(Locale.ROOT, "Scaled: (%d, %d). Absolute: (%f, %f)", n, \u2603, this.field_78531_r.field_71417_B.func_198024_e(), this.field_78531_r.field_71417_B.func_198026_f()));
                \u26032.func_189529_a("Screen size", () -> String.format(Locale.ROOT, "Scaled: (%d, %d). Absolute: (%d, %d). Scale factor of %f", this.field_78531_r.field_195558_d.func_198107_o(), this.field_78531_r.field_195558_d.func_198087_p(), this.field_78531_r.field_195558_d.func_198109_k(), this.field_78531_r.field_195558_d.func_198091_l(), this.field_78531_r.field_195558_d.func_198100_s()));
                throw new ReportedException(crashReport);
            }
        }
    }

    private void func_184373_n() {
        if (this.field_78531_r.field_71438_f.func_184382_g() > 10 && this.field_78531_r.field_71438_f.func_184384_n() && !this.field_78531_r.func_71401_C().func_184106_y()) {
            NativeImage nativeImage = ScreenShotHelper.func_198052_a(this.field_78531_r.field_195558_d.func_198109_k(), this.field_78531_r.field_195558_d.func_198091_l(), this.field_78531_r.func_147110_a());
            SimpleResource.field_199031_a.execute(() -> {
                int n = nativeImage.func_195702_a();
                \u2603 = nativeImage.func_195714_b();
                \u2603 = 0;
                \u2603 = 0;
                if (n > \u2603) {
                    \u2603 = (n - \u2603) / 2;
                    n = \u2603;
                } else {
                    \u2603 = (\u2603 - n) / 2;
                    \u2603 = n;
                }
                try (NativeImage nativeImage2 = new NativeImage(64, 64, false);){
                    nativeImage.func_195708_a(\u2603, \u2603, n, \u2603, nativeImage2);
                    nativeImage2.func_209271_a(this.field_78531_r.func_71401_C().func_184109_z());
                }
                catch (IOException iOException) {
                    field_147710_q.warn("Couldn't save auto screenshot", (Throwable)iOException);
                }
                finally {
                    nativeImage.close();
                }
            });
        }
    }

    public void func_152430_c(float f) {
        this.field_78531_r.field_195558_d.func_198094_a();
    }

    private boolean func_175070_n() {
        boolean \u26034;
        if (!this.field_175073_D) {
            return false;
        }
        Entity entity = this.field_78531_r.func_175606_aa();
        boolean bl = \u26034 = entity instanceof EntityPlayer && !this.field_78531_r.field_71474_y.field_74319_N;
        if (\u26034 && !((EntityPlayer)entity).field_71075_bZ.field_75099_e) {
            ItemStack itemStack = ((EntityPlayer)entity).func_184614_ca();
            if (this.field_78531_r.field_71476_x != null && this.field_78531_r.field_71476_x.field_72313_a == RayTraceResult.Type.BLOCK) {
                BlockPos blockPos = this.field_78531_r.field_71476_x.func_178782_a();
                Block \u26032 = this.field_78531_r.field_71441_e.func_180495_p(blockPos).func_177230_c();
                if (this.field_78531_r.field_71442_b.func_178889_l() == GameType.SPECTATOR) {
                    \u26034 = \u26032.func_149716_u() && this.field_78531_r.field_71441_e.func_175625_s(blockPos) instanceof IInventory;
                } else {
                    BlockWorldState \u26033 = new BlockWorldState(this.field_78531_r.field_71441_e, blockPos, false);
                    \u26034 = !itemStack.func_190926_b() && (itemStack.func_206848_a(this.field_78531_r.field_71441_e.func_205772_D(), \u26033) || itemStack.func_206847_b(this.field_78531_r.field_71441_e.func_205772_D(), \u26033));
                }
            }
        }
        return \u26034;
    }

    public void func_78471_a(float f, long l) {
        this.field_78513_d.func_205106_a(f);
        if (this.field_78531_r.func_175606_aa() == null) {
            this.field_78531_r.func_175607_a(this.field_78531_r.field_71439_g);
        }
        this.func_78473_a(f);
        GlStateManager.func_179126_j();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a(516, 0.5f);
        this.field_78531_r.field_71424_I.func_76320_a("center");
        this.func_181560_a(f, l);
        this.field_78531_r.field_71424_I.func_76319_b();
    }

    private void func_181560_a(float f2, long l) {
        WorldRenderer worldRenderer = this.field_78531_r.field_71438_f;
        ParticleManager \u26032 = this.field_78531_r.field_71452_i;
        boolean \u26033 = this.func_175070_n();
        GlStateManager.func_179089_o();
        this.field_78531_r.field_71424_I.func_76318_c("clear");
        GlStateManager.func_179083_b(0, 0, this.field_78531_r.field_195558_d.func_198109_k(), this.field_78531_r.field_195558_d.func_198091_l());
        this.field_205003_A.func_78466_h(f2);
        GlStateManager.func_179086_m(16640);
        this.field_78531_r.field_71424_I.func_76318_c("camera");
        this.func_195460_g(f2);
        ActiveRenderInfo.func_197924_a(this.field_78531_r.field_71439_g, this.field_78531_r.field_71474_y.field_74320_O == 2, this.field_78530_s);
        this.field_78531_r.field_71424_I.func_76318_c("frustum");
        ClippingHelperImpl.func_78558_a();
        this.field_78531_r.field_71424_I.func_76318_c("culling");
        Frustum \u26034 = new Frustum();
        Entity \u26035 = this.field_78531_r.func_175606_aa();
        double \u26036 = \u26035.field_70142_S + (\u26035.field_70165_t - \u26035.field_70142_S) * (double)f2;
        double \u26037 = \u26035.field_70137_T + (\u26035.field_70163_u - \u26035.field_70137_T) * (double)f2;
        double \u26038 = \u26035.field_70136_U + (\u26035.field_70161_v - \u26035.field_70136_U) * (double)f2;
        \u26034.func_78547_a(\u26036, \u26037, \u26038);
        if (this.field_78531_r.field_71474_y.field_151451_c >= 4) {
            this.field_205003_A.func_78468_a(-1, f2);
            this.field_78531_r.field_71424_I.func_76318_c("sky");
            GlStateManager.func_179128_n(5889);
            GlStateManager.func_179096_D();
            GlStateManager.func_199294_a(Matrix4f.func_195876_a(this.func_195459_a(f2, true), (float)this.field_78531_r.field_195558_d.func_198109_k() / (float)this.field_78531_r.field_195558_d.func_198091_l(), 0.05f, this.field_78530_s * 2.0f));
            GlStateManager.func_179128_n(5888);
            worldRenderer.func_195465_a(f2);
            GlStateManager.func_179128_n(5889);
            GlStateManager.func_179096_D();
            GlStateManager.func_199294_a(Matrix4f.func_195876_a(this.func_195459_a(f2, true), (float)this.field_78531_r.field_195558_d.func_198109_k() / (float)this.field_78531_r.field_195558_d.func_198091_l(), 0.05f, this.field_78530_s * MathHelper.field_180189_a));
            GlStateManager.func_179128_n(5888);
        }
        this.field_205003_A.func_78468_a(0, f2);
        GlStateManager.func_179103_j(7425);
        if (\u26035.field_70163_u + (double)\u26035.func_70047_e() < 128.0) {
            this.func_195456_a(worldRenderer, f2, \u26036, \u26037, \u26038);
        }
        this.field_78531_r.field_71424_I.func_76318_c("prepareterrain");
        this.field_205003_A.func_78468_a(0, f2);
        this.field_78531_r.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        RenderHelper.func_74518_a();
        this.field_78531_r.field_71424_I.func_76318_c("terrain_setup");
        worldRenderer.func_195473_a(\u26035, f2, \u26034, this.field_175084_ae++, this.field_78531_r.field_71439_g.func_175149_v());
        this.field_78531_r.field_71424_I.func_76318_c("updatechunks");
        this.field_78531_r.field_71438_f.func_174967_a(l);
        this.field_78531_r.field_71424_I.func_76318_c("terrain");
        GlStateManager.func_179128_n(5888);
        GlStateManager.func_179094_E();
        GlStateManager.func_179118_c();
        worldRenderer.func_195464_a(BlockRenderLayer.SOLID, f2, \u26035);
        GlStateManager.func_179141_d();
        worldRenderer.func_195464_a(BlockRenderLayer.CUTOUT_MIPPED, f2, \u26035);
        this.field_78531_r.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        worldRenderer.func_195464_a(BlockRenderLayer.CUTOUT, f2, \u26035);
        this.field_78531_r.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
        GlStateManager.func_179103_j(7424);
        GlStateManager.func_179092_a(516, 0.1f);
        GlStateManager.func_179128_n(5888);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        RenderHelper.func_74519_b();
        this.field_78531_r.field_71424_I.func_76318_c("entities");
        worldRenderer.func_180446_a(\u26035, \u26034, f2);
        RenderHelper.func_74518_a();
        this.func_175072_h();
        GlStateManager.func_179128_n(5888);
        GlStateManager.func_179121_F();
        if (\u26033 && this.field_78531_r.field_71476_x != null) {
            EntityPlayer entityPlayer = (EntityPlayer)\u26035;
            GlStateManager.func_179118_c();
            this.field_78531_r.field_71424_I.func_76318_c("outline");
            worldRenderer.func_72731_b(entityPlayer, this.field_78531_r.field_71476_x, 0, f2);
            GlStateManager.func_179141_d();
        }
        if (this.field_78531_r.field_184132_p.func_190074_a()) {
            float f2;
            this.field_78531_r.field_184132_p.func_190073_a(f2, l);
        }
        this.field_78531_r.field_71424_I.func_76318_c("destroyProgress");
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        this.field_78531_r.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        worldRenderer.func_174981_a(Tessellator.func_178181_a(), Tessellator.func_178181_a().func_178180_c(), \u26035, f2);
        this.field_78531_r.func_110434_K().func_110581_b(TextureMap.field_110575_b).func_174935_a();
        GlStateManager.func_179084_k();
        this.func_180436_i();
        this.field_78531_r.field_71424_I.func_76318_c("litParticles");
        \u26032.func_78872_b(\u26035, f2);
        RenderHelper.func_74518_a();
        this.field_205003_A.func_78468_a(0, f2);
        this.field_78531_r.field_71424_I.func_76318_c("particles");
        \u26032.func_78874_a(\u26035, f2);
        this.func_175072_h();
        GlStateManager.func_179132_a(false);
        GlStateManager.func_179089_o();
        this.field_78531_r.field_71424_I.func_76318_c("weather");
        this.func_78474_d(f2);
        GlStateManager.func_179132_a(true);
        worldRenderer.func_180449_a(\u26035, f2);
        GlStateManager.func_179084_k();
        GlStateManager.func_179089_o();
        GlStateManager.func_187428_a(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179092_a(516, 0.1f);
        this.field_205003_A.func_78468_a(0, f2);
        GlStateManager.func_179147_l();
        GlStateManager.func_179132_a(false);
        this.field_78531_r.func_110434_K().func_110577_a(TextureMap.field_110575_b);
        GlStateManager.func_179103_j(7425);
        this.field_78531_r.field_71424_I.func_76318_c("translucent");
        worldRenderer.func_195464_a(BlockRenderLayer.TRANSLUCENT, f2, \u26035);
        GlStateManager.func_179103_j(7424);
        GlStateManager.func_179132_a(true);
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GlStateManager.func_179106_n();
        if (\u26035.field_70163_u + (double)\u26035.func_70047_e() >= 128.0) {
            this.field_78531_r.field_71424_I.func_76318_c("aboveClouds");
            this.func_195456_a(worldRenderer, f2, \u26036, \u26037, \u26038);
        }
        this.field_78531_r.field_71424_I.func_76318_c("hand");
        if (this.field_175074_C) {
            GlStateManager.func_179086_m(256);
            this.func_195457_h(f2);
        }
    }

    private void func_195456_a(WorldRenderer worldRenderer, float f, double d, double d2, double d3) {
        if (this.field_78531_r.field_71474_y.func_181147_e() != 0) {
            this.field_78531_r.field_71424_I.func_76318_c("clouds");
            GlStateManager.func_179128_n(5889);
            GlStateManager.func_179096_D();
            GlStateManager.func_199294_a(Matrix4f.func_195876_a(this.func_195459_a(f, true), (float)this.field_78531_r.field_195558_d.func_198109_k() / (float)this.field_78531_r.field_195558_d.func_198091_l(), 0.05f, this.field_78530_s * 4.0f));
            GlStateManager.func_179128_n(5888);
            GlStateManager.func_179094_E();
            this.field_205003_A.func_78468_a(0, f);
            worldRenderer.func_195466_a(f, d, d2, d3);
            GlStateManager.func_179106_n();
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n(5889);
            GlStateManager.func_179096_D();
            GlStateManager.func_199294_a(Matrix4f.func_195876_a(this.func_195459_a(f, true), (float)this.field_78531_r.field_195558_d.func_198109_k() / (float)this.field_78531_r.field_195558_d.func_198091_l(), 0.05f, this.field_78530_s * MathHelper.field_180189_a));
            GlStateManager.func_179128_n(5888);
        }
    }

    private void func_78484_h() {
        float f = this.field_78531_r.field_71441_e.func_72867_j(1.0f);
        if (!this.field_78531_r.field_71474_y.field_74347_j) {
            f /= 2.0f;
        }
        if (f == 0.0f) {
            return;
        }
        this.field_78537_ab.setSeed((long)this.field_78529_t * 312987231L);
        Entity \u26032 = this.field_78531_r.func_175606_aa();
        WorldClient \u26033 = this.field_78531_r.field_71441_e;
        BlockPos \u26034 = new BlockPos(\u26032);
        int \u26035 = 10;
        double \u26036 = 0.0;
        double \u26037 = 0.0;
        double \u26038 = 0.0;
        int \u26039 = 0;
        int \u260310 = (int)(100.0f * f * f);
        if (this.field_78531_r.field_71474_y.field_74362_aa == 1) {
            \u260310 >>= 1;
        } else if (this.field_78531_r.field_71474_y.field_74362_aa == 2) {
            \u260310 = 0;
        }
        for (int i = 0; i < \u260310; ++i) {
            double d;
            BlockPos blockPos = \u26033.func_205770_a(Heightmap.Type.MOTION_BLOCKING, \u26034.func_177982_a(this.field_78537_ab.nextInt(10) - this.field_78537_ab.nextInt(10), 0, this.field_78537_ab.nextInt(10) - this.field_78537_ab.nextInt(10)));
            Biome \u260311 = \u26033.func_180494_b(blockPos);
            \u2603 = blockPos.func_177977_b();
            if (blockPos.func_177956_o() > \u26034.func_177956_o() + 10 || blockPos.func_177956_o() < \u26034.func_177956_o() - 10 || \u260311.func_201851_b() != Biome.RainType.RAIN || !(\u260311.func_180626_a(blockPos) >= 0.15f)) continue;
            double \u260312 = this.field_78537_ab.nextDouble();
            double \u260313 = this.field_78537_ab.nextDouble();
            IBlockState \u260314 = \u26033.func_180495_p(\u2603);
            IFluidState \u260315 = \u26033.func_204610_c(blockPos);
            VoxelShape \u260316 = \u260314.func_196952_d(\u26033, \u2603);
            double \u260317 = \u260316.func_197760_b(EnumFacing.Axis.Y, \u260312, \u260313);
            if (\u260317 >= (\u2603 = (double)\u260315.func_206885_f())) {
                d = \u260317;
                \u2603 = \u260316.func_197764_a(EnumFacing.Axis.Y, \u260312, \u260313);
            } else {
                d = 0.0;
                \u2603 = 0.0;
            }
            if (!(d > -1.7976931348623157E308)) continue;
            if (\u260315.func_206884_a(FluidTags.field_206960_b) || \u260314.func_177230_c() == Blocks.field_196814_hQ) {
                this.field_78531_r.field_71441_e.func_195594_a(Particles.field_197601_L, (double)blockPos.func_177958_n() + \u260312, (double)((float)blockPos.func_177956_o() + 0.1f) - \u2603, (double)blockPos.func_177952_p() + \u260313, 0.0, 0.0, 0.0);
                continue;
            }
            if (this.field_78537_ab.nextInt(++\u26039) == 0) {
                \u26036 = (double)\u2603.func_177958_n() + \u260312;
                \u26037 = (double)((float)\u2603.func_177956_o() + 0.1f) + d - 1.0;
                \u26038 = (double)\u2603.func_177952_p() + \u260313;
            }
            this.field_78531_r.field_71441_e.func_195594_a(Particles.field_197600_K, (double)\u2603.func_177958_n() + \u260312, (double)((float)\u2603.func_177956_o() + 0.1f) + d, (double)\u2603.func_177952_p() + \u260313, 0.0, 0.0, 0.0);
        }
        if (\u26039 > 0 && this.field_78537_ab.nextInt(3) < this.field_78534_ac++) {
            this.field_78534_ac = 0;
            if (\u26037 > (double)(\u26034.func_177956_o() + 1) && \u26033.func_205770_a(Heightmap.Type.MOTION_BLOCKING, \u26034).func_177956_o() > MathHelper.func_76141_d(\u26034.func_177956_o())) {
                this.field_78531_r.field_71441_e.func_184134_a(\u26036, \u26037, \u26038, SoundEvents.field_187919_gs, SoundCategory.WEATHER, 0.1f, 0.5f, false);
            } else {
                this.field_78531_r.field_71441_e.func_184134_a(\u26036, \u26037, \u26038, SoundEvents.field_187918_gr, SoundCategory.WEATHER, 0.2f, 1.0f, false);
            }
        }
    }

    protected void func_78474_d(float f) {
        \u2603 = this.field_78531_r.field_71441_e.func_72867_j(f);
        if (\u2603 <= 0.0f) {
            return;
        }
        this.func_180436_i();
        Entity entity = this.field_78531_r.func_175606_aa();
        WorldClient \u26032 = this.field_78531_r.field_71441_e;
        int \u26033 = MathHelper.func_76128_c(entity.field_70165_t);
        int \u26034 = MathHelper.func_76128_c(entity.field_70163_u);
        int \u26035 = MathHelper.func_76128_c(entity.field_70161_v);
        Tessellator \u26036 = Tessellator.func_178181_a();
        BufferBuilder \u26037 = \u26036.func_178180_c();
        GlStateManager.func_179129_p();
        GlStateManager.func_187432_a(0.0f, 1.0f, 0.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179092_a(516, 0.1f);
        double \u26038 = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)f;
        double \u26039 = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)f;
        double \u260310 = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)f;
        int \u260311 = MathHelper.func_76128_c(\u26039);
        int \u260312 = 5;
        if (this.field_78531_r.field_71474_y.field_74347_j) {
            \u260312 = 10;
        }
        int \u260313 = -1;
        float \u260314 = (float)this.field_78529_t + f;
        \u26037.func_178969_c(-\u26038, -\u26039, -\u260310);
        GlStateManager.func_179131_c(1.0f, 1.0f, 1.0f, 1.0f);
        BlockPos.MutableBlockPos \u260315 = new BlockPos.MutableBlockPos();
        for (int i = \u26035 - \u260312; i <= \u26035 + \u260312; ++i) {
            for (n = \u26033 - \u260312; n <= \u26033 + \u260312; ++n) {
                int n;
                \u2603 = (i - \u26035 + 16) * 32 + n - \u26033 + 16;
                double d = (double)this.field_175076_N[\u2603] * 0.5;
                \u2603 = (double)this.field_175077_O[\u2603] * 0.5;
                \u260315.func_181079_c(n, 0, i);
                Biome \u260316 = \u26032.func_180494_b(\u260315);
                if (\u260316.func_201851_b() == Biome.RainType.NONE) continue;
                int \u260317 = \u26032.func_205770_a(Heightmap.Type.MOTION_BLOCKING, \u260315).func_177956_o();
                int \u260318 = \u26034 - \u260312;
                int \u260319 = \u26034 + \u260312;
                if (\u260318 < \u260317) {
                    \u260318 = \u260317;
                }
                if (\u260319 < \u260317) {
                    \u260319 = \u260317;
                }
                if ((n2 = \u260317) < \u260311) {
                    int n2 = \u260311;
                }
                if (\u260318 == \u260319) continue;
                this.field_78537_ab.setSeed(n * n * 3121 + n * 45238971 ^ i * i * 418711 + i * 13761);
                \u260315.func_181079_c(n, \u260318, i);
                float \u260320 = \u260316.func_180626_a(\u260315);
                if (\u260320 >= 0.15f) {
                    if (\u260313 != 0) {
                        if (\u260313 >= 0) {
                            \u26036.func_78381_a();
                        }
                        \u260313 = 0;
                        this.field_78531_r.func_110434_K().func_110577_a(field_110924_q);
                        \u26037.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                    }
                    double d2 = -((double)(this.field_78529_t + n * n * 3121 + n * 45238971 + i * i * 418711 + i * 13761 & 0x1F) + (double)f) / 32.0 * (3.0 + this.field_78537_ab.nextDouble());
                    \u2603 = (double)((float)n + 0.5f) - entity.field_70165_t;
                    \u2603 = (double)((float)i + 0.5f) - entity.field_70161_v;
                    float \u260321 = MathHelper.func_76133_a(\u2603 * \u2603 + \u2603 * \u2603) / (float)\u260312;
                    float \u260322 = ((1.0f - \u260321 * \u260321) * 0.5f + 0.5f) * \u2603;
                    \u260315.func_181079_c(n, n2, i);
                    int \u260323 = \u26032.func_175626_b(\u260315, 0);
                    int \u260324 = \u260323 >> 16 & 0xFFFF;
                    int \u260325 = \u260323 & 0xFFFF;
                    \u26037.func_181662_b((double)n - d + 0.5, \u260319, (double)i - \u2603 + 0.5).func_187315_a(0.0, (double)\u260318 * 0.25 + d2).func_181666_a(1.0f, 1.0f, 1.0f, \u260322).func_187314_a(\u260324, \u260325).func_181675_d();
                    \u26037.func_181662_b((double)n + d + 0.5, \u260319, (double)i + \u2603 + 0.5).func_187315_a(1.0, (double)\u260318 * 0.25 + d2).func_181666_a(1.0f, 1.0f, 1.0f, \u260322).func_187314_a(\u260324, \u260325).func_181675_d();
                    \u26037.func_181662_b((double)n + d + 0.5, \u260318, (double)i + \u2603 + 0.5).func_187315_a(1.0, (double)\u260319 * 0.25 + d2).func_181666_a(1.0f, 1.0f, 1.0f, \u260322).func_187314_a(\u260324, \u260325).func_181675_d();
                    \u26037.func_181662_b((double)n - d + 0.5, \u260318, (double)i - \u2603 + 0.5).func_187315_a(0.0, (double)\u260319 * 0.25 + d2).func_181666_a(1.0f, 1.0f, 1.0f, \u260322).func_187314_a(\u260324, \u260325).func_181675_d();
                    continue;
                }
                if (\u260313 != 1) {
                    if (\u260313 >= 0) {
                        \u26036.func_78381_a();
                    }
                    \u260313 = 1;
                    this.field_78531_r.func_110434_K().func_110577_a(field_110923_r);
                    \u26037.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                }
                d2 = -((float)(this.field_78529_t & 0x1FF) + f) / 512.0f;
                \u2603 = this.field_78537_ab.nextDouble() + (double)\u260314 * 0.01 * (double)((float)this.field_78537_ab.nextGaussian());
                \u2603 = this.field_78537_ab.nextDouble() + (double)(\u260314 * (float)this.field_78537_ab.nextGaussian()) * 0.001;
                \u2603 = (double)((float)n + 0.5f) - entity.field_70165_t;
                \u2603 = (double)((float)i + 0.5f) - entity.field_70161_v;
                float f2 = MathHelper.func_76133_a(\u2603 * \u2603 + \u2603 * \u2603) / (float)\u260312;
                \u2603 = ((1.0f - f2 * f2) * 0.3f + 0.5f) * \u2603;
                \u260315.func_181079_c(n, n2, i);
                int \u260326 = (\u26032.func_175626_b(\u260315, 0) * 3 + 0xF000F0) / 4;
                int \u260327 = \u260326 >> 16 & 0xFFFF;
                int \u260328 = \u260326 & 0xFFFF;
                \u26037.func_181662_b((double)n - d + 0.5, \u260319, (double)i - \u2603 + 0.5).func_187315_a(0.0 + \u2603, (double)\u260318 * 0.25 + d2 + \u2603).func_181666_a(1.0f, 1.0f, 1.0f, \u2603).func_187314_a(\u260327, \u260328).func_181675_d();
                \u26037.func_181662_b((double)n + d + 0.5, \u260319, (double)i + \u2603 + 0.5).func_187315_a(1.0 + \u2603, (double)\u260318 * 0.25 + d2 + \u2603).func_181666_a(1.0f, 1.0f, 1.0f, \u2603).func_187314_a(\u260327, \u260328).func_181675_d();
                \u26037.func_181662_b((double)n + d + 0.5, \u260318, (double)i + \u2603 + 0.5).func_187315_a(1.0 + \u2603, (double)\u260319 * 0.25 + d2 + \u2603).func_181666_a(1.0f, 1.0f, 1.0f, \u2603).func_187314_a(\u260327, \u260328).func_181675_d();
                \u26037.func_181662_b((double)n - d + 0.5, \u260318, (double)i - \u2603 + 0.5).func_187315_a(0.0 + \u2603, (double)\u260319 * 0.25 + d2 + \u2603).func_181666_a(1.0f, 1.0f, 1.0f, \u2603).func_187314_a(\u260327, \u260328).func_181675_d();
            }
        }
        if (\u260313 >= 0) {
            \u26036.func_78381_a();
        }
        \u26037.func_178969_c(0.0, 0.0, 0.0);
        GlStateManager.func_179089_o();
        GlStateManager.func_179084_k();
        GlStateManager.func_179092_a(516, 0.1f);
        this.func_175072_h();
    }

    public void func_191514_d(boolean bl) {
        this.field_205003_A.func_205090_a(bl);
    }

    public void func_190564_k() {
        this.field_190566_ab = null;
        this.field_147709_v.func_148249_a();
    }

    public MapItemRenderer func_147701_i() {
        return this.field_147709_v;
    }

    public static void func_189692_a(FontRenderer fontRenderer, String string, float f, float f2, float f3, int n, float f4, float f5, boolean bl, boolean bl2) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b(f, f2, f3);
        GlStateManager.func_187432_a(0.0f, 1.0f, 0.0f);
        GlStateManager.func_179114_b(-f4, 0.0f, 1.0f, 0.0f);
        GlStateManager.func_179114_b((float)(bl ? -1 : 1) * f5, 1.0f, 0.0f, 0.0f);
        GlStateManager.func_179152_a(-0.025f, -0.025f, 0.025f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179132_a(false);
        if (!bl2) {
            GlStateManager.func_179097_i();
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        int n2 = fontRenderer.func_78256_a(string) / 2;
        GlStateManager.func_179090_x();
        Tessellator \u26032 = Tessellator.func_178181_a();
        BufferBuilder \u26033 = \u26032.func_178180_c();
        \u26033.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        \u26033.func_181662_b(-n2 - 1, -1 + n, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        \u26033.func_181662_b(-n2 - 1, 8 + n, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        \u26033.func_181662_b(n2 + 1, 8 + n, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        \u26033.func_181662_b(n2 + 1, -1 + n, 0.0).func_181666_a(0.0f, 0.0f, 0.0f, 0.25f).func_181675_d();
        \u26032.func_78381_a();
        GlStateManager.func_179098_w();
        if (!bl2) {
            fontRenderer.func_211126_b(string, -fontRenderer.func_78256_a(string) / 2, n, 0x20FFFFFF);
            GlStateManager.func_179126_j();
        }
        GlStateManager.func_179132_a(true);
        fontRenderer.func_211126_b(string, -fontRenderer.func_78256_a(string) / 2, n, bl2 ? 0x20FFFFFF : -1);
        GlStateManager.func_179145_e();
        GlStateManager.func_179084_k();
        GlStateManager.func_179131_c(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.func_179121_F();
    }

    public void func_190565_a(ItemStack itemStack) {
        this.field_190566_ab = itemStack;
        this.field_190567_ac = 40;
        this.field_190568_ad = this.field_78537_ab.nextFloat() * 2.0f - 1.0f;
        this.field_190569_ae = this.field_78537_ab.nextFloat() * 2.0f - 1.0f;
    }

    private void func_190563_a(int n, int n2, float f) {
        if (this.field_190566_ab == null || this.field_190567_ac <= 0) {
            return;
        }
        int n3 = 40 - this.field_190567_ac;
        float \u26032 = ((float)n3 + f) / 40.0f;
        float \u26033 = \u26032 * \u26032;
        float \u26034 = \u26032 * \u26033;
        float \u26035 = 10.25f * \u26034 * \u26033 - 24.95f * \u26033 * \u26033 + 25.5f * \u26034 - 13.8f * \u26033 + 4.0f * \u26032;
        float \u26036 = \u26035 * (float)Math.PI;
        float \u26037 = this.field_190568_ad * (float)(n / 4);
        float \u26038 = this.field_190569_ae * (float)(n2 / 4);
        GlStateManager.func_179141_d();
        GlStateManager.func_179094_E();
        GlStateManager.func_179123_a();
        GlStateManager.func_179126_j();
        GlStateManager.func_179129_p();
        RenderHelper.func_74519_b();
        GlStateManager.func_179109_b((float)(n / 2) + \u26037 * MathHelper.func_76135_e(MathHelper.func_76126_a(\u26036 * 2.0f)), (float)(n2 / 2) + \u26038 * MathHelper.func_76135_e(MathHelper.func_76126_a(\u26036 * 2.0f)), -50.0f);
        float \u26039 = 50.0f + 175.0f * MathHelper.func_76126_a(\u26036);
        GlStateManager.func_179152_a(\u26039, -\u26039, \u26039);
        GlStateManager.func_179114_b(900.0f * MathHelper.func_76135_e(MathHelper.func_76126_a(\u26036)), 0.0f, 1.0f, 0.0f);
        GlStateManager.func_179114_b(6.0f * MathHelper.func_76134_b(\u26032 * 8.0f), 1.0f, 0.0f, 0.0f);
        GlStateManager.func_179114_b(6.0f * MathHelper.func_76134_b(\u26032 * 8.0f), 0.0f, 0.0f, 1.0f);
        this.field_78531_r.func_175599_af().func_181564_a(this.field_190566_ab, ItemCameraTransforms.TransformType.FIXED);
        GlStateManager.func_179099_b();
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179089_o();
        GlStateManager.func_179097_i();
    }

    public Minecraft func_205000_l() {
        return this.field_78531_r;
    }

    public float func_205002_d(float f) {
        return this.field_82832_V + (this.field_82831_U - this.field_82832_V) * f;
    }

    public float func_205001_m() {
        return this.field_78530_s;
    }
}

