/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.ItemModelMesher;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.color.ItemColors;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemTransformVec3f;
import net.minecraft.client.renderer.model.ModelManager;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityItemStackRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.World;

public class ItemRenderer
implements IResourceManagerReloadListener {
    public static final ResourceLocation field_110798_h = new ResourceLocation("textures/misc/enchanted_item_glint.png");
    private static final Set<Item> field_195411_c = Sets.newHashSet((Object[])new Item[]{Items.field_190931_a});
    public float field_77023_b;
    private final ItemModelMesher field_175059_m;
    private final TextureManager field_175057_n;
    private final ItemColors field_184395_f;

    public ItemRenderer(TextureManager textureManager, ModelManager modelManager, ItemColors itemColors2) {
        ItemColors itemColors2;
        this.field_175057_n = textureManager;
        this.field_175059_m = new ItemModelMesher(modelManager);
        for (Item item : IRegistry.field_212630_s) {
            if (field_195411_c.contains(item)) continue;
            this.field_175059_m.func_199311_a(item, new ModelResourceLocation(IRegistry.field_212630_s.func_177774_c(item), "inventory"));
        }
        this.field_184395_f = itemColors2;
    }

    public ItemModelMesher func_175037_a() {
        return this.field_175059_m;
    }

    private void func_191961_a(IBakedModel iBakedModel, ItemStack itemStack) {
        this.func_191967_a(iBakedModel, -1, itemStack);
    }

    private void func_191965_a(IBakedModel iBakedModel, int n) {
        this.func_191967_a(iBakedModel, n, ItemStack.field_190927_a);
    }

    private void func_191967_a(IBakedModel iBakedModel2, int n, ItemStack itemStack) {
        IBakedModel iBakedModel2;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder \u26032 = tessellator.func_178180_c();
        \u26032.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        Random \u26033 = new Random();
        long \u26034 = 42L;
        for (EnumFacing enumFacing : EnumFacing.values()) {
            \u26033.setSeed(42L);
            this.func_191970_a(\u26032, iBakedModel2.func_200117_a(null, enumFacing, \u26033), n, itemStack);
        }
        \u26033.setSeed(42L);
        this.func_191970_a(\u26032, iBakedModel2.func_200117_a(null, null, \u26033), n, itemStack);
        tessellator.func_78381_a();
    }

    public void func_180454_a(ItemStack itemStack, IBakedModel iBakedModel) {
        if (itemStack.func_190926_b()) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b(-0.5f, -0.5f, -0.5f);
        if (iBakedModel.func_188618_c()) {
            GlStateManager.func_179131_c(1.0f, 1.0f, 1.0f, 1.0f);
            GlStateManager.func_179091_B();
            TileEntityItemStackRenderer.field_147719_a.func_179022_a(itemStack);
        } else {
            this.func_191961_a(iBakedModel, itemStack);
            if (itemStack.func_77962_s()) {
                ItemRenderer.func_211128_a(this.field_175057_n, () -> this.func_191965_a(iBakedModel, -8372020), 8);
            }
        }
        GlStateManager.func_179121_F();
    }

    public static void func_211128_a(TextureManager textureManager, Runnable runnable, int n) {
        GlStateManager.func_179132_a(false);
        GlStateManager.func_179143_c(514);
        GlStateManager.func_179140_f();
        GlStateManager.func_187401_a(GlStateManager.SourceFactor.SRC_COLOR, GlStateManager.DestFactor.ONE);
        textureManager.func_110577_a(field_110798_h);
        GlStateManager.func_179128_n(5890);
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a(n, n, n);
        float f = (float)(Util.func_211177_b() % 3000L) / 3000.0f / (float)n;
        GlStateManager.func_179109_b(f, 0.0f, 0.0f);
        GlStateManager.func_179114_b(-50.0f, 0.0f, 0.0f, 1.0f);
        runnable.run();
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        GlStateManager.func_179152_a(n, n, n);
        \u2603 = (float)(Util.func_211177_b() % 4873L) / 4873.0f / (float)n;
        GlStateManager.func_179109_b(-\u2603, 0.0f, 0.0f);
        GlStateManager.func_179114_b(10.0f, 0.0f, 0.0f, 1.0f);
        runnable.run();
        GlStateManager.func_179121_F();
        GlStateManager.func_179128_n(5888);
        GlStateManager.func_187401_a(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179145_e();
        GlStateManager.func_179143_c(515);
        GlStateManager.func_179132_a(true);
        textureManager.func_110577_a(TextureMap.field_110575_b);
    }

    private void func_175038_a(BufferBuilder bufferBuilder, BakedQuad bakedQuad) {
        Vec3i vec3i = bakedQuad.func_178210_d().func_176730_m();
        bufferBuilder.func_178975_e(vec3i.func_177958_n(), vec3i.func_177956_o(), vec3i.func_177952_p());
    }

    private void func_191969_a(BufferBuilder bufferBuilder, BakedQuad bakedQuad, int n) {
        bufferBuilder.func_178981_a(bakedQuad.func_178209_a());
        bufferBuilder.func_178968_d(n);
        this.func_175038_a(bufferBuilder, bakedQuad);
    }

    private void func_191970_a(BufferBuilder bufferBuilder, List<BakedQuad> list, int n, ItemStack itemStack) {
        boolean bl = n == -1 && !itemStack.func_190926_b();
        int \u26032 = list.size();
        for (int i = 0; i < \u26032; ++i) {
            BakedQuad bakedQuad = list.get(i);
            int \u26033 = n;
            if (bl && bakedQuad.func_178212_b()) {
                \u26033 = this.field_184395_f.func_186728_a(itemStack, bakedQuad.func_178211_c());
                \u26033 |= 0xFF000000;
            }
            this.func_191969_a(bufferBuilder, bakedQuad, \u26033);
        }
    }

    public boolean func_175050_a(ItemStack itemStack) {
        IBakedModel iBakedModel = this.field_175059_m.func_178089_a(itemStack);
        if (iBakedModel == null) {
            return false;
        }
        return iBakedModel.func_177556_c();
    }

    public void func_181564_a(ItemStack itemStack, ItemCameraTransforms.TransformType transformType) {
        if (itemStack.func_190926_b()) {
            return;
        }
        IBakedModel iBakedModel = this.func_204206_b(itemStack);
        this.func_184394_a(itemStack, iBakedModel, transformType, false);
    }

    public IBakedModel func_184393_a(ItemStack itemStack, @Nullable World world, @Nullable EntityLivingBase entityLivingBase) {
        IBakedModel iBakedModel = this.field_175059_m.func_178089_a(itemStack);
        Item \u26032 = itemStack.func_77973_b();
        if (!\u26032.func_185040_i()) {
            return iBakedModel;
        }
        return this.func_204207_a(iBakedModel, itemStack, world, entityLivingBase);
    }

    public IBakedModel func_204205_b(ItemStack itemStack, World world, EntityLivingBase entityLivingBase) {
        Item item = itemStack.func_77973_b();
        IBakedModel \u26032 = item == Items.field_203184_eO ? this.field_175059_m.func_178083_a().func_174953_a(new ModelResourceLocation("minecraft:trident_in_hand#inventory")) : this.field_175059_m.func_178089_a(itemStack);
        if (!item.func_185040_i()) {
            return \u26032;
        }
        return this.func_204207_a(\u26032, itemStack, world, entityLivingBase);
    }

    public IBakedModel func_204206_b(ItemStack itemStack) {
        return this.func_184393_a(itemStack, null, null);
    }

    private IBakedModel func_204207_a(IBakedModel iBakedModel, ItemStack itemStack, @Nullable World world, @Nullable EntityLivingBase entityLivingBase) {
        IBakedModel iBakedModel2 = iBakedModel.func_188617_f().func_209581_a(iBakedModel, itemStack, world, entityLivingBase);
        return iBakedModel2 == null ? this.field_175059_m.func_178083_a().func_174951_a() : iBakedModel2;
    }

    public void func_184392_a(ItemStack itemStack, EntityLivingBase entityLivingBase, ItemCameraTransforms.TransformType transformType, boolean bl) {
        if (itemStack.func_190926_b() || entityLivingBase == null) {
            return;
        }
        IBakedModel iBakedModel = this.func_204205_b(itemStack, entityLivingBase.field_70170_p, entityLivingBase);
        this.func_184394_a(itemStack, iBakedModel, transformType, bl);
    }

    protected void func_184394_a(ItemStack itemStack, IBakedModel iBakedModel, ItemCameraTransforms.TransformType transformType, boolean bl) {
        if (itemStack.func_190926_b()) {
            return;
        }
        this.field_175057_n.func_110577_a(TextureMap.field_110575_b);
        this.field_175057_n.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_179131_c(1.0f, 1.0f, 1.0f, 1.0f);
        GlStateManager.func_179091_B();
        GlStateManager.func_179092_a(516, 0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, GlStateManager.SourceFactor.ONE, GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179094_E();
        ItemCameraTransforms itemCameraTransforms = iBakedModel.func_177552_f();
        ItemCameraTransforms.func_188034_a(itemCameraTransforms.func_181688_b(transformType), bl);
        if (this.func_183005_a(itemCameraTransforms.func_181688_b(transformType))) {
            GlStateManager.func_187407_a(GlStateManager.CullFace.FRONT);
        }
        this.func_180454_a(itemStack, iBakedModel);
        GlStateManager.func_187407_a(GlStateManager.CullFace.BACK);
        GlStateManager.func_179121_F();
        GlStateManager.func_179101_C();
        GlStateManager.func_179084_k();
        this.field_175057_n.func_110577_a(TextureMap.field_110575_b);
        this.field_175057_n.func_110581_b(TextureMap.field_110575_b).func_174935_a();
    }

    private boolean func_183005_a(ItemTransformVec3f itemTransformVec3f) {
        return itemTransformVec3f.field_178363_d.func_195899_a() < 0.0f ^ itemTransformVec3f.field_178363_d.func_195900_b() < 0.0f ^ itemTransformVec3f.field_178363_d.func_195902_c() < 0.0f;
    }

    public void func_175042_a(ItemStack itemStack, int n, int n2) {
        this.func_191962_a(itemStack, n, n2, this.func_204206_b(itemStack));
    }

    protected void func_191962_a(ItemStack itemStack, int n, int n2, IBakedModel iBakedModel) {
        GlStateManager.func_179094_E();
        this.field_175057_n.func_110577_a(TextureMap.field_110575_b);
        this.field_175057_n.func_110581_b(TextureMap.field_110575_b).func_174936_b(false, false);
        GlStateManager.func_179091_B();
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a(516, 0.1f);
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a(GlStateManager.SourceFactor.SRC_ALPHA, GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c(1.0f, 1.0f, 1.0f, 1.0f);
        this.func_180452_a(n, n2, iBakedModel.func_177556_c());
        iBakedModel.func_177552_f().func_181689_a(ItemCameraTransforms.TransformType.GUI);
        this.func_180454_a(itemStack, iBakedModel);
        GlStateManager.func_179118_c();
        GlStateManager.func_179101_C();
        GlStateManager.func_179140_f();
        GlStateManager.func_179121_F();
        this.field_175057_n.func_110577_a(TextureMap.field_110575_b);
        this.field_175057_n.func_110581_b(TextureMap.field_110575_b).func_174935_a();
    }

    private void func_180452_a(int n, int n2, boolean bl) {
        GlStateManager.func_179109_b(n, n2, 100.0f + this.field_77023_b);
        GlStateManager.func_179109_b(8.0f, 8.0f, 0.0f);
        GlStateManager.func_179152_a(1.0f, -1.0f, 1.0f);
        GlStateManager.func_179152_a(16.0f, 16.0f, 16.0f);
        if (bl) {
            GlStateManager.func_179145_e();
        } else {
            GlStateManager.func_179140_f();
        }
    }

    public void func_180450_b(ItemStack itemStack, int n, int n2) {
        this.func_184391_a(Minecraft.func_71410_x().field_71439_g, itemStack, n, n2);
    }

    public void func_184391_a(@Nullable EntityLivingBase entityLivingBase, ItemStack itemStack, int n, int n2) {
        if (itemStack.func_190926_b()) {
            return;
        }
        this.field_77023_b += 50.0f;
        try {
            this.func_191962_a(itemStack, n, n2, this.func_184393_a(itemStack, null, entityLivingBase));
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, "Rendering item");
            CrashReportCategory \u26032 = crashReport.func_85058_a("Item being rendered");
            \u26032.func_189529_a("Item Type", () -> String.valueOf(itemStack.func_77973_b()));
            \u26032.func_189529_a("Item Damage", () -> String.valueOf(itemStack.func_77952_i()));
            \u26032.func_189529_a("Item NBT", () -> String.valueOf(itemStack.func_77978_p()));
            \u26032.func_189529_a("Item Foil", () -> String.valueOf(itemStack.func_77962_s()));
            throw new ReportedException(crashReport);
        }
        this.field_77023_b -= 50.0f;
    }

    public void func_175030_a(FontRenderer fontRenderer, ItemStack itemStack, int n, int n2) {
        this.func_180453_a(fontRenderer, itemStack, n, n2, null);
    }

    public void func_180453_a(FontRenderer fontRenderer, ItemStack itemStack2, int n, int n2, @Nullable String string) {
        ItemStack itemStack2;
        Object object;
        if (itemStack2.func_190926_b()) {
            return;
        }
        if (itemStack2.func_190916_E() != 1 || string != null) {
            object = string == null ? String.valueOf(itemStack2.func_190916_E()) : string;
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            GlStateManager.func_179084_k();
            fontRenderer.func_175063_a((String)object, n + 19 - 2 - fontRenderer.func_78256_a((String)object), n2 + 6 + 3, 0xFFFFFF);
            GlStateManager.func_179147_l();
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
        }
        if (itemStack2.func_77951_h()) {
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            GlStateManager.func_179090_x();
            GlStateManager.func_179118_c();
            GlStateManager.func_179084_k();
            object = Tessellator.func_178181_a();
            BufferBuilder \u26032 = ((Tessellator)object).func_178180_c();
            float \u26033 = itemStack2.func_77952_i();
            float \u26034 = itemStack2.func_77958_k();
            float \u26035 = Math.max(0.0f, (\u26034 - \u26033) / \u26034);
            int \u26036 = Math.round(13.0f - \u26033 * 13.0f / \u26034);
            int \u26037 = MathHelper.func_181758_c(\u26035 / 3.0f, 1.0f, 1.0f);
            this.func_181565_a(\u26032, n + 2, n2 + 13, 13, 2, 0, 0, 0, 255);
            this.func_181565_a(\u26032, n + 2, n2 + 13, \u26036, 1, \u26037 >> 16 & 0xFF, \u26037 >> 8 & 0xFF, \u26037 & 0xFF, 255);
            GlStateManager.func_179147_l();
            GlStateManager.func_179141_d();
            GlStateManager.func_179098_w();
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
        }
        float f = \u2603 = (object = Minecraft.func_71410_x().field_71439_g) == null ? 0.0f : ((EntityPlayer)object).func_184811_cZ().func_185143_a(itemStack2.func_77973_b(), Minecraft.func_71410_x().func_184121_ak());
        if (\u2603 > 0.0f) {
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            GlStateManager.func_179090_x();
            Tessellator \u26038 = Tessellator.func_178181_a();
            BufferBuilder \u26039 = \u26038.func_178180_c();
            this.func_181565_a(\u26039, n, n2 + MathHelper.func_76141_d(16.0f * (1.0f - \u2603)), 16, MathHelper.func_76123_f(16.0f * \u2603), 255, 255, 255, 127);
            GlStateManager.func_179098_w();
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
        }
    }

    private void func_181565_a(BufferBuilder bufferBuilder, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferBuilder.func_181662_b(n + 0, n2 + 0, 0.0).func_181669_b(n5, n6, n7, n8).func_181675_d();
        bufferBuilder.func_181662_b(n + 0, n2 + n4, 0.0).func_181669_b(n5, n6, n7, n8).func_181675_d();
        bufferBuilder.func_181662_b(n + n3, n2 + n4, 0.0).func_181669_b(n5, n6, n7, n8).func_181675_d();
        bufferBuilder.func_181662_b(n + n3, n2 + 0, 0.0).func_181669_b(n5, n6, n7, n8).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    @Override
    public void func_195410_a(IResourceManager iResourceManager) {
        this.field_175059_m.func_178085_b();
    }
}

