/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.GameSettings;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.Util;
import org.lwjgl.opengl.ARBFramebufferObject;
import org.lwjgl.opengl.ARBMultitexture;
import org.lwjgl.opengl.ARBShaderObjects;
import org.lwjgl.opengl.ARBVertexBufferObject;
import org.lwjgl.opengl.ARBVertexShader;
import org.lwjgl.opengl.EXTBlendFuncSeparate;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL30;
import org.lwjgl.opengl.GLCapabilities;
import oshi.SystemInfo;
import oshi.hardware.Processor;

public class OpenGlHelper {
    public static boolean field_153197_d;
    public static boolean field_181063_b;
    public static int field_153198_e;
    public static int field_153199_f;
    public static int field_153200_g;
    public static int field_153201_h;
    public static int field_153202_i;
    public static int field_153203_j;
    public static int field_153204_k;
    public static int field_153205_l;
    public static int field_153206_m;
    private static FboMode field_153212_w;
    public static boolean field_148823_f;
    private static boolean field_153213_x;
    private static boolean field_153214_y;
    public static int field_153207_o;
    public static int field_153208_p;
    public static int field_153209_q;
    public static int field_153210_r;
    private static boolean field_153215_z;
    public static int field_77478_a;
    public static int field_77476_b;
    public static int field_176096_r;
    private static boolean field_176088_V;
    public static int field_176095_s;
    public static int field_176094_t;
    public static int field_176093_u;
    public static int field_176092_v;
    public static int field_176091_w;
    public static int field_176099_x;
    public static int field_176098_y;
    public static int field_176097_z;
    public static int field_176080_A;
    public static int field_176081_B;
    public static int field_176082_C;
    public static int field_176076_D;
    public static int field_176077_E;
    public static int field_176078_F;
    public static int field_176079_G;
    public static int field_176084_H;
    public static int field_176085_I;
    public static int field_176086_J;
    public static int field_176087_K;
    private static boolean field_148828_i;
    public static boolean field_153211_u;
    public static boolean field_148827_a;
    public static boolean field_148824_g;
    private static String field_153196_B;
    private static String field_183030_aa;
    public static boolean field_176083_O;
    public static boolean field_181062_Q;
    private static boolean field_176090_Y;
    public static int field_176089_P;
    public static int field_148826_e;
    private static final Map<Integer, String> field_195919_ac;

    public static void func_77474_a() {
        GLCapabilities gLCapabilities = GL.getCapabilities();
        field_153215_z = gLCapabilities.GL_ARB_multitexture && !gLCapabilities.OpenGL13;
        boolean bl = field_176088_V = gLCapabilities.GL_ARB_texture_env_combine && !gLCapabilities.OpenGL13;
        if (field_153215_z) {
            field_153196_B = field_153196_B + "Using ARB_multitexture.\n";
            field_77478_a = 33984;
            field_77476_b = 33985;
            field_176096_r = 33986;
        } else {
            field_153196_B = field_153196_B + "Using GL 1.3 multitexturing.\n";
            field_77478_a = 33984;
            field_77476_b = 33985;
            field_176096_r = 33986;
        }
        if (field_176088_V) {
            field_153196_B = field_153196_B + "Using ARB_texture_env_combine.\n";
            field_176095_s = 34160;
            field_176094_t = 34165;
            field_176093_u = 34167;
            field_176092_v = 34166;
            field_176091_w = 34168;
            field_176099_x = 34161;
            field_176098_y = 34176;
            field_176097_z = 34177;
            field_176080_A = 34178;
            field_176081_B = 34192;
            field_176082_C = 34193;
            field_176076_D = 34194;
            field_176077_E = 34162;
            field_176078_F = 34184;
            field_176079_G = 34185;
            field_176084_H = 34186;
            field_176085_I = 34200;
            field_176086_J = 34201;
            field_176087_K = 34202;
        } else {
            field_153196_B = field_153196_B + "Using GL 1.3 texture combiners.\n";
            field_176095_s = 34160;
            field_176094_t = 34165;
            field_176093_u = 34167;
            field_176092_v = 34166;
            field_176091_w = 34168;
            field_176099_x = 34161;
            field_176098_y = 34176;
            field_176097_z = 34177;
            field_176080_A = 34178;
            field_176081_B = 34192;
            field_176082_C = 34193;
            field_176076_D = 34194;
            field_176077_E = 34162;
            field_176078_F = 34184;
            field_176079_G = 34185;
            field_176084_H = 34186;
            field_176085_I = 34200;
            field_176086_J = 34201;
            field_176087_K = 34202;
        }
        field_153211_u = gLCapabilities.GL_EXT_blend_func_separate && !gLCapabilities.OpenGL14;
        field_148828_i = gLCapabilities.OpenGL14 || gLCapabilities.GL_EXT_blend_func_separate;
        boolean bl2 = field_148823_f = field_148828_i && (gLCapabilities.GL_ARB_framebuffer_object || gLCapabilities.GL_EXT_framebuffer_object || gLCapabilities.OpenGL30);
        if (field_148823_f) {
            field_153196_B = field_153196_B + "Using framebuffer objects because ";
            if (gLCapabilities.OpenGL30) {
                field_153196_B = field_153196_B + "OpenGL 3.0 is supported and separate blending is supported.\n";
                field_153212_w = FboMode.BASE;
                field_153198_e = 36160;
                field_153199_f = 36161;
                field_153200_g = 36064;
                field_153201_h = 36096;
                field_153202_i = 36053;
                field_153203_j = 36054;
                field_153204_k = 36055;
                field_153205_l = 36059;
                field_153206_m = 36060;
            } else if (gLCapabilities.GL_ARB_framebuffer_object) {
                field_153196_B = field_153196_B + "ARB_framebuffer_object is supported and separate blending is supported.\n";
                field_153212_w = FboMode.ARB;
                field_153198_e = 36160;
                field_153199_f = 36161;
                field_153200_g = 36064;
                field_153201_h = 36096;
                field_153202_i = 36053;
                field_153204_k = 36055;
                field_153203_j = 36054;
                field_153205_l = 36059;
                field_153206_m = 36060;
            } else if (gLCapabilities.GL_EXT_framebuffer_object) {
                field_153196_B = field_153196_B + "EXT_framebuffer_object is supported.\n";
                field_153212_w = FboMode.EXT;
                field_153198_e = 36160;
                field_153199_f = 36161;
                field_153200_g = 36064;
                field_153201_h = 36096;
                field_153202_i = 36053;
                field_153204_k = 36055;
                field_153203_j = 36054;
                field_153205_l = 36059;
                field_153206_m = 36060;
            }
        } else {
            field_153196_B = field_153196_B + "Not using framebuffer objects because ";
            field_153196_B = field_153196_B + "OpenGL 1.4 is " + (gLCapabilities.OpenGL14 ? "" : "not ") + "supported, ";
            field_153196_B = field_153196_B + "EXT_blend_func_separate is " + (gLCapabilities.GL_EXT_blend_func_separate ? "" : "not ") + "supported, ";
            field_153196_B = field_153196_B + "OpenGL 3.0 is " + (gLCapabilities.OpenGL30 ? "" : "not ") + "supported, ";
            field_153196_B = field_153196_B + "ARB_framebuffer_object is " + (gLCapabilities.GL_ARB_framebuffer_object ? "" : "not ") + "supported, and ";
            field_153196_B = field_153196_B + "EXT_framebuffer_object is " + (gLCapabilities.GL_EXT_framebuffer_object ? "" : "not ") + "supported.\n";
        }
        field_148827_a = gLCapabilities.OpenGL21;
        field_153213_x = field_148827_a || gLCapabilities.GL_ARB_vertex_shader && gLCapabilities.GL_ARB_fragment_shader && gLCapabilities.GL_ARB_shader_objects;
        field_153196_B = field_153196_B + "Shaders are " + (field_153213_x ? "" : "not ") + "available because ";
        if (field_153213_x) {
            if (gLCapabilities.OpenGL21) {
                field_153196_B = field_153196_B + "OpenGL 2.1 is supported.\n";
                field_153214_y = false;
                field_153207_o = 35714;
                field_153208_p = 35713;
                field_153209_q = 35633;
                field_153210_r = 35632;
            } else {
                field_153196_B = field_153196_B + "ARB_shader_objects, ARB_vertex_shader, and ARB_fragment_shader are supported.\n";
                field_153214_y = true;
                field_153207_o = 35714;
                field_153208_p = 35713;
                field_153209_q = 35633;
                field_153210_r = 35632;
            }
        } else {
            field_153196_B = field_153196_B + "OpenGL 2.1 is " + (gLCapabilities.OpenGL21 ? "" : "not ") + "supported, ";
            field_153196_B = field_153196_B + "ARB_shader_objects is " + (gLCapabilities.GL_ARB_shader_objects ? "" : "not ") + "supported, ";
            field_153196_B = field_153196_B + "ARB_vertex_shader is " + (gLCapabilities.GL_ARB_vertex_shader ? "" : "not ") + "supported, and ";
            field_153196_B = field_153196_B + "ARB_fragment_shader is " + (gLCapabilities.GL_ARB_fragment_shader ? "" : "not ") + "supported.\n";
        }
        field_148824_g = field_148823_f && field_153213_x;
        String \u26032 = GL11.glGetString((int)7936).toLowerCase(Locale.ROOT);
        field_153197_d = \u26032.contains("nvidia");
        field_176090_Y = !gLCapabilities.OpenGL15 && gLCapabilities.GL_ARB_vertex_buffer_object;
        field_176083_O = gLCapabilities.OpenGL15 || field_176090_Y;
        field_153196_B = field_153196_B + "VBOs are " + (field_176083_O ? "" : "not ") + "available because ";
        if (field_176083_O) {
            if (field_176090_Y) {
                field_153196_B = field_153196_B + "ARB_vertex_buffer_object is supported.\n";
                field_148826_e = 35044;
                field_176089_P = 34962;
            } else {
                field_153196_B = field_153196_B + "OpenGL 1.5 is supported.\n";
                field_148826_e = 35044;
                field_176089_P = 34962;
            }
        }
        if (field_181063_b = \u26032.contains("ati")) {
            if (field_176083_O) {
                field_181062_Q = true;
            } else {
                GameSettings.Options.RENDER_DISTANCE.func_148263_a(16.0f);
            }
        }
        try {
            Processor[] processorArray = new SystemInfo().getHardware().getProcessors();
            field_183030_aa = String.format("%dx %s", processorArray.length, processorArray[0]).replaceAll("\\s+", " ");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean func_153193_b() {
        return field_148824_g;
    }

    public static String func_153172_c() {
        return field_153196_B;
    }

    public static int func_153175_a(int n, int n2) {
        if (field_153214_y) {
            return ARBShaderObjects.glGetObjectParameteriARB((int)n, (int)n2);
        }
        return GL20.glGetProgrami((int)n, (int)n2);
    }

    public static void func_153178_b(int n, int n2) {
        if (field_153214_y) {
            ARBShaderObjects.glAttachObjectARB((int)n, (int)n2);
        } else {
            GL20.glAttachShader((int)n, (int)n2);
        }
    }

    public static void func_153180_a(int n) {
        if (field_153214_y) {
            ARBShaderObjects.glDeleteObjectARB((int)n);
        } else {
            GL20.glDeleteShader((int)n);
        }
    }

    public static int func_153195_b(int n) {
        if (field_153214_y) {
            return ARBShaderObjects.glCreateShaderObjectARB((int)n);
        }
        return GL20.glCreateShader((int)n);
    }

    public static void func_195918_a(int n, CharSequence charSequence) {
        if (field_153214_y) {
            ARBShaderObjects.glShaderSourceARB((int)n, (CharSequence)charSequence);
        } else {
            GL20.glShaderSource((int)n, (CharSequence)charSequence);
        }
    }

    public static void func_153170_c(int n) {
        if (field_153214_y) {
            ARBShaderObjects.glCompileShaderARB((int)n);
        } else {
            GL20.glCompileShader((int)n);
        }
    }

    public static int func_153157_c(int n, int n2) {
        if (field_153214_y) {
            return ARBShaderObjects.glGetObjectParameteriARB((int)n, (int)n2);
        }
        return GL20.glGetShaderi((int)n, (int)n2);
    }

    public static String func_153158_d(int n, int n2) {
        if (field_153214_y) {
            return ARBShaderObjects.glGetInfoLogARB((int)n, (int)n2);
        }
        return GL20.glGetShaderInfoLog((int)n, (int)n2);
    }

    public static String func_153166_e(int n, int n2) {
        if (field_153214_y) {
            return ARBShaderObjects.glGetInfoLogARB((int)n, (int)n2);
        }
        return GL20.glGetProgramInfoLog((int)n, (int)n2);
    }

    public static void func_153161_d(int n) {
        if (field_153214_y) {
            ARBShaderObjects.glUseProgramObjectARB((int)n);
        } else {
            GL20.glUseProgram((int)n);
        }
    }

    public static int func_153183_d() {
        if (field_153214_y) {
            return ARBShaderObjects.glCreateProgramObjectARB();
        }
        return GL20.glCreateProgram();
    }

    public static void func_153187_e(int n) {
        if (field_153214_y) {
            ARBShaderObjects.glDeleteObjectARB((int)n);
        } else {
            GL20.glDeleteProgram((int)n);
        }
    }

    public static void func_153179_f(int n) {
        if (field_153214_y) {
            ARBShaderObjects.glLinkProgramARB((int)n);
        } else {
            GL20.glLinkProgram((int)n);
        }
    }

    public static int func_153194_a(int n, CharSequence charSequence) {
        if (field_153214_y) {
            return ARBShaderObjects.glGetUniformLocationARB((int)n, (CharSequence)charSequence);
        }
        return GL20.glGetUniformLocation((int)n, (CharSequence)charSequence);
    }

    public static void func_153181_a(int n, IntBuffer intBuffer) {
        if (field_153214_y) {
            ARBShaderObjects.glUniform1ivARB((int)n, (IntBuffer)intBuffer);
        } else {
            GL20.glUniform1iv((int)n, (IntBuffer)intBuffer);
        }
    }

    public static void func_153163_f(int n, int n2) {
        if (field_153214_y) {
            ARBShaderObjects.glUniform1iARB((int)n, (int)n2);
        } else {
            GL20.glUniform1i((int)n, (int)n2);
        }
    }

    public static void func_153168_a(int n, FloatBuffer floatBuffer) {
        if (field_153214_y) {
            ARBShaderObjects.glUniform1fvARB((int)n, (FloatBuffer)floatBuffer);
        } else {
            GL20.glUniform1fv((int)n, (FloatBuffer)floatBuffer);
        }
    }

    public static void func_153182_b(int n, IntBuffer intBuffer) {
        if (field_153214_y) {
            ARBShaderObjects.glUniform2ivARB((int)n, (IntBuffer)intBuffer);
        } else {
            GL20.glUniform2iv((int)n, (IntBuffer)intBuffer);
        }
    }

    public static void func_153177_b(int n, FloatBuffer floatBuffer) {
        if (field_153214_y) {
            ARBShaderObjects.glUniform2fvARB((int)n, (FloatBuffer)floatBuffer);
        } else {
            GL20.glUniform2fv((int)n, (FloatBuffer)floatBuffer);
        }
    }

    public static void func_153192_c(int n, IntBuffer intBuffer) {
        if (field_153214_y) {
            ARBShaderObjects.glUniform3ivARB((int)n, (IntBuffer)intBuffer);
        } else {
            GL20.glUniform3iv((int)n, (IntBuffer)intBuffer);
        }
    }

    public static void func_153191_c(int n, FloatBuffer floatBuffer) {
        if (field_153214_y) {
            ARBShaderObjects.glUniform3fvARB((int)n, (FloatBuffer)floatBuffer);
        } else {
            GL20.glUniform3fv((int)n, (FloatBuffer)floatBuffer);
        }
    }

    public static void func_153162_d(int n, IntBuffer intBuffer) {
        if (field_153214_y) {
            ARBShaderObjects.glUniform4ivARB((int)n, (IntBuffer)intBuffer);
        } else {
            GL20.glUniform4iv((int)n, (IntBuffer)intBuffer);
        }
    }

    public static void func_153159_d(int n, FloatBuffer floatBuffer) {
        if (field_153214_y) {
            ARBShaderObjects.glUniform4fvARB((int)n, (FloatBuffer)floatBuffer);
        } else {
            GL20.glUniform4fv((int)n, (FloatBuffer)floatBuffer);
        }
    }

    public static void func_153173_a(int n, boolean bl, FloatBuffer floatBuffer) {
        if (field_153214_y) {
            ARBShaderObjects.glUniformMatrix2fvARB((int)n, (boolean)bl, (FloatBuffer)floatBuffer);
        } else {
            GL20.glUniformMatrix2fv((int)n, (boolean)bl, (FloatBuffer)floatBuffer);
        }
    }

    public static void func_153189_b(int n, boolean bl, FloatBuffer floatBuffer) {
        if (field_153214_y) {
            ARBShaderObjects.glUniformMatrix3fvARB((int)n, (boolean)bl, (FloatBuffer)floatBuffer);
        } else {
            GL20.glUniformMatrix3fv((int)n, (boolean)bl, (FloatBuffer)floatBuffer);
        }
    }

    public static void func_153160_c(int n, boolean bl, FloatBuffer floatBuffer) {
        if (field_153214_y) {
            ARBShaderObjects.glUniformMatrix4fvARB((int)n, (boolean)bl, (FloatBuffer)floatBuffer);
        } else {
            GL20.glUniformMatrix4fv((int)n, (boolean)bl, (FloatBuffer)floatBuffer);
        }
    }

    public static int func_153164_b(int n, CharSequence charSequence) {
        if (field_153214_y) {
            return ARBVertexShader.glGetAttribLocationARB((int)n, (CharSequence)charSequence);
        }
        return GL20.glGetAttribLocation((int)n, (CharSequence)charSequence);
    }

    public static int func_176073_e() {
        if (field_176090_Y) {
            return ARBVertexBufferObject.glGenBuffersARB();
        }
        return GL15.glGenBuffers();
    }

    public static void func_176072_g(int n, int n2) {
        if (field_176090_Y) {
            ARBVertexBufferObject.glBindBufferARB((int)n, (int)n2);
        } else {
            GL15.glBindBuffer((int)n, (int)n2);
        }
    }

    public static void func_176071_a(int n, ByteBuffer byteBuffer, int n2) {
        if (field_176090_Y) {
            ARBVertexBufferObject.glBufferDataARB((int)n, (ByteBuffer)byteBuffer, (int)n2);
        } else {
            GL15.glBufferData((int)n, (ByteBuffer)byteBuffer, (int)n2);
        }
    }

    public static void func_176074_g(int n) {
        if (field_176090_Y) {
            ARBVertexBufferObject.glDeleteBuffersARB((int)n);
        } else {
            GL15.glDeleteBuffers((int)n);
        }
    }

    public static boolean func_176075_f() {
        return field_176083_O && Minecraft.func_71410_x().field_71474_y.field_178881_t;
    }

    public static void func_153171_g(int n, int n2) {
        if (!field_148823_f) {
            return;
        }
        switch (field_153212_w) {
            case BASE: {
                GL30.glBindFramebuffer((int)n, (int)n2);
                break;
            }
            case ARB: {
                ARBFramebufferObject.glBindFramebuffer((int)n, (int)n2);
                break;
            }
            case EXT: {
                EXTFramebufferObject.glBindFramebufferEXT((int)n, (int)n2);
            }
        }
    }

    public static void func_153176_h(int n, int n2) {
        if (!field_148823_f) {
            return;
        }
        switch (field_153212_w) {
            case BASE: {
                GL30.glBindRenderbuffer((int)n, (int)n2);
                break;
            }
            case ARB: {
                ARBFramebufferObject.glBindRenderbuffer((int)n, (int)n2);
                break;
            }
            case EXT: {
                EXTFramebufferObject.glBindRenderbufferEXT((int)n, (int)n2);
            }
        }
    }

    public static void func_153184_g(int n) {
        if (!field_148823_f) {
            return;
        }
        switch (field_153212_w) {
            case BASE: {
                GL30.glDeleteRenderbuffers((int)n);
                break;
            }
            case ARB: {
                ARBFramebufferObject.glDeleteRenderbuffers((int)n);
                break;
            }
            case EXT: {
                EXTFramebufferObject.glDeleteRenderbuffersEXT((int)n);
            }
        }
    }

    public static void func_153174_h(int n) {
        if (!field_148823_f) {
            return;
        }
        switch (field_153212_w) {
            case BASE: {
                GL30.glDeleteFramebuffers((int)n);
                break;
            }
            case ARB: {
                ARBFramebufferObject.glDeleteFramebuffers((int)n);
                break;
            }
            case EXT: {
                EXTFramebufferObject.glDeleteFramebuffersEXT((int)n);
            }
        }
    }

    public static int func_153165_e() {
        if (!field_148823_f) {
            return -1;
        }
        switch (field_153212_w) {
            case BASE: {
                return GL30.glGenFramebuffers();
            }
            case ARB: {
                return ARBFramebufferObject.glGenFramebuffers();
            }
            case EXT: {
                return EXTFramebufferObject.glGenFramebuffersEXT();
            }
        }
        return -1;
    }

    public static int func_153185_f() {
        if (!field_148823_f) {
            return -1;
        }
        switch (field_153212_w) {
            case BASE: {
                return GL30.glGenRenderbuffers();
            }
            case ARB: {
                return ARBFramebufferObject.glGenRenderbuffers();
            }
            case EXT: {
                return EXTFramebufferObject.glGenRenderbuffersEXT();
            }
        }
        return -1;
    }

    public static void func_153186_a(int n, int n2, int n3, int n4) {
        if (!field_148823_f) {
            return;
        }
        switch (field_153212_w) {
            case BASE: {
                GL30.glRenderbufferStorage((int)n, (int)n2, (int)n3, (int)n4);
                break;
            }
            case ARB: {
                ARBFramebufferObject.glRenderbufferStorage((int)n, (int)n2, (int)n3, (int)n4);
                break;
            }
            case EXT: {
                EXTFramebufferObject.glRenderbufferStorageEXT((int)n, (int)n2, (int)n3, (int)n4);
            }
        }
    }

    public static void func_153190_b(int n, int n2, int n3, int n4) {
        if (!field_148823_f) {
            return;
        }
        switch (field_153212_w) {
            case BASE: {
                GL30.glFramebufferRenderbuffer((int)n, (int)n2, (int)n3, (int)n4);
                break;
            }
            case ARB: {
                ARBFramebufferObject.glFramebufferRenderbuffer((int)n, (int)n2, (int)n3, (int)n4);
                break;
            }
            case EXT: {
                EXTFramebufferObject.glFramebufferRenderbufferEXT((int)n, (int)n2, (int)n3, (int)n4);
            }
        }
    }

    public static int func_153167_i(int n) {
        if (!field_148823_f) {
            return -1;
        }
        switch (field_153212_w) {
            case BASE: {
                return GL30.glCheckFramebufferStatus((int)n);
            }
            case ARB: {
                return ARBFramebufferObject.glCheckFramebufferStatus((int)n);
            }
            case EXT: {
                return EXTFramebufferObject.glCheckFramebufferStatusEXT((int)n);
            }
        }
        return -1;
    }

    public static void func_153188_a(int n, int n2, int n3, int n4, int n5) {
        if (!field_148823_f) {
            return;
        }
        switch (field_153212_w) {
            case BASE: {
                GL30.glFramebufferTexture2D((int)n, (int)n2, (int)n3, (int)n4, (int)n5);
                break;
            }
            case ARB: {
                ARBFramebufferObject.glFramebufferTexture2D((int)n, (int)n2, (int)n3, (int)n4, (int)n5);
                break;
            }
            case EXT: {
                EXTFramebufferObject.glFramebufferTexture2DEXT((int)n, (int)n2, (int)n3, (int)n4, (int)n5);
            }
        }
    }

    public static void func_77473_a(int n) {
        if (field_153215_z) {
            ARBMultitexture.glActiveTextureARB((int)n);
        } else {
            GL13.glActiveTexture((int)n);
        }
    }

    public static void func_77472_b(int n) {
        if (field_153215_z) {
            ARBMultitexture.glClientActiveTextureARB((int)n);
        } else {
            GL13.glClientActiveTexture((int)n);
        }
    }

    public static void func_77475_a(int n, float f, float f2) {
        if (field_153215_z) {
            ARBMultitexture.glMultiTexCoord2fARB((int)n, (float)f, (float)f2);
        } else {
            GL13.glMultiTexCoord2f((int)n, (float)f, (float)f2);
        }
    }

    public static void func_148821_a(int n, int n2, int n3, int n4) {
        if (field_148828_i) {
            if (field_153211_u) {
                EXTBlendFuncSeparate.glBlendFuncSeparateEXT((int)n, (int)n2, (int)n3, (int)n4);
            } else {
                GL14.glBlendFuncSeparate((int)n, (int)n2, (int)n3, (int)n4);
            }
        } else {
            GL11.glBlendFunc((int)n, (int)n2);
        }
    }

    public static boolean func_148822_b() {
        return field_148823_f && Minecraft.func_71410_x().field_71474_y.field_151448_g;
    }

    public static String func_183029_j() {
        return field_183030_aa == null ? "<unknown>" : field_183030_aa;
    }

    public static void func_188785_m(int n) {
        OpenGlHelper.func_203094_a(n, true, true, true);
    }

    public static void func_203094_a(int n, boolean bl, boolean bl2, boolean bl3) {
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a(false);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder \u26032 = tessellator.func_178180_c();
        GL11.glLineWidth((float)4.0f);
        \u26032.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        if (bl) {
            \u26032.func_181662_b(0.0, 0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            \u26032.func_181662_b(n, 0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
        }
        if (bl2) {
            \u26032.func_181662_b(0.0, 0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            \u26032.func_181662_b(0.0, n, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
        }
        if (bl3) {
            \u26032.func_181662_b(0.0, 0.0, 0.0).func_181669_b(0, 0, 0, 255).func_181675_d();
            \u26032.func_181662_b(0.0, 0.0, n).func_181669_b(0, 0, 0, 255).func_181675_d();
        }
        tessellator.func_78381_a();
        GL11.glLineWidth((float)2.0f);
        \u26032.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        if (bl) {
            \u26032.func_181662_b(0.0, 0.0, 0.0).func_181669_b(255, 0, 0, 255).func_181675_d();
            \u26032.func_181662_b(n, 0.0, 0.0).func_181669_b(255, 0, 0, 255).func_181675_d();
        }
        if (bl2) {
            \u26032.func_181662_b(0.0, 0.0, 0.0).func_181669_b(0, 255, 0, 255).func_181675_d();
            \u26032.func_181662_b(0.0, n, 0.0).func_181669_b(0, 255, 0, 255).func_181675_d();
        }
        if (bl3) {
            \u26032.func_181662_b(0.0, 0.0, 0.0).func_181669_b(127, 127, 255, 255).func_181675_d();
            \u26032.func_181662_b(0.0, 0.0, n).func_181669_b(127, 127, 255, 255).func_181675_d();
        }
        tessellator.func_78381_a();
        GL11.glLineWidth((float)1.0f);
        GlStateManager.func_179132_a(true);
        GlStateManager.func_179098_w();
    }

    public static String func_195917_n(int n) {
        return field_195919_ac.get(n);
    }

    static {
        field_153196_B = "";
        field_195919_ac = Util.func_200696_a(Maps.newHashMap(), hashMap -> {
            hashMap.put(0, "No error");
            hashMap.put(1280, "Enum parameter is invalid for this function");
            hashMap.put(1281, "Parameter is invalid for this function");
            hashMap.put(1282, "Current state is invalid for this function");
            hashMap.put(1283, "Stack overflow");
            hashMap.put(1284, "Stack underflow");
            hashMap.put(1285, "Out of memory");
            hashMap.put(1286, "Operation on incomplete framebuffer");
            hashMap.put(1286, "Operation on incomplete framebuffer");
        });
    }

    static enum FboMode {
        BASE,
        ARB,
        EXT;

    }
}

