/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer;

import java.util.Arrays;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.util.math.MathHelper;

public final class Quaternion {
    private final float[] field_195895_a;

    public Quaternion() {
        this.field_195895_a = new float[4];
        this.field_195895_a[4] = 1.0f;
    }

    public Quaternion(float f, float f2, float f3, float f4) {
        this.field_195895_a = new float[4];
        this.field_195895_a[0] = f;
        this.field_195895_a[1] = f2;
        this.field_195895_a[2] = f3;
        this.field_195895_a[3] = f4;
    }

    public Quaternion(Vector3f vector3f, float f, boolean bl) {
        if (bl) {
            f *= (float)Math.PI / 180;
        }
        float f2 = MathHelper.func_76126_a(f / 2.0f);
        this.field_195895_a = new float[4];
        this.field_195895_a[0] = vector3f.func_195899_a() * f2;
        this.field_195895_a[1] = vector3f.func_195900_b() * f2;
        this.field_195895_a[2] = vector3f.func_195902_c() * f2;
        this.field_195895_a[3] = MathHelper.func_76134_b(f / 2.0f);
    }

    public Quaternion(float f, float f2, float f3, boolean bl) {
        if (bl) {
            f *= (float)Math.PI / 180;
            f2 *= (float)Math.PI / 180;
            f3 *= (float)Math.PI / 180;
        }
        float f4 = MathHelper.func_76126_a(0.5f * f);
        \u2603 = MathHelper.func_76134_b(0.5f * f);
        \u2603 = MathHelper.func_76126_a(0.5f * f2);
        \u2603 = MathHelper.func_76134_b(0.5f * f2);
        \u2603 = MathHelper.func_76126_a(0.5f * f3);
        \u2603 = MathHelper.func_76134_b(0.5f * f3);
        this.field_195895_a = new float[4];
        this.field_195895_a[0] = f4 * \u2603 * \u2603 + \u2603 * \u2603 * \u2603;
        this.field_195895_a[1] = \u2603 * \u2603 * \u2603 - f4 * \u2603 * \u2603;
        this.field_195895_a[2] = f4 * \u2603 * \u2603 + \u2603 * \u2603 * \u2603;
        this.field_195895_a[3] = \u2603 * \u2603 * \u2603 - f4 * \u2603 * \u2603;
    }

    public Quaternion(Quaternion quaternion) {
        this.field_195895_a = Arrays.copyOf(quaternion.field_195895_a, 4);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Quaternion quaternion = (Quaternion)object;
        return Arrays.equals(this.field_195895_a, quaternion.field_195895_a);
    }

    public int hashCode() {
        return Arrays.hashCode(this.field_195895_a);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Quaternion[").append(this.func_195894_d()).append(" + ");
        stringBuilder.append(this.func_195889_a()).append("i + ");
        stringBuilder.append(this.func_195891_b()).append("j + ");
        stringBuilder.append(this.func_195893_c()).append("k]");
        return stringBuilder.toString();
    }

    public float func_195889_a() {
        return this.field_195895_a[0];
    }

    public float func_195891_b() {
        return this.field_195895_a[1];
    }

    public float func_195893_c() {
        return this.field_195895_a[2];
    }

    public float func_195894_d() {
        return this.field_195895_a[3];
    }

    public void func_195890_a(Quaternion quaternion) {
        float f = this.func_195889_a();
        \u2603 = this.func_195891_b();
        \u2603 = this.func_195893_c();
        \u2603 = this.func_195894_d();
        \u2603 = quaternion.func_195889_a();
        \u2603 = quaternion.func_195891_b();
        \u2603 = quaternion.func_195893_c();
        \u2603 = quaternion.func_195894_d();
        this.field_195895_a[0] = \u2603 * \u2603 + f * \u2603 + \u2603 * \u2603 - \u2603 * \u2603;
        this.field_195895_a[1] = \u2603 * \u2603 - f * \u2603 + \u2603 * \u2603 + \u2603 * \u2603;
        this.field_195895_a[2] = \u2603 * \u2603 + f * \u2603 - \u2603 * \u2603 + \u2603 * \u2603;
        this.field_195895_a[3] = \u2603 * \u2603 - f * \u2603 - \u2603 * \u2603 - \u2603 * \u2603;
    }

    public void func_195892_e() {
        this.field_195895_a[0] = -this.field_195895_a[0];
        this.field_195895_a[1] = -this.field_195895_a[1];
        this.field_195895_a[2] = -this.field_195895_a[2];
    }
}

