/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.primitives.Doubles;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableFutureTask;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.ThreadFactory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RegionRenderCacheBuilder;
import net.minecraft.client.renderer.VertexBufferUploader;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.chunk.ChunkRenderTask;
import net.minecraft.client.renderer.chunk.ChunkRenderWorker;
import net.minecraft.client.renderer.chunk.CompiledChunk;
import net.minecraft.client.renderer.chunk.ListedRenderChunk;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkRenderDispatcher {
    private static final Logger field_178523_a = LogManager.getLogger();
    private static final ThreadFactory field_178521_b = new ThreadFactoryBuilder().setNameFormat("Chunk Batcher %d").setDaemon(true).setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new DefaultUncaughtExceptionHandler(field_178523_a)).build();
    private final int field_188249_c;
    private final List<Thread> field_188250_d = Lists.newArrayList();
    private final List<ChunkRenderWorker> field_178522_c = Lists.newArrayList();
    private final PriorityBlockingQueue<ChunkRenderTask> field_178519_d = Queues.newPriorityBlockingQueue();
    private final BlockingQueue<RegionRenderCacheBuilder> field_178520_e;
    private final WorldVertexBufferUploader field_178517_f = new WorldVertexBufferUploader();
    private final VertexBufferUploader field_178518_g = new VertexBufferUploader();
    private final Queue<PendingUpload> field_178524_h = Queues.newPriorityQueue();
    private final ChunkRenderWorker field_178525_i;

    public ChunkRenderDispatcher() {
        int n = Math.max(1, (int)((double)Runtime.getRuntime().maxMemory() * 0.3) / 0xA00000);
        \u2603 = Math.max(1, MathHelper.func_76125_a(Runtime.getRuntime().availableProcessors(), 1, n / 5));
        this.field_188249_c = MathHelper.func_76125_a(\u2603 * 10, 1, n);
        if (\u2603 > 1) {
            for (i = 0; i < \u2603; ++i) {
                ChunkRenderWorker chunkRenderWorker = new ChunkRenderWorker(this);
                Thread \u26032 = field_178521_b.newThread(chunkRenderWorker);
                \u26032.start();
                this.field_178522_c.add(chunkRenderWorker);
                this.field_188250_d.add(\u26032);
            }
        }
        this.field_178520_e = Queues.newArrayBlockingQueue((int)this.field_188249_c);
        for (int i = 0; i < this.field_188249_c; ++i) {
            this.field_178520_e.add(new RegionRenderCacheBuilder());
        }
        this.field_178525_i = new ChunkRenderWorker(this, new RegionRenderCacheBuilder());
    }

    public String func_178504_a() {
        if (this.field_188250_d.isEmpty()) {
            return String.format("pC: %03d, single-threaded", this.field_178519_d.size());
        }
        return String.format("pC: %03d, pU: %1d, aB: %1d", this.field_178519_d.size(), this.field_178524_h.size(), this.field_178520_e.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_178516_a(long l) {
        boolean bl = false;
        do {
            bl2 = false;
            if (this.field_188250_d.isEmpty() && (\u2603 = this.field_178519_d.poll()) != null) {
                try {
                    this.field_178525_i.func_178474_a(\u2603);
                    bl2 = true;
                }
                catch (InterruptedException interruptedException) {
                    field_178523_a.warn("Skipped task due to interrupt");
                }
            }
            Queue<PendingUpload> queue = this.field_178524_h;
            synchronized (queue) {
                if (!this.field_178524_h.isEmpty()) {
                    this.field_178524_h.poll().field_188241_b.run();
                    boolean bl2 = true;
                    bl = true;
                }
            }
        } while (l != 0L && bl2 && l >= Util.func_211178_c());
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_178507_a(RenderChunk renderChunk) {
        renderChunk.func_178579_c().lock();
        try {
            ChunkRenderTask chunkRenderTask = renderChunk.func_178574_d();
            chunkRenderTask.func_178539_a(() -> this.field_178519_d.remove(chunkRenderTask));
            boolean \u26032 = this.field_178519_d.offer(chunkRenderTask);
            if (!\u26032) {
                chunkRenderTask.func_178542_e();
            }
            boolean bl = \u26032;
            return bl;
        }
        finally {
            renderChunk.func_178579_c().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_178505_b(RenderChunk renderChunk2) {
        renderChunk2.func_178579_c().lock();
        try {
            ChunkRenderTask chunkRenderTask = renderChunk2.func_178574_d();
            try {
                this.field_178525_i.func_178474_a(chunkRenderTask);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            boolean bl = true;
            return bl;
        }
        finally {
            RenderChunk renderChunk2;
            renderChunk2.func_178579_c().unlock();
        }
    }

    public void func_178514_b() {
        this.func_178513_e();
        ArrayList arrayList = Lists.newArrayList();
        while (arrayList.size() != this.field_188249_c) {
            this.func_178516_a(Long.MAX_VALUE);
            try {
                arrayList.add(this.func_178515_c());
            }
            catch (InterruptedException interruptedException) {}
        }
        this.field_178520_e.addAll(arrayList);
    }

    public void func_178512_a(RegionRenderCacheBuilder regionRenderCacheBuilder) {
        this.field_178520_e.add(regionRenderCacheBuilder);
    }

    public RegionRenderCacheBuilder func_178515_c() throws InterruptedException {
        return this.field_178520_e.take();
    }

    public ChunkRenderTask func_178511_d() throws InterruptedException {
        return this.field_178519_d.take();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean func_178509_c(RenderChunk renderChunk2) {
        renderChunk2.func_178579_c().lock();
        try {
            ChunkRenderTask chunkRenderTask = renderChunk2.func_178582_e();
            if (chunkRenderTask != null) {
                chunkRenderTask.func_178539_a(() -> this.field_178519_d.remove(chunkRenderTask));
                boolean bl = this.field_178519_d.offer(chunkRenderTask);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            RenderChunk renderChunk2;
            renderChunk2.func_178579_c().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<Object> func_188245_a(BlockRenderLayer blockRenderLayer, BufferBuilder bufferBuilder, RenderChunk renderChunk, CompiledChunk compiledChunk, double d) {
        if (Minecraft.func_71410_x().func_152345_ab()) {
            if (OpenGlHelper.func_176075_f()) {
                this.func_178506_a(bufferBuilder, renderChunk.func_178565_b(blockRenderLayer.ordinal()));
            } else {
                this.func_178510_a(bufferBuilder, ((ListedRenderChunk)renderChunk).func_178600_a(blockRenderLayer, compiledChunk), renderChunk);
            }
            bufferBuilder.func_178969_c(0.0, 0.0, 0.0);
            return Futures.immediateFuture(null);
        }
        ListenableFutureTask listenableFutureTask = ListenableFutureTask.create(() -> this.func_188245_a(blockRenderLayer, bufferBuilder, renderChunk, compiledChunk, d), null);
        Queue<PendingUpload> queue = this.field_178524_h;
        synchronized (queue) {
            this.field_178524_h.add(new PendingUpload((ListenableFutureTask<Object>)listenableFutureTask, d));
        }
        return listenableFutureTask;
    }

    private void func_178510_a(BufferBuilder bufferBuilder, int n, RenderChunk renderChunk) {
        GlStateManager.func_187423_f(n, 4864);
        GlStateManager.func_179094_E();
        renderChunk.func_178572_f();
        this.field_178517_f.func_181679_a(bufferBuilder);
        GlStateManager.func_179121_F();
        GlStateManager.func_187415_K();
    }

    private void func_178506_a(BufferBuilder bufferBuilder, VertexBuffer vertexBuffer) {
        this.field_178518_g.func_178178_a(vertexBuffer);
        this.field_178518_g.func_181679_a(bufferBuilder);
    }

    public void func_178513_e() {
        while (!this.field_178519_d.isEmpty()) {
            ChunkRenderTask chunkRenderTask = this.field_178519_d.poll();
            if (chunkRenderTask == null) continue;
            chunkRenderTask.func_178542_e();
        }
    }

    public boolean func_188247_f() {
        return this.field_178519_d.isEmpty() && this.field_178524_h.isEmpty();
    }

    public void func_188244_g() {
        this.func_178513_e();
        for (ChunkRenderWorker chunkRenderWorker : this.field_178522_c) {
            chunkRenderWorker.func_188264_a();
        }
        for (Thread thread : this.field_188250_d) {
            try {
                thread.interrupt();
                thread.join();
            }
            catch (InterruptedException interruptedException) {
                field_178523_a.warn("Interrupted whilst waiting for worker to die", (Throwable)interruptedException);
            }
        }
        this.field_178520_e.clear();
    }

    public boolean func_188248_h() {
        return this.field_178520_e.isEmpty();
    }

    class PendingUpload
    implements Comparable<PendingUpload> {
        private final ListenableFutureTask<Object> field_188241_b;
        private final double field_188242_c;

        public PendingUpload(ListenableFutureTask<Object> listenableFutureTask, double d) {
            this.field_188241_b = listenableFutureTask;
            this.field_188242_c = d;
        }

        @Override
        public int compareTo(PendingUpload pendingUpload) {
            return Doubles.compare((double)this.field_188242_c, (double)pendingUpload.field_188242_c);
        }

        @Override
        public /* synthetic */ int compareTo(Object object) {
            return this.compareTo((PendingUpload)object);
        }
    }
}

