/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import com.google.common.collect.Lists;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.RegionRenderCacheBuilder;
import net.minecraft.client.renderer.chunk.ChunkRenderDispatcher;
import net.minecraft.client.renderer.chunk.ChunkRenderTask;
import net.minecraft.client.renderer.chunk.CompiledChunk;
import net.minecraft.crash.CrashReport;
import net.minecraft.entity.Entity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkRenderWorker
implements Runnable {
    private static final Logger field_152478_a = LogManager.getLogger();
    private final ChunkRenderDispatcher field_178477_b;
    private final RegionRenderCacheBuilder field_178478_c;
    private boolean field_188265_d = true;

    public ChunkRenderWorker(ChunkRenderDispatcher chunkRenderDispatcher) {
        this(chunkRenderDispatcher, null);
    }

    public ChunkRenderWorker(ChunkRenderDispatcher chunkRenderDispatcher, @Nullable RegionRenderCacheBuilder regionRenderCacheBuilder) {
        this.field_178477_b = chunkRenderDispatcher;
        this.field_178478_c = regionRenderCacheBuilder;
    }

    @Override
    public void run() {
        while (this.field_188265_d) {
            try {
                this.func_178474_a(this.field_178477_b.func_178511_d());
            }
            catch (InterruptedException interruptedException) {
                field_152478_a.debug("Stopping chunk worker due to interrupt");
                return;
            }
            catch (Throwable throwable) {
                CrashReport crashReport = CrashReport.func_85055_a(throwable, "Batching chunks");
                Minecraft.func_71410_x().func_71404_a(Minecraft.func_71410_x().func_71396_d(crashReport));
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void func_178474_a(final ChunkRenderTask chunkRenderTask2) throws InterruptedException {
        chunkRenderTask2.func_178540_f().lock();
        try {
            if (chunkRenderTask2.func_178546_a() != ChunkRenderTask.Status.PENDING) {
                if (!chunkRenderTask2.func_178537_h()) {
                    field_152478_a.warn("Chunk render task was {} when I expected it to be pending; ignoring task", (Object)chunkRenderTask2.func_178546_a());
                }
                return;
            }
            Object object = new BlockPos(Minecraft.func_71410_x().field_71439_g);
            \u2603 = chunkRenderTask2.func_178536_b().func_178568_j();
            int \u26032 = 16;
            int \u26033 = 8;
            int \u26034 = 24;
            if (((BlockPos)\u2603).func_177982_a(8, 8, 8).func_177951_i((Vec3i)object) > 576.0) {
                \u26035 = chunkRenderTask2.func_178536_b().func_188283_p();
                \u26036 = new BlockPos.MutableBlockPos((BlockPos)\u2603);
                if (!(this.func_188263_a(((BlockPos.MutableBlockPos)\u26036).func_189533_g((Vec3i)\u2603).func_189534_c(EnumFacing.WEST, 16), (World)\u26035) && this.func_188263_a(((BlockPos.MutableBlockPos)\u26036).func_189533_g((Vec3i)\u2603).func_189534_c(EnumFacing.NORTH, 16), (World)\u26035) && this.func_188263_a(((BlockPos.MutableBlockPos)\u26036).func_189533_g((Vec3i)\u2603).func_189534_c(EnumFacing.EAST, 16), (World)\u26035) && this.func_188263_a(((BlockPos.MutableBlockPos)\u26036).func_189533_g((Vec3i)\u2603).func_189534_c(EnumFacing.SOUTH, 16), (World)\u26035))) {
                    return;
                }
            }
            chunkRenderTask2.func_178535_a(ChunkRenderTask.Status.COMPILING);
        }
        finally {
            chunkRenderTask2.func_178540_f().unlock();
        }
        object = Minecraft.func_71410_x().func_175606_aa();
        if (object == null) {
            chunkRenderTask2.func_178542_e();
            return;
        }
        chunkRenderTask2.func_178541_a(this.func_178475_b());
        \u2603 = ActiveRenderInfo.func_178806_a((Entity)object, 1.0);
        float f = (float)((Vec3d)\u2603).field_72450_a;
        \u2603 = (float)((Vec3d)\u2603).field_72448_b;
        \u2603 = (float)((Vec3d)\u2603).field_72449_c;
        Object \u26035 = chunkRenderTask2.func_178538_g();
        if (\u26035 == ChunkRenderTask.Type.REBUILD_CHUNK) {
            chunkRenderTask2.func_178536_b().func_178581_b(f, \u2603, \u2603, chunkRenderTask2);
        } else if (\u26035 == ChunkRenderTask.Type.RESORT_TRANSPARENCY) {
            chunkRenderTask2.func_178536_b().func_178570_a(f, \u2603, \u2603, chunkRenderTask2);
        }
        chunkRenderTask2.func_178540_f().lock();
        try {
            if (chunkRenderTask2.func_178546_a() != ChunkRenderTask.Status.COMPILING) {
                if (!chunkRenderTask2.func_178537_h()) {
                    field_152478_a.warn("Chunk render task was {} when I expected it to be compiling; aborting task", (Object)chunkRenderTask2.func_178546_a());
                }
                this.func_178473_b(chunkRenderTask2);
                return;
            }
            chunkRenderTask2.func_178535_a(ChunkRenderTask.Status.UPLOADING);
        }
        finally {
            chunkRenderTask2.func_178540_f().unlock();
        }
        Object \u26036 = chunkRenderTask2.func_178544_c();
        ArrayList \u26037 = Lists.newArrayList();
        if (\u26035 == ChunkRenderTask.Type.REBUILD_CHUNK) {
            for (BlockRenderLayer blockRenderLayer : BlockRenderLayer.values()) {
                if (!((CompiledChunk)\u26036).func_178492_d(blockRenderLayer)) continue;
                \u26037.add(this.field_178477_b.func_188245_a(blockRenderLayer, chunkRenderTask2.func_178545_d().func_179038_a(blockRenderLayer), chunkRenderTask2.func_178536_b(), (CompiledChunk)\u26036, chunkRenderTask2.func_188228_i()));
            }
        } else if (\u26035 == ChunkRenderTask.Type.RESORT_TRANSPARENCY) {
            ChunkRenderTask chunkRenderTask2;
            \u26037.add(this.field_178477_b.func_188245_a(BlockRenderLayer.TRANSLUCENT, chunkRenderTask2.func_178545_d().func_179038_a(BlockRenderLayer.TRANSLUCENT), chunkRenderTask2.func_178536_b(), (CompiledChunk)\u26036, chunkRenderTask2.func_188228_i()));
        }
        ListenableFuture listenableFuture = Futures.allAsList((Iterable)\u26037);
        chunkRenderTask2.func_178539_a(() -> listenableFuture.cancel(false));
        Futures.addCallback((ListenableFuture)listenableFuture, (FutureCallback)new FutureCallback<List<Object>>((CompiledChunk)\u26036){
            final /* synthetic */ CompiledChunk field_210269_b;
            {
                this.field_210269_b = compiledChunk;
            }

            public void onSuccess(@Nullable List<Object> list) {
                ChunkRenderWorker.this.func_178473_b(chunkRenderTask2);
                chunkRenderTask2.func_178540_f().lock();
                try {
                    if (chunkRenderTask2.func_178546_a() != ChunkRenderTask.Status.UPLOADING) {
                        if (!chunkRenderTask2.func_178537_h()) {
                            field_152478_a.warn("Chunk render task was {} when I expected it to be uploading; aborting task", (Object)chunkRenderTask2.func_178546_a());
                        }
                        return;
                    }
                    chunkRenderTask2.func_178535_a(ChunkRenderTask.Status.DONE);
                }
                finally {
                    chunkRenderTask2.func_178540_f().unlock();
                }
                chunkRenderTask2.func_178536_b().func_178580_a(this.field_210269_b);
            }

            public void onFailure(Throwable throwable) {
                ChunkRenderWorker.this.func_178473_b(chunkRenderTask2);
                if (!(throwable instanceof CancellationException) && !(throwable instanceof InterruptedException)) {
                    Minecraft.func_71410_x().func_71404_a(CrashReport.func_85055_a(throwable, "Rendering chunk"));
                }
            }

            public /* synthetic */ void onSuccess(@Nullable Object object) {
                this.onSuccess((List)object);
            }
        });
    }

    private boolean func_188263_a(BlockPos blockPos, World world) {
        return !world.func_72964_e(blockPos.func_177958_n() >> 4, blockPos.func_177952_p() >> 4).func_76621_g();
    }

    private RegionRenderCacheBuilder func_178475_b() throws InterruptedException {
        return this.field_178478_c != null ? this.field_178478_c : this.field_178477_b.func_178515_c();
    }

    private void func_178473_b(ChunkRenderTask chunkRenderTask) {
        if (this.field_178478_c == null) {
            this.field_178477_b.func_178512_a(chunkRenderTask.func_178545_d());
        }
    }

    public void func_188264_a() {
        this.field_188265_d = false;
    }
}

