/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.chunk;

import com.google.common.collect.Sets;
import java.nio.FloatBuffer;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.BlockModelRenderer;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.chunk.ChunkRenderTask;
import net.minecraft.client.renderer.chunk.CompiledChunk;
import net.minecraft.client.renderer.chunk.RenderChunkCache;
import net.minecraft.client.renderer.chunk.VisGraph;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexBuffer;
import net.minecraft.fluid.IFluidState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class RenderChunk {
    private volatile World field_178588_d;
    private final WorldRenderer field_178589_e;
    public static int field_178592_a;
    public CompiledChunk field_178590_b = CompiledChunk.field_178502_a;
    private final ReentrantLock field_178587_g = new ReentrantLock();
    private final ReentrantLock field_178598_h = new ReentrantLock();
    private ChunkRenderTask field_178599_i;
    private final Set<TileEntity> field_181056_j = Sets.newHashSet();
    private final FloatBuffer field_178597_k = GLAllocation.func_74529_h(16);
    private final VertexBuffer[] field_178594_l = new VertexBuffer[BlockRenderLayer.values().length];
    public AxisAlignedBB field_178591_c;
    private int field_178595_m = -1;
    private boolean field_178593_n = true;
    private final BlockPos.MutableBlockPos field_178586_f = new BlockPos.MutableBlockPos(-1, -1, -1);
    private final BlockPos.MutableBlockPos[] field_181702_p = Util.func_200696_a(new BlockPos.MutableBlockPos[6], mutableBlockPosArray -> {
        for (int i = 0; i < ((BlockPos.MutableBlockPos[])mutableBlockPosArray).length; ++i) {
            mutableBlockPosArray[i] = new BlockPos.MutableBlockPos();
        }
    });
    private boolean field_188284_q;

    public RenderChunk(World world, WorldRenderer worldRenderer) {
        this.field_178588_d = world;
        this.field_178589_e = worldRenderer;
        if (OpenGlHelper.func_176075_f()) {
            for (int i = 0; i < BlockRenderLayer.values().length; ++i) {
                this.field_178594_l[i] = new VertexBuffer(DefaultVertexFormats.field_176600_a);
            }
        }
    }

    public boolean func_178577_a(int n) {
        if (this.field_178595_m == n) {
            return false;
        }
        this.field_178595_m = n;
        return true;
    }

    public VertexBuffer func_178565_b(int n) {
        return this.field_178594_l[n];
    }

    public void func_189562_a(int n, int n2, int n3) {
        if (n == this.field_178586_f.func_177958_n() && n2 == this.field_178586_f.func_177956_o() && n3 == this.field_178586_f.func_177952_p()) {
            return;
        }
        this.func_178585_h();
        this.field_178586_f.func_181079_c(n, n2, n3);
        this.field_178591_c = new AxisAlignedBB(n, n2, n3, n + 16, n2 + 16, n3 + 16);
        for (EnumFacing enumFacing : EnumFacing.values()) {
            this.field_181702_p[enumFacing.ordinal()].func_189533_g(this.field_178586_f).func_189534_c(enumFacing, 16);
        }
        this.func_178567_n();
    }

    public void func_178570_a(float f, float f2, float f3, ChunkRenderTask chunkRenderTask) {
        CompiledChunk compiledChunk = chunkRenderTask.func_178544_c();
        if (compiledChunk.func_178487_c() == null || compiledChunk.func_178491_b(BlockRenderLayer.TRANSLUCENT)) {
            return;
        }
        this.func_178573_a(chunkRenderTask.func_178545_d().func_179038_a(BlockRenderLayer.TRANSLUCENT), this.field_178586_f);
        chunkRenderTask.func_178545_d().func_179038_a(BlockRenderLayer.TRANSLUCENT).func_178993_a(compiledChunk.func_178487_c());
        this.func_178584_a(BlockRenderLayer.TRANSLUCENT, f, f2, f3, chunkRenderTask.func_178545_d().func_179038_a(BlockRenderLayer.TRANSLUCENT), compiledChunk);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_178581_b(float f, float f2, float f3, ChunkRenderTask chunkRenderTask) {
        CompiledChunk compiledChunk = new CompiledChunk();
        boolean \u26032 = true;
        BlockPos \u26033 = this.field_178586_f.func_185334_h();
        BlockPos \u26034 = \u26033.func_177982_a(15, 15, 15);
        World \u26035 = this.field_178588_d;
        if (\u26035 == null) {
            return;
        }
        chunkRenderTask.func_178540_f().lock();
        try {
            if (chunkRenderTask.func_178546_a() != ChunkRenderTask.Status.COMPILING) {
                return;
            }
            chunkRenderTask.func_178543_a(compiledChunk);
        }
        finally {
            chunkRenderTask.func_178540_f().unlock();
        }
        RenderChunkCache \u26036 = RenderChunkCache.func_212397_a(\u26035, \u26033.func_177982_a(-1, -1, -1), \u26033.func_177982_a(16, 16, 16), 1);
        VisGraph \u26037 = new VisGraph();
        HashSet \u26038 = Sets.newHashSet();
        if (\u26036 != null) {
            ++field_178592_a;
            boolean[] object = new boolean[BlockRenderLayer.values().length];
            BlockModelRenderer.func_211847_a();
            Random \u26039 = new Random();
            BlockRendererDispatcher \u260310 = Minecraft.func_71410_x().func_175602_ab();
            for (BlockPos.MutableBlockPos mutableBlockPos : BlockPos.func_177975_b(\u26033, \u26034)) {
                Object object2;
                IBlockState iBlockState = \u26036.func_180495_p(mutableBlockPos);
                Block block = iBlockState.func_177230_c();
                if (iBlockState.func_200015_d(\u26036, mutableBlockPos)) {
                    \u26037.func_178606_a(mutableBlockPos);
                }
                if (block.func_149716_u() && (object2 = \u26036.func_212399_a(mutableBlockPos, Chunk.EnumCreateEntityType.CHECK)) != null && (\u2603 = TileEntityRendererDispatcher.field_147556_a.func_147547_b((TileEntity)object2)) != null) {
                    compiledChunk.func_178490_a((TileEntity)object2);
                    if (((TileEntityRenderer)\u2603).func_188185_a(object2)) {
                        \u26038.add(object2);
                    }
                }
                if (!(object2 = \u26036.func_204610_c(mutableBlockPos)).func_206888_e()) {
                    BlockRenderLayer object22 = object2.func_180664_k();
                    int \u260312 = object22.ordinal();
                    BufferBuilder \u260313 = chunkRenderTask.func_178545_d().func_179039_a(\u260312);
                    if (!compiledChunk.func_178492_d(object22)) {
                        compiledChunk.func_178493_c(object22);
                        this.func_178573_a(\u260313, \u26033);
                    }
                    int n = \u260312;
                    object[n] = object[n] | \u260310.func_205318_a(mutableBlockPos, \u26036, \u260313, (IFluidState)object2);
                }
                if (iBlockState.func_185901_i() == EnumBlockRenderType.INVISIBLE) continue;
                \u2603 = block.func_180664_k();
                int \u260314 = ((Enum)\u2603).ordinal();
                BufferBuilder \u260315 = chunkRenderTask.func_178545_d().func_179039_a(\u260314);
                if (!compiledChunk.func_178492_d((BlockRenderLayer)((Object)\u2603))) {
                    compiledChunk.func_178493_c((BlockRenderLayer)((Object)\u2603));
                    this.func_178573_a(\u260315, \u26033);
                }
                int n = \u260314;
                object[n] = object[n] | \u260310.func_195475_a(iBlockState, mutableBlockPos, \u26036, \u260315, \u26039);
            }
            for (BlockRenderLayer blockRenderLayer : BlockRenderLayer.values()) {
                if (object[blockRenderLayer.ordinal()]) {
                    compiledChunk.func_178486_a(blockRenderLayer);
                }
                if (!compiledChunk.func_178492_d(blockRenderLayer)) continue;
                this.func_178584_a(blockRenderLayer, f, f2, f3, chunkRenderTask.func_178545_d().func_179038_a(blockRenderLayer), compiledChunk);
            }
            BlockModelRenderer.func_210266_a();
        }
        compiledChunk.func_178488_a(\u26037.func_178607_a());
        this.field_178587_g.lock();
        try {
            HashSet hashSet = Sets.newHashSet((Iterable)\u26038);
            \u2603 = Sets.newHashSet(this.field_181056_j);
            hashSet.removeAll(this.field_181056_j);
            \u2603.removeAll(\u26038);
            this.field_181056_j.clear();
            this.field_181056_j.addAll(\u26038);
            this.field_178589_e.func_181023_a(\u2603, hashSet);
        }
        finally {
            this.field_178587_g.unlock();
        }
    }

    protected void func_178578_b() {
        this.field_178587_g.lock();
        try {
            if (this.field_178599_i != null && this.field_178599_i.func_178546_a() != ChunkRenderTask.Status.DONE) {
                this.field_178599_i.func_178542_e();
                this.field_178599_i = null;
            }
        }
        finally {
            this.field_178587_g.unlock();
        }
    }

    public ReentrantLock func_178579_c() {
        return this.field_178587_g;
    }

    public ChunkRenderTask func_178574_d() {
        this.field_178587_g.lock();
        try {
            this.func_178578_b();
            ChunkRenderTask chunkRenderTask = this.field_178599_i = new ChunkRenderTask(this, ChunkRenderTask.Type.REBUILD_CHUNK, this.func_188280_f());
            return chunkRenderTask;
        }
        finally {
            this.field_178587_g.unlock();
        }
    }

    @Nullable
    public ChunkRenderTask func_178582_e() {
        this.field_178587_g.lock();
        try {
            if (this.field_178599_i != null && this.field_178599_i.func_178546_a() == ChunkRenderTask.Status.PENDING) {
                ChunkRenderTask chunkRenderTask = null;
                return chunkRenderTask;
            }
            if (this.field_178599_i != null && this.field_178599_i.func_178546_a() != ChunkRenderTask.Status.DONE) {
                this.field_178599_i.func_178542_e();
                this.field_178599_i = null;
            }
            this.field_178599_i = new ChunkRenderTask(this, ChunkRenderTask.Type.RESORT_TRANSPARENCY, this.func_188280_f());
            this.field_178599_i.func_178543_a(this.field_178590_b);
            ChunkRenderTask chunkRenderTask = this.field_178599_i;
            return chunkRenderTask;
        }
        finally {
            this.field_178587_g.unlock();
        }
    }

    protected double func_188280_f() {
        EntityPlayerSP entityPlayerSP = Minecraft.func_71410_x().field_71439_g;
        double \u26032 = this.field_178591_c.field_72340_a + 8.0 - entityPlayerSP.field_70165_t;
        double \u26033 = this.field_178591_c.field_72338_b + 8.0 - entityPlayerSP.field_70163_u;
        double \u26034 = this.field_178591_c.field_72339_c + 8.0 - entityPlayerSP.field_70161_v;
        return \u26032 * \u26032 + \u26033 * \u26033 + \u26034 * \u26034;
    }

    private void func_178573_a(BufferBuilder bufferBuilder, BlockPos blockPos) {
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_176600_a);
        bufferBuilder.func_178969_c(-blockPos.func_177958_n(), -blockPos.func_177956_o(), -blockPos.func_177952_p());
    }

    private void func_178584_a(BlockRenderLayer blockRenderLayer, float f, float f2, float f3, BufferBuilder bufferBuilder, CompiledChunk compiledChunk) {
        if (blockRenderLayer == BlockRenderLayer.TRANSLUCENT && !compiledChunk.func_178491_b(blockRenderLayer)) {
            bufferBuilder.func_181674_a(f, f2, f3);
            compiledChunk.func_178494_a(bufferBuilder.func_181672_a());
        }
        bufferBuilder.func_178977_d();
    }

    private void func_178567_n() {
        GlStateManager.func_179094_E();
        GlStateManager.func_179096_D();
        float f = 1.000001f;
        GlStateManager.func_179109_b(-8.0f, -8.0f, -8.0f);
        GlStateManager.func_179152_a(1.000001f, 1.000001f, 1.000001f);
        GlStateManager.func_179109_b(8.0f, 8.0f, 8.0f);
        GlStateManager.func_179111_a(2982, this.field_178597_k);
        GlStateManager.func_179121_F();
    }

    public void func_178572_f() {
        GlStateManager.func_179110_a(this.field_178597_k);
    }

    public CompiledChunk func_178571_g() {
        return this.field_178590_b;
    }

    public void func_178580_a(CompiledChunk compiledChunk) {
        this.field_178598_h.lock();
        try {
            this.field_178590_b = compiledChunk;
        }
        finally {
            this.field_178598_h.unlock();
        }
    }

    public void func_178585_h() {
        this.func_178578_b();
        this.field_178590_b = CompiledChunk.field_178502_a;
    }

    public void func_178566_a() {
        this.func_178585_h();
        this.field_178588_d = null;
        for (int i = 0; i < BlockRenderLayer.values().length; ++i) {
            if (this.field_178594_l[i] == null) continue;
            this.field_178594_l[i].func_177362_c();
        }
    }

    public BlockPos func_178568_j() {
        return this.field_178586_f;
    }

    public void func_178575_a(boolean bl) {
        if (this.field_178593_n) {
            bl |= this.field_188284_q;
        }
        this.field_178593_n = true;
        this.field_188284_q = bl;
    }

    public void func_188282_m() {
        this.field_178593_n = false;
        this.field_188284_q = false;
    }

    public boolean func_178569_m() {
        return this.field_178593_n;
    }

    public boolean func_188281_o() {
        return this.field_178593_n && this.field_188284_q;
    }

    public BlockPos func_181701_a(EnumFacing enumFacing) {
        return this.field_181702_p[enumFacing.ordinal()];
    }

    public World func_188283_p() {
        return this.field_178588_d;
    }
}

