/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.BlockPartRotation;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.math.MathHelper;

public class BlockPart {
    public final Vector3f field_178241_a;
    public final Vector3f field_178239_b;
    public final Map<EnumFacing, BlockPartFace> field_178240_c;
    public final BlockPartRotation field_178237_d;
    public final boolean field_178238_e;

    public BlockPart(Vector3f vector3f, Vector3f vector3f2, Map<EnumFacing, BlockPartFace> map, @Nullable BlockPartRotation blockPartRotation, boolean bl) {
        this.field_178241_a = vector3f;
        this.field_178239_b = vector3f2;
        this.field_178240_c = map;
        this.field_178237_d = blockPartRotation;
        this.field_178238_e = bl;
        this.func_178235_a();
    }

    private void func_178235_a() {
        for (Map.Entry<EnumFacing, BlockPartFace> entry : this.field_178240_c.entrySet()) {
            float[] fArray = this.func_178236_a(entry.getKey());
            entry.getValue().field_178243_e.func_178349_a(fArray);
        }
    }

    private float[] func_178236_a(EnumFacing enumFacing) {
        switch (enumFacing) {
            case DOWN: {
                return new float[]{this.field_178241_a.func_195899_a(), 16.0f - this.field_178239_b.func_195902_c(), this.field_178239_b.func_195899_a(), 16.0f - this.field_178241_a.func_195902_c()};
            }
            case UP: {
                return new float[]{this.field_178241_a.func_195899_a(), this.field_178241_a.func_195902_c(), this.field_178239_b.func_195899_a(), this.field_178239_b.func_195902_c()};
            }
            default: {
                return new float[]{16.0f - this.field_178239_b.func_195899_a(), 16.0f - this.field_178239_b.func_195900_b(), 16.0f - this.field_178241_a.func_195899_a(), 16.0f - this.field_178241_a.func_195900_b()};
            }
            case SOUTH: {
                return new float[]{this.field_178241_a.func_195899_a(), 16.0f - this.field_178239_b.func_195900_b(), this.field_178239_b.func_195899_a(), 16.0f - this.field_178241_a.func_195900_b()};
            }
            case WEST: {
                return new float[]{this.field_178241_a.func_195902_c(), 16.0f - this.field_178239_b.func_195900_b(), this.field_178239_b.func_195902_c(), 16.0f - this.field_178241_a.func_195900_b()};
            }
            case EAST: 
        }
        return new float[]{16.0f - this.field_178239_b.func_195902_c(), 16.0f - this.field_178239_b.func_195900_b(), 16.0f - this.field_178241_a.func_195902_c(), 16.0f - this.field_178241_a.func_195900_b()};
    }

    static class Deserializer
    implements JsonDeserializer<BlockPart> {
        Deserializer() {
        }

        public BlockPart deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            Vector3f \u26032 = this.func_199330_e(jsonObject);
            Vector3f \u26033 = this.func_199329_d(jsonObject);
            BlockPartRotation \u26034 = this.func_178256_a(jsonObject);
            Map<EnumFacing, BlockPartFace> \u26035 = this.func_178250_a(jsonDeserializationContext, jsonObject);
            if (jsonObject.has("shade") && !JsonUtils.func_180199_c(jsonObject, "shade")) {
                throw new JsonParseException("Expected shade to be a Boolean");
            }
            boolean \u26036 = JsonUtils.func_151209_a(jsonObject, "shade", true);
            return new BlockPart(\u26032, \u26033, \u26035, \u26034, \u26036);
        }

        @Nullable
        private BlockPartRotation func_178256_a(JsonObject jsonObject) {
            BlockPartRotation \u26036 = null;
            if (jsonObject.has("rotation")) {
                JsonObject jsonObject2 = JsonUtils.func_152754_s(jsonObject, "rotation");
                Vector3f \u26032 = this.func_199328_a(jsonObject2, "origin");
                \u26032.func_195898_a(0.0625f);
                EnumFacing.Axis \u26033 = this.func_178252_c(jsonObject2);
                float \u26034 = this.func_178255_b(jsonObject2);
                boolean \u26035 = JsonUtils.func_151209_a(jsonObject2, "rescale", false);
                \u26036 = new BlockPartRotation(\u26032, \u26033, \u26034, \u26035);
            }
            return \u26036;
        }

        private float func_178255_b(JsonObject jsonObject) {
            float f = JsonUtils.func_151217_k(jsonObject, "angle");
            if (f != 0.0f && MathHelper.func_76135_e(f) != 22.5f && MathHelper.func_76135_e(f) != 45.0f) {
                throw new JsonParseException("Invalid rotation " + f + " found, only -45/-22.5/0/22.5/45 allowed");
            }
            return f;
        }

        private EnumFacing.Axis func_178252_c(JsonObject jsonObject) {
            String string = JsonUtils.func_151200_h(jsonObject, "axis");
            EnumFacing.Axis \u26032 = EnumFacing.Axis.func_176717_a(string.toLowerCase(Locale.ROOT));
            if (\u26032 == null) {
                throw new JsonParseException("Invalid rotation axis: " + string);
            }
            return \u26032;
        }

        private Map<EnumFacing, BlockPartFace> func_178250_a(JsonDeserializationContext jsonDeserializationContext, JsonObject jsonObject) {
            Map<EnumFacing, BlockPartFace> map = this.func_178253_b(jsonDeserializationContext, jsonObject);
            if (map.isEmpty()) {
                throw new JsonParseException("Expected between 1 and 6 unique faces, got 0");
            }
            return map;
        }

        private Map<EnumFacing, BlockPartFace> func_178253_b(JsonDeserializationContext jsonDeserializationContext, JsonObject jsonObject) {
            EnumMap enumMap = Maps.newEnumMap(EnumFacing.class);
            JsonObject \u26032 = JsonUtils.func_152754_s(jsonObject, "faces");
            for (Map.Entry entry : \u26032.entrySet()) {
                EnumFacing enumFacing = this.func_178248_a((String)entry.getKey());
                enumMap.put(enumFacing, jsonDeserializationContext.deserialize((JsonElement)entry.getValue(), BlockPartFace.class));
            }
            return enumMap;
        }

        private EnumFacing func_178248_a(String string) {
            EnumFacing enumFacing = EnumFacing.func_176739_a(string);
            if (enumFacing == null) {
                throw new JsonParseException("Unknown facing: " + string);
            }
            return enumFacing;
        }

        private Vector3f func_199329_d(JsonObject jsonObject) {
            Vector3f vector3f = this.func_199328_a(jsonObject, "to");
            if (vector3f.func_195899_a() < -16.0f || vector3f.func_195900_b() < -16.0f || vector3f.func_195902_c() < -16.0f || vector3f.func_195899_a() > 32.0f || vector3f.func_195900_b() > 32.0f || vector3f.func_195902_c() > 32.0f) {
                throw new JsonParseException("'to' specifier exceeds the allowed boundaries: " + vector3f);
            }
            return vector3f;
        }

        private Vector3f func_199330_e(JsonObject jsonObject) {
            Vector3f vector3f = this.func_199328_a(jsonObject, "from");
            if (vector3f.func_195899_a() < -16.0f || vector3f.func_195900_b() < -16.0f || vector3f.func_195902_c() < -16.0f || vector3f.func_195899_a() > 32.0f || vector3f.func_195900_b() > 32.0f || vector3f.func_195902_c() > 32.0f) {
                throw new JsonParseException("'from' specifier exceeds the allowed boundaries: " + vector3f);
            }
            return vector3f;
        }

        private Vector3f func_199328_a(JsonObject jsonObject, String string) {
            JsonArray jsonArray = JsonUtils.func_151214_t(jsonObject, string);
            if (jsonArray.size() != 3) {
                throw new JsonParseException("Expected 3 " + string + " values, found: " + jsonArray.size());
            }
            float[] \u26032 = new float[3];
            for (int i = 0; i < \u26032.length; ++i) {
                \u26032[i] = JsonUtils.func_151220_d(jsonArray.get(i), string + "[" + i + "]");
            }
            return new Vector3f(\u26032[0], \u26032[1], \u26032[2]);
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }
}

