/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ModelBlock;
import net.minecraft.client.renderer.model.ModelBlockDefinition;
import net.minecraft.client.renderer.model.ModelResourceLocation;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.model.multipart.Multipart;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.init.Blocks;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.IRegistry;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModelBakery {
    public static final ResourceLocation field_207763_a = new ResourceLocation("block/fire_0");
    public static final ResourceLocation field_207764_b = new ResourceLocation("block/fire_1");
    public static final ResourceLocation field_207766_d = new ResourceLocation("block/lava_flow");
    public static final ResourceLocation field_207768_f = new ResourceLocation("block/water_flow");
    public static final ResourceLocation field_207769_g = new ResourceLocation("block/water_overlay");
    public static final ResourceLocation field_207770_h = new ResourceLocation("block/destroy_stage_0");
    public static final ResourceLocation field_207771_i = new ResourceLocation("block/destroy_stage_1");
    public static final ResourceLocation field_207772_j = new ResourceLocation("block/destroy_stage_2");
    public static final ResourceLocation field_207773_k = new ResourceLocation("block/destroy_stage_3");
    public static final ResourceLocation field_207774_l = new ResourceLocation("block/destroy_stage_4");
    public static final ResourceLocation field_207775_m = new ResourceLocation("block/destroy_stage_5");
    public static final ResourceLocation field_207776_n = new ResourceLocation("block/destroy_stage_6");
    public static final ResourceLocation field_207777_o = new ResourceLocation("block/destroy_stage_7");
    public static final ResourceLocation field_207778_p = new ResourceLocation("block/destroy_stage_8");
    public static final ResourceLocation field_207779_q = new ResourceLocation("block/destroy_stage_9");
    private static final Set<ResourceLocation> field_177602_b = Sets.newHashSet((Object[])new ResourceLocation[]{field_207768_f, field_207766_d, field_207769_g, field_207763_a, field_207764_b, field_207770_h, field_207771_i, field_207772_j, field_207773_k, field_207774_l, field_207775_m, field_207776_n, field_207777_o, field_207778_p, field_207779_q, new ResourceLocation("item/empty_armor_slot_helmet"), new ResourceLocation("item/empty_armor_slot_chestplate"), new ResourceLocation("item/empty_armor_slot_leggings"), new ResourceLocation("item/empty_armor_slot_boots"), new ResourceLocation("item/empty_armor_slot_shield")});
    private static final Logger field_177603_c = LogManager.getLogger();
    public static final ModelResourceLocation field_177604_a = new ModelResourceLocation("builtin/missing", "missing");
    @VisibleForTesting
    public static final String field_188641_d = ("{    'textures': {       'particle': '" + MissingTextureSprite.func_195677_a().func_195668_m().func_110623_a() + "',       'missingno': '" + MissingTextureSprite.func_195677_a().func_195668_m().func_110623_a() + "'    },    'elements': [         {  'from': [ 0, 0, 0 ],            'to': [ 16, 16, 16 ],            'faces': {                'down':  { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'down',  'texture': '#missingno' },                'up':    { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'up',    'texture': '#missingno' },                'north': { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'north', 'texture': '#missingno' },                'south': { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'south', 'texture': '#missingno' },                'west':  { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'west',  'texture': '#missingno' },                'east':  { 'uv': [ 0, 0, 16, 16 ], 'cullface': 'east',  'texture': '#missingno' }            }        }    ]}").replace('\'', '\"');
    private static final Map<String, String> field_177600_d = Maps.newHashMap((Map)ImmutableMap.of((Object)"missing", (Object)field_188641_d));
    private static final Splitter field_209611_w = Splitter.on((char)',');
    private static final Splitter field_209612_x = Splitter.on((char)'=').limit(2);
    public static final ModelBlock field_177606_o = Util.func_200696_a(ModelBlock.func_178294_a("{}"), modelBlock -> {
        modelBlock.field_178317_b = "generation marker";
    });
    public static final ModelBlock field_177616_r = Util.func_200696_a(ModelBlock.func_178294_a("{}"), modelBlock -> {
        modelBlock.field_178317_b = "block entity marker";
    });
    private static final StateContainer<Block, IBlockState> field_209613_y = new StateContainer.Builder(Blocks.field_150350_a).func_206894_a(BooleanProperty.func_177716_a("map")).func_206893_a(BlockState::new);
    private final IResourceManager field_177598_f;
    private final TextureMap field_177609_j;
    private final Map<ModelResourceLocation, IBakedModel> field_177605_n = Maps.newHashMap();
    private static final Map<ResourceLocation, StateContainer<Block, IBlockState>> field_209607_C = ImmutableMap.of((Object)new ResourceLocation("item_frame"), field_209613_y);
    private final Map<ResourceLocation, IUnbakedModel> field_209608_D = Maps.newHashMap();
    private final Set<ResourceLocation> field_209609_E = Sets.newHashSet();
    private final ModelBlockDefinition.ContainerHolder field_209610_F = new ModelBlockDefinition.ContainerHolder();

    public ModelBakery(IResourceManager iResourceManager, TextureMap textureMap) {
        this.field_177598_f = iResourceManager;
        this.field_177609_j = textureMap;
    }

    private static Predicate<IBlockState> func_209605_a(StateContainer<Block, IBlockState> stateContainer, String string) {
        HashMap hashMap = Maps.newHashMap();
        for (String string2 : field_209611_w.split((CharSequence)string)) {
            Iterator iterator = field_209612_x.split((CharSequence)string2).iterator();
            if (!iterator.hasNext()) continue;
            String \u26032 = (String)iterator.next();
            IProperty<?> \u26033 = stateContainer.func_185920_a(\u26032);
            if (\u26033 != null && iterator.hasNext()) {
                String string3 = (String)iterator.next();
                Object \u26034 = ModelBakery.func_209592_a(\u26033, string3);
                if (\u26034 != null) {
                    hashMap.put(\u26033, \u26034);
                    continue;
                }
                throw new RuntimeException("Unknown value: '" + string3 + "' for blockstate property: '" + \u26032 + "' " + \u26033.func_177700_c());
            }
            if (\u26032.isEmpty()) continue;
            throw new RuntimeException("Unknown blockstate property: '" + \u26032 + "'");
        }
        Block block = stateContainer.func_177622_c();
        return iBlockState -> {
            if (iBlockState == null || block != iBlockState.func_177230_c()) {
                return false;
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                if (Objects.equals(iBlockState.func_177229_b((IProperty)entry.getKey()), entry.getValue())) continue;
                return false;
            }
            return true;
        };
    }

    @Nullable
    static <T extends Comparable<T>> T func_209592_a(IProperty<T> iProperty, String string) {
        return (T)((Comparable)iProperty.func_185929_b(string).orElse(null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IUnbakedModel func_209597_a(ResourceLocation resourceLocation) {
        if (this.field_209608_D.containsKey(resourceLocation)) {
            return this.field_209608_D.get(resourceLocation);
        }
        if (this.field_209609_E.contains(resourceLocation)) {
            throw new IllegalStateException("Circular reference while loading " + resourceLocation);
        }
        this.field_209609_E.add(resourceLocation);
        IUnbakedModel iUnbakedModel = this.field_209608_D.get(field_177604_a);
        while (!this.field_209609_E.isEmpty()) {
            ResourceLocation resourceLocation2 = this.field_209609_E.iterator().next();
            try {
                if (this.field_209608_D.containsKey(resourceLocation2)) continue;
                this.func_209598_b(resourceLocation2);
            }
            catch (BlockStateDefinitionException \u26032) {
                field_177603_c.warn(\u26032.getMessage());
                this.field_209608_D.put(resourceLocation2, iUnbakedModel);
            }
            catch (Exception \u26033) {
                field_177603_c.warn("Unable to load model: '{}' referenced from: {}: {}", (Object)resourceLocation2, (Object)resourceLocation, (Object)\u26033);
                this.field_209608_D.put(resourceLocation2, iUnbakedModel);
            }
            finally {
                this.field_209609_E.remove(resourceLocation2);
            }
        }
        return this.field_209608_D.getOrDefault(resourceLocation, iUnbakedModel);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void func_209598_b(ResourceLocation resourceLocation) throws Exception {
        if (!(resourceLocation instanceof ModelResourceLocation)) {
            this.func_209593_a(resourceLocation, this.func_177594_c(resourceLocation));
            return;
        }
        ModelResourceLocation modelResourceLocation = (ModelResourceLocation)resourceLocation;
        if (Objects.equals(modelResourceLocation.func_177518_c(), "inventory")) {
            ResourceLocation resourceLocation2 = new ResourceLocation(resourceLocation.func_110624_b(), "item/" + resourceLocation.func_110623_a());
            ModelBlock \u26032 = this.func_177594_c(resourceLocation2);
            this.func_209593_a(modelResourceLocation, \u26032);
            this.field_209608_D.put(resourceLocation2, \u26032);
            return;
        }
        ResourceLocation resourceLocation2 = new ResourceLocation(resourceLocation.func_110624_b(), resourceLocation.func_110623_a());
        StateContainer stateContainer = Optional.ofNullable(field_209607_C.get(resourceLocation2)).orElseGet(() -> IRegistry.field_212618_g.func_82594_a(resourceLocation2).func_176194_O());
        this.field_209610_F.func_209573_a(stateContainer);
        ImmutableList \u26033 = stateContainer.func_177619_a();
        HashMap \u26034 = Maps.newHashMap();
        \u26033.forEach(iBlockState -> \u26034.put(BlockModelShapes.func_209553_a(resourceLocation2, iBlockState), iBlockState));
        HashMap \u26035 = Maps.newHashMap();
        ResourceLocation \u26036 = new ResourceLocation(resourceLocation.func_110624_b(), "blockstates/" + resourceLocation.func_110623_a() + ".json");
        try {
            try {
                List object = this.field_177598_f.func_199004_b(\u26036).stream().map(iResource -> {
                    try (InputStream inputStream = iResource.func_199027_b();){
                        Pair pair = Pair.of((Object)iResource.func_199026_d(), (Object)ModelBlockDefinition.func_209577_a(this.field_209610_F, new InputStreamReader(inputStream, StandardCharsets.UTF_8)));
                        return pair;
                    }
                    catch (Exception exception) {
                        throw new BlockStateDefinitionException(String.format("Exception loading blockstate definition: '%s' in resourcepack: '%s': %s", iResource.func_199029_a(), iResource.func_199026_d(), exception.getMessage()));
                    }
                }).collect(Collectors.toList());
            }
            catch (IOException iOException) {
                field_177603_c.warn("Exception loading blockstate definition: {}: {}", (Object)\u26036, (Object)iOException);
                Iterator iterator = \u26034.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    this.func_209593_a((ResourceLocation)entry.getKey(), \u26035.getOrDefault(entry.getValue(), this.field_209608_D.get(field_177604_a)));
                }
                return;
            }
            Iterator iterator = \u2603.iterator();
            while (iterator.hasNext()) {
                IUnbakedModel multipart;
                Pair pair = (Pair)iterator.next();
                ModelBlockDefinition \u26037 = (ModelBlockDefinition)pair.getSecond();
                IdentityHashMap \u26038 = Maps.newIdentityHashMap();
                if (\u26037.func_188002_b()) {
                    Multipart multipart2 = \u26037.func_188001_c();
                    \u26033.forEach(iBlockState -> \u26038.put(iBlockState, multipart));
                } else {
                    multipart = null;
                }
                \u26037.func_209578_a().forEach((string, variantList) -> {
                    try {
                        \u26033.stream().filter(ModelBakery.func_209605_a(stateContainer, string)).forEach(iBlockState -> {
                            IUnbakedModel iUnbakedModel2 = \u26038.put(iBlockState, variantList);
                            if (iUnbakedModel2 != null && iUnbakedModel2 != multipart) {
                                \u26038.put(iBlockState, this.field_209608_D.get(field_177604_a));
                                throw new RuntimeException("Overlapping definition with: " + (String)\u26037.func_209578_a().entrySet().stream().filter(entry -> entry.getValue() == iUnbakedModel2).findFirst().get().getKey());
                            }
                        });
                    }
                    catch (Exception exception) {
                        field_177603_c.warn("Exception loading blockstate definition: '{}' in resourcepack: '{}' for variant: '{}': {}", (Object)\u26036, pair.getFirst(), string, (Object)exception.getMessage());
                    }
                });
                \u26035.putAll(\u26038);
            }
            return;
        }
        catch (BlockStateDefinitionException blockStateDefinitionException) {
            throw blockStateDefinitionException;
        }
        catch (Exception exception) {
            throw new BlockStateDefinitionException(String.format("Exception loading blockstate definition: '%s': %s", \u26036, exception));
        }
        finally {
            Iterator iterator = \u26034.entrySet().iterator();
            while (true) {
                if (!iterator.hasNext()) {
                }
                Map.Entry entry = iterator.next();
                this.func_209593_a((ResourceLocation)entry.getKey(), \u26035.getOrDefault(entry.getValue(), this.field_209608_D.get(field_177604_a)));
            }
        }
    }

    private void func_209593_a(ResourceLocation resourceLocation, IUnbakedModel iUnbakedModel) {
        this.field_209608_D.put(resourceLocation, iUnbakedModel);
        this.field_209609_E.addAll(iUnbakedModel.func_187965_e());
    }

    private void func_209594_a(Map<ModelResourceLocation, IUnbakedModel> map, ModelResourceLocation modelResourceLocation) {
        map.put(modelResourceLocation, this.func_209597_a(modelResourceLocation));
    }

    public Map<ModelResourceLocation, IBakedModel> func_177570_a() {
        Set<ResourceLocation> \u260332;
        HashMap hashMap = Maps.newHashMap();
        try {
            this.field_209608_D.put(field_177604_a, this.func_177594_c(field_177604_a));
            this.func_209594_a(hashMap, field_177604_a);
        }
        catch (IOException \u26032) {
            field_177603_c.error("Error loading missing model, should never happen :(", (Throwable)\u26032);
            throw new RuntimeException(\u26032);
        }
        field_209607_C.forEach((resourceLocation, stateContainer) -> stateContainer.func_177619_a().forEach(iBlockState -> this.func_209594_a(hashMap, BlockModelShapes.func_209553_a(resourceLocation, iBlockState))));
        for (Set<ResourceLocation> \u260332 : IRegistry.field_212618_g) {
            ((Block)((Object)\u260332)).func_176194_O().func_177619_a().forEach(iBlockState -> this.func_209594_a(hashMap, BlockModelShapes.func_209554_c(iBlockState)));
        }
        for (Set<ResourceLocation> \u260332 : IRegistry.field_212630_s.func_148742_b()) {
            this.func_209594_a(hashMap, new ModelResourceLocation((ResourceLocation)((Object)\u260332), "inventory"));
        }
        this.func_209594_a(hashMap, new ModelResourceLocation("minecraft:trident_in_hand#inventory"));
        LinkedHashSet \u26032 = Sets.newLinkedHashSet();
        \u260332 = hashMap.values().stream().flatMap(iUnbakedModel -> iUnbakedModel.func_209559_a(this::func_209597_a, \u26032).stream()).collect(Collectors.toSet());
        \u260332.addAll(field_177602_b);
        \u26032.forEach(string -> field_177603_c.warn("Unable to resolve texture reference: {}", string));
        this.field_177609_j.func_195426_a(this.field_177598_f, \u260332);
        hashMap.forEach((modelResourceLocation, iUnbakedModel) -> {
            IBakedModel iBakedModel = null;
            try {
                iBakedModel = iUnbakedModel.func_209558_a(this::func_209597_a, this.field_177609_j::func_195424_a, ModelRotation.X0_Y0, false);
            }
            catch (Exception \u26032) {
                field_177603_c.warn("Unable to bake model: '{}': {}", modelResourceLocation, (Object)\u26032);
            }
            if (iBakedModel != null) {
                this.field_177605_n.put((ModelResourceLocation)modelResourceLocation, iBakedModel);
            }
        });
        return this.field_177605_n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ModelBlock func_177594_c(ResourceLocation resourceLocation) throws IOException {
        String string;
        IResource \u26032;
        Reader \u26034;
        block8: {
            block7: {
                ModelBlock modelBlock;
                \u26034 = null;
                \u26032 = null;
                try {
                    string = resourceLocation.func_110623_a();
                    if (!"builtin/generated".equals(string)) break block7;
                    modelBlock = field_177606_o;
                }
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(\u26034);
                    IOUtils.closeQuietly(\u26032);
                    throw throwable;
                }
                IOUtils.closeQuietly(\u26034);
                IOUtils.closeQuietly(\u26032);
                return modelBlock;
            }
            if (!"builtin/entity".equals(string)) break block8;
            ModelBlock modelBlock = field_177616_r;
            IOUtils.closeQuietly(\u26034);
            IOUtils.closeQuietly(\u26032);
            return modelBlock;
        }
        if (string.startsWith("builtin/")) {
            Object object = string.substring("builtin/".length());
            String \u26033 = field_177600_d.get(object);
            if (\u26033 == null) {
                throw new FileNotFoundException(resourceLocation.toString());
            }
            \u26034 = new StringReader(\u26033);
        } else {
            \u26032 = this.field_177598_f.func_199002_a(new ResourceLocation(resourceLocation.func_110624_b(), "models/" + resourceLocation.func_110623_a() + ".json"));
            \u26034 = new InputStreamReader(\u26032.func_199027_b(), StandardCharsets.UTF_8);
        }
        object = ModelBlock.func_178307_a(\u26034);
        ((ModelBlock)object).field_178317_b = resourceLocation.toString();
        Object object = object;
        IOUtils.closeQuietly((Reader)\u26034);
        IOUtils.closeQuietly((Closeable)\u26032);
        return object;
    }

    static class BlockStateDefinitionException
    extends RuntimeException {
        public BlockStateDefinitionException(String string) {
            super(string);
        }
    }
}

