/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockFaceUV;
import net.minecraft.client.renderer.model.BlockPart;
import net.minecraft.client.renderer.model.BlockPartFace;
import net.minecraft.client.renderer.model.BuiltInModel;
import net.minecraft.client.renderer.model.FaceBakery;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemModelGenerator;
import net.minecraft.client.renderer.model.ItemOverride;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ItemTransformVec3f;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.model.SimpleBakedModel;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModelBlock
implements IUnbakedModel {
    private static final Logger field_178313_f = LogManager.getLogger();
    private static final ItemModelGenerator field_209571_g = new ItemModelGenerator();
    private static final FaceBakery field_209572_h = new FaceBakery();
    @VisibleForTesting
    static final Gson field_178319_a = new GsonBuilder().registerTypeAdapter(ModelBlock.class, (Object)new Deserializer()).registerTypeAdapter(BlockPart.class, (Object)new BlockPart.Deserializer()).registerTypeAdapter(BlockPartFace.class, (Object)new BlockPartFace.Deserializer()).registerTypeAdapter(BlockFaceUV.class, (Object)new BlockFaceUV.Deserializer()).registerTypeAdapter(ItemTransformVec3f.class, (Object)new ItemTransformVec3f.Deserializer()).registerTypeAdapter(ItemCameraTransforms.class, (Object)new ItemCameraTransforms.Deserializer()).registerTypeAdapter(ItemOverride.class, (Object)new ItemOverride.Deserializer()).create();
    private final List<BlockPart> field_178314_g;
    private final boolean field_178321_h;
    private final boolean field_178322_i;
    private final ItemCameraTransforms field_178320_j;
    private final List<ItemOverride> field_187968_k;
    public String field_178317_b = "";
    @VisibleForTesting
    protected final Map<String, String> field_178318_c;
    @VisibleForTesting
    ModelBlock field_178315_d;
    @VisibleForTesting
    ResourceLocation field_178316_e;

    public static ModelBlock func_178307_a(Reader reader) {
        return JsonUtils.func_193839_a(field_178319_a, reader, ModelBlock.class);
    }

    public static ModelBlock func_178294_a(String string) {
        return ModelBlock.func_178307_a(new StringReader(string));
    }

    public ModelBlock(@Nullable ResourceLocation resourceLocation, List<BlockPart> list, Map<String, String> map, boolean bl, boolean bl2, ItemCameraTransforms itemCameraTransforms, List<ItemOverride> list2) {
        this.field_178314_g = list;
        this.field_178322_i = bl;
        this.field_178321_h = bl2;
        this.field_178318_c = map;
        this.field_178316_e = resourceLocation;
        this.field_178320_j = itemCameraTransforms;
        this.field_187968_k = list2;
    }

    public List<BlockPart> func_178298_a() {
        if (this.field_178314_g.isEmpty() && this.func_178295_k()) {
            return this.field_178315_d.func_178298_a();
        }
        return this.field_178314_g;
    }

    private boolean func_178295_k() {
        return this.field_178315_d != null;
    }

    public boolean func_178309_b() {
        if (this.func_178295_k()) {
            return this.field_178315_d.func_178309_b();
        }
        return this.field_178322_i;
    }

    public boolean func_178311_c() {
        return this.field_178321_h;
    }

    public boolean func_178303_d() {
        return this.field_178316_e == null || this.field_178315_d != null && this.field_178315_d.func_178303_d();
    }

    private void func_209566_a(Function<ResourceLocation, IUnbakedModel> function) {
        if (this.field_178316_e != null && (\u2603 = function.apply(this.field_178316_e)) != null) {
            if (\u2603 instanceof ModelBlock) {
                this.field_178315_d = (ModelBlock)\u2603;
            } else {
                throw new IllegalStateException("BlockModel parent has to be a block model.");
            }
        }
    }

    public List<ItemOverride> func_187966_f() {
        return this.field_187968_k;
    }

    private ItemOverrideList func_209568_a(ModelBlock modelBlock, Function<ResourceLocation, IUnbakedModel> function, Function<ResourceLocation, TextureAtlasSprite> function2) {
        if (this.field_187968_k.isEmpty()) {
            return ItemOverrideList.field_188022_a;
        }
        return new ItemOverrideList(modelBlock, function, function2, this.field_187968_k);
    }

    @Override
    public Collection<ResourceLocation> func_187965_e() {
        HashSet hashSet = Sets.newHashSet();
        for (ItemOverride itemOverride : this.field_187968_k) {
            hashSet.add(itemOverride.func_188026_a());
        }
        if (this.field_178316_e != null) {
            hashSet.add(this.field_178316_e);
        }
        return hashSet;
    }

    @Override
    public Collection<ResourceLocation> func_209559_a(Function<ResourceLocation, IUnbakedModel> function2, Set<String> set) {
        Function<ResourceLocation, IUnbakedModel> function2;
        if (!this.func_178303_d()) {
            HashSet hashSet = Sets.newLinkedHashSet();
            ModelBlock \u26032 = this;
            do {
                hashSet.add(\u26032);
                \u26032.func_209566_a(function2);
                if (!hashSet.contains(\u26032.field_178315_d)) continue;
                field_178313_f.warn("Found 'parent' loop while loading model '{}' in chain: {} -> {}", (Object)\u26032.field_178317_b, (Object)hashSet.stream().map(modelBlock -> modelBlock.field_178317_b).collect(Collectors.joining(" -> ")), (Object)\u26032.field_178315_d.field_178317_b);
                \u26032.field_178316_e = ModelBakery.field_177604_a;
                \u26032.func_209566_a(function2);
            } while (!(\u26032 = \u26032.field_178315_d).func_178303_d());
        }
        hashSet = Sets.newHashSet((Object[])new ResourceLocation[]{new ResourceLocation(this.func_178308_c("particle"))});
        for (BlockPart \u26033 : this.func_178298_a()) {
            for (BlockPartFace blockPartFace : \u26033.field_178240_c.values()) {
                String string2 = this.func_178308_c(blockPartFace.field_178242_d);
                if (Objects.equals(string2, MissingTextureSprite.func_195677_a().func_195668_m().toString())) {
                    set.add(String.format("%s in %s", blockPartFace.field_178242_d, this.field_178317_b));
                }
                hashSet.add(new ResourceLocation(string2));
            }
        }
        this.field_187968_k.forEach(itemOverride -> {
            IUnbakedModel iUnbakedModel = (IUnbakedModel)function2.apply(itemOverride.func_188026_a());
            if (Objects.equals(iUnbakedModel, this)) {
                return;
            }
            hashSet.addAll(iUnbakedModel.func_209559_a(function2, set));
        });
        if (this.func_178310_f() == ModelBakery.field_177606_o) {
            ItemModelGenerator.field_178398_a.forEach(string -> hashSet.add(new ResourceLocation(this.func_178308_c((String)string))));
        }
        return hashSet;
    }

    @Override
    public IBakedModel func_209558_a(Function<ResourceLocation, IUnbakedModel> function, Function<ResourceLocation, TextureAtlasSprite> function2, ModelRotation modelRotation, boolean bl) {
        return this.func_209565_a(this, function, function2, modelRotation, bl);
    }

    private IBakedModel func_209565_a(ModelBlock modelBlock, Function<ResourceLocation, IUnbakedModel> function, Function<ResourceLocation, TextureAtlasSprite> function2, ModelRotation modelRotation, boolean bl) {
        ModelBlock modelBlock2 = this.func_178310_f();
        if (modelBlock2 == ModelBakery.field_177606_o) {
            return field_209571_g.func_209579_a(function2, this).func_209565_a(modelBlock, function, function2, modelRotation, bl);
        }
        if (modelBlock2 == ModelBakery.field_177616_r) {
            return new BuiltInModel(this.func_181682_g(), this.func_209568_a(modelBlock, function, function2));
        }
        TextureAtlasSprite \u26032 = function2.apply(new ResourceLocation(this.func_178308_c("particle")));
        SimpleBakedModel.Builder \u26033 = new SimpleBakedModel.Builder(this, this.func_209568_a(modelBlock, function, function2)).func_177646_a(\u26032);
        for (BlockPart blockPart : this.func_178298_a()) {
            for (EnumFacing enumFacing : blockPart.field_178240_c.keySet()) {
                BlockPartFace blockPartFace = blockPart.field_178240_c.get(enumFacing);
                TextureAtlasSprite \u26034 = function2.apply(new ResourceLocation(this.func_178308_c(blockPartFace.field_178242_d)));
                if (blockPartFace.field_178244_b == null) {
                    \u26033.func_177648_a(ModelBlock.func_209567_a(blockPart, blockPartFace, \u26034, enumFacing, modelRotation, bl));
                    continue;
                }
                \u26033.func_177650_a(modelRotation.func_177523_a(blockPartFace.field_178244_b), ModelBlock.func_209567_a(blockPart, blockPartFace, \u26034, enumFacing, modelRotation, bl));
            }
        }
        return \u26033.func_177645_b();
    }

    private static BakedQuad func_209567_a(BlockPart blockPart, BlockPartFace blockPartFace, TextureAtlasSprite textureAtlasSprite, EnumFacing enumFacing, ModelRotation modelRotation, boolean bl) {
        return field_209572_h.func_199332_a(blockPart.field_178241_a, blockPart.field_178239_b, blockPartFace, textureAtlasSprite, enumFacing, modelRotation, blockPart.field_178237_d, bl, blockPart.field_178238_e);
    }

    public boolean func_178300_b(String string) {
        return !MissingTextureSprite.func_195677_a().func_195668_m().toString().equals(this.func_178308_c(string));
    }

    public String func_178308_c(String string) {
        if (!this.func_178304_d(string)) {
            string = '#' + string;
        }
        return this.func_178302_a(string, new Bookkeep(this));
    }

    private String func_178302_a(String string2, Bookkeep bookkeep) {
        String string2;
        if (this.func_178304_d(string2)) {
            if (this == bookkeep.field_178323_b) {
                field_178313_f.warn("Unable to resolve texture due to upward reference: {} in {}", (Object)string2, (Object)this.field_178317_b);
                return MissingTextureSprite.func_195677_a().func_195668_m().toString();
            }
            String string3 = this.field_178318_c.get(string2.substring(1));
            if (string3 == null && this.func_178295_k()) {
                string3 = this.field_178315_d.func_178302_a(string2, bookkeep);
            }
            bookkeep.field_178323_b = this;
            if (string3 != null && this.func_178304_d(string3)) {
                string3 = bookkeep.field_178324_a.func_178302_a(string3, bookkeep);
            }
            if (string3 == null || this.func_178304_d(string3)) {
                return MissingTextureSprite.func_195677_a().func_195668_m().toString();
            }
            return string3;
        }
        return string2;
    }

    private boolean func_178304_d(String string) {
        return string.charAt(0) == '#';
    }

    public ModelBlock func_178310_f() {
        return this.func_178295_k() ? this.field_178315_d.func_178310_f() : this;
    }

    public ItemCameraTransforms func_181682_g() {
        ItemTransformVec3f itemTransformVec3f = this.func_181681_a(ItemCameraTransforms.TransformType.THIRD_PERSON_LEFT_HAND);
        \u2603 = this.func_181681_a(ItemCameraTransforms.TransformType.THIRD_PERSON_RIGHT_HAND);
        \u2603 = this.func_181681_a(ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND);
        \u2603 = this.func_181681_a(ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND);
        \u2603 = this.func_181681_a(ItemCameraTransforms.TransformType.HEAD);
        \u2603 = this.func_181681_a(ItemCameraTransforms.TransformType.GUI);
        \u2603 = this.func_181681_a(ItemCameraTransforms.TransformType.GROUND);
        \u2603 = this.func_181681_a(ItemCameraTransforms.TransformType.FIXED);
        return new ItemCameraTransforms(itemTransformVec3f, \u2603, \u2603, \u2603, \u2603, \u2603, \u2603, \u2603);
    }

    private ItemTransformVec3f func_181681_a(ItemCameraTransforms.TransformType transformType) {
        if (this.field_178315_d != null && !this.field_178320_j.func_181687_c(transformType)) {
            return this.field_178315_d.func_181681_a(transformType);
        }
        return this.field_178320_j.func_181688_b(transformType);
    }

    public static class Deserializer
    implements JsonDeserializer<ModelBlock> {
        public ModelBlock deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext2) throws JsonParseException {
            JsonDeserializationContext jsonDeserializationContext2;
            Object \u26037;
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            List<BlockPart> \u26032 = this.func_178325_a(jsonDeserializationContext2, jsonObject);
            String \u26033 = this.func_178326_c(jsonObject);
            Map<String, String> \u26034 = this.func_178329_b(jsonObject);
            boolean \u26035 = this.func_178328_a(jsonObject);
            ItemCameraTransforms \u26036 = ItemCameraTransforms.field_178357_a;
            if (jsonObject.has("display")) {
                \u26037 = JsonUtils.func_152754_s(jsonObject, "display");
                \u26036 = (ItemCameraTransforms)jsonDeserializationContext2.deserialize((JsonElement)\u26037, ItemCameraTransforms.class);
            }
            \u26037 = this.func_187964_a(jsonDeserializationContext2, jsonObject);
            ResourceLocation \u26038 = \u26033.isEmpty() ? null : new ResourceLocation(\u26033);
            return new ModelBlock(\u26038, \u26032, \u26034, \u26035, true, \u26036, (List<ItemOverride>)\u26037);
        }

        protected List<ItemOverride> func_187964_a(JsonDeserializationContext jsonDeserializationContext, JsonObject jsonObject) {
            ArrayList arrayList = Lists.newArrayList();
            if (jsonObject.has("overrides")) {
                JsonArray jsonArray = JsonUtils.func_151214_t(jsonObject, "overrides");
                for (JsonElement jsonElement : jsonArray) {
                    arrayList.add(jsonDeserializationContext.deserialize(jsonElement, ItemOverride.class));
                }
            }
            return arrayList;
        }

        private Map<String, String> func_178329_b(JsonObject jsonObject) {
            HashMap hashMap = Maps.newHashMap();
            if (jsonObject.has("textures")) {
                JsonObject jsonObject2 = jsonObject.getAsJsonObject("textures");
                for (Map.Entry entry : jsonObject2.entrySet()) {
                    hashMap.put(entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
                }
            }
            return hashMap;
        }

        private String func_178326_c(JsonObject jsonObject) {
            return JsonUtils.func_151219_a(jsonObject, "parent", "");
        }

        protected boolean func_178328_a(JsonObject jsonObject) {
            return JsonUtils.func_151209_a(jsonObject, "ambientocclusion", true);
        }

        protected List<BlockPart> func_178325_a(JsonDeserializationContext jsonDeserializationContext, JsonObject jsonObject) {
            ArrayList arrayList = Lists.newArrayList();
            if (jsonObject.has("elements")) {
                for (JsonElement jsonElement : JsonUtils.func_151214_t(jsonObject, "elements")) {
                    arrayList.add(jsonDeserializationContext.deserialize(jsonElement, BlockPart.class));
                }
            }
            return arrayList;
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }

    static final class Bookkeep {
        public final ModelBlock field_178324_a;
        public ModelBlock field_178323_b;

        private Bookkeep(ModelBlock modelBlock) {
            this.field_178324_a = modelBlock;
        }
    }
}

