/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.model.Variant;
import net.minecraft.client.renderer.model.VariantList;
import net.minecraft.client.renderer.model.multipart.Multipart;
import net.minecraft.client.renderer.model.multipart.Selector;
import net.minecraft.state.StateContainer;
import net.minecraft.util.JsonUtils;

public class ModelBlockDefinition {
    private final Map<String, VariantList> field_178332_b = Maps.newLinkedHashMap();
    private Multipart field_188005_c;

    public static ModelBlockDefinition func_209577_a(ContainerHolder containerHolder, Reader reader) {
        return JsonUtils.func_193839_a(containerHolder.field_209575_a, reader, ModelBlockDefinition.class);
    }

    public ModelBlockDefinition(Map<String, VariantList> map, Multipart multipart) {
        this.field_188005_c = multipart;
        this.field_178332_b.putAll(map);
    }

    public ModelBlockDefinition(List<ModelBlockDefinition> list) {
        ModelBlockDefinition modelBlockDefinition = null;
        for (ModelBlockDefinition modelBlockDefinition2 : list) {
            if (modelBlockDefinition2.func_188002_b()) {
                this.field_178332_b.clear();
                modelBlockDefinition = modelBlockDefinition2;
            }
            this.field_178332_b.putAll(modelBlockDefinition2.field_178332_b);
        }
        if (modelBlockDefinition != null) {
            this.field_188005_c = modelBlockDefinition.field_188005_c;
        }
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ModelBlockDefinition) {
            ModelBlockDefinition modelBlockDefinition = (ModelBlockDefinition)object;
            if (this.field_178332_b.equals(modelBlockDefinition.field_178332_b)) {
                return this.func_188002_b() ? this.field_188005_c.equals(modelBlockDefinition.field_188005_c) : !modelBlockDefinition.func_188002_b();
            }
        }
        return false;
    }

    public int hashCode() {
        return 31 * this.field_178332_b.hashCode() + (this.func_188002_b() ? this.field_188005_c.hashCode() : 0);
    }

    public Map<String, VariantList> func_209578_a() {
        return this.field_178332_b;
    }

    public boolean func_188002_b() {
        return this.field_188005_c != null;
    }

    public Multipart func_188001_c() {
        return this.field_188005_c;
    }

    public static class Deserializer
    implements JsonDeserializer<ModelBlockDefinition> {
        public ModelBlockDefinition deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            Map<String, VariantList> \u26032 = this.func_187999_a(jsonDeserializationContext, jsonObject);
            Multipart \u26033 = this.func_187998_b(jsonDeserializationContext, jsonObject);
            if (\u26032.isEmpty() && (\u26033 == null || \u26033.func_188137_b().isEmpty())) {
                throw new JsonParseException("Neither 'variants' nor 'multipart' found");
            }
            return new ModelBlockDefinition(\u26032, \u26033);
        }

        protected Map<String, VariantList> func_187999_a(JsonDeserializationContext jsonDeserializationContext, JsonObject jsonObject) {
            HashMap hashMap = Maps.newHashMap();
            if (jsonObject.has("variants")) {
                JsonObject jsonObject2 = JsonUtils.func_152754_s(jsonObject, "variants");
                for (Map.Entry entry : jsonObject2.entrySet()) {
                    hashMap.put(entry.getKey(), jsonDeserializationContext.deserialize((JsonElement)entry.getValue(), VariantList.class));
                }
            }
            return hashMap;
        }

        @Nullable
        protected Multipart func_187998_b(JsonDeserializationContext jsonDeserializationContext, JsonObject jsonObject) {
            if (!jsonObject.has("multipart")) {
                return null;
            }
            JsonArray jsonArray = JsonUtils.func_151214_t(jsonObject, "multipart");
            return (Multipart)jsonDeserializationContext.deserialize((JsonElement)jsonArray, Multipart.class);
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }

    public static final class ContainerHolder {
        @VisibleForTesting
        final Gson field_209575_a = new GsonBuilder().registerTypeAdapter(ModelBlockDefinition.class, (Object)new Deserializer()).registerTypeAdapter(Variant.class, (Object)new Variant.Deserializer()).registerTypeAdapter(VariantList.class, (Object)new VariantList.Deserializer()).registerTypeAdapter(Multipart.class, (Object)new Multipart.Deserializer(this)).registerTypeAdapter(Selector.class, (Object)new Selector.Deserializer()).create();
        private StateContainer<Block, IBlockState> field_209576_b;

        public StateContainer<Block, IBlockState> func_209574_a() {
            return this.field_209576_b;
        }

        public void func_209573_a(StateContainer<Block, IBlockState> stateContainer) {
            this.field_209576_b = stateContainer;
        }
    }
}

