/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.Quaternion;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;

public enum ModelRotation {
    X0_Y0(0, 0),
    X0_Y90(0, 90),
    X0_Y180(0, 180),
    X0_Y270(0, 270),
    X90_Y0(90, 0),
    X90_Y90(90, 90),
    X90_Y180(90, 180),
    X90_Y270(90, 270),
    X180_Y0(180, 0),
    X180_Y90(180, 90),
    X180_Y180(180, 180),
    X180_Y270(180, 270),
    X270_Y0(270, 0),
    X270_Y90(270, 90),
    X270_Y180(270, 180),
    X270_Y270(270, 270);

    private static final Map<Integer, ModelRotation> field_177546_q;
    private final int field_177545_r;
    private final Quaternion field_177544_s;
    private final int field_177543_t;
    private final int field_177542_u;

    private static int func_177521_b(int n, int n2) {
        return n * 360 + n2;
    }

    private ModelRotation(int n2, int n3) {
        this.field_177545_r = ModelRotation.func_177521_b(n2, n3);
        Quaternion quaternion = new Quaternion(new Vector3f(0.0f, 1.0f, 0.0f), -n3, true);
        quaternion.func_195890_a(new Quaternion(new Vector3f(1.0f, 0.0f, 0.0f), -n2, true));
        this.field_177544_s = quaternion;
        this.field_177543_t = MathHelper.func_76130_a(n2 / 90);
        this.field_177542_u = MathHelper.func_76130_a(n3 / 90);
    }

    public Quaternion func_195820_a() {
        return this.field_177544_s;
    }

    public EnumFacing func_177523_a(EnumFacing enumFacing) {
        EnumFacing enumFacing2;
        int n;
        enumFacing2 = enumFacing;
        for (n = 0; n < this.field_177543_t; ++n) {
            enumFacing2 = enumFacing2.func_176732_a(EnumFacing.Axis.X);
        }
        if (enumFacing2.func_176740_k() != EnumFacing.Axis.Y) {
            for (n = 0; n < this.field_177542_u; ++n) {
                enumFacing2 = enumFacing2.func_176732_a(EnumFacing.Axis.Y);
            }
        }
        return enumFacing2;
    }

    public int func_177520_a(EnumFacing enumFacing, int n) {
        int n2;
        n2 = n;
        if (enumFacing.func_176740_k() == EnumFacing.Axis.X) {
            n2 = (n2 + this.field_177543_t) % 4;
        }
        EnumFacing enumFacing2 = enumFacing;
        for (int i = 0; i < this.field_177543_t; ++i) {
            enumFacing2 = enumFacing2.func_176732_a(EnumFacing.Axis.X);
        }
        if (enumFacing2.func_176740_k() == EnumFacing.Axis.Y) {
            n2 = (n2 + this.field_177542_u) % 4;
        }
        return n2;
    }

    public static ModelRotation func_177524_a(int n, int n2) {
        return field_177546_q.get(ModelRotation.func_177521_b(MathHelper.func_180184_b(n, 360), MathHelper.func_180184_b(n2, 360)));
    }

    static {
        field_177546_q = Arrays.stream(ModelRotation.values()).sorted(Comparator.comparingInt(modelRotation -> modelRotation.field_177545_r)).collect(Collectors.toMap(modelRotation -> modelRotation.field_177545_r, modelRotation -> modelRotation));
    }
}

