/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BakedQuadRetextured;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBlock;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;

public class SimpleBakedModel
implements IBakedModel {
    protected final List<BakedQuad> field_177563_a;
    protected final Map<EnumFacing, List<BakedQuad>> field_177561_b;
    protected final boolean field_177562_c;
    protected final boolean field_177559_d;
    protected final TextureAtlasSprite field_177560_e;
    protected final ItemCameraTransforms field_177558_f;
    protected final ItemOverrideList field_188620_g;

    public SimpleBakedModel(List<BakedQuad> list, Map<EnumFacing, List<BakedQuad>> map, boolean bl, boolean bl2, TextureAtlasSprite textureAtlasSprite, ItemCameraTransforms itemCameraTransforms, ItemOverrideList itemOverrideList) {
        this.field_177563_a = list;
        this.field_177561_b = map;
        this.field_177562_c = bl;
        this.field_177559_d = bl2;
        this.field_177560_e = textureAtlasSprite;
        this.field_177558_f = itemCameraTransforms;
        this.field_188620_g = itemOverrideList;
    }

    @Override
    public List<BakedQuad> func_200117_a(@Nullable IBlockState iBlockState, @Nullable EnumFacing enumFacing, Random random) {
        return enumFacing == null ? this.field_177563_a : this.field_177561_b.get(enumFacing);
    }

    @Override
    public boolean func_177555_b() {
        return this.field_177562_c;
    }

    @Override
    public boolean func_177556_c() {
        return this.field_177559_d;
    }

    @Override
    public boolean func_188618_c() {
        return false;
    }

    @Override
    public TextureAtlasSprite func_177554_e() {
        return this.field_177560_e;
    }

    @Override
    public ItemCameraTransforms func_177552_f() {
        return this.field_177558_f;
    }

    @Override
    public ItemOverrideList func_188617_f() {
        return this.field_188620_g;
    }

    public static class Builder {
        private final List<BakedQuad> field_177656_a = Lists.newArrayList();
        private final Map<EnumFacing, List<BakedQuad>> field_177654_b = Maps.newEnumMap(EnumFacing.class);
        private final ItemOverrideList field_188646_c;
        private final boolean field_177655_c;
        private TextureAtlasSprite field_177652_d;
        private final boolean field_177653_e;
        private final ItemCameraTransforms field_177651_f;

        public Builder(ModelBlock modelBlock, ItemOverrideList itemOverrideList) {
            this(modelBlock.func_178309_b(), modelBlock.func_178311_c(), modelBlock.func_181682_g(), itemOverrideList);
        }

        public Builder(IBlockState iBlockState, IBakedModel iBakedModel, TextureAtlasSprite textureAtlasSprite, Random random2, long l) {
            this(iBakedModel.func_177555_b(), iBakedModel.func_177556_c(), iBakedModel.func_177552_f(), iBakedModel.func_188617_f());
            Random random2;
            this.field_177652_d = iBakedModel.func_177554_e();
            for (EnumFacing enumFacing : EnumFacing.values()) {
                random2.setSeed(l);
                for (BakedQuad bakedQuad : iBakedModel.func_200117_a(iBlockState, enumFacing, random2)) {
                    this.func_177650_a(enumFacing, new BakedQuadRetextured(bakedQuad, textureAtlasSprite));
                }
            }
            random2.setSeed(l);
            for (BakedQuad bakedQuad : iBakedModel.func_200117_a(iBlockState, null, random2)) {
                this.func_177648_a(new BakedQuadRetextured(bakedQuad, textureAtlasSprite));
            }
        }

        private Builder(boolean bl, boolean bl2, ItemCameraTransforms itemCameraTransforms, ItemOverrideList itemOverrideList2) {
            ItemOverrideList itemOverrideList2;
            for (EnumFacing enumFacing : EnumFacing.values()) {
                this.field_177654_b.put(enumFacing, Lists.newArrayList());
            }
            this.field_188646_c = itemOverrideList2;
            this.field_177655_c = bl;
            this.field_177653_e = bl2;
            this.field_177651_f = itemCameraTransforms;
        }

        public Builder func_177650_a(EnumFacing enumFacing, BakedQuad bakedQuad) {
            this.field_177654_b.get(enumFacing).add(bakedQuad);
            return this;
        }

        public Builder func_177648_a(BakedQuad bakedQuad) {
            this.field_177656_a.add(bakedQuad);
            return this;
        }

        public Builder func_177646_a(TextureAtlasSprite textureAtlasSprite) {
            this.field_177652_d = textureAtlasSprite;
            return this;
        }

        public IBakedModel func_177645_b() {
            if (this.field_177652_d == null) {
                throw new RuntimeException("Missing particle!");
            }
            return new SimpleBakedModel(this.field_177656_a, this.field_177654_b, this.field_177655_c, this.field_177653_e, this.field_177652_d, this.field_177651_f, this.field_188646_c);
        }
    }
}

