/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;

public class Variant {
    private final ResourceLocation field_188050_a;
    private final ModelRotation field_188051_b;
    private final boolean field_188052_c;
    private final int field_188053_d;

    public Variant(ResourceLocation resourceLocation, ModelRotation modelRotation, boolean bl, int n) {
        this.field_188050_a = resourceLocation;
        this.field_188051_b = modelRotation;
        this.field_188052_c = bl;
        this.field_188053_d = n;
    }

    public ResourceLocation func_188046_a() {
        return this.field_188050_a;
    }

    public ModelRotation func_188048_b() {
        return this.field_188051_b;
    }

    public boolean func_188049_c() {
        return this.field_188052_c;
    }

    public int func_188047_d() {
        return this.field_188053_d;
    }

    public String toString() {
        return "Variant{modelLocation=" + this.field_188050_a + ", rotation=" + (Object)((Object)this.field_188051_b) + ", uvLock=" + this.field_188052_c + ", weight=" + this.field_188053_d + '}';
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Variant) {
            Variant variant = (Variant)object;
            return this.field_188050_a.equals(variant.field_188050_a) && this.field_188051_b == variant.field_188051_b && this.field_188052_c == variant.field_188052_c && this.field_188053_d == variant.field_188053_d;
        }
        return false;
    }

    public int hashCode() {
        int n = this.field_188050_a.hashCode();
        n = 31 * n + this.field_188051_b.hashCode();
        n = 31 * n + Boolean.valueOf(this.field_188052_c).hashCode();
        n = 31 * n + this.field_188053_d;
        return n;
    }

    public static class Deserializer
    implements JsonDeserializer<Variant> {
        public Variant deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            JsonObject jsonObject = jsonElement.getAsJsonObject();
            ResourceLocation \u26032 = this.func_188043_b(jsonObject);
            ModelRotation \u26033 = this.func_188042_a(jsonObject);
            boolean \u26034 = this.func_188044_d(jsonObject);
            int \u26035 = this.func_188045_c(jsonObject);
            return new Variant(\u26032, \u26033, \u26034, \u26035);
        }

        private boolean func_188044_d(JsonObject jsonObject) {
            return JsonUtils.func_151209_a(jsonObject, "uvlock", false);
        }

        protected ModelRotation func_188042_a(JsonObject jsonObject) {
            int n = JsonUtils.func_151208_a(jsonObject, "x", 0);
            ModelRotation \u26032 = ModelRotation.func_177524_a(n, \u2603 = JsonUtils.func_151208_a(jsonObject, "y", 0));
            if (\u26032 == null) {
                throw new JsonParseException("Invalid BlockModelRotation x: " + n + ", y: " + \u2603);
            }
            return \u26032;
        }

        protected ResourceLocation func_188043_b(JsonObject jsonObject) {
            return new ResourceLocation(JsonUtils.func_151200_h(jsonObject, "model"));
        }

        protected int func_188045_c(JsonObject jsonObject) {
            int n = JsonUtils.func_151208_a(jsonObject, "weight", 1);
            if (n < 1) {
                throw new JsonParseException("Invalid weight " + n + " found, expected integer >= 1");
            }
            return n;
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }
}

