/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model.multipart;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ModelBlockDefinition;
import net.minecraft.client.renderer.model.ModelRotation;
import net.minecraft.client.renderer.model.MultipartBakedModel;
import net.minecraft.client.renderer.model.VariantList;
import net.minecraft.client.renderer.model.multipart.Selector;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.state.StateContainer;
import net.minecraft.util.ResourceLocation;

public class Multipart
implements IUnbakedModel {
    private final StateContainer<Block, IBlockState> field_188140_b;
    private final List<Selector> field_188139_a;

    public Multipart(StateContainer<Block, IBlockState> stateContainer, List<Selector> list) {
        this.field_188140_b = stateContainer;
        this.field_188139_a = list;
    }

    public List<Selector> func_188136_a() {
        return this.field_188139_a;
    }

    public Set<VariantList> func_188137_b() {
        HashSet hashSet = Sets.newHashSet();
        for (Selector selector : this.field_188139_a) {
            hashSet.add(selector.func_188165_a());
        }
        return hashSet;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Multipart) {
            Multipart multipart = (Multipart)object;
            return Objects.equals(this.field_188140_b, multipart.field_188140_b) && Objects.equals(this.field_188139_a, multipart.field_188139_a);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.field_188140_b, this.field_188139_a);
    }

    @Override
    public Collection<ResourceLocation> func_187965_e() {
        return this.func_188136_a().stream().flatMap(selector -> selector.func_188165_a().func_187965_e().stream()).collect(Collectors.toSet());
    }

    @Override
    public Collection<ResourceLocation> func_209559_a(Function<ResourceLocation, IUnbakedModel> function, Set<String> set) {
        return this.func_188136_a().stream().flatMap(selector -> selector.func_188165_a().func_209559_a(function, set).stream()).collect(Collectors.toSet());
    }

    @Override
    @Nullable
    public IBakedModel func_209558_a(Function<ResourceLocation, IUnbakedModel> function, Function<ResourceLocation, TextureAtlasSprite> function2, ModelRotation modelRotation, boolean bl) {
        MultipartBakedModel.Builder builder = new MultipartBakedModel.Builder();
        for (Selector selector : this.func_188136_a()) {
            IBakedModel iBakedModel = selector.func_188165_a().func_209558_a(function, function2, modelRotation, bl);
            if (iBakedModel == null) continue;
            builder.func_188648_a(selector.func_188166_a(this.field_188140_b), iBakedModel);
        }
        return builder.func_188647_a();
    }

    public static class Deserializer
    implements JsonDeserializer<Multipart> {
        private final ModelBlockDefinition.ContainerHolder field_209584_a;

        public Deserializer(ModelBlockDefinition.ContainerHolder containerHolder) {
            this.field_209584_a = containerHolder;
        }

        public Multipart deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return new Multipart(this.field_209584_a.func_209574_a(), this.func_188133_a(jsonDeserializationContext, jsonElement.getAsJsonArray()));
        }

        private List<Selector> func_188133_a(JsonDeserializationContext jsonDeserializationContext, JsonArray jsonArray) {
            ArrayList arrayList = Lists.newArrayList();
            for (JsonElement jsonElement : jsonArray) {
                arrayList.add(jsonDeserializationContext.deserialize(jsonElement, Selector.class));
            }
            return arrayList;
        }

        public /* synthetic */ Object deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
            return this.deserialize(jsonElement, type, jsonDeserializationContext);
        }
    }
}

