/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.EnumSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.util.LWJGLMemoryUntracker;
import org.apache.commons.io.IOUtils;
import org.lwjgl.stb.STBIWriteCallback;
import org.lwjgl.stb.STBIWriteCallbackI;
import org.lwjgl.stb.STBImage;
import org.lwjgl.stb.STBImageResize;
import org.lwjgl.stb.STBImageWrite;
import org.lwjgl.stb.STBTTFontinfo;
import org.lwjgl.stb.STBTruetype;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public final class NativeImage
implements AutoCloseable {
    private static final Set<StandardOpenOption> field_209272_a = EnumSet.of(StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
    private final PixelFormat field_211680_b;
    private final int field_195719_a;
    private final int field_195720_b;
    private final boolean field_195721_c;
    private long field_195722_d;
    private final int field_195723_e;

    public NativeImage(int n, int n2, boolean bl) {
        this(PixelFormat.RGBA, n, n2, bl);
    }

    public NativeImage(PixelFormat pixelFormat, int n, int n2, boolean bl) {
        this.field_211680_b = pixelFormat;
        this.field_195719_a = n;
        this.field_195720_b = n2;
        this.field_195723_e = n * n2 * pixelFormat.func_211651_a();
        this.field_195721_c = false;
        this.field_195722_d = bl ? MemoryUtil.nmemCalloc((long)1L, (long)this.field_195723_e) : MemoryUtil.nmemAlloc((long)this.field_195723_e);
    }

    private NativeImage(PixelFormat pixelFormat, int n, int n2, boolean bl, long l) {
        this.field_211680_b = pixelFormat;
        this.field_195719_a = n;
        this.field_195720_b = n2;
        this.field_195721_c = bl;
        this.field_195722_d = l;
        this.field_195723_e = n * n2 * pixelFormat.func_211651_a();
    }

    public String toString() {
        return "NativeImage[" + (Object)((Object)this.field_211680_b) + " " + this.field_195719_a + "x" + this.field_195720_b + "@" + this.field_195722_d + (this.field_195721_c ? "S" : "N") + "]";
    }

    public static NativeImage func_195713_a(InputStream inputStream) throws IOException {
        return NativeImage.func_211679_a(PixelFormat.RGBA, inputStream);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NativeImage func_211679_a(@Nullable PixelFormat pixelFormat, InputStream inputStream) throws IOException {
        ByteBuffer byteBuffer = null;
        try {
            byteBuffer = TextureUtil.func_195724_a(inputStream);
            byteBuffer.rewind();
            NativeImage nativeImage = NativeImage.func_211677_a(pixelFormat, byteBuffer);
            return nativeImage;
        }
        finally {
            MemoryUtil.memFree((Buffer)byteBuffer);
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public static NativeImage func_195704_a(ByteBuffer byteBuffer) throws IOException {
        return NativeImage.func_211677_a(PixelFormat.RGBA, byteBuffer);
    }

    public static NativeImage func_211677_a(@Nullable PixelFormat pixelFormat, ByteBuffer byteBuffer) throws IOException {
        if (pixelFormat != null && !pixelFormat.func_211654_w()) {
            throw new UnsupportedOperationException("Don't know how to read format " + (Object)((Object)pixelFormat));
        }
        if (MemoryUtil.memAddress((ByteBuffer)byteBuffer) == 0L) {
            throw new IllegalArgumentException("Invalid buffer");
        }
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            IntBuffer intBuffer = memoryStack.mallocInt(1);
            \u2603 = memoryStack.mallocInt(1);
            \u2603 = memoryStack.mallocInt(1);
            ByteBuffer \u26032 = STBImage.stbi_load_from_memory((ByteBuffer)byteBuffer, (IntBuffer)intBuffer, (IntBuffer)\u2603, (IntBuffer)\u2603, (int)(pixelFormat == null ? 0 : pixelFormat.field_211659_e));
            if (\u26032 == null) {
                throw new IOException("Could not load image: " + STBImage.stbi_failure_reason());
            }
            NativeImage nativeImage = new NativeImage(pixelFormat == null ? PixelFormat.func_211646_b(\u2603.get(0)) : pixelFormat, intBuffer.get(0), \u2603.get(0), true, MemoryUtil.memAddress((ByteBuffer)\u26032));
            return nativeImage;
        }
    }

    private static void func_195707_b(boolean bl) {
        if (bl) {
            GlStateManager.func_187421_b(3553, 10242, 10496);
            GlStateManager.func_187421_b(3553, 10243, 10496);
        } else {
            GlStateManager.func_187421_b(3553, 10242, 10497);
            GlStateManager.func_187421_b(3553, 10243, 10497);
        }
    }

    private static void func_195705_a(boolean bl, boolean bl2) {
        if (bl) {
            GlStateManager.func_187421_b(3553, 10241, bl2 ? 9987 : 9729);
            GlStateManager.func_187421_b(3553, 10240, 9729);
        } else {
            GlStateManager.func_187421_b(3553, 10241, bl2 ? 9986 : 9728);
            GlStateManager.func_187421_b(3553, 10240, 9728);
        }
    }

    private void func_195696_g() {
        if (this.field_195722_d == 0L) {
            throw new IllegalStateException("Image is not allocated.");
        }
    }

    @Override
    public void close() {
        if (this.field_195722_d != 0L) {
            if (this.field_195721_c) {
                STBImage.nstbi_image_free((long)this.field_195722_d);
            } else {
                MemoryUtil.nmemFree((long)this.field_195722_d);
            }
        }
        this.field_195722_d = 0L;
    }

    public int func_195702_a() {
        return this.field_195719_a;
    }

    public int func_195714_b() {
        return this.field_195720_b;
    }

    public PixelFormat func_211678_c() {
        return this.field_211680_b;
    }

    public int func_195709_a(int n, int n2) {
        if (this.field_211680_b != PixelFormat.RGBA) {
            throw new IllegalArgumentException(String.format("getPixelRGBA only works on RGBA images; have %s", new Object[]{this.field_211680_b}));
        }
        if (n > this.field_195719_a || n2 > this.field_195720_b) {
            throw new IllegalArgumentException(String.format("(%s, %s) outside of image bounds (%s, %s)", n, n2, this.field_195719_a, this.field_195720_b));
        }
        this.func_195696_g();
        return MemoryUtil.memIntBuffer((long)this.field_195722_d, (int)this.field_195723_e).get(n + n2 * this.field_195719_a);
    }

    public void func_195700_a(int n, int n2, int n3) {
        if (this.field_211680_b != PixelFormat.RGBA) {
            throw new IllegalArgumentException(String.format("getPixelRGBA only works on RGBA images; have %s", new Object[]{this.field_211680_b}));
        }
        if (n > this.field_195719_a || n2 > this.field_195720_b) {
            throw new IllegalArgumentException(String.format("(%s, %s) outside of image bounds (%s, %s)", n, n2, this.field_195719_a, this.field_195720_b));
        }
        this.func_195696_g();
        MemoryUtil.memIntBuffer((long)this.field_195722_d, (int)this.field_195723_e).put(n + n2 * this.field_195719_a, n3);
    }

    public byte func_211675_e(int n, int n2) {
        if (!this.field_211680_b.func_211653_r()) {
            throw new IllegalArgumentException(String.format("no luminance or alpha in %s", new Object[]{this.field_211680_b}));
        }
        if (n > this.field_195719_a || n2 > this.field_195720_b) {
            throw new IllegalArgumentException(String.format("(%s, %s) outside of image bounds (%s, %s)", n, n2, this.field_195719_a, this.field_195720_b));
        }
        return MemoryUtil.memByteBuffer((long)this.field_195722_d, (int)this.field_195723_e).get((n + n2 * this.field_195719_a) * this.field_211680_b.func_211651_a() + this.field_211680_b.func_211647_v() / 8);
    }

    public void func_195718_b(int n, int n2, int n3) {
        if (this.field_211680_b != PixelFormat.RGBA) {
            throw new UnsupportedOperationException("Can only call blendPixel with RGBA format");
        }
        \u2603 = this.func_195709_a(n, n2);
        float f = (float)(n3 >> 24 & 0xFF) / 255.0f;
        \u2603 = (float)(n3 >> 16 & 0xFF) / 255.0f;
        \u2603 = (float)(n3 >> 8 & 0xFF) / 255.0f;
        \u2603 = (float)(n3 >> 0 & 0xFF) / 255.0f;
        \u2603 = (float)(\u2603 >> 24 & 0xFF) / 255.0f;
        \u2603 = (float)(\u2603 >> 16 & 0xFF) / 255.0f;
        \u2603 = (float)(\u2603 >> 8 & 0xFF) / 255.0f;
        \u2603 = (float)(\u2603 >> 0 & 0xFF) / 255.0f;
        \u2603 = f;
        \u2603 = 1.0f - f;
        \u2603 = f * \u2603 + \u2603 * \u2603;
        \u2603 = \u2603 * \u2603 + \u2603 * \u2603;
        \u2603 = \u2603 * \u2603 + \u2603 * \u2603;
        \u2603 = \u2603 * \u2603 + \u2603 * \u2603;
        if (\u2603 > 1.0f) {
            \u2603 = 1.0f;
        }
        if (\u2603 > 1.0f) {
            \u2603 = 1.0f;
        }
        if (\u2603 > 1.0f) {
            \u2603 = 1.0f;
        }
        if (\u2603 > 1.0f) {
            \u2603 = 1.0f;
        }
        int \u26032 = (int)(\u2603 * 255.0f);
        int \u26033 = (int)(\u2603 * 255.0f);
        int \u26034 = (int)(\u2603 * 255.0f);
        int \u26035 = (int)(\u2603 * 255.0f);
        this.func_195700_a(n, n2, \u26032 << 24 | \u26033 << 16 | \u26034 << 8 | \u26035 << 0);
    }

    @Deprecated
    public int[] func_195716_c() {
        if (this.field_211680_b != PixelFormat.RGBA) {
            throw new UnsupportedOperationException("can only call makePixelArray for RGBA images.");
        }
        this.func_195696_g();
        int[] nArray = new int[this.func_195702_a() * this.func_195714_b()];
        for (int i = 0; i < this.func_195714_b(); ++i) {
            for (\u2603 = 0; \u2603 < this.func_195702_a(); ++\u2603) {
                \u2603 = this.func_195709_a(\u2603, i);
                \u2603 = \u2603 >> 24 & 0xFF;
                \u2603 = \u2603 >> 16 & 0xFF;
                \u2603 = \u2603 >> 8 & 0xFF;
                \u2603 = \u2603 >> 0 & 0xFF;
                nArray[\u2603 + i * this.func_195702_a()] = \u2603 = \u2603 << 24 | \u2603 << 16 | \u2603 << 8 | \u2603;
            }
        }
        return nArray;
    }

    public void func_195697_a(int n, int n2, int n3, boolean bl) {
        this.func_195706_a(n, n2, n3, 0, 0, this.field_195719_a, this.field_195720_b, bl);
    }

    public void func_195706_a(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl) {
        this.func_195712_a(n, n2, n3, n4, n5, n6, n7, false, false, bl);
    }

    public void func_195712_a(int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, boolean bl2, boolean bl3) {
        this.func_195696_g();
        NativeImage.func_195705_a(bl, bl3);
        NativeImage.func_195707_b(bl2);
        if (n6 == this.func_195702_a()) {
            GlStateManager.func_187425_g(3314, 0);
        } else {
            GlStateManager.func_187425_g(3314, this.func_195702_a());
        }
        GlStateManager.func_187425_g(3316, n4);
        GlStateManager.func_187425_g(3315, n5);
        this.field_211680_b.func_211658_c();
        GlStateManager.func_199298_a(3553, n, n2, n3, n6, n7, this.field_211680_b.func_211650_d(), 5121, this.field_195722_d);
    }

    public void func_195717_a(int n, boolean bl) {
        this.func_195696_g();
        this.field_211680_b.func_211656_b();
        GlStateManager.func_199295_a(3553, n, this.field_211680_b.func_211650_d(), 5121, this.field_195722_d);
        if (bl && this.field_211680_b.func_211645_i()) {
            for (int i = 0; i < this.func_195714_b(); ++i) {
                for (\u2603 = 0; \u2603 < this.func_195702_a(); ++\u2603) {
                    this.func_195700_a(\u2603, i, this.func_195709_a(\u2603, i) | 255 << this.field_211680_b.func_211648_n());
                }
            }
        }
    }

    public void func_195701_a(boolean bl) {
        this.func_195696_g();
        this.field_211680_b.func_211656_b();
        if (bl) {
            GlStateManager.func_199297_b(3357, Float.MAX_VALUE);
        }
        GlStateManager.func_199296_a(0, 0, this.field_195719_a, this.field_195720_b, this.field_211680_b.func_211650_d(), 5121, this.field_195722_d);
        if (bl) {
            GlStateManager.func_199297_b(3357, 0.0f);
        }
    }

    public void func_209271_a(File file) throws IOException {
        this.func_209270_a(file.toPath());
    }

    public void func_211676_a(STBTTFontinfo sTBTTFontinfo, int n, int n2, int n3, float f, float f2, float f3, float f4, int n4, int n5) {
        if (n4 < 0 || n4 + n2 > this.func_195702_a() || n5 < 0 || n5 + n3 > this.func_195714_b()) {
            throw new IllegalArgumentException(String.format("Out of bounds: start: (%s, %s) (size: %sx%s); size: %sx%s", n4, n5, n2, n3, this.func_195702_a(), this.func_195714_b()));
        }
        if (this.field_211680_b.func_211651_a() != 1) {
            throw new IllegalArgumentException("Can only write fonts into 1-component images.");
        }
        STBTruetype.nstbtt_MakeGlyphBitmapSubpixel((long)sTBTTFontinfo.address(), (long)(this.field_195722_d + (long)n4 + (long)(n5 * this.func_195702_a())), (int)n2, (int)n3, (int)this.func_195702_a(), (float)f, (float)f2, (float)f3, (float)f4, (int)n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_209270_a(Path path) throws IOException {
        if (!this.field_211680_b.func_211654_w()) {
            throw new UnsupportedOperationException("Don't know how to write format " + (Object)((Object)this.field_211680_b));
        }
        this.func_195696_g();
        try (SeekableByteChannel seekableByteChannel = Files.newByteChannel(path, field_209272_a, new FileAttribute[0]);){
            WriteCallback writeCallback = new WriteCallback(seekableByteChannel);
            try {
                if (!STBImageWrite.stbi_write_png_to_func((STBIWriteCallbackI)writeCallback, (long)0L, (int)this.func_195702_a(), (int)this.func_195714_b(), (int)this.field_211680_b.func_211651_a(), (ByteBuffer)MemoryUtil.memByteBuffer((long)this.field_195722_d, (int)this.field_195723_e), (int)0)) {
                    throw new IOException("Could not write image to the PNG file \"" + path.toAbsolutePath() + "\": " + STBImage.stbi_failure_reason());
                }
            }
            finally {
                writeCallback.free();
            }
            writeCallback.func_209267_a();
        }
    }

    public void func_195703_a(NativeImage nativeImage) {
        if (nativeImage.func_211678_c() != this.field_211680_b) {
            throw new UnsupportedOperationException("Image formats don't match.");
        }
        int n = this.field_211680_b.func_211651_a();
        this.func_195696_g();
        nativeImage.func_195696_g();
        if (this.field_195719_a == nativeImage.field_195719_a) {
            MemoryUtil.memCopy((long)nativeImage.field_195722_d, (long)this.field_195722_d, (long)Math.min(this.field_195723_e, nativeImage.field_195723_e));
        } else {
            \u2603 = Math.min(this.func_195702_a(), nativeImage.func_195702_a());
            \u2603 = Math.min(this.func_195714_b(), nativeImage.func_195714_b());
            for (\u2603 = 0; \u2603 < \u2603; ++\u2603) {
                \u2603 = \u2603 * nativeImage.func_195702_a() * n;
                \u2603 = \u2603 * this.func_195702_a() * n;
                MemoryUtil.memCopy((long)(nativeImage.field_195722_d + (long)\u2603), (long)(this.field_195722_d + (long)\u2603), (long)\u2603);
            }
        }
    }

    public void func_195715_a(int n, int n2, int n3, int n4, int n5) {
        for (\u2603 = n2; \u2603 < n2 + n4; ++\u2603) {
            for (\u2603 = n; \u2603 < n + n3; ++\u2603) {
                this.func_195700_a(\u2603, \u2603, n5);
            }
        }
    }

    public void func_195699_a(int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2) {
        for (int i = 0; i < n6; ++i) {
            for (\u2603 = 0; \u2603 < n5; ++\u2603) {
                \u2603 = bl ? n5 - 1 - \u2603 : \u2603;
                \u2603 = bl2 ? n6 - 1 - i : i;
                \u2603 = this.func_195709_a(n + \u2603, n2 + i);
                this.func_195700_a(n + n3 + \u2603, n2 + n4 + \u2603, \u2603);
            }
        }
    }

    public void func_195710_e() {
        this.func_195696_g();
        try (MemoryStack memoryStack = MemoryStack.stackPush();){
            int n = this.field_211680_b.func_211651_a();
            \u2603 = this.func_195702_a() * n;
            long \u26032 = memoryStack.nmalloc(\u2603);
            for (\u2603 = 0; \u2603 < this.func_195714_b() / 2; ++\u2603) {
                \u2603 = \u2603 * this.func_195702_a() * n;
                \u2603 = (this.func_195714_b() - 1 - \u2603) * this.func_195702_a() * n;
                MemoryUtil.memCopy((long)(this.field_195722_d + (long)\u2603), (long)\u26032, (long)\u2603);
                MemoryUtil.memCopy((long)(this.field_195722_d + (long)\u2603), (long)(this.field_195722_d + (long)\u2603), (long)\u2603);
                MemoryUtil.memCopy((long)\u26032, (long)(this.field_195722_d + (long)\u2603), (long)\u2603);
            }
        }
    }

    public void func_195708_a(int n, int n2, int n3, int n4, NativeImage nativeImage) {
        this.func_195696_g();
        if (nativeImage.func_211678_c() != this.field_211680_b) {
            throw new UnsupportedOperationException("resizeSubRectTo only works for images of the same format.");
        }
        int n5 = this.field_211680_b.func_211651_a();
        STBImageResize.nstbir_resize_uint8((long)(this.field_195722_d + (long)((n + n2 * this.func_195702_a()) * n5)), (int)n3, (int)n4, (int)(this.func_195702_a() * n5), (long)nativeImage.field_195722_d, (int)nativeImage.func_195702_a(), (int)nativeImage.func_195714_b(), (int)0, (int)n5);
    }

    public void func_195711_f() {
        LWJGLMemoryUntracker.func_197933_a(this.field_195722_d);
    }

    public static enum PixelFormat {
        RGBA(4, 6408, true, true, true, false, true, 0, 8, 16, 255, 24, true),
        RGB(3, 6407, true, true, true, false, false, 0, 8, 16, 255, 255, true),
        LUMINANCE_ALPHA(2, 6410, false, false, false, true, true, 255, 255, 255, 0, 8, true),
        LUMINANCE(1, 6409, false, false, false, true, false, 0, 0, 0, 0, 255, true);

        private final int field_211659_e;
        private final int field_211660_f;
        private final boolean field_211661_g;
        private final boolean field_211662_h;
        private final boolean field_211663_i;
        private final boolean field_211664_j;
        private final boolean field_211665_k;
        private final int field_211666_l;
        private final int field_211667_m;
        private final int field_211668_n;
        private final int field_211669_o;
        private final int field_211670_p;
        private final boolean field_211671_q;

        private PixelFormat(int n2, int n3, boolean bl, boolean bl2, boolean bl3, boolean bl4, boolean bl5, int n4, int n5, int n6, int n7, int n8, boolean bl6) {
            this.field_211659_e = n2;
            this.field_211660_f = n3;
            this.field_211661_g = bl;
            this.field_211662_h = bl2;
            this.field_211663_i = bl3;
            this.field_211664_j = bl4;
            this.field_211665_k = bl5;
            this.field_211666_l = n4;
            this.field_211667_m = n5;
            this.field_211668_n = n6;
            this.field_211669_o = n7;
            this.field_211670_p = n8;
            this.field_211671_q = bl6;
        }

        public int func_211651_a() {
            return this.field_211659_e;
        }

        public void func_211656_b() {
            GlStateManager.func_187425_g(3333, this.func_211651_a());
        }

        public void func_211658_c() {
            GlStateManager.func_187425_g(3317, this.func_211651_a());
        }

        public int func_211650_d() {
            return this.field_211660_f;
        }

        public boolean func_211645_i() {
            return this.field_211665_k;
        }

        public int func_211648_n() {
            return this.field_211670_p;
        }

        public boolean func_211653_r() {
            return this.field_211664_j || this.field_211665_k;
        }

        public int func_211647_v() {
            return this.field_211664_j ? this.field_211669_o : this.field_211670_p;
        }

        public boolean func_211654_w() {
            return this.field_211671_q;
        }

        private static PixelFormat func_211646_b(int n) {
            switch (n) {
                case 1: {
                    return LUMINANCE;
                }
                case 2: {
                    return LUMINANCE_ALPHA;
                }
                case 3: {
                    return RGB;
                }
            }
            return RGBA;
        }
    }

    public static enum PixelFormatGLCode {
        RGBA(6408),
        RGB(6407),
        LUMINANCE_ALPHA(6410),
        LUMINANCE(6409),
        INTENSITY(32841);

        private final int field_211673_f;

        private PixelFormatGLCode(int n2) {
            this.field_211673_f = n2;
        }

        int func_211672_a() {
            return this.field_211673_f;
        }
    }

    static class WriteCallback
    extends STBIWriteCallback {
        private final WritableByteChannel field_209268_a;
        private IOException field_209269_b;

        private WriteCallback(WritableByteChannel writableByteChannel) {
            this.field_209268_a = writableByteChannel;
        }

        public void invoke(long l, long l2, int n) {
            ByteBuffer byteBuffer = WriteCallback.getData((long)l2, (int)n);
            try {
                this.field_209268_a.write(byteBuffer);
            }
            catch (IOException \u26032) {
                this.field_209269_b = \u26032;
            }
        }

        public void func_209267_a() throws IOException {
            if (this.field_209269_b != null) {
                throw this.field_209269_b;
            }
        }
    }
}

