/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import java.io.EOFException;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import net.minecraft.resources.IResource;
import org.lwjgl.stb.STBIEOFCallback;
import org.lwjgl.stb.STBIEOFCallbackI;
import org.lwjgl.stb.STBIIOCallbacks;
import org.lwjgl.stb.STBIReadCallback;
import org.lwjgl.stb.STBIReadCallbackI;
import org.lwjgl.stb.STBISkipCallback;
import org.lwjgl.stb.STBISkipCallbackI;
import org.lwjgl.stb.STBImage;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

public class PngSizeInfo {
    public final int field_188533_a;
    public final int field_188534_b;

    public PngSizeInfo(IResource iResource) throws IOException {
        try (MemoryStack memoryStack = MemoryStack.stackPush();
             Reader reader = PngSizeInfo.func_195695_a(iResource.func_199027_b());
             STBIReadCallback sTBIReadCallback = STBIReadCallback.create(reader::func_195682_a);
             STBISkipCallback sTBISkipCallback = STBISkipCallback.create(reader::func_195686_a);
             STBIEOFCallback sTBIEOFCallback = STBIEOFCallback.create(reader::func_195685_a);){
            STBIIOCallbacks sTBIIOCallbacks = STBIIOCallbacks.mallocStack((MemoryStack)memoryStack);
            sTBIIOCallbacks.read((STBIReadCallbackI)sTBIReadCallback);
            sTBIIOCallbacks.skip((STBISkipCallbackI)sTBISkipCallback);
            sTBIIOCallbacks.eof((STBIEOFCallbackI)sTBIEOFCallback);
            IntBuffer \u26032 = memoryStack.mallocInt(1);
            IntBuffer \u26033 = memoryStack.mallocInt(1);
            IntBuffer \u26034 = memoryStack.mallocInt(1);
            if (!STBImage.stbi_info_from_callbacks((STBIIOCallbacks)sTBIIOCallbacks, (long)0L, (IntBuffer)\u26032, (IntBuffer)\u26033, (IntBuffer)\u26034)) {
                throw new IOException("Could not read info from the PNG file " + iResource + " " + STBImage.stbi_failure_reason());
            }
            this.field_188533_a = \u26032.get(0);
            this.field_188534_b = \u26033.get(0);
        }
    }

    private static Reader func_195695_a(InputStream inputStream) {
        if (inputStream instanceof FileInputStream) {
            return new ReaderSeekable(((FileInputStream)inputStream).getChannel());
        }
        return new ReaderBuffer(Channels.newChannel(inputStream));
    }

    static class ReaderBuffer
    extends Reader {
        private final ReadableByteChannel field_195689_b;
        private long field_195690_c = MemoryUtil.nmemAlloc((long)128L);
        private int field_195691_d = 128;
        private int field_195692_e;
        private int field_195693_f;

        private ReaderBuffer(ReadableByteChannel readableByteChannel) {
            this.field_195689_b = readableByteChannel;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void func_195688_b(int n) throws IOException {
            ByteBuffer byteBuffer = MemoryUtil.memByteBuffer((long)this.field_195690_c, (int)this.field_195691_d);
            if (n + this.field_195693_f > this.field_195691_d) {
                this.field_195691_d = n + this.field_195693_f;
                byteBuffer = MemoryUtil.memRealloc((ByteBuffer)byteBuffer, (int)this.field_195691_d);
                this.field_195690_c = MemoryUtil.memAddress((ByteBuffer)byteBuffer);
            }
            byteBuffer.position(this.field_195692_e);
            while (n + this.field_195693_f > this.field_195692_e) {
                try {
                    int n2 = this.field_195689_b.read(byteBuffer);
                    if (n2 != -1) continue;
                    break;
                }
                finally {
                    this.field_195692_e = byteBuffer.position();
                }
            }
        }

        @Override
        public int func_195683_b(long l, int n) throws IOException {
            this.func_195688_b(n);
            if (n + this.field_195693_f > this.field_195692_e) {
                n = this.field_195692_e - this.field_195693_f;
            }
            MemoryUtil.memCopy((long)(this.field_195690_c + (long)this.field_195693_f), (long)l, (long)n);
            this.field_195693_f += n;
            return n;
        }

        @Override
        public void func_195684_a(int n) throws IOException {
            if (n > 0) {
                this.func_195688_b(n);
                if (n + this.field_195693_f > this.field_195692_e) {
                    throw new EOFException("Can't skip past the EOF.");
                }
            }
            if (this.field_195693_f + n < 0) {
                throw new IOException("Can't seek before the beginning: " + (this.field_195693_f + n));
            }
            this.field_195693_f += n;
        }

        @Override
        public void close() throws IOException {
            MemoryUtil.nmemFree((long)this.field_195690_c);
            this.field_195689_b.close();
        }
    }

    static class ReaderSeekable
    extends Reader {
        private final SeekableByteChannel field_195694_b;

        private ReaderSeekable(SeekableByteChannel seekableByteChannel) {
            this.field_195694_b = seekableByteChannel;
        }

        @Override
        public int func_195683_b(long l, int n) throws IOException {
            ByteBuffer byteBuffer = MemoryUtil.memByteBuffer((long)l, (int)n);
            return this.field_195694_b.read(byteBuffer);
        }

        @Override
        public void func_195684_a(int n) throws IOException {
            this.field_195694_b.position(this.field_195694_b.position() + (long)n);
        }

        @Override
        public int func_195685_a(long l) {
            return super.func_195685_a(l) != 0 && this.field_195694_b.isOpen() ? 1 : 0;
        }

        @Override
        public void close() throws IOException {
            this.field_195694_b.close();
        }
    }

    static abstract class Reader
    implements AutoCloseable {
        protected boolean field_195687_a;

        private Reader() {
        }

        int func_195682_a(long l, long l2, int n) {
            try {
                return this.func_195683_b(l2, n);
            }
            catch (IOException iOException) {
                this.field_195687_a = true;
                return 0;
            }
        }

        void func_195686_a(long l, int n) {
            try {
                this.func_195684_a(n);
            }
            catch (IOException iOException) {
                this.field_195687_a = true;
            }
        }

        int func_195685_a(long l) {
            return this.field_195687_a ? 1 : 0;
        }

        protected abstract int func_195683_b(long var1, int var3) throws IOException;

        protected abstract void func_195684_a(int var1) throws IOException;

        @Override
        public abstract void close() throws IOException;
    }
}

