/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.ITickable;
import net.minecraft.client.renderer.texture.ITickableTextureObject;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextureManager
implements ITickable,
IResourceManagerReloadListener {
    private static final Logger field_147646_a = LogManager.getLogger();
    public static final ResourceLocation field_194008_a = new ResourceLocation("");
    private final Map<ResourceLocation, ITextureObject> field_110585_a = Maps.newHashMap();
    private final List<ITickable> field_110583_b = Lists.newArrayList();
    private final Map<String, Integer> field_110584_c = Maps.newHashMap();
    private final IResourceManager field_110582_d;

    public TextureManager(IResourceManager iResourceManager) {
        this.field_110582_d = iResourceManager;
    }

    public void func_110577_a(ResourceLocation resourceLocation) {
        ITextureObject iTextureObject = this.field_110585_a.get(resourceLocation);
        if (iTextureObject == null) {
            iTextureObject = new SimpleTexture(resourceLocation);
            this.func_110579_a(resourceLocation, iTextureObject);
        }
        iTextureObject.func_195412_h();
    }

    public boolean func_110580_a(ResourceLocation resourceLocation, ITickableTextureObject iTickableTextureObject) {
        if (this.func_110579_a(resourceLocation, iTickableTextureObject)) {
            this.field_110583_b.add(iTickableTextureObject);
            return true;
        }
        return false;
    }

    public boolean func_110579_a(ResourceLocation resourceLocation, ITextureObject iTextureObject2) {
        boolean \u26033 = true;
        try {
            iTextureObject2.func_195413_a(this.field_110582_d);
        }
        catch (IOException \u26032) {
            if (resourceLocation != field_194008_a) {
                field_147646_a.warn("Failed to load texture: {}", (Object)resourceLocation, (Object)\u26032);
            }
            ITextureObject iTextureObject2 = MissingTextureSprite.func_195676_d();
            this.field_110585_a.put(resourceLocation, iTextureObject2);
            \u26033 = false;
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, "Registering texture");
            CrashReportCategory \u26034 = crashReport.func_85058_a("Resource location being registered");
            ITextureObject \u26035 = iTextureObject2;
            \u26034.func_71507_a("Resource location", resourceLocation);
            \u26034.func_189529_a("Texture object class", () -> \u26035.getClass().getName());
            throw new ReportedException(crashReport);
        }
        this.field_110585_a.put(resourceLocation, iTextureObject2);
        return \u26033;
    }

    public ITextureObject func_110581_b(ResourceLocation resourceLocation) {
        return this.field_110585_a.get(resourceLocation);
    }

    public ResourceLocation func_110578_a(String string, DynamicTexture dynamicTexture) {
        Integer n = this.field_110584_c.get(string);
        if (n == null) {
            n = 1;
        } else {
            Integer n2 = n;
            Integer n3 = n = Integer.valueOf(n + 1);
        }
        this.field_110584_c.put(string, n);
        ResourceLocation \u26032 = new ResourceLocation(String.format("dynamic/%s_%d", string, n));
        this.func_110579_a(\u26032, dynamicTexture);
        return \u26032;
    }

    @Override
    public void func_110550_d() {
        for (ITickable iTickable : this.field_110583_b) {
            iTickable.func_110550_d();
        }
    }

    public void func_147645_c(ResourceLocation resourceLocation) {
        ITextureObject iTextureObject = this.func_110581_b(resourceLocation);
        if (iTextureObject != null) {
            TextureUtil.func_147942_a(iTextureObject.func_110552_b());
        }
    }

    @Override
    public void func_195410_a(IResourceManager iResourceManager) {
        MissingTextureSprite.func_195676_d();
        Iterator<Map.Entry<ResourceLocation, ITextureObject>> iterator = this.field_110585_a.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<ResourceLocation, ITextureObject> entry = iterator.next();
            ResourceLocation \u26032 = entry.getKey();
            ITextureObject \u26033 = entry.getValue();
            if (\u26033 == MissingTextureSprite.func_195676_d() && !\u26032.equals(MissingTextureSprite.func_195675_b())) {
                iterator.remove();
                continue;
            }
            this.func_110579_a(entry.getKey(), \u26033);
        }
    }
}

