/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.ITickableTextureObject;
import net.minecraft.client.renderer.texture.MissingTextureSprite;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.renderer.texture.Stitcher;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextureMap
extends AbstractTexture
implements ITickableTextureObject {
    private static final Logger field_147635_d = LogManager.getLogger();
    public static final ResourceLocation field_110575_b = new ResourceLocation("textures/atlas/blocks.png");
    private final List<TextureAtlasSprite> field_94258_i = Lists.newArrayList();
    private final Set<ResourceLocation> field_195427_i = Sets.newHashSet();
    private final Map<ResourceLocation, TextureAtlasSprite> field_94252_e = Maps.newHashMap();
    private final String field_94254_c;
    private int field_147636_j;
    private final TextureAtlasSprite field_94249_f = MissingTextureSprite.func_195677_a();

    public TextureMap(String string) {
        this.field_94254_c = string;
    }

    @Override
    public void func_195413_a(IResourceManager iResourceManager) throws IOException {
    }

    public void func_195426_a(IResourceManager iResourceManager, Iterable<ResourceLocation> iterable) {
        this.field_195427_i.clear();
        iterable.forEach(resourceLocation -> this.func_199362_a(iResourceManager, (ResourceLocation)resourceLocation));
        this.func_195421_b(iResourceManager);
    }

    public void func_195421_b(IResourceManager iResourceManager) {
        int n;
        Object \u26035;
        int n2 = Minecraft.func_71369_N();
        Stitcher \u26032 = new Stitcher(n2, n2, 0, this.field_147636_j);
        this.func_195419_g();
        n = Integer.MAX_VALUE;
        \u2603 = 1 << this.field_147636_j;
        for (ResourceLocation resourceLocation : this.field_195427_i) {
            TextureAtlasSprite \u26034;
            if (this.field_94249_f.func_195668_m().equals(resourceLocation)) continue;
            \u2603 = this.func_195420_b(resourceLocation);
            try (IResource iResource = iResourceManager.func_199002_a(\u2603);){
                \u26035 = new PngSizeInfo(iResource);
                AnimationMetadataSection \u26033 = iResource.func_199028_a(AnimationMetadataSection.field_195817_a);
                \u26034 = new TextureAtlasSprite(resourceLocation, (PngSizeInfo)\u26035, \u26033);
            }
            catch (RuntimeException runtimeException) {
                field_147635_d.error("Unable to parse metadata from {} : {}", (Object)\u2603, (Object)runtimeException);
                continue;
            }
            catch (IOException iOException) {
                field_147635_d.error("Using missing texture, unable to load {} : {}", (Object)\u2603, (Object)iOException);
                continue;
            }
            n = Math.min(n, Math.min(\u26034.func_94211_a(), \u26034.func_94216_b()));
            \u2603 = Math.min(Integer.lowestOneBit(\u26034.func_94211_a()), Integer.lowestOneBit(\u26034.func_94216_b()));
            if (\u2603 < \u2603) {
                field_147635_d.warn("Texture {} with size {}x{} limits mip level from {} to {}", (Object)\u2603, (Object)\u26034.func_94211_a(), (Object)\u26034.func_94216_b(), (Object)MathHelper.func_151239_c(\u2603), (Object)MathHelper.func_151239_c(\u2603));
                \u2603 = \u2603;
            }
            \u26032.func_110934_a(\u26034);
        }
        \u2603 = Math.min(n, \u2603);
        \u2603 = MathHelper.func_151239_c(\u2603);
        if (\u2603 < this.field_147636_j) {
            field_147635_d.warn("{}: dropping miplevel from {} to {}, because of minimum power of two: {}", (Object)this.field_94254_c, (Object)this.field_147636_j, (Object)\u2603, (Object)\u2603);
            this.field_147636_j = \u2603;
        }
        this.field_94249_f.func_147963_d(this.field_147636_j);
        \u26032.func_110934_a(this.field_94249_f);
        \u26032.func_94305_f();
        field_147635_d.info("Created: {}x{} {}-atlas", (Object)\u26032.func_110935_a(), (Object)\u26032.func_110936_b(), (Object)this.field_94254_c);
        TextureUtil.func_180600_a(this.func_110552_b(), this.field_147636_j, \u26032.func_110935_a(), \u26032.func_110936_b());
        for (TextureAtlasSprite \u26034 : \u26032.func_94309_g()) {
            if (\u26034 != this.field_94249_f && !this.func_195422_a(iResourceManager, \u26034)) continue;
            this.field_94252_e.put(\u26034.func_195668_m(), \u26034);
            try {
                \u26034.func_195663_q();
            }
            catch (Throwable throwable) {
                CrashReport crashReport = CrashReport.func_85055_a(throwable, "Stitching texture atlas");
                \u26035 = crashReport.func_85058_a("Texture being stitched together");
                ((CrashReportCategory)\u26035).func_71507_a("Atlas path", this.field_94254_c);
                ((CrashReportCategory)\u26035).func_71507_a("Sprite", \u26034);
                throw new ReportedException(crashReport);
            }
            if (!\u26034.func_130098_m()) continue;
            this.field_94258_i.add(\u26034);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean func_195422_a(IResourceManager iResourceManager, TextureAtlasSprite textureAtlasSprite) {
        ResourceLocation resourceLocation = this.func_195420_b(textureAtlasSprite.func_195668_m());
        IResource \u26032 = null;
        try {
            \u26032 = iResourceManager.func_199002_a(resourceLocation);
            textureAtlasSprite.func_195664_a(\u26032, this.field_147636_j + 1);
        }
        catch (RuntimeException \u26033) {
            field_147635_d.error("Unable to parse metadata from {}", (Object)resourceLocation, (Object)\u26033);
            boolean bl = false;
            return bl;
        }
        catch (IOException \u26034) {
            field_147635_d.error("Using missing texture, unable to load {}", (Object)resourceLocation, (Object)\u26034);
            boolean bl = false;
            return bl;
        }
        finally {
            IOUtils.closeQuietly((Closeable)\u26032);
        }
        try {
            textureAtlasSprite.func_147963_d(this.field_147636_j);
        }
        catch (Throwable \u26035) {
            CrashReport crashReport = CrashReport.func_85055_a(\u26035, "Applying mipmap");
            CrashReportCategory \u26036 = crashReport.func_85058_a("Sprite being mipmapped");
            \u26036.func_189529_a("Sprite name", () -> textureAtlasSprite.func_195668_m().toString());
            \u26036.func_189529_a("Sprite size", () -> textureAtlasSprite.func_94211_a() + " x " + textureAtlasSprite.func_94216_b());
            \u26036.func_189529_a("Sprite frames", () -> textureAtlasSprite.func_110970_k() + " frames");
            \u26036.func_71507_a("Mipmap levels", this.field_147636_j);
            throw new ReportedException(crashReport);
        }
        return true;
    }

    private ResourceLocation func_195420_b(ResourceLocation resourceLocation) {
        return new ResourceLocation(resourceLocation.func_110624_b(), String.format("%s/%s%s", this.field_94254_c, resourceLocation.func_110623_a(), ".png"));
    }

    public TextureAtlasSprite func_110572_b(String string) {
        return this.func_195424_a(new ResourceLocation(string));
    }

    public void func_94248_c() {
        this.func_195412_h();
        for (TextureAtlasSprite textureAtlasSprite : this.field_94258_i) {
            textureAtlasSprite.func_94219_l();
        }
    }

    public void func_199362_a(IResourceManager iResourceManager, ResourceLocation resourceLocation) {
        if (resourceLocation == null) {
            throw new IllegalArgumentException("Location cannot be null!");
        }
        this.field_195427_i.add(resourceLocation);
    }

    @Override
    public void func_110550_d() {
        this.func_94248_c();
    }

    public void func_147633_a(int n) {
        this.field_147636_j = n;
    }

    public TextureAtlasSprite func_195424_a(ResourceLocation resourceLocation) {
        TextureAtlasSprite textureAtlasSprite = this.field_94252_e.get(resourceLocation);
        if (textureAtlasSprite == null) {
            return this.field_94249_f;
        }
        return textureAtlasSprite;
    }

    public void func_195419_g() {
        for (TextureAtlasSprite textureAtlasSprite : this.field_94252_e.values()) {
            textureAtlasSprite.func_130103_l();
        }
        this.field_94252_e.clear();
        this.field_94258_i.clear();
    }
}

