/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.texture;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.DefaultUncaughtExceptionHandler;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThreadDownloadImageData
extends SimpleTexture {
    private static final Logger field_147644_c = LogManager.getLogger();
    private static final AtomicInteger field_147643_d = new AtomicInteger(0);
    @Nullable
    private final File field_152434_e;
    private final String field_110562_b;
    @Nullable
    private final IImageBuffer field_110563_c;
    @Nullable
    private Thread field_110561_e;
    private volatile boolean field_110559_g;

    public ThreadDownloadImageData(@Nullable File file, String string, ResourceLocation resourceLocation, @Nullable IImageBuffer iImageBuffer) {
        super(resourceLocation);
        this.field_152434_e = file;
        this.field_110562_b = string;
        this.field_110563_c = iImageBuffer;
    }

    private void func_195416_b(NativeImage nativeImage) {
        TextureUtil.func_110991_a(this.func_110552_b(), nativeImage.func_195702_a(), nativeImage.func_195714_b());
        nativeImage.func_195697_a(0, 0, 0, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_195417_a(NativeImage nativeImage) {
        if (this.field_110563_c != null) {
            this.field_110563_c.func_152634_a();
        }
        ThreadDownloadImageData threadDownloadImageData = this;
        synchronized (threadDownloadImageData) {
            this.func_195416_b(nativeImage);
            this.field_110559_g = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void func_195413_a(IResourceManager iResourceManager) throws IOException {
        if (!this.field_110559_g) {
            ThreadDownloadImageData threadDownloadImageData = this;
            synchronized (threadDownloadImageData) {
                super.func_195413_a(iResourceManager);
                this.field_110559_g = true;
            }
        }
        if (this.field_110561_e == null) {
            if (this.field_152434_e != null && this.field_152434_e.isFile()) {
                field_147644_c.debug("Loading http texture from local cache ({})", (Object)this.field_152434_e);
                try (NativeImage nativeImage = null;){
                    nativeImage = NativeImage.func_195713_a(new FileInputStream(this.field_152434_e));
                    if (this.field_110563_c != null) {
                        nativeImage = this.field_110563_c.func_195786_a(nativeImage);
                    }
                    this.func_195417_a(nativeImage);
                }
            } else {
                this.func_152433_a();
            }
        }
    }

    protected void func_152433_a() {
        this.field_110561_e = new Thread("Texture Downloader #" + field_147643_d.incrementAndGet()){

            @Override
            public void run() {
                HttpURLConnection httpURLConnection = null;
                field_147644_c.debug("Downloading http texture from {} to {}", (Object)ThreadDownloadImageData.this.field_110562_b, (Object)ThreadDownloadImageData.this.field_152434_e);
                try {
                    InputStream \u26032;
                    httpURLConnection = (HttpURLConnection)new URL(ThreadDownloadImageData.this.field_110562_b).openConnection(Minecraft.func_71410_x().func_110437_J());
                    httpURLConnection.setDoInput(true);
                    httpURLConnection.setDoOutput(false);
                    httpURLConnection.connect();
                    if (httpURLConnection.getResponseCode() / 100 != 2) {
                        return;
                    }
                    if (ThreadDownloadImageData.this.field_152434_e != null) {
                        FileUtils.copyInputStreamToFile((InputStream)httpURLConnection.getInputStream(), (File)ThreadDownloadImageData.this.field_152434_e);
                        \u26032 = new FileInputStream(ThreadDownloadImageData.this.field_152434_e);
                    } else {
                        \u26032 = httpURLConnection.getInputStream();
                    }
                    Minecraft.func_71410_x().func_152344_a(() -> {
                        NativeImage nativeImage = null;
                        try {
                            nativeImage = NativeImage.func_195713_a(\u26032);
                            if (ThreadDownloadImageData.this.field_110563_c != null) {
                                nativeImage = ThreadDownloadImageData.this.field_110563_c.func_195786_a(nativeImage);
                            }
                            \u2603 = nativeImage;
                            Minecraft.func_71410_x().func_152344_a(() -> ThreadDownloadImageData.this.func_195417_a(\u2603));
                        }
                        catch (IOException \u26032) {
                            field_147644_c.warn("Error while loading the skin texture", (Throwable)\u26032);
                        }
                        finally {
                            if (nativeImage != null) {
                                nativeImage.close();
                            }
                            IOUtils.closeQuietly((InputStream)\u26032);
                        }
                    });
                }
                catch (Exception exception) {
                    field_147644_c.error("Couldn't download http texture", (Throwable)exception);
                }
                finally {
                    if (httpURLConnection != null) {
                        httpURLConnection.disconnect();
                    }
                }
            }
        };
        this.field_110561_e.setDaemon(true);
        this.field_110561_e.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(field_147644_c));
        this.field_110561_e.start();
    }
}

