/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreenWorking;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.resources.ResourceIndex;
import net.minecraft.client.resources.ResourcePackInfoClient;
import net.minecraft.client.resources.VirtualAssetsPack;
import net.minecraft.resources.FilePack;
import net.minecraft.resources.IPackFinder;
import net.minecraft.resources.PackCompatibility;
import net.minecraft.resources.ResourcePackInfo;
import net.minecraft.resources.VanillaPack;
import net.minecraft.resources.data.PackMetadataSection;
import net.minecraft.util.HttpUtil;
import net.minecraft.util.text.TextComponentTranslation;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.comparator.LastModifiedFileComparator;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.apache.commons.io.filefilter.TrueFileFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DownloadingPackFinder
implements IPackFinder {
    private static final Logger field_195751_a = LogManager.getLogger();
    private static final Pattern field_195752_b = Pattern.compile("^[a-fA-F0-9]{40}$");
    private final VanillaPack field_195753_c;
    private final File field_195754_d;
    private final ReentrantLock field_195755_e = new ReentrantLock();
    @Nullable
    private ListenableFuture<?> field_195756_f;
    @Nullable
    private ResourcePackInfoClient field_195757_g;

    public DownloadingPackFinder(File file, ResourceIndex resourceIndex) {
        this.field_195754_d = file;
        this.field_195753_c = new VirtualAssetsPack(resourceIndex);
    }

    @Override
    public <T extends ResourcePackInfo> void func_195730_a(Map<String, T> map, ResourcePackInfo.IFactory<T> iFactory) {
        T t = ResourcePackInfo.func_195793_a("vanilla", true, () -> this.field_195753_c, iFactory, ResourcePackInfo.Priority.BOTTOM);
        if (t != null) {
            map.put("vanilla", t);
        }
        if (this.field_195757_g != null) {
            map.put("server", this.field_195757_g);
        }
    }

    public VanillaPack func_195746_a() {
        return this.field_195753_c;
    }

    public static Map<String, String> func_195742_b() {
        HashMap hashMap = Maps.newHashMap();
        hashMap.put("X-Minecraft-Username", Minecraft.func_71410_x().func_110432_I().func_111285_a());
        hashMap.put("X-Minecraft-UUID", Minecraft.func_71410_x().func_110432_I().func_148255_b());
        hashMap.put("X-Minecraft-Version", "1.13.2");
        hashMap.put("X-Minecraft-Pack-Format", String.valueOf(4));
        hashMap.put("User-Agent", "Minecraft Java/1.13.2");
        return hashMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ListenableFuture<?> func_195744_a(String string, String string2) {
        \u2603 = DigestUtils.sha1Hex((String)string);
        \u2603 = field_195752_b.matcher(string2).matches() ? string2 : "";
        final File file = new File(this.field_195754_d, \u2603);
        this.field_195755_e.lock();
        try {
            this.func_195749_c();
            if (file.exists()) {
                if (this.func_195745_a(\u2603, file)) {
                    ListenableFuture<Object> listenableFuture = this.func_195741_a(file);
                    return listenableFuture;
                }
                field_195751_a.warn("Deleting file {}", (Object)file);
                FileUtils.deleteQuietly((File)file);
            }
            this.func_195747_e();
            GuiScreenWorking guiScreenWorking = new GuiScreenWorking();
            Map<String, String> \u26032 = DownloadingPackFinder.func_195742_b();
            Minecraft \u26033 = Minecraft.func_71410_x();
            Futures.getUnchecked(\u26033.func_152344_a(() -> \u26033.func_147108_a(guiScreenWorking)));
            final SettableFuture \u26034 = SettableFuture.create();
            this.field_195756_f = HttpUtil.func_180192_a(file, string, \u26032, 0x3200000, guiScreenWorking, \u26033.func_110437_J());
            Futures.addCallback(this.field_195756_f, (FutureCallback)new FutureCallback<Object>(){

                public void onSuccess(@Nullable Object object) {
                    if (DownloadingPackFinder.this.func_195745_a(\u2603, file)) {
                        DownloadingPackFinder.this.func_195741_a(file);
                        \u26034.set(null);
                    } else {
                        field_195751_a.warn("Deleting file {}", (Object)file);
                        FileUtils.deleteQuietly((File)file);
                    }
                }

                public void onFailure(Throwable throwable) {
                    FileUtils.deleteQuietly((File)file);
                    \u26034.setException(throwable);
                }
            });
            ListenableFuture<?> listenableFuture = this.field_195756_f;
            return listenableFuture;
        }
        finally {
            this.field_195755_e.unlock();
        }
    }

    public void func_195749_c() {
        this.field_195755_e.lock();
        try {
            if (this.field_195756_f != null) {
                this.field_195756_f.cancel(true);
            }
            this.field_195756_f = null;
            if (this.field_195757_g != null) {
                this.field_195757_g = null;
                Minecraft.func_71410_x().func_175603_A();
            }
        }
        finally {
            this.field_195755_e.unlock();
        }
    }

    private boolean func_195745_a(String string, File file) {
        try {
            String string2 = DigestUtils.sha1Hex((InputStream)new FileInputStream(file));
            if (string.isEmpty()) {
                field_195751_a.info("Found file {} without verification hash", (Object)file);
                return true;
            }
            if (string2.toLowerCase(Locale.ROOT).equals(string.toLowerCase(Locale.ROOT))) {
                field_195751_a.info("Found file {} matching requested hash {}", (Object)file, (Object)string);
                return true;
            }
            field_195751_a.warn("File {} had wrong hash (expected {}, found {}).", (Object)file, (Object)string, (Object)string2);
        }
        catch (IOException iOException) {
            field_195751_a.warn("File {} couldn't be hashed.", (Object)file, (Object)iOException);
        }
        return false;
    }

    private void func_195747_e() {
        try {
            ArrayList arrayList = Lists.newArrayList((Iterable)FileUtils.listFiles((File)this.field_195754_d, (IOFileFilter)TrueFileFilter.TRUE, null));
            arrayList.sort(LastModifiedFileComparator.LASTMODIFIED_REVERSE);
            int \u26032 = 0;
            for (File file : arrayList) {
                if (\u26032++ < 10) continue;
                field_195751_a.info("Deleting old server resource pack {}", (Object)file.getName());
                FileUtils.deleteQuietly((File)file);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            field_195751_a.error("Error while deleting old server resource pack : {}", (Object)illegalArgumentException.getMessage());
        }
    }

    public ListenableFuture<Object> func_195741_a(File file) {
        PackMetadataSection packMetadataSection = null;
        NativeImage \u26032 = null;
        try (FilePack filePack = new FilePack(file);){
            packMetadataSection = filePack.func_195760_a(PackMetadataSection.field_198964_a);
            try (InputStream inputStream = filePack.func_195763_b("pack.png");){
                \u26032 = NativeImage.func_195713_a(inputStream);
            }
            catch (IOException | IllegalArgumentException exception) {
                // empty catch block
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (packMetadataSection == null) {
            return Futures.immediateFailedFuture((Throwable)new RuntimeException("Invalid resourcepack"));
        }
        this.field_195757_g = new ResourcePackInfoClient("server", true, () -> new FilePack(file), new TextComponentTranslation("resourcePack.server.name", new Object[0]), packMetadataSection.func_198963_a(), PackCompatibility.func_198969_a(packMetadataSection.func_198962_b()), ResourcePackInfo.Priority.TOP, true, \u26032);
        return Minecraft.func_71410_x().func_175603_A();
    }
}

