/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.IllegalFormatException;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Locale {
    private static final Gson field_200700_b = new Gson();
    private static final Logger field_199755_b = LogManager.getLogger();
    private static final Pattern field_135031_c = Pattern.compile("%(\\d+\\$)?[\\d\\.]*[df]");
    Map<String, String> field_135032_a = Maps.newHashMap();

    public synchronized void func_195811_a(IResourceManager iResourceManager, List<String> list) {
        this.field_135032_a.clear();
        for (String string : list) {
            \u2603 = String.format("lang/%s.json", string);
            for (String string2 : iResourceManager.func_199001_a()) {
                try {
                    ResourceLocation resourceLocation = new ResourceLocation(string2, \u2603);
                    this.func_135028_a(iResourceManager.func_199004_b(resourceLocation));
                }
                catch (FileNotFoundException resourceLocation) {
                }
                catch (Exception exception) {
                    field_199755_b.warn("Skipped language file: {}:{} ({})", (Object)string2, (Object)\u2603, (Object)exception.toString());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void func_135028_a(List<IResource> list) {
        for (IResource iResource : list) {
            InputStream inputStream = iResource.func_199027_b();
            try {
                this.func_135021_a(inputStream);
            }
            finally {
                IOUtils.closeQuietly((InputStream)inputStream);
            }
        }
    }

    private void func_135021_a(InputStream inputStream) {
        JsonElement jsonElement = (JsonElement)field_200700_b.fromJson((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8), JsonElement.class);
        JsonObject \u26032 = JsonUtils.func_151210_l(jsonElement, "strings");
        for (Map.Entry entry : \u26032.entrySet()) {
            String string = field_135031_c.matcher(JsonUtils.func_151206_a((JsonElement)entry.getValue(), (String)entry.getKey())).replaceAll("%$1s");
            this.field_135032_a.put((String)entry.getKey(), string);
        }
    }

    private String func_135026_c(String string) {
        \u2603 = this.field_135032_a.get(string);
        return \u2603 == null ? string : \u2603;
    }

    public String func_135023_a(String string, Object[] objectArray) {
        String string2 = this.func_135026_c(string);
        try {
            return String.format(string2, objectArray);
        }
        catch (IllegalFormatException \u26032) {
            return "Format error: " + string2;
        }
    }

    public boolean func_188568_a(String string) {
        return this.field_135032_a.containsKey(string);
    }
}

