/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.hash.Hashing;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.InsecureTextureException;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IImageBuffer;
import net.minecraft.client.renderer.ImageBufferDownload;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.ThreadDownloadImageData;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.util.ResourceLocation;

public class SkinManager {
    private static final ExecutorService field_152794_b = new ThreadPoolExecutor(0, 2, 1L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>());
    private final TextureManager field_152795_c;
    private final File field_152796_d;
    private final MinecraftSessionService field_152797_e;
    private final LoadingCache<GameProfile, Map<MinecraftProfileTexture.Type, MinecraftProfileTexture>> field_152798_f;

    public SkinManager(TextureManager textureManager, File file, MinecraftSessionService minecraftSessionService) {
        this.field_152795_c = textureManager;
        this.field_152796_d = file;
        this.field_152797_e = minecraftSessionService;
        this.field_152798_f = CacheBuilder.newBuilder().expireAfterAccess(15L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<GameProfile, Map<MinecraftProfileTexture.Type, MinecraftProfileTexture>>(){

            public Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> load(GameProfile gameProfile) throws Exception {
                try {
                    return Minecraft.func_71410_x().func_152347_ac().getTextures(gameProfile, false);
                }
                catch (Throwable throwable) {
                    return Maps.newHashMap();
                }
            }

            public /* synthetic */ Object load(Object object) throws Exception {
                return this.load((GameProfile)object);
            }
        });
    }

    public ResourceLocation func_152792_a(MinecraftProfileTexture minecraftProfileTexture, MinecraftProfileTexture.Type type) {
        return this.func_152789_a(minecraftProfileTexture, type, null);
    }

    public ResourceLocation func_152789_a(final MinecraftProfileTexture minecraftProfileTexture, final MinecraftProfileTexture.Type type, final @Nullable SkinAvailableCallback skinAvailableCallback) {
        String string = Hashing.sha1().hashUnencodedChars((CharSequence)minecraftProfileTexture.getHash()).toString();
        final ResourceLocation \u26032 = new ResourceLocation("skins/" + string);
        ITextureObject \u26033 = this.field_152795_c.func_110581_b(\u26032);
        if (\u26033 != null) {
            if (skinAvailableCallback != null) {
                skinAvailableCallback.onSkinTextureAvailable(type, \u26032, minecraftProfileTexture);
            }
        } else {
            File file = new File(this.field_152796_d, string.length() > 2 ? string.substring(0, 2) : "xx");
            \u2603 = new File(file, string);
            final ImageBufferDownload \u26034 = type == MinecraftProfileTexture.Type.SKIN ? new ImageBufferDownload() : null;
            ThreadDownloadImageData \u26035 = new ThreadDownloadImageData(\u2603, minecraftProfileTexture.getUrl(), DefaultPlayerSkin.func_177335_a(), new IImageBuffer(){

                @Override
                public NativeImage func_195786_a(NativeImage nativeImage) {
                    if (\u26034 != null) {
                        return \u26034.func_195786_a(nativeImage);
                    }
                    return nativeImage;
                }

                @Override
                public void func_152634_a() {
                    if (\u26034 != null) {
                        \u26034.func_152634_a();
                    }
                    if (skinAvailableCallback != null) {
                        skinAvailableCallback.onSkinTextureAvailable(type, \u26032, minecraftProfileTexture);
                    }
                }
            });
            this.field_152795_c.func_110579_a(\u26032, \u26035);
        }
        return \u26032;
    }

    public void func_152790_a(GameProfile gameProfile, SkinAvailableCallback skinAvailableCallback, boolean bl) {
        field_152794_b.submit(() -> {
            HashMap hashMap = Maps.newHashMap();
            try {
                hashMap.putAll(this.field_152797_e.getTextures(gameProfile, bl));
            }
            catch (InsecureTextureException insecureTextureException) {
                // empty catch block
            }
            if (hashMap.isEmpty()) {
                gameProfile.getProperties().clear();
                if (gameProfile.getId().equals(Minecraft.func_71410_x().func_110432_I().func_148256_e().getId())) {
                    gameProfile.getProperties().putAll((Multimap)Minecraft.func_71410_x().func_181037_M());
                    hashMap.putAll(this.field_152797_e.getTextures(gameProfile, false));
                } else {
                    this.field_152797_e.fillProfileProperties(gameProfile, bl);
                    try {
                        hashMap.putAll(this.field_152797_e.getTextures(gameProfile, bl));
                    }
                    catch (InsecureTextureException insecureTextureException) {
                        // empty catch block
                    }
                }
            }
            Minecraft.func_71410_x().func_152344_a(() -> {
                if (hashMap.containsKey(MinecraftProfileTexture.Type.SKIN)) {
                    this.func_152789_a((MinecraftProfileTexture)hashMap.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN, skinAvailableCallback);
                }
                if (hashMap.containsKey(MinecraftProfileTexture.Type.CAPE)) {
                    this.func_152789_a((MinecraftProfileTexture)hashMap.get(MinecraftProfileTexture.Type.CAPE), MinecraftProfileTexture.Type.CAPE, skinAvailableCallback);
                }
            });
        });
    }

    public Map<MinecraftProfileTexture.Type, MinecraftProfileTexture> func_152788_a(GameProfile gameProfile) {
        return (Map)this.field_152798_f.getUnchecked((Object)gameProfile);
    }

    public static interface SkinAvailableCallback {
        public void onSkinTextureAvailable(MinecraftProfileTexture.Type var1, ResourceLocation var2, MinecraftProfileTexture var3);
    }
}

