/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.data;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import net.minecraft.client.resources.data.AnimationFrame;
import net.minecraft.client.resources.data.AnimationMetadataSection;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.JsonUtils;
import org.apache.commons.lang3.Validate;

public class AnimationMetadataSectionSerializer
implements IMetadataSectionSerializer<AnimationMetadataSection> {
    @Override
    public AnimationMetadataSection func_195812_a(JsonObject jsonObject2) {
        JsonObject jsonObject2;
        int \u26035;
        ArrayList arrayList = Lists.newArrayList();
        int \u26032 = JsonUtils.func_151208_a(jsonObject2, "frametime", 1);
        if (\u26032 != 1) {
            Validate.inclusiveBetween((long)1L, (long)Integer.MAX_VALUE, (long)\u26032, (String)"Invalid default frame time");
        }
        if (jsonObject2.has("frames")) {
            try {
                JsonArray jsonArray = JsonUtils.func_151214_t(jsonObject2, "frames");
                for (\u26035 = 0; \u26035 < jsonArray.size(); ++\u26035) {
                    JsonElement jsonElement = jsonArray.get(\u26035);
                    AnimationFrame \u26033 = this.func_110492_a(\u26035, jsonElement);
                    if (\u26033 == null) continue;
                    arrayList.add(\u26033);
                }
            }
            catch (ClassCastException classCastException) {
                throw new JsonParseException("Invalid animation->frames: expected array, was " + jsonObject2.get("frames"), (Throwable)classCastException);
            }
        }
        int \u26034 = JsonUtils.func_151208_a(jsonObject2, "width", -1);
        \u26035 = JsonUtils.func_151208_a(jsonObject2, "height", -1);
        if (\u26034 != -1) {
            Validate.inclusiveBetween((long)1L, (long)Integer.MAX_VALUE, (long)\u26034, (String)"Invalid width");
        }
        if (\u26035 != -1) {
            Validate.inclusiveBetween((long)1L, (long)Integer.MAX_VALUE, (long)\u26035, (String)"Invalid height");
        }
        boolean \u26036 = JsonUtils.func_151209_a(jsonObject2, "interpolate", false);
        return new AnimationMetadataSection(arrayList, \u26034, \u26035, \u26032, \u26036);
    }

    private AnimationFrame func_110492_a(int n, JsonElement jsonElement) {
        if (jsonElement.isJsonPrimitive()) {
            return new AnimationFrame(JsonUtils.func_151215_f(jsonElement, "frames[" + n + "]"));
        }
        if (jsonElement.isJsonObject()) {
            JsonObject jsonObject = JsonUtils.func_151210_l(jsonElement, "frames[" + n + "]");
            int \u26032 = JsonUtils.func_151208_a(jsonObject, "time", -1);
            if (jsonObject.has("time")) {
                Validate.inclusiveBetween((long)1L, (long)Integer.MAX_VALUE, (long)\u26032, (String)"Invalid frame time");
            }
            int \u26033 = JsonUtils.func_151203_m(jsonObject, "index");
            Validate.inclusiveBetween((long)0L, (long)Integer.MAX_VALUE, (long)\u26033, (String)"Invalid frame index");
            return new AnimationFrame(\u26033, \u26032);
        }
        return null;
    }

    @Override
    public String func_110483_a() {
        return "animation";
    }

    @Override
    public /* synthetic */ Object func_195812_a(JsonObject jsonObject) {
        return this.func_195812_a(jsonObject);
    }
}

