/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.resources.data;

import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.client.resources.Language;
import net.minecraft.client.resources.data.LanguageMetadataSection;
import net.minecraft.resources.data.IMetadataSectionSerializer;
import net.minecraft.util.JsonUtils;

public class LanguageMetadataSectionSerializer
implements IMetadataSectionSerializer<LanguageMetadataSection> {
    @Override
    public LanguageMetadataSection func_195812_a(JsonObject jsonObject) {
        HashSet hashSet = Sets.newHashSet();
        for (Map.Entry entry : jsonObject.entrySet()) {
            String string = (String)entry.getKey();
            if (string.length() > 16) {
                throw new JsonParseException("Invalid language->'" + string + "': language code must not be more than " + 16 + " characters long");
            }
            JsonObject \u26032 = JsonUtils.func_151210_l((JsonElement)entry.getValue(), "language");
            \u2603 = JsonUtils.func_151200_h(\u26032, "region");
            \u2603 = JsonUtils.func_151200_h(\u26032, "name");
            boolean \u26033 = JsonUtils.func_151209_a(\u26032, "bidirectional", false);
            if (\u2603.isEmpty()) {
                throw new JsonParseException("Invalid language->'" + string + "'->region: empty value");
            }
            if (\u2603.isEmpty()) {
                throw new JsonParseException("Invalid language->'" + string + "'->name: empty value");
            }
            if (hashSet.add(new Language(string, \u2603, \u2603, \u26033))) continue;
            throw new JsonParseException("Duplicate language->'" + string + "' defined");
        }
        return new LanguageMetadataSection(hashSet);
    }

    @Override
    public String func_110483_a() {
        return "language";
    }

    @Override
    public /* synthetic */ Object func_195812_a(JsonObject jsonObject) {
        return this.func_195812_a(jsonObject);
    }
}

