/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.shader;

import com.google.common.collect.Maps;
import java.io.Closeable;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.Map;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.TextureUtil;
import net.minecraft.client.shader.ShaderManager;
import net.minecraft.client.util.JsonException;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.lwjgl.system.MemoryUtil;

public class ShaderLoader {
    private final ShaderType field_148061_a;
    private final String field_148059_b;
    private final int field_148060_c;
    private int field_148058_d;

    private ShaderLoader(ShaderType shaderType, int n, String string) {
        this.field_148061_a = shaderType;
        this.field_148060_c = n;
        this.field_148059_b = string;
    }

    public void func_148056_a(ShaderManager shaderManager) {
        ++this.field_148058_d;
        OpenGlHelper.func_153178_b(shaderManager.func_147986_h(), this.field_148060_c);
    }

    public void func_195656_a() {
        --this.field_148058_d;
        if (this.field_148058_d <= 0) {
            OpenGlHelper.func_153180_a(this.field_148060_c);
            this.field_148061_a.func_148064_d().remove(this.field_148059_b);
        }
    }

    public String func_148055_a() {
        return this.field_148059_b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ShaderLoader func_195655_a(IResourceManager iResourceManager, ShaderType shaderType, String string) throws IOException {
        ShaderLoader shaderLoader = (ShaderLoader)shaderType.func_148064_d().get(string);
        if (shaderLoader == null) {
            ResourceLocation resourceLocation = new ResourceLocation("shaders/program/" + string + shaderType.func_148063_b());
            IResource \u26032 = iResourceManager.func_199002_a(resourceLocation);
            ByteBuffer \u26033 = null;
            try {
                \u26033 = TextureUtil.func_195724_a(\u26032.func_199027_b());
                int n = \u26033.position();
                \u26033.rewind();
                \u2603 = OpenGlHelper.func_153195_b(shaderType.func_148065_c());
                String \u26034 = MemoryUtil.memASCII((ByteBuffer)\u26033, (int)n);
                OpenGlHelper.func_195918_a(\u2603, \u26034);
                OpenGlHelper.func_153170_c(\u2603);
                if (OpenGlHelper.func_153157_c(\u2603, OpenGlHelper.field_153208_p) == 0) {
                    String string2 = StringUtils.trim((String)OpenGlHelper.func_153158_d(\u2603, 32768));
                    JsonException \u26035 = new JsonException("Couldn't compile " + shaderType.func_148062_a() + " program: " + string2);
                    \u26035.func_151381_b(resourceLocation.func_110623_a());
                    throw \u26035;
                }
                shaderLoader = new ShaderLoader(shaderType, \u2603, string);
                shaderType.func_148064_d().put(string, shaderLoader);
            }
            finally {
                IOUtils.closeQuietly((Closeable)\u26032);
                if (\u26033 != null) {
                    MemoryUtil.memFree((Buffer)\u26033);
                }
            }
        }
        return shaderLoader;
    }

    public static enum ShaderType {
        VERTEX("vertex", ".vsh", OpenGlHelper.field_153209_q),
        FRAGMENT("fragment", ".fsh", OpenGlHelper.field_153210_r);

        private final String field_148072_c;
        private final String field_148069_d;
        private final int field_148070_e;
        private final Map<String, ShaderLoader> field_148067_f = Maps.newHashMap();

        private ShaderType(String string2, String string3, int n2) {
            this.field_148072_c = string2;
            this.field_148069_d = string3;
            this.field_148070_e = n2;
        }

        public String func_148062_a() {
            return this.field_148072_c;
        }

        private String func_148063_b() {
            return this.field_148069_d;
        }

        private int func_148065_c() {
            return this.field_148070_e;
        }

        private Map<String, ShaderLoader> func_148064_d() {
            return this.field_148067_f;
        }
    }
}

