/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.shader;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.client.shader.ShaderDefault;
import net.minecraft.client.shader.ShaderLinkHelper;
import net.minecraft.client.shader.ShaderLoader;
import net.minecraft.client.shader.ShaderUniform;
import net.minecraft.client.util.JsonBlendingMode;
import net.minecraft.client.util.JsonException;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ShaderManager
implements AutoCloseable {
    private static final Logger field_148003_a = LogManager.getLogger();
    private static final ShaderDefault field_148001_b = new ShaderDefault();
    private static ShaderManager field_148002_c;
    private static int field_147999_d;
    private final Map<String, Object> field_147997_f = Maps.newHashMap();
    private final List<String> field_147998_g = Lists.newArrayList();
    private final List<Integer> field_148010_h = Lists.newArrayList();
    private final List<ShaderUniform> field_148011_i = Lists.newArrayList();
    private final List<Integer> field_148008_j = Lists.newArrayList();
    private final Map<String, ShaderUniform> field_148009_k = Maps.newHashMap();
    private final int field_148006_l;
    private final String field_148007_m;
    private final boolean field_148004_n;
    private boolean field_148005_o;
    private final JsonBlendingMode field_148016_p;
    private final List<Integer> field_148015_q;
    private final List<String> field_148014_r;
    private final ShaderLoader field_148013_s;
    private final ShaderLoader field_148012_t;

    public ShaderManager(IResourceManager iResourceManager, String string) throws IOException {
        ResourceLocation resourceLocation = new ResourceLocation("shaders/program/" + string + ".json");
        this.field_148007_m = string;
        IResource \u26032 = null;
        try {
            JsonArray jsonArray;
            JsonArray jsonArray2;
            \u26032 = iResourceManager.func_199002_a(resourceLocation);
            JsonObject jsonObject = JsonUtils.func_212743_a(new InputStreamReader(\u26032.func_199027_b(), StandardCharsets.UTF_8));
            String \u26033 = JsonUtils.func_151200_h(jsonObject, "vertex");
            String \u26034 = JsonUtils.func_151200_h(jsonObject, "fragment");
            JsonArray \u26035 = JsonUtils.func_151213_a(jsonObject, "samplers", null);
            if (\u26035 != null) {
                int n = 0;
                for (Object object : \u26035) {
                    try {
                        this.func_147996_a((JsonElement)object);
                    }
                    catch (Exception exception) {
                        JsonException jsonException = JsonException.func_151379_a(exception);
                        jsonException.func_151380_a("samplers[" + n + "]");
                        throw jsonException;
                    }
                    ++n;
                }
            }
            if ((jsonArray2 = JsonUtils.func_151213_a(jsonObject, "attributes", null)) != null) {
                int n = 0;
                this.field_148015_q = Lists.newArrayListWithCapacity((int)jsonArray2.size());
                this.field_148014_r = Lists.newArrayListWithCapacity((int)jsonArray2.size());
                for (JsonElement jsonElement : jsonArray2) {
                    try {
                        this.field_148014_r.add(JsonUtils.func_151206_a(jsonElement, "attribute"));
                    }
                    catch (Exception exception) {
                        JsonException jsonException = JsonException.func_151379_a(exception);
                        jsonException.func_151380_a("attributes[" + n + "]");
                        throw jsonException;
                    }
                    ++n;
                }
            } else {
                this.field_148015_q = null;
                this.field_148014_r = null;
            }
            if ((jsonArray = JsonUtils.func_151213_a(jsonObject, "uniforms", null)) != null) {
                int n = 0;
                for (JsonElement jsonElement : jsonArray) {
                    try {
                        this.func_147987_b(jsonElement);
                    }
                    catch (Exception exception) {
                        JsonException jsonException = JsonException.func_151379_a(exception);
                        jsonException.func_151380_a("uniforms[" + n + "]");
                        throw jsonException;
                    }
                    ++n;
                }
            }
            this.field_148016_p = JsonBlendingMode.func_148110_a(JsonUtils.func_151218_a(jsonObject, "blend", null));
            this.field_148004_n = JsonUtils.func_151209_a(jsonObject, "cull", true);
            this.field_148013_s = ShaderLoader.func_195655_a(iResourceManager, ShaderLoader.ShaderType.VERTEX, \u26033);
            this.field_148012_t = ShaderLoader.func_195655_a(iResourceManager, ShaderLoader.ShaderType.FRAGMENT, \u26034);
            this.field_148006_l = ShaderLinkHelper.func_148074_b().func_148078_c();
            ShaderLinkHelper.func_148074_b().func_148075_b(this);
            this.func_147990_i();
            if (this.field_148014_r != null) {
                for (String string2 : this.field_148014_r) {
                    int n = OpenGlHelper.func_153164_b(this.field_148006_l, string2);
                    this.field_148015_q.add(n);
                }
            }
        }
        catch (Exception exception) {
            JsonException jsonException = JsonException.func_151379_a(exception);
            jsonException.func_151381_b(resourceLocation.func_110623_a());
            throw jsonException;
        }
        finally {
            IOUtils.closeQuietly((Closeable)\u26032);
        }
        this.func_147985_d();
    }

    @Override
    public void close() {
        for (ShaderUniform shaderUniform : this.field_148011_i) {
            shaderUniform.close();
        }
        ShaderLinkHelper.func_148074_b().func_148077_a(this);
    }

    public void func_147993_b() {
        OpenGlHelper.func_153161_d(0);
        field_147999_d = -1;
        field_148002_c = null;
        for (int i = 0; i < this.field_148010_h.size(); ++i) {
            if (this.field_147997_f.get(this.field_147998_g.get(i)) == null) continue;
            GlStateManager.func_179138_g(OpenGlHelper.field_77478_a + i);
            GlStateManager.func_179144_i(0);
        }
    }

    public void func_147995_c() {
        this.field_148005_o = false;
        field_148002_c = this;
        this.field_148016_p.func_148109_a();
        if (this.field_148006_l != field_147999_d) {
            OpenGlHelper.func_153161_d(this.field_148006_l);
            field_147999_d = this.field_148006_l;
        }
        if (this.field_148004_n) {
            GlStateManager.func_179089_o();
        } else {
            GlStateManager.func_179129_p();
        }
        for (int i = 0; i < this.field_148010_h.size(); ++i) {
            if (this.field_147997_f.get(this.field_147998_g.get(i)) == null) continue;
            GlStateManager.func_179138_g(OpenGlHelper.field_77478_a + i);
            GlStateManager.func_179098_w();
            Object object = this.field_147997_f.get(this.field_147998_g.get(i));
            int \u26032 = -1;
            if (object instanceof Framebuffer) {
                \u26032 = ((Framebuffer)object).field_147617_g;
            } else if (object instanceof ITextureObject) {
                \u26032 = ((ITextureObject)object).func_110552_b();
            } else if (object instanceof Integer) {
                \u26032 = (Integer)object;
            }
            if (\u26032 == -1) continue;
            GlStateManager.func_179144_i(\u26032);
            OpenGlHelper.func_153163_f(OpenGlHelper.func_153194_a(this.field_148006_l, this.field_147998_g.get(i)), i);
        }
        for (ShaderUniform shaderUniform : this.field_148011_i) {
            shaderUniform.func_148093_b();
        }
    }

    public void func_147985_d() {
        this.field_148005_o = true;
    }

    @Nullable
    public ShaderUniform func_147991_a(String string) {
        return this.field_148009_k.get(string);
    }

    public ShaderDefault func_195653_b(String string) {
        ShaderUniform shaderUniform = this.func_147991_a(string);
        return shaderUniform == null ? field_148001_b : shaderUniform;
    }

    private void func_147990_i() {
        int \u26032;
        int n = 0;
        \u2603 = 0;
        while (n < this.field_147998_g.size()) {
            String string = this.field_147998_g.get(n);
            \u26032 = OpenGlHelper.func_153194_a(this.field_148006_l, string);
            if (\u26032 == -1) {
                field_148003_a.warn("Shader {}could not find sampler named {} in the specified shader program.", (Object)this.field_148007_m, (Object)string);
                this.field_147997_f.remove(string);
                this.field_147998_g.remove(\u2603);
                --\u2603;
            } else {
                this.field_148010_h.add(\u26032);
            }
            ++n;
            ++\u2603;
        }
        for (ShaderUniform \u26033 : this.field_148011_i) {
            string = \u26033.func_148086_a();
            \u26032 = OpenGlHelper.func_153194_a(this.field_148006_l, string);
            if (\u26032 == -1) {
                field_148003_a.warn("Could not find uniform named {} in the specified shader program.", (Object)string);
                continue;
            }
            this.field_148008_j.add(\u26032);
            \u26033.func_148084_b(\u26032);
            this.field_148009_k.put(string, \u26033);
        }
    }

    private void func_147996_a(JsonElement jsonElement) {
        JsonObject jsonObject = JsonUtils.func_151210_l(jsonElement, "sampler");
        String \u26032 = JsonUtils.func_151200_h(jsonObject, "name");
        if (!JsonUtils.func_151205_a(jsonObject, "file")) {
            this.field_147997_f.put(\u26032, null);
            this.field_147998_g.add(\u26032);
            return;
        }
        this.field_147998_g.add(\u26032);
    }

    public void func_147992_a(String string, Object object) {
        if (this.field_147997_f.containsKey(string)) {
            this.field_147997_f.remove(string);
        }
        this.field_147997_f.put(string, object);
        this.func_147985_d();
    }

    private void func_147987_b(JsonElement jsonElement) throws JsonException {
        Object \u260382;
        JsonObject jsonObject = JsonUtils.func_151210_l(jsonElement, "uniform");
        String \u26032 = JsonUtils.func_151200_h(jsonObject, "name");
        int \u26033 = ShaderUniform.func_148085_a(JsonUtils.func_151200_h(jsonObject, "type"));
        int \u26034 = JsonUtils.func_151203_m(jsonObject, "count");
        float[] \u26035 = new float[Math.max(\u26034, 16)];
        JsonArray \u26036 = JsonUtils.func_151214_t(jsonObject, "values");
        if (\u26036.size() != \u26034 && \u26036.size() > 1) {
            throw new JsonException("Invalid amount of values specified (expected " + \u26034 + ", found " + \u26036.size() + ")");
        }
        int \u26037 = 0;
        for (Object \u260382 : \u26036) {
            try {
                \u26035[\u26037] = JsonUtils.func_151220_d((JsonElement)\u260382, "value");
            }
            catch (Exception exception) {
                JsonException jsonException = JsonException.func_151379_a(exception);
                jsonException.func_151380_a("values[" + \u26037 + "]");
                throw jsonException;
            }
            ++\u26037;
        }
        if (\u26034 > 1 && \u26036.size() == 1) {
            while (\u26037 < \u26034) {
                \u26035[\u26037] = \u26035[0];
                ++\u26037;
            }
        }
        int n = \u26034 > 1 && \u26034 <= 4 && \u26033 < 8 ? \u26034 - 1 : 0;
        \u260382 = new ShaderUniform(\u26032, \u26033 + n, \u26034, this);
        if (\u26033 <= 3) {
            ((ShaderUniform)\u260382).func_148083_a((int)\u26035[0], (int)\u26035[1], (int)\u26035[2], (int)\u26035[3]);
        } else if (\u26033 <= 7) {
            ((ShaderUniform)\u260382).func_148092_b(\u26035[0], \u26035[1], \u26035[2], \u26035[3]);
        } else {
            ((ShaderUniform)\u260382).func_148097_a(\u26035);
        }
        this.field_148011_i.add((ShaderUniform)\u260382);
    }

    public ShaderLoader func_147989_e() {
        return this.field_148013_s;
    }

    public ShaderLoader func_147994_f() {
        return this.field_148012_t;
    }

    public int func_147986_h() {
        return this.field_148006_l;
    }

    static {
        field_147999_d = -1;
    }
}

