/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.util;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.recipebook.RecipeList;
import net.minecraft.client.util.RecipeBookCategories;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ContainerFurnace;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.inventory.ContainerWorkbench;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipe;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.RecipeBook;
import net.minecraft.item.crafting.RecipeManager;

public class RecipeBookClient
extends RecipeBook {
    private final RecipeManager field_199645_e;
    private final Map<RecipeBookCategories, List<RecipeList>> field_197931_e = Maps.newHashMap();
    private final List<RecipeList> field_197932_f = Lists.newArrayList();

    public RecipeBookClient(RecipeManager recipeManager) {
        this.field_199645_e = recipeManager;
    }

    public void func_199644_c() {
        this.field_197932_f.clear();
        this.field_197931_e.clear();
        HashBasedTable hashBasedTable = HashBasedTable.create();
        for (IRecipe iRecipe : this.field_199645_e.func_199510_b()) {
            RecipeList \u26033;
            if (iRecipe.func_192399_d()) continue;
            RecipeBookCategories recipeBookCategories = RecipeBookClient.func_202887_g(iRecipe);
            String \u26032 = iRecipe.func_193358_e();
            if (\u26032.isEmpty()) {
                \u26033 = this.func_202889_b(recipeBookCategories);
            } else {
                \u26033 = (RecipeList)hashBasedTable.get((Object)recipeBookCategories, (Object)\u26032);
                if (\u26033 == null) {
                    \u26033 = this.func_202889_b(recipeBookCategories);
                    hashBasedTable.put((Object)recipeBookCategories, (Object)\u26032, (Object)\u26033);
                }
            }
            \u26033.func_192709_a(iRecipe);
        }
    }

    private RecipeList func_202889_b(RecipeBookCategories recipeBookCategories2) {
        RecipeList recipeList = new RecipeList();
        this.field_197932_f.add(recipeList);
        this.field_197931_e.computeIfAbsent(recipeBookCategories2, recipeBookCategories -> Lists.newArrayList()).add(recipeList);
        if (recipeBookCategories2 == RecipeBookCategories.FURNACE_BLOCKS || recipeBookCategories2 == RecipeBookCategories.FURNACE_FOOD || recipeBookCategories2 == RecipeBookCategories.FURNACE_MISC) {
            this.field_197931_e.computeIfAbsent(RecipeBookCategories.FURNACE_SEARCH, recipeBookCategories -> Lists.newArrayList()).add(recipeList);
        } else {
            this.field_197931_e.computeIfAbsent(RecipeBookCategories.SEARCH, recipeBookCategories -> Lists.newArrayList()).add(recipeList);
        }
        return recipeList;
    }

    private static RecipeBookCategories func_202887_g(IRecipe iRecipe) {
        if (iRecipe instanceof FurnaceRecipe) {
            if (iRecipe.func_77571_b().func_77973_b() instanceof ItemFood) {
                return RecipeBookCategories.FURNACE_FOOD;
            }
            if (iRecipe.func_77571_b().func_77973_b() instanceof ItemBlock) {
                return RecipeBookCategories.FURNACE_BLOCKS;
            }
            return RecipeBookCategories.FURNACE_MISC;
        }
        ItemStack itemStack = iRecipe.func_77571_b();
        ItemGroup \u26032 = itemStack.func_77973_b().func_77640_w();
        if (\u26032 == ItemGroup.field_78030_b) {
            return RecipeBookCategories.BUILDING_BLOCKS;
        }
        if (\u26032 == ItemGroup.field_78040_i || \u26032 == ItemGroup.field_78037_j) {
            return RecipeBookCategories.EQUIPMENT;
        }
        if (\u26032 == ItemGroup.field_78028_d) {
            return RecipeBookCategories.REDSTONE;
        }
        return RecipeBookCategories.MISC;
    }

    public static List<RecipeBookCategories> func_202888_a(Container container) {
        if (container instanceof ContainerWorkbench || container instanceof ContainerPlayer) {
            return Lists.newArrayList((Object[])new RecipeBookCategories[]{RecipeBookCategories.SEARCH, RecipeBookCategories.EQUIPMENT, RecipeBookCategories.BUILDING_BLOCKS, RecipeBookCategories.MISC, RecipeBookCategories.REDSTONE});
        }
        if (container instanceof ContainerFurnace) {
            return Lists.newArrayList((Object[])new RecipeBookCategories[]{RecipeBookCategories.FURNACE_SEARCH, RecipeBookCategories.FURNACE_FOOD, RecipeBookCategories.FURNACE_BLOCKS, RecipeBookCategories.FURNACE_MISC});
        }
        return Lists.newArrayList();
    }

    public List<RecipeList> func_199642_d() {
        return this.field_197932_f;
    }

    public List<RecipeList> func_202891_a(RecipeBookCategories recipeBookCategories) {
        return this.field_197931_e.getOrDefault((Object)recipeBookCategories, Collections.emptyList());
    }
}

