/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.arguments;

import com.google.common.primitives.Doubles;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import javax.annotation.Nullable;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.MinMaxBoundsWrapped;
import net.minecraft.command.arguments.EntityOptions;
import net.minecraft.command.arguments.EntitySelector;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextComponentTranslation;

public class EntitySelectorParser {
    public static final SimpleCommandExceptionType field_197408_a = new SimpleCommandExceptionType((Message)new TextComponentTranslation("argument.entity.invalid", new Object[0]));
    public static final DynamicCommandExceptionType field_197409_b = new DynamicCommandExceptionType(object -> new TextComponentTranslation("argument.entity.selector.unknown", object));
    public static final SimpleCommandExceptionType field_210328_c = new SimpleCommandExceptionType((Message)new TextComponentTranslation("argument.entity.selector.not_allowed", new Object[0]));
    public static final SimpleCommandExceptionType field_197410_c = new SimpleCommandExceptionType((Message)new TextComponentTranslation("argument.entity.selector.missing", new Object[0]));
    public static final SimpleCommandExceptionType field_197411_d = new SimpleCommandExceptionType((Message)new TextComponentTranslation("argument.entity.options.unterminated", new Object[0]));
    public static final DynamicCommandExceptionType field_197412_e = new DynamicCommandExceptionType(object -> new TextComponentTranslation("argument.entity.options.valueless", object));
    public static final BiConsumer<Vec3d, List<? extends Entity>> field_197413_f = (vec3d, list) -> {};
    public static final BiConsumer<Vec3d, List<? extends Entity>> field_197414_g = (vec3d, list) -> list.sort((entity, entity2) -> Doubles.compare((double)entity.func_195048_a((Vec3d)vec3d), (double)entity2.func_195048_a((Vec3d)vec3d)));
    public static final BiConsumer<Vec3d, List<? extends Entity>> field_197415_h = (vec3d, list) -> list.sort((entity, entity2) -> Doubles.compare((double)entity2.func_195048_a((Vec3d)vec3d), (double)entity.func_195048_a((Vec3d)vec3d)));
    public static final BiConsumer<Vec3d, List<? extends Entity>> field_197416_i = (vec3d, list) -> Collections.shuffle(list);
    public static final BiFunction<SuggestionsBuilder, Consumer<SuggestionsBuilder>, CompletableFuture<Suggestions>> field_201355_j = (suggestionsBuilder, consumer) -> suggestionsBuilder.buildFuture();
    private final StringReader field_197417_j;
    private final boolean field_210329_m;
    private int field_197418_k;
    private boolean field_197419_l;
    private boolean field_197420_m;
    private MinMaxBounds.FloatBound field_197421_n = MinMaxBounds.FloatBound.field_211359_e;
    private MinMaxBounds.IntBound field_197422_o = MinMaxBounds.IntBound.field_211347_e;
    @Nullable
    private Double field_197423_p;
    @Nullable
    private Double field_197424_q;
    @Nullable
    private Double field_197425_r;
    @Nullable
    private Double field_197426_s;
    @Nullable
    private Double field_197427_t;
    @Nullable
    private Double field_197428_u;
    private MinMaxBoundsWrapped field_197429_v = MinMaxBoundsWrapped.field_207926_a;
    private MinMaxBoundsWrapped field_197430_w = MinMaxBoundsWrapped.field_207926_a;
    private Predicate<Entity> field_197431_x = entity -> true;
    private BiConsumer<Vec3d, List<? extends Entity>> field_197432_y = field_197413_f;
    private boolean field_197433_z;
    @Nullable
    private String field_197406_A;
    private int field_201999_C;
    @Nullable
    private UUID field_197407_B;
    private BiFunction<SuggestionsBuilder, Consumer<SuggestionsBuilder>, CompletableFuture<Suggestions>> field_201354_D = field_201355_j;
    private boolean field_202000_F;
    private boolean field_202001_G;
    private boolean field_202002_H;
    private boolean field_202003_I;
    private boolean field_202004_J;
    private boolean field_202005_K;
    private boolean field_202006_L;
    private boolean field_202007_M;
    private Class<? extends Entity> field_202008_N;
    private boolean field_202009_O;
    private boolean field_202010_P;
    private boolean field_202011_Q;
    private boolean field_210327_T;

    public EntitySelectorParser(StringReader stringReader) {
        this(stringReader, true);
    }

    public EntitySelectorParser(StringReader stringReader, boolean bl) {
        this.field_197417_j = stringReader;
        this.field_210329_m = bl;
    }

    public EntitySelector func_197400_a() {
        AxisAlignedBB \u26032;
        if (this.field_197426_s != null || this.field_197427_t != null || this.field_197428_u != null) {
            \u26032 = this.func_197390_a(this.field_197426_s == null ? 0.0 : this.field_197426_s, this.field_197427_t == null ? 0.0 : this.field_197427_t, this.field_197428_u == null ? 0.0 : this.field_197428_u);
        } else if (this.field_197421_n.func_196977_b() != null) {
            float f = ((Float)this.field_197421_n.func_196977_b()).floatValue();
            \u26032 = new AxisAlignedBB(-f, -f, -f, f + 1.0f, f + 1.0f, f + 1.0f);
        } else {
            \u26032 = null;
        }
        Function<Vec3d, Vec3d> function = this.field_197423_p == null && this.field_197424_q == null && this.field_197425_r == null ? vec3d -> vec3d : vec3d -> new Vec3d(this.field_197423_p == null ? vec3d.field_72450_a : this.field_197423_p, this.field_197424_q == null ? vec3d.field_72448_b : this.field_197424_q, this.field_197425_r == null ? vec3d.field_72449_c : this.field_197425_r);
        return new EntitySelector(this.field_197418_k, this.field_197419_l, this.field_197420_m, this.field_197431_x, this.field_197421_n, function, \u26032, this.field_197432_y, this.field_197433_z, this.field_197406_A, this.field_197407_B, this.field_202008_N == null ? Entity.class : this.field_202008_N, this.field_210327_T);
    }

    private AxisAlignedBB func_197390_a(double d, double d2, double d3) {
        boolean bl = d < 0.0;
        \u2603 = d2 < 0.0;
        \u2603 = d3 < 0.0;
        double \u26032 = bl ? d : 0.0;
        double \u26033 = \u2603 ? d2 : 0.0;
        double \u26034 = \u2603 ? d3 : 0.0;
        double \u26035 = (bl ? 0.0 : d) + 1.0;
        double \u26036 = (\u2603 ? 0.0 : d2) + 1.0;
        double \u26037 = (\u2603 ? 0.0 : d3) + 1.0;
        return new AxisAlignedBB(\u26032, \u26033, \u26034, \u26035, \u26036, \u26037);
    }

    private void func_197396_n() {
        if (this.field_197429_v != MinMaxBoundsWrapped.field_207926_a) {
            this.field_197431_x = this.field_197431_x.and(this.func_197366_a(this.field_197429_v, entity -> entity.field_70125_A));
        }
        if (this.field_197430_w != MinMaxBoundsWrapped.field_207926_a) {
            this.field_197431_x = this.field_197431_x.and(this.func_197366_a(this.field_197430_w, entity -> entity.field_70177_z));
        }
        if (!this.field_197422_o.func_211335_c()) {
            this.field_197431_x = this.field_197431_x.and(entity -> {
                if (!(entity instanceof EntityPlayerMP)) {
                    return false;
                }
                return this.field_197422_o.func_211339_d(((EntityPlayerMP)entity).field_71068_ca);
            });
        }
    }

    private Predicate<Entity> func_197366_a(MinMaxBoundsWrapped minMaxBoundsWrapped, ToDoubleFunction<Entity> toDoubleFunction) {
        double d = MathHelper.func_76142_g(minMaxBoundsWrapped.func_207923_a() == null ? 0.0f : minMaxBoundsWrapped.func_207923_a().floatValue());
        \u2603 = MathHelper.func_76142_g(minMaxBoundsWrapped.func_207925_b() == null ? 359.0f : minMaxBoundsWrapped.func_207925_b().floatValue());
        return entity -> {
            double d3 = MathHelper.func_76138_g(toDoubleFunction.applyAsDouble((Entity)entity));
            if (d > \u2603) {
                return d3 >= d || d3 <= \u2603;
            }
            return d3 >= d && d3 <= \u2603;
        };
    }

    protected void func_197403_b() throws CommandSyntaxException {
        this.field_210327_T = true;
        this.field_201354_D = this::func_201959_d;
        if (!this.field_197417_j.canRead()) {
            throw field_197410_c.createWithContext((ImmutableStringReader)this.field_197417_j);
        }
        int n = this.field_197417_j.getCursor();
        char \u26032 = this.field_197417_j.read();
        if (\u26032 == 'p') {
            this.field_197418_k = 1;
            this.field_197419_l = false;
            this.field_197432_y = field_197414_g;
            this.func_201964_a(EntityPlayerMP.class);
        } else if (\u26032 == 'a') {
            this.field_197418_k = Integer.MAX_VALUE;
            this.field_197419_l = false;
            this.field_197432_y = field_197413_f;
            this.func_201964_a(EntityPlayerMP.class);
        } else if (\u26032 == 'r') {
            this.field_197418_k = 1;
            this.field_197419_l = false;
            this.field_197432_y = field_197416_i;
            this.func_201964_a(EntityPlayerMP.class);
        } else if (\u26032 == 's') {
            this.field_197418_k = 1;
            this.field_197419_l = true;
            this.field_197433_z = true;
        } else if (\u26032 == 'e') {
            this.field_197418_k = Integer.MAX_VALUE;
            this.field_197419_l = true;
            this.field_197432_y = field_197413_f;
            this.field_197431_x = Entity::func_70089_S;
        } else {
            this.field_197417_j.setCursor(n);
            throw field_197409_b.createWithContext((ImmutableStringReader)this.field_197417_j, (Object)('@' + String.valueOf(\u26032)));
        }
        this.field_201354_D = this::func_201989_e;
        if (this.field_197417_j.canRead() && this.field_197417_j.peek() == '[') {
            this.field_197417_j.skip();
            this.field_201354_D = this::func_201996_f;
            this.func_197404_d();
        }
    }

    protected void func_197382_c() throws CommandSyntaxException {
        if (this.field_197417_j.canRead()) {
            this.field_201354_D = this::func_201974_c;
        }
        int n = this.field_197417_j.getCursor();
        String \u26032 = this.field_197417_j.readString();
        try {
            this.field_197407_B = UUID.fromString(\u26032);
            this.field_197419_l = true;
        }
        catch (IllegalArgumentException \u26033) {
            if (\u26032.isEmpty() || \u26032.length() > 16) {
                this.field_197417_j.setCursor(n);
                throw field_197408_a.createWithContext((ImmutableStringReader)this.field_197417_j);
            }
            this.field_197419_l = false;
            this.field_197406_A = \u26032;
        }
        this.field_197418_k = 1;
    }

    protected void func_197404_d() throws CommandSyntaxException {
        this.field_201354_D = this::func_201994_g;
        this.field_197417_j.skipWhitespace();
        while (this.field_197417_j.canRead() && this.field_197417_j.peek() != ']') {
            this.field_197417_j.skipWhitespace();
            int n = this.field_197417_j.getCursor();
            String \u26032 = this.field_197417_j.readString();
            EntityOptions.Filter \u26033 = EntityOptions.func_202017_a(this, \u26032, n);
            this.field_197417_j.skipWhitespace();
            if (!this.field_197417_j.canRead() || this.field_197417_j.peek() != '=') {
                this.field_197417_j.setCursor(n);
                throw field_197412_e.createWithContext((ImmutableStringReader)this.field_197417_j, (Object)\u26032);
            }
            this.field_197417_j.skip();
            this.field_197417_j.skipWhitespace();
            this.field_201354_D = field_201355_j;
            \u26033.handle(this);
            this.field_197417_j.skipWhitespace();
            this.field_201354_D = this::func_201969_h;
            if (!this.field_197417_j.canRead()) continue;
            if (this.field_197417_j.peek() == ',') {
                this.field_197417_j.skip();
                this.field_201354_D = this::func_201994_g;
                continue;
            }
            if (this.field_197417_j.peek() == ']') break;
            throw field_197411_d.createWithContext((ImmutableStringReader)this.field_197417_j);
        }
        if (!this.field_197417_j.canRead()) {
            throw field_197411_d.createWithContext((ImmutableStringReader)this.field_197417_j);
        }
        this.field_197417_j.skip();
        this.field_201354_D = field_201355_j;
    }

    public boolean func_197378_e() {
        this.field_197417_j.skipWhitespace();
        if (this.field_197417_j.canRead() && this.field_197417_j.peek() == '!') {
            this.field_197417_j.skip();
            this.field_197417_j.skipWhitespace();
            return true;
        }
        return false;
    }

    public StringReader func_197398_f() {
        return this.field_197417_j;
    }

    public void func_197401_a(Predicate<Entity> predicate) {
        this.field_197431_x = this.field_197431_x.and(predicate);
    }

    public void func_197365_g() {
        this.field_197420_m = true;
    }

    public MinMaxBounds.FloatBound func_197370_h() {
        return this.field_197421_n;
    }

    public void func_197397_a(MinMaxBounds.FloatBound floatBound) {
        this.field_197421_n = floatBound;
    }

    public MinMaxBounds.IntBound func_197394_i() {
        return this.field_197422_o;
    }

    public void func_197399_b(MinMaxBounds.IntBound intBound) {
        this.field_197422_o = intBound;
    }

    public MinMaxBoundsWrapped func_201968_j() {
        return this.field_197429_v;
    }

    public void func_197389_c(MinMaxBoundsWrapped minMaxBoundsWrapped) {
        this.field_197429_v = minMaxBoundsWrapped;
    }

    public MinMaxBoundsWrapped func_201980_k() {
        return this.field_197430_w;
    }

    public void func_197387_d(MinMaxBoundsWrapped minMaxBoundsWrapped) {
        this.field_197430_w = minMaxBoundsWrapped;
    }

    @Nullable
    public Double func_201965_l() {
        return this.field_197423_p;
    }

    @Nullable
    public Double func_201991_m() {
        return this.field_197424_q;
    }

    @Nullable
    public Double func_201983_n() {
        return this.field_197425_r;
    }

    public void func_197384_a(double d) {
        this.field_197423_p = d;
    }

    public void func_197395_b(double d) {
        this.field_197424_q = d;
    }

    public void func_197372_c(double d) {
        this.field_197425_r = d;
    }

    public void func_197377_d(double d) {
        this.field_197426_s = d;
    }

    public void func_197391_e(double d) {
        this.field_197427_t = d;
    }

    public void func_197405_f(double d) {
        this.field_197428_u = d;
    }

    @Nullable
    public Double func_201977_o() {
        return this.field_197426_s;
    }

    @Nullable
    public Double func_201971_p() {
        return this.field_197427_t;
    }

    @Nullable
    public Double func_201962_q() {
        return this.field_197428_u;
    }

    public void func_197388_a(int n) {
        this.field_197418_k = n;
    }

    public void func_197373_a(boolean bl) {
        this.field_197419_l = bl;
    }

    public void func_197376_a(BiConsumer<Vec3d, List<? extends Entity>> biConsumer) {
        this.field_197432_y = biConsumer;
    }

    public EntitySelector func_201345_m() throws CommandSyntaxException {
        this.field_201999_C = this.field_197417_j.getCursor();
        this.field_201354_D = this::func_201981_b;
        if (this.field_197417_j.canRead() && this.field_197417_j.peek() == '@') {
            if (!this.field_210329_m) {
                throw field_210328_c.createWithContext((ImmutableStringReader)this.field_197417_j);
            }
            this.field_197417_j.skip();
            this.func_197403_b();
        } else {
            this.func_197382_c();
        }
        this.func_197396_n();
        return this.func_197400_a();
    }

    private static void func_210326_a(SuggestionsBuilder suggestionsBuilder) {
        suggestionsBuilder.suggest("@p", (Message)new TextComponentTranslation("argument.entity.selector.nearestPlayer", new Object[0]));
        suggestionsBuilder.suggest("@a", (Message)new TextComponentTranslation("argument.entity.selector.allPlayers", new Object[0]));
        suggestionsBuilder.suggest("@r", (Message)new TextComponentTranslation("argument.entity.selector.randomPlayer", new Object[0]));
        suggestionsBuilder.suggest("@s", (Message)new TextComponentTranslation("argument.entity.selector.self", new Object[0]));
        suggestionsBuilder.suggest("@e", (Message)new TextComponentTranslation("argument.entity.selector.allEntities", new Object[0]));
    }

    private CompletableFuture<Suggestions> func_201981_b(SuggestionsBuilder suggestionsBuilder, Consumer<SuggestionsBuilder> consumer) {
        consumer.accept(suggestionsBuilder);
        if (this.field_210329_m) {
            EntitySelectorParser.func_210326_a(suggestionsBuilder);
        }
        return suggestionsBuilder.buildFuture();
    }

    private CompletableFuture<Suggestions> func_201974_c(SuggestionsBuilder suggestionsBuilder, Consumer<SuggestionsBuilder> consumer) {
        SuggestionsBuilder suggestionsBuilder2 = suggestionsBuilder.createOffset(this.field_201999_C);
        consumer.accept(suggestionsBuilder2);
        return suggestionsBuilder.add(suggestionsBuilder2).buildFuture();
    }

    private CompletableFuture<Suggestions> func_201959_d(SuggestionsBuilder suggestionsBuilder, Consumer<SuggestionsBuilder> consumer) {
        SuggestionsBuilder suggestionsBuilder2 = suggestionsBuilder.createOffset(suggestionsBuilder.getStart() - 1);
        EntitySelectorParser.func_210326_a(suggestionsBuilder2);
        suggestionsBuilder.add(suggestionsBuilder2);
        return suggestionsBuilder.buildFuture();
    }

    private CompletableFuture<Suggestions> func_201989_e(SuggestionsBuilder suggestionsBuilder, Consumer<SuggestionsBuilder> consumer) {
        suggestionsBuilder.suggest(String.valueOf('['));
        return suggestionsBuilder.buildFuture();
    }

    private CompletableFuture<Suggestions> func_201996_f(SuggestionsBuilder suggestionsBuilder, Consumer<SuggestionsBuilder> consumer) {
        suggestionsBuilder.suggest(String.valueOf(']'));
        EntityOptions.func_202049_a(this, suggestionsBuilder);
        return suggestionsBuilder.buildFuture();
    }

    private CompletableFuture<Suggestions> func_201994_g(SuggestionsBuilder suggestionsBuilder, Consumer<SuggestionsBuilder> consumer) {
        EntityOptions.func_202049_a(this, suggestionsBuilder);
        return suggestionsBuilder.buildFuture();
    }

    private CompletableFuture<Suggestions> func_201969_h(SuggestionsBuilder suggestionsBuilder, Consumer<SuggestionsBuilder> consumer) {
        suggestionsBuilder.suggest(String.valueOf(','));
        suggestionsBuilder.suggest(String.valueOf(']'));
        return suggestionsBuilder.buildFuture();
    }

    public boolean func_197381_m() {
        return this.field_197433_z;
    }

    public void func_201978_a(BiFunction<SuggestionsBuilder, Consumer<SuggestionsBuilder>, CompletableFuture<Suggestions>> biFunction) {
        this.field_201354_D = biFunction;
    }

    public CompletableFuture<Suggestions> func_201993_a(SuggestionsBuilder suggestionsBuilder, Consumer<SuggestionsBuilder> consumer) {
        return this.field_201354_D.apply(suggestionsBuilder.createOffset(this.field_197417_j.getCursor()), consumer);
    }

    public boolean func_201984_u() {
        return this.field_202000_F;
    }

    public void func_201990_c(boolean bl) {
        this.field_202000_F = bl;
    }

    public boolean func_201997_v() {
        return this.field_202001_G;
    }

    public void func_201998_d(boolean bl) {
        this.field_202001_G = bl;
    }

    public boolean func_201967_w() {
        return this.field_202002_H;
    }

    public void func_201979_e(boolean bl) {
        this.field_202002_H = bl;
    }

    public boolean func_201976_x() {
        return this.field_202003_I;
    }

    public void func_201986_f(boolean bl) {
        this.field_202003_I = bl;
    }

    public boolean func_201987_y() {
        return this.field_202004_J;
    }

    public void func_201988_g(boolean bl) {
        this.field_202004_J = bl;
    }

    public boolean func_201961_z() {
        return this.field_202005_K;
    }

    public void func_201973_h(boolean bl) {
        this.field_202005_K = bl;
    }

    public boolean func_201960_A() {
        return this.field_202006_L;
    }

    public void func_201975_i(boolean bl) {
        this.field_202006_L = bl;
    }

    public void func_201958_j(boolean bl) {
        this.field_202007_M = bl;
    }

    public void func_201964_a(Class<? extends Entity> clazz) {
        this.field_202008_N = clazz;
    }

    public void func_201982_C() {
        this.field_202009_O = true;
    }

    public boolean func_201963_E() {
        return this.field_202008_N != null;
    }

    public boolean func_201985_F() {
        return this.field_202009_O;
    }

    public boolean func_201995_G() {
        return this.field_202010_P;
    }

    public void func_201970_k(boolean bl) {
        this.field_202010_P = bl;
    }

    public boolean func_201966_H() {
        return this.field_202011_Q;
    }

    public void func_201992_l(boolean bl) {
        this.field_202011_Q = bl;
    }
}

