/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.arguments.ItemParser;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tags.Tag;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;

public class ItemPredicateArgument
implements ArgumentType<IResult> {
    private static final Collection<String> field_201340_a = Arrays.asList("stick", "minecraft:stick", "#stick", "#stick{foo=bar}");
    private static final DynamicCommandExceptionType field_199849_a = new DynamicCommandExceptionType(object -> new TextComponentTranslation("arguments.item.tag.unknown", object));

    public static ItemPredicateArgument func_199846_a() {
        return new ItemPredicateArgument();
    }

    public IResult parse(StringReader stringReader) throws CommandSyntaxException {
        ItemParser itemParser = new ItemParser(stringReader, true).func_197327_f();
        if (itemParser.func_197326_b() != null) {
            ItemPredicate itemPredicate = new ItemPredicate(itemParser.func_197326_b(), itemParser.func_197325_c());
            return commandContext -> itemPredicate;
        }
        ResourceLocation \u26032 = itemParser.func_199835_d();
        return commandContext -> {
            Tag<Item> tag = ((CommandSource)commandContext.getSource()).func_197028_i().func_199731_aO().func_199715_b().func_199910_a(\u26032);
            if (tag == null) {
                throw field_199849_a.create((Object)\u26032.toString());
            }
            return new TagPredicate(tag, itemParser.func_197325_c());
        };
    }

    public static Predicate<ItemStack> func_199847_a(CommandContext<CommandSource> commandContext, String string) throws CommandSyntaxException {
        return ((IResult)commandContext.getArgument(string, IResult.class)).create(commandContext);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> commandContext, SuggestionsBuilder suggestionsBuilder) {
        StringReader stringReader = new StringReader(suggestionsBuilder.getInput());
        stringReader.setCursor(suggestionsBuilder.getStart());
        ItemParser \u26032 = new ItemParser(stringReader, true);
        try {
            \u26032.func_197327_f();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return \u26032.func_197329_a(suggestionsBuilder);
    }

    public Collection<String> getExamples() {
        return field_201340_a;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    static class TagPredicate
    implements Predicate<ItemStack> {
        private final Tag<Item> field_199843_a;
        @Nullable
        private final NBTTagCompound field_199844_b;

        public TagPredicate(Tag<Item> tag, @Nullable NBTTagCompound nBTTagCompound) {
            this.field_199843_a = tag;
            this.field_199844_b = nBTTagCompound;
        }

        @Override
        public boolean test(ItemStack itemStack) {
            return this.field_199843_a.func_199685_a_(itemStack.func_77973_b()) && NBTUtil.func_181123_a(this.field_199844_b, itemStack.func_77978_p(), true);
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((ItemStack)object);
        }
    }

    static class ItemPredicate
    implements Predicate<ItemStack> {
        private final Item field_199841_a;
        @Nullable
        private final NBTTagCompound field_199842_b;

        public ItemPredicate(Item item, @Nullable NBTTagCompound nBTTagCompound) {
            this.field_199841_a = item;
            this.field_199842_b = nBTTagCompound;
        }

        @Override
        public boolean test(ItemStack itemStack) {
            return itemStack.func_77973_b() == this.field_199841_a && NBTUtil.func_181123_a(this.field_199842_b, itemStack.func_77978_p(), true);
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((ItemStack)object);
        }
    }

    public static interface IResult {
        public Predicate<ItemStack> create(CommandContext<CommandSource> var1) throws CommandSyntaxException;
    }
}

