/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.impl;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.command.CommandException;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.TextComponentTranslation;

public class AdvancementCommand {
    private static final SuggestionProvider<CommandSource> field_198218_a = (commandContext, suggestionsBuilder) -> {
        Collection<Advancement> collection = ((CommandSource)commandContext.getSource()).func_197028_i().func_191949_aK().func_195438_b();
        return ISuggestionProvider.func_212476_a(collection.stream().map(Advancement::func_192067_g), suggestionsBuilder);
    };

    public static void func_198199_a(CommandDispatcher<CommandSource> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a("advancement").requires(commandSource -> commandSource.func_197034_c(2))).then(Commands.func_197057_a("grant").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a("targets", EntityArgument.func_197094_d()).then(Commands.func_197057_a("only").then(((RequiredArgumentBuilder)Commands.func_197056_a("advancement", ResourceLocationArgument.func_197197_a()).suggests(field_198218_a).executes(commandContext -> AdvancementCommand.func_198214_a((CommandSource)commandContext.getSource(), EntityArgument.func_197090_e((CommandContext<CommandSource>)commandContext, "targets"), Action.GRANT, AdvancementCommand.func_198216_a(ResourceLocationArgument.func_197198_a((CommandContext<CommandSource>)commandContext, "advancement"), Mode.ONLY)))).then(Commands.func_197056_a("criterion", StringArgumentType.greedyString()).suggests((commandContext, suggestionsBuilder) -> ISuggestionProvider.func_197005_b(ResourceLocationArgument.func_197198_a((CommandContext<CommandSource>)commandContext, "advancement").func_192073_f().keySet(), suggestionsBuilder)).executes(commandContext -> AdvancementCommand.func_198203_a((CommandSource)commandContext.getSource(), EntityArgument.func_197090_e((CommandContext<CommandSource>)commandContext, "targets"), Action.GRANT, ResourceLocationArgument.func_197198_a((CommandContext<CommandSource>)commandContext, "advancement"), StringArgumentType.getString((CommandContext)commandContext, (String)"criterion"))))))).then(Commands.func_197057_a("from").then(Commands.func_197056_a("advancement", ResourceLocationArgument.func_197197_a()).suggests(field_198218_a).executes(commandContext -> AdvancementCommand.func_198214_a((CommandSource)commandContext.getSource(), EntityArgument.func_197090_e((CommandContext<CommandSource>)commandContext, "targets"), Action.GRANT, AdvancementCommand.func_198216_a(ResourceLocationArgument.func_197198_a((CommandContext<CommandSource>)commandContext, "advancement"), Mode.FROM)))))).then(Commands.func_197057_a("until").then(Commands.func_197056_a("advancement", ResourceLocationArgument.func_197197_a()).suggests(field_198218_a).executes(commandContext -> AdvancementCommand.func_198214_a((CommandSource)commandContext.getSource(), EntityArgument.func_197090_e((CommandContext<CommandSource>)commandContext, "targets"), Action.GRANT, AdvancementCommand.func_198216_a(ResourceLocationArgument.func_197198_a((CommandContext<CommandSource>)commandContext, "advancement"), Mode.UNTIL)))))).then(Commands.func_197057_a("through").then(Commands.func_197056_a("advancement", ResourceLocationArgument.func_197197_a()).suggests(field_198218_a).executes(commandContext -> AdvancementCommand.func_198214_a((CommandSource)commandContext.getSource(), EntityArgument.func_197090_e((CommandContext<CommandSource>)commandContext, "targets"), Action.GRANT, AdvancementCommand.func_198216_a(ResourceLocationArgument.func_197198_a((CommandContext<CommandSource>)commandContext, "advancement"), Mode.THROUGH)))))).then(Commands.func_197057_a("everything").executes(commandContext -> AdvancementCommand.func_198214_a((CommandSource)commandContext.getSource(), EntityArgument.func_197090_e((CommandContext<CommandSource>)commandContext, "targets"), Action.GRANT, ((CommandSource)commandContext.getSource()).func_197028_i().func_191949_aK().func_195438_b())))))).then(Commands.func_197057_a("revoke").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a("targets", EntityArgument.func_197094_d()).then(Commands.func_197057_a("only").then(((RequiredArgumentBuilder)Commands.func_197056_a("advancement", ResourceLocationArgument.func_197197_a()).suggests(field_198218_a).executes(commandContext -> AdvancementCommand.func_198214_a((CommandSource)commandContext.getSource(), EntityArgument.func_197090_e((CommandContext<CommandSource>)commandContext, "targets"), Action.REVOKE, AdvancementCommand.func_198216_a(ResourceLocationArgument.func_197198_a((CommandContext<CommandSource>)commandContext, "advancement"), Mode.ONLY)))).then(Commands.func_197056_a("criterion", StringArgumentType.greedyString()).suggests((commandContext, suggestionsBuilder) -> ISuggestionProvider.func_197005_b(ResourceLocationArgument.func_197198_a((CommandContext<CommandSource>)commandContext, "advancement").func_192073_f().keySet(), suggestionsBuilder)).executes(commandContext -> AdvancementCommand.func_198203_a((CommandSource)commandContext.getSource(), EntityArgument.func_197090_e((CommandContext<CommandSource>)commandContext, "targets"), Action.REVOKE, ResourceLocationArgument.func_197198_a((CommandContext<CommandSource>)commandContext, "advancement"), StringArgumentType.getString((CommandContext)commandContext, (String)"criterion"))))))).then(Commands.func_197057_a("from").then(Commands.func_197056_a("advancement", ResourceLocationArgument.func_197197_a()).suggests(field_198218_a).executes(commandContext -> AdvancementCommand.func_198214_a((CommandSource)commandContext.getSource(), EntityArgument.func_197090_e((CommandContext<CommandSource>)commandContext, "targets"), Action.REVOKE, AdvancementCommand.func_198216_a(ResourceLocationArgument.func_197198_a((CommandContext<CommandSource>)commandContext, "advancement"), Mode.FROM)))))).then(Commands.func_197057_a("until").then(Commands.func_197056_a("advancement", ResourceLocationArgument.func_197197_a()).suggests(field_198218_a).executes(commandContext -> AdvancementCommand.func_198214_a((CommandSource)commandContext.getSource(), EntityArgument.func_197090_e((CommandContext<CommandSource>)commandContext, "targets"), Action.REVOKE, AdvancementCommand.func_198216_a(ResourceLocationArgument.func_197198_a((CommandContext<CommandSource>)commandContext, "advancement"), Mode.UNTIL)))))).then(Commands.func_197057_a("through").then(Commands.func_197056_a("advancement", ResourceLocationArgument.func_197197_a()).suggests(field_198218_a).executes(commandContext -> AdvancementCommand.func_198214_a((CommandSource)commandContext.getSource(), EntityArgument.func_197090_e((CommandContext<CommandSource>)commandContext, "targets"), Action.REVOKE, AdvancementCommand.func_198216_a(ResourceLocationArgument.func_197198_a((CommandContext<CommandSource>)commandContext, "advancement"), Mode.THROUGH)))))).then(Commands.func_197057_a("everything").executes(commandContext -> AdvancementCommand.func_198214_a((CommandSource)commandContext.getSource(), EntityArgument.func_197090_e((CommandContext<CommandSource>)commandContext, "targets"), Action.REVOKE, ((CommandSource)commandContext.getSource()).func_197028_i().func_191949_aK().func_195438_b()))))));
    }

    private static int func_198214_a(CommandSource commandSource, Collection<EntityPlayerMP> collection, Action action, Collection<Advancement> collection2) {
        int n = 0;
        for (EntityPlayerMP entityPlayerMP : collection) {
            n += action.func_198180_a(entityPlayerMP, collection2);
        }
        if (n == 0) {
            if (collection2.size() == 1) {
                if (collection.size() == 1) {
                    throw new CommandException(new TextComponentTranslation(action.func_198181_a() + ".one.to.one.failure", collection2.iterator().next().func_193123_j(), collection.iterator().next().func_145748_c_()));
                }
                throw new CommandException(new TextComponentTranslation(action.func_198181_a() + ".one.to.many.failure", collection2.iterator().next().func_193123_j(), collection.size()));
            }
            if (collection.size() == 1) {
                throw new CommandException(new TextComponentTranslation(action.func_198181_a() + ".many.to.one.failure", collection2.size(), collection.iterator().next().func_145748_c_()));
            }
            throw new CommandException(new TextComponentTranslation(action.func_198181_a() + ".many.to.many.failure", collection2.size(), collection.size()));
        }
        if (collection2.size() == 1) {
            if (collection.size() == 1) {
                commandSource.func_197030_a(new TextComponentTranslation(action.func_198181_a() + ".one.to.one.success", collection2.iterator().next().func_193123_j(), collection.iterator().next().func_145748_c_()), true);
            } else {
                commandSource.func_197030_a(new TextComponentTranslation(action.func_198181_a() + ".one.to.many.success", collection2.iterator().next().func_193123_j(), collection.size()), true);
            }
        } else if (collection.size() == 1) {
            commandSource.func_197030_a(new TextComponentTranslation(action.func_198181_a() + ".many.to.one.success", collection2.size(), collection.iterator().next().func_145748_c_()), true);
        } else {
            commandSource.func_197030_a(new TextComponentTranslation(action.func_198181_a() + ".many.to.many.success", collection2.size(), collection.size()), true);
        }
        return n;
    }

    private static int func_198203_a(CommandSource commandSource, Collection<EntityPlayerMP> collection, Action action, Advancement advancement, String string) {
        int n = 0;
        if (!advancement.func_192073_f().containsKey(string)) {
            throw new CommandException(new TextComponentTranslation("commands.advancement.criterionNotFound", advancement.func_193123_j(), string));
        }
        for (EntityPlayerMP entityPlayerMP : collection) {
            if (!action.func_198182_a(entityPlayerMP, advancement, string)) continue;
            ++n;
        }
        if (n == 0) {
            if (collection.size() == 1) {
                throw new CommandException(new TextComponentTranslation(action.func_198181_a() + ".criterion.to.one.failure", string, advancement.func_193123_j(), collection.iterator().next().func_145748_c_()));
            }
            throw new CommandException(new TextComponentTranslation(action.func_198181_a() + ".criterion.to.many.failure", string, advancement.func_193123_j(), collection.size()));
        }
        if (collection.size() == 1) {
            commandSource.func_197030_a(new TextComponentTranslation(action.func_198181_a() + ".criterion.to.one.success", string, advancement.func_193123_j(), collection.iterator().next().func_145748_c_()), true);
        } else {
            commandSource.func_197030_a(new TextComponentTranslation(action.func_198181_a() + ".criterion.to.many.success", string, advancement.func_193123_j(), collection.size()), true);
        }
        return n;
    }

    private static List<Advancement> func_198216_a(Advancement advancement, Mode mode) {
        ArrayList arrayList = Lists.newArrayList();
        if (mode.field_198194_f) {
            for (Advancement advancement2 = advancement.func_192070_b(); advancement2 != null; advancement2 = advancement2.func_192070_b()) {
                arrayList.add(advancement2);
            }
        }
        arrayList.add(advancement);
        if (mode.field_198195_g) {
            AdvancementCommand.func_198207_a(advancement, arrayList);
        }
        return arrayList;
    }

    private static void func_198207_a(Advancement advancement, List<Advancement> list) {
        for (Advancement advancement2 : advancement.func_192069_e()) {
            list.add(advancement2);
            AdvancementCommand.func_198207_a(advancement2, list);
        }
    }

    static enum Mode {
        ONLY(false, false),
        THROUGH(true, true),
        FROM(false, true),
        UNTIL(true, false),
        EVERYTHING(true, true);

        private final boolean field_198194_f;
        private final boolean field_198195_g;

        private Mode(boolean bl, boolean bl2) {
            this.field_198194_f = bl;
            this.field_198195_g = bl2;
        }
    }

    static enum Action {
        GRANT("grant"){

            @Override
            protected boolean func_198179_a(EntityPlayerMP entityPlayerMP, Advancement advancement) {
                AdvancementProgress advancementProgress = entityPlayerMP.func_192039_O().func_192747_a(advancement);
                if (advancementProgress.func_192105_a()) {
                    return false;
                }
                for (String string : advancementProgress.func_192107_d()) {
                    entityPlayerMP.func_192039_O().func_192750_a(advancement, string);
                }
                return true;
            }

            @Override
            protected boolean func_198182_a(EntityPlayerMP entityPlayerMP, Advancement advancement, String string) {
                return entityPlayerMP.func_192039_O().func_192750_a(advancement, string);
            }
        }
        ,
        REVOKE("revoke"){

            @Override
            protected boolean func_198179_a(EntityPlayerMP entityPlayerMP, Advancement advancement) {
                AdvancementProgress advancementProgress = entityPlayerMP.func_192039_O().func_192747_a(advancement);
                if (!advancementProgress.func_192108_b()) {
                    return false;
                }
                for (String string : advancementProgress.func_192102_e()) {
                    entityPlayerMP.func_192039_O().func_192744_b(advancement, string);
                }
                return true;
            }

            @Override
            protected boolean func_198182_a(EntityPlayerMP entityPlayerMP, Advancement advancement, String string) {
                return entityPlayerMP.func_192039_O().func_192744_b(advancement, string);
            }
        };

        private final String field_198186_c;

        private Action(String string2) {
            this.field_198186_c = "commands.advancement." + string2;
        }

        public int func_198180_a(EntityPlayerMP entityPlayerMP, Iterable<Advancement> iterable) {
            int n = 0;
            for (Advancement advancement : iterable) {
                if (!this.func_198179_a(entityPlayerMP, advancement)) continue;
                ++n;
            }
            return n;
        }

        protected abstract boolean func_198179_a(EntityPlayerMP var1, Advancement var2);

        protected abstract boolean func_198182_a(EntityPlayerMP var1, Advancement var2, String var3);

        protected String func_198181_a() {
            return this.field_198186_c;
        }
    }
}

