/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.impl;

import com.google.common.base.Joiner;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import it.unimi.dsi.fastutil.longs.LongSet;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.command.arguments.ColumnPosArgument;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.WorldServer;
import net.minecraft.world.dimension.DimensionType;

public class ForceLoadCommand {
    private static final Dynamic2CommandExceptionType field_212726_a = new Dynamic2CommandExceptionType((object, object2) -> new TextComponentTranslation("commands.forceload.toobig", object, object2));
    private static final Dynamic2CommandExceptionType field_212727_b = new Dynamic2CommandExceptionType((object, object2) -> new TextComponentTranslation("commands.forceload.query.failure", object, object2));
    private static final SimpleCommandExceptionType field_212728_c = new SimpleCommandExceptionType((Message)new TextComponentTranslation("commands.forceload.added.failure", new Object[0]));
    private static final SimpleCommandExceptionType field_212729_d = new SimpleCommandExceptionType((Message)new TextComponentTranslation("commands.forceload.removed.failure", new Object[0]));

    public static void func_212712_a(CommandDispatcher<CommandSource> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a("forceload").requires(commandSource -> commandSource.func_197034_c(4))).then(Commands.func_197057_a("add").then(((RequiredArgumentBuilder)Commands.func_197056_a("from", ColumnPosArgument.func_212603_a()).executes(commandContext -> ForceLoadCommand.func_212719_a((CommandSource)commandContext.getSource(), ColumnPosArgument.func_212602_a((CommandContext<CommandSource>)commandContext, "from"), ColumnPosArgument.func_212602_a((CommandContext<CommandSource>)commandContext, "from"), true))).then(Commands.func_197056_a("to", ColumnPosArgument.func_212603_a()).executes(commandContext -> ForceLoadCommand.func_212719_a((CommandSource)commandContext.getSource(), ColumnPosArgument.func_212602_a((CommandContext<CommandSource>)commandContext, "from"), ColumnPosArgument.func_212602_a((CommandContext<CommandSource>)commandContext, "to"), true)))))).then(((LiteralArgumentBuilder)Commands.func_197057_a("remove").then(((RequiredArgumentBuilder)Commands.func_197056_a("from", ColumnPosArgument.func_212603_a()).executes(commandContext -> ForceLoadCommand.func_212719_a((CommandSource)commandContext.getSource(), ColumnPosArgument.func_212602_a((CommandContext<CommandSource>)commandContext, "from"), ColumnPosArgument.func_212602_a((CommandContext<CommandSource>)commandContext, "from"), false))).then(Commands.func_197056_a("to", ColumnPosArgument.func_212603_a()).executes(commandContext -> ForceLoadCommand.func_212719_a((CommandSource)commandContext.getSource(), ColumnPosArgument.func_212602_a((CommandContext<CommandSource>)commandContext, "from"), ColumnPosArgument.func_212602_a((CommandContext<CommandSource>)commandContext, "to"), false))))).then(Commands.func_197057_a("all").executes(commandContext -> ForceLoadCommand.func_212722_b((CommandSource)commandContext.getSource()))))).then(((LiteralArgumentBuilder)Commands.func_197057_a("query").executes(commandContext -> ForceLoadCommand.func_212721_a((CommandSource)commandContext.getSource()))).then(Commands.func_197056_a("pos", ColumnPosArgument.func_212603_a()).executes(commandContext -> ForceLoadCommand.func_212713_a((CommandSource)commandContext.getSource(), ColumnPosArgument.func_212602_a((CommandContext<CommandSource>)commandContext, "pos"))))));
    }

    private static int func_212713_a(CommandSource commandSource, ColumnPosArgument.ColumnPos columnPos) throws CommandSyntaxException {
        ChunkPos chunkPos = new ChunkPos(columnPos.field_212600_a >> 4, columnPos.field_212601_b >> 4);
        DimensionType \u26032 = commandSource.func_197023_e().func_201675_m().func_186058_p();
        boolean \u26033 = commandSource.func_197028_i().func_71218_a(\u26032).func_212416_f(chunkPos.field_77276_a, chunkPos.field_77275_b);
        if (\u26033) {
            commandSource.func_197030_a(new TextComponentTranslation("commands.forceload.query.success", chunkPos, \u26032), false);
            return 1;
        }
        throw field_212727_b.create((Object)chunkPos, (Object)\u26032);
    }

    private static int func_212721_a(CommandSource commandSource2) {
        DimensionType dimensionType = commandSource2.func_197023_e().func_201675_m().func_186058_p();
        LongSet \u26032 = commandSource2.func_197028_i().func_71218_a(dimensionType).func_212412_ag();
        int \u26033 = \u26032.size();
        if (\u26033 > 0) {
            String string = Joiner.on((String)", ").join(\u26032.stream().sorted().map(ChunkPos::new).map(ChunkPos::toString).iterator());
            if (\u26033 == 1) {
                commandSource2.func_197030_a(new TextComponentTranslation("commands.forceload.list.single", dimensionType, string), false);
            } else {
                commandSource2.func_197030_a(new TextComponentTranslation("commands.forceload.list.multiple", \u26033, dimensionType, string), false);
            }
        } else {
            CommandSource commandSource2;
            commandSource2.func_197021_a(new TextComponentTranslation("commands.forceload.added.none", dimensionType));
        }
        return \u26033;
    }

    private static int func_212722_b(CommandSource commandSource) {
        DimensionType dimensionType = commandSource.func_197023_e().func_201675_m().func_186058_p();
        WorldServer \u26032 = commandSource.func_197028_i().func_71218_a(dimensionType);
        LongSet \u26033 = \u26032.func_212412_ag();
        \u26033.forEach(l -> \u26032.func_212414_b(ChunkPos.func_212578_a(l), ChunkPos.func_212579_b(l), false));
        commandSource.func_197030_a(new TextComponentTranslation("commands.forceload.removed.all", dimensionType), true);
        return 0;
    }

    private static int func_212719_a(CommandSource commandSource, ColumnPosArgument.ColumnPos columnPos, ColumnPosArgument.ColumnPos columnPos2, boolean bl) throws CommandSyntaxException {
        int n;
        int n2 = Math.min(columnPos.field_212600_a, columnPos2.field_212600_a);
        \u2603 = Math.min(columnPos.field_212601_b, columnPos2.field_212601_b);
        \u2603 = Math.max(columnPos.field_212600_a, columnPos2.field_212600_a);
        \u2603 = Math.max(columnPos.field_212601_b, columnPos2.field_212601_b);
        if (n2 < -30000000 || \u2603 < -30000000 || \u2603 >= 30000000 || \u2603 >= 30000000) {
            throw BlockPosArgument.field_197279_c.create();
        }
        \u2603 = \u2603 >> 4;
        \u2603 = n2 >> 4;
        \u2603 = \u2603 >> 4;
        \u2603 = \u2603 >> 4;
        long \u26032 = ((long)(\u2603 - \u2603) + 1L) * ((long)(\u2603 - \u2603) + 1L);
        if (\u26032 > 256L) {
            throw field_212726_a.create((Object)256, (Object)\u26032);
        }
        DimensionType \u26033 = commandSource.func_197023_e().func_201675_m().func_186058_p();
        WorldServer \u26034 = commandSource.func_197028_i().func_71218_a(\u26033);
        ChunkPos \u26035 = null;
        n = 0;
        for (\u2603 = \u2603; \u2603 <= \u2603; ++\u2603) {
            for (\u2603 = \u2603; \u2603 <= \u2603; ++\u2603) {
                boolean bl2 = \u26034.func_212414_b(\u2603, \u2603, bl);
                if (!bl2) continue;
                ++n;
                if (\u26035 != null) continue;
                \u26035 = new ChunkPos(\u2603, \u2603);
            }
        }
        if (n == 0) {
            throw (bl ? field_212728_c : field_212729_d).create();
        }
        if (n == 1) {
            commandSource.func_197030_a(new TextComponentTranslation("commands.forceload." + (bl ? "added" : "removed") + ".single", \u26035, \u26033), true);
        } else {
            ChunkPos chunkPos = new ChunkPos(\u2603, \u2603);
            \u2603 = new ChunkPos(\u2603, \u2603);
            commandSource.func_197030_a(new TextComponentTranslation("commands.forceload." + (bl ? "added" : "removed") + ".multiple", n, \u26033, chunkPos, \u2603), true);
        }
        return n;
    }
}

