/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.impl;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic4CommandExceptionType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Random;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.command.arguments.Vec2Argument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.WorldServer;

public class SpreadPlayersCommand {
    private static final Dynamic4CommandExceptionType field_198723_a = new Dynamic4CommandExceptionType((object, object2, object3, object4) -> new TextComponentTranslation("commands.spreadplayers.failed.teams", object, object2, object3, object4));
    private static final Dynamic4CommandExceptionType field_198724_b = new Dynamic4CommandExceptionType((object, object2, object3, object4) -> new TextComponentTranslation("commands.spreadplayers.failed.entities", object, object2, object3, object4));

    public static void func_198716_a(CommandDispatcher<CommandSource> commandDispatcher) {
        commandDispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a("spreadplayers").requires(commandSource -> commandSource.func_197034_c(2))).then(Commands.func_197056_a("center", Vec2Argument.func_197296_a()).then(Commands.func_197056_a("spreadDistance", FloatArgumentType.floatArg((float)0.0f)).then(Commands.func_197056_a("maxRange", FloatArgumentType.floatArg((float)1.0f)).then(Commands.func_197056_a("respectTeams", BoolArgumentType.bool()).then(Commands.func_197056_a("targets", EntityArgument.func_197093_b()).executes(commandContext -> SpreadPlayersCommand.func_198722_a((CommandSource)commandContext.getSource(), Vec2Argument.func_197295_a((CommandContext<CommandSource>)commandContext, "center"), FloatArgumentType.getFloat((CommandContext)commandContext, (String)"spreadDistance"), FloatArgumentType.getFloat((CommandContext)commandContext, (String)"maxRange"), BoolArgumentType.getBool((CommandContext)commandContext, (String)"respectTeams"), EntityArgument.func_197097_b((CommandContext<CommandSource>)commandContext, "targets")))))))));
    }

    private static int func_198722_a(CommandSource commandSource, Vec2f vec2f, float f, float f2, boolean bl, Collection<? extends Entity> collection) throws CommandSyntaxException {
        Random random = new Random();
        double \u26032 = vec2f.field_189982_i - f2;
        double \u26033 = vec2f.field_189983_j - f2;
        double \u26034 = vec2f.field_189982_i + f2;
        double \u26035 = vec2f.field_189983_j + f2;
        Position[] \u26036 = SpreadPlayersCommand.func_198720_a(random, bl ? SpreadPlayersCommand.func_198715_a(collection) : collection.size(), \u26032, \u26033, \u26034, \u26035);
        SpreadPlayersCommand.func_198717_a(vec2f, f, commandSource.func_197023_e(), random, \u26032, \u26033, \u26034, \u26035, \u26036, bl);
        double \u26037 = SpreadPlayersCommand.func_198719_a(collection, commandSource.func_197023_e(), \u26036, bl);
        commandSource.func_197030_a(new TextComponentTranslation("commands.spreadplayers.success." + (bl ? "teams" : "entities"), \u26036.length, Float.valueOf(vec2f.field_189982_i), Float.valueOf(vec2f.field_189983_j), String.format(Locale.ROOT, "%.2f", \u26037)), true);
        return \u26036.length;
    }

    private static int func_198715_a(Collection<? extends Entity> collection) {
        HashSet hashSet = Sets.newHashSet();
        for (Entity entity : collection) {
            if (entity instanceof EntityPlayer) {
                hashSet.add(entity.func_96124_cp());
                continue;
            }
            hashSet.add(null);
        }
        return hashSet.size();
    }

    private static void func_198717_a(Vec2f vec2f, double d, WorldServer worldServer, Random random, double d2, double d3, double d4, double d5, Position[] positionArray, boolean bl) throws CommandSyntaxException {
        int n;
        \u26035 = true;
        double \u26032 = 3.4028234663852886E38;
        for (n = 0; n < 10000 && \u26035; ++n) {
            boolean \u26035 = false;
            \u26032 = 3.4028234663852886E38;
            for (int i = 0; i < positionArray.length; ++i) {
                Position position = positionArray[i];
                int \u26033 = 0;
                position = new Position();
                for (int j = 0; j < positionArray.length; ++j) {
                    if (i == j) continue;
                    Position position2 = positionArray[j];
                    double \u26034 = position.func_198708_a(position2);
                    \u26032 = Math.min(\u26034, \u26032);
                    if (!(\u26034 < d)) continue;
                    ++\u26033;
                    position.field_198713_a = position.field_198713_a + (position2.field_198713_a - position.field_198713_a);
                    position.field_198714_b = position.field_198714_b + (position2.field_198714_b - position.field_198714_b);
                }
                if (\u26033 > 0) {
                    position.field_198713_a = position.field_198713_a / (double)\u26033;
                    position.field_198714_b = position.field_198714_b / (double)\u26033;
                    double d6 = position.func_198712_b();
                    if (d6 > 0.0) {
                        position.func_198707_a();
                        position.func_198705_b(position);
                    } else {
                        position.func_198711_a(random, d2, d3, d4, d5);
                    }
                    \u26035 = true;
                }
                if (!position.func_198709_a(d2, d3, d4, d5)) continue;
                \u26035 = true;
            }
            if (\u26035) continue;
            for (Position position : positionArray) {
                if (position.func_198706_b(worldServer)) continue;
                position.func_198711_a(random, d2, d3, d4, d5);
                \u26035 = true;
            }
        }
        if (\u26032 == 3.4028234663852886E38) {
            \u26032 = 0.0;
        }
        if (n >= 10000) {
            if (bl) {
                throw field_198723_a.create((Object)positionArray.length, (Object)Float.valueOf(vec2f.field_189982_i), (Object)Float.valueOf(vec2f.field_189983_j), (Object)String.format(Locale.ROOT, "%.2f", \u26032));
            }
            throw field_198724_b.create((Object)positionArray.length, (Object)Float.valueOf(vec2f.field_189982_i), (Object)Float.valueOf(vec2f.field_189983_j), (Object)String.format(Locale.ROOT, "%.2f", \u26032));
        }
    }

    private static double func_198719_a(Collection<? extends Entity> collection2, WorldServer worldServer, Position[] positionArray2, boolean bl) {
        double d = 0.0;
        int \u26032 = 0;
        HashMap \u26033 = Maps.newHashMap();
        for (Entity entity : collection2) {
            Position \u26034;
            if (bl) {
                Team team;
                Team team2 = team = entity instanceof EntityPlayer ? entity.func_96124_cp() : null;
                if (!\u26033.containsKey(team)) {
                    \u26033.put(team, positionArray2[\u26032++]);
                }
                Position \u26035 = (Position)\u26033.get(team);
            } else {
                \u26034 = positionArray2[\u26032++];
            }
            entity.func_70634_a((float)MathHelper.func_76128_c(\u26034.field_198713_a) + 0.5f, \u26034.func_198710_a(worldServer), (double)MathHelper.func_76128_c(\u26034.field_198714_b) + 0.5);
            double d2 = Double.MAX_VALUE;
            for (Position position : positionArray2) {
                if (\u26034 == position) continue;
                double d3 = \u26034.func_198708_a(position);
                d2 = Math.min(d3, d2);
            }
            d += d2;
        }
        if (collection2.size() < 2) {
            return 0.0;
        }
        return d /= (double)collection2.size();
    }

    private static Position[] func_198720_a(Random random, int n, double d, double d2, double d3, double d4) {
        Position[] positionArray = new Position[n];
        for (int i = 0; i < positionArray.length; ++i) {
            Position position = new Position();
            position.func_198711_a(random, d, d2, d3, d4);
            positionArray[i] = position;
        }
        return positionArray;
    }

    static class Position {
        private double field_198713_a;
        private double field_198714_b;

        Position() {
        }

        double func_198708_a(Position position) {
            double d = this.field_198713_a - position.field_198713_a;
            \u2603 = this.field_198714_b - position.field_198714_b;
            return Math.sqrt(d * d + \u2603 * \u2603);
        }

        void func_198707_a() {
            double d = this.func_198712_b();
            this.field_198713_a /= d;
            this.field_198714_b /= d;
        }

        float func_198712_b() {
            return MathHelper.func_76133_a(this.field_198713_a * this.field_198713_a + this.field_198714_b * this.field_198714_b);
        }

        public void func_198705_b(Position position) {
            this.field_198713_a -= position.field_198713_a;
            this.field_198714_b -= position.field_198714_b;
        }

        public boolean func_198709_a(double d, double d2, double d3, double d4) {
            boolean bl = false;
            if (this.field_198713_a < d) {
                this.field_198713_a = d;
                bl = true;
            } else if (this.field_198713_a > d3) {
                this.field_198713_a = d3;
                bl = true;
            }
            if (this.field_198714_b < d2) {
                this.field_198714_b = d2;
                bl = true;
            } else if (this.field_198714_b > d4) {
                this.field_198714_b = d4;
                bl = true;
            }
            return bl;
        }

        public int func_198710_a(IBlockReader iBlockReader) {
            BlockPos blockPos = new BlockPos(this.field_198713_a, 256.0, this.field_198714_b);
            while (blockPos.func_177956_o() > 0) {
                if (iBlockReader.func_180495_p(blockPos = blockPos.func_177977_b()).func_196958_f()) continue;
                return blockPos.func_177956_o() + 1;
            }
            return 257;
        }

        public boolean func_198706_b(IBlockReader iBlockReader) {
            BlockPos blockPos = new BlockPos(this.field_198713_a, 256.0, this.field_198714_b);
            while (blockPos.func_177956_o() > 0) {
                IBlockState iBlockState = iBlockReader.func_180495_p(blockPos = blockPos.func_177977_b());
                if (iBlockState.func_196958_f()) continue;
                Material \u26032 = iBlockState.func_185904_a();
                return !\u26032.func_76224_d() && \u26032 != Material.field_151581_o;
            }
            return false;
        }

        public void func_198711_a(Random random, double d, double d2, double d3, double d4) {
            this.field_198713_a = MathHelper.func_82716_a(random, d, d3);
            this.field_198714_b = MathHelper.func_82716_a(random, d2, d4);
        }
    }
}

