/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.command.impl.data;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.List;
import java.util.function.Function;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.NBTArgument;
import net.minecraft.command.arguments.NBTPathArgument;
import net.minecraft.command.impl.data.BlockDataAccessor;
import net.minecraft.command.impl.data.EntityDataAccessor;
import net.minecraft.command.impl.data.IDataAccessor;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagCollection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextComponentTranslation;

public class DataCommand {
    private static final SimpleCommandExceptionType field_198949_b = new SimpleCommandExceptionType((Message)new TextComponentTranslation("commands.data.merge.failed", new Object[0]));
    private static final DynamicCommandExceptionType field_198950_c = new DynamicCommandExceptionType(object -> new TextComponentTranslation("commands.data.get.invalid", object));
    private static final DynamicCommandExceptionType field_201229_d = new DynamicCommandExceptionType(object -> new TextComponentTranslation("commands.data.get.unknown", object));
    public static final List<IDataProvider> field_198948_a = Lists.newArrayList((Object[])new IDataProvider[]{EntityDataAccessor.field_198926_a, BlockDataAccessor.field_198930_a});

    public static void func_198937_a(CommandDispatcher<CommandSource> commandDispatcher2) {
        CommandDispatcher<CommandSource> commandDispatcher2;
        LiteralArgumentBuilder literalArgumentBuilder = (LiteralArgumentBuilder)Commands.func_197057_a("data").requires(commandSource -> commandSource.func_197034_c(2));
        for (IDataProvider iDataProvider : field_198948_a) {
            ((LiteralArgumentBuilder)((LiteralArgumentBuilder)literalArgumentBuilder.then(iDataProvider.func_198920_a((ArgumentBuilder<CommandSource, ?>)Commands.func_197057_a("merge"), argumentBuilder -> argumentBuilder.then(Commands.func_197056_a("nbt", NBTArgument.func_197131_a()).executes(commandContext -> DataCommand.func_198946_a((CommandSource)commandContext.getSource(), iDataProvider.func_198919_a((CommandContext<CommandSource>)commandContext), NBTArgument.func_197130_a(commandContext, "nbt"))))))).then(iDataProvider.func_198920_a((ArgumentBuilder<CommandSource, ?>)Commands.func_197057_a("get"), argumentBuilder -> argumentBuilder.executes(commandContext -> DataCommand.func_198947_a((CommandSource)commandContext.getSource(), iDataProvider.func_198919_a((CommandContext<CommandSource>)commandContext))).then(((RequiredArgumentBuilder)Commands.func_197056_a("path", NBTPathArgument.func_197149_a()).executes(commandContext -> DataCommand.func_201228_b((CommandSource)commandContext.getSource(), iDataProvider.func_198919_a((CommandContext<CommandSource>)commandContext), NBTPathArgument.func_197148_a((CommandContext<CommandSource>)commandContext, "path")))).then(Commands.func_197056_a("scale", DoubleArgumentType.doubleArg()).executes(commandContext -> DataCommand.func_198938_a((CommandSource)commandContext.getSource(), iDataProvider.func_198919_a((CommandContext<CommandSource>)commandContext), NBTPathArgument.func_197148_a((CommandContext<CommandSource>)commandContext, "path"), DoubleArgumentType.getDouble((CommandContext)commandContext, (String)"scale")))))))).then(iDataProvider.func_198920_a((ArgumentBuilder<CommandSource, ?>)Commands.func_197057_a("remove"), argumentBuilder -> argumentBuilder.then(Commands.func_197056_a("path", NBTPathArgument.func_197149_a()).executes(commandContext -> DataCommand.func_198942_a((CommandSource)commandContext.getSource(), iDataProvider.func_198919_a((CommandContext<CommandSource>)commandContext), NBTPathArgument.func_197148_a((CommandContext<CommandSource>)commandContext, "path"))))));
        }
        commandDispatcher2.register(literalArgumentBuilder);
    }

    private static int func_198942_a(CommandSource commandSource, IDataAccessor iDataAccessor, NBTPathArgument.NBTPath nBTPath) throws CommandSyntaxException {
        NBTTagCompound nBTTagCompound = iDataAccessor.func_198923_a();
        \u2603 = nBTTagCompound.func_74737_b();
        nBTPath.func_197140_b(nBTTagCompound);
        if (\u2603.equals(nBTTagCompound)) {
            throw field_198949_b.create();
        }
        iDataAccessor.func_198925_a(nBTTagCompound);
        commandSource.func_197030_a(iDataAccessor.func_198921_b(), true);
        return 1;
    }

    private static int func_201228_b(CommandSource commandSource2, IDataAccessor iDataAccessor, NBTPathArgument.NBTPath nBTPath2) throws CommandSyntaxException {
        CommandSource commandSource2;
        int n;
        INBTBase iNBTBase = nBTPath2.func_197143_a(iDataAccessor.func_198923_a());
        if (iNBTBase instanceof NBTPrimitive) {
            n = MathHelper.func_76128_c(((NBTPrimitive)iNBTBase).func_150286_g());
        } else if (iNBTBase instanceof NBTTagCollection) {
            n = ((NBTTagCollection)iNBTBase).size();
        } else if (iNBTBase instanceof NBTTagCompound) {
            n = ((NBTTagCompound)iNBTBase).func_186856_d();
        } else if (iNBTBase instanceof NBTTagString) {
            n = ((NBTTagString)iNBTBase).func_150285_a_().length();
        } else {
            NBTPathArgument.NBTPath nBTPath2;
            throw field_201229_d.create((Object)nBTPath2.toString());
        }
        commandSource2.func_197030_a(iDataAccessor.func_198924_b(iNBTBase), false);
        return n;
    }

    private static int func_198938_a(CommandSource commandSource, IDataAccessor iDataAccessor, NBTPathArgument.NBTPath nBTPath, double d) throws CommandSyntaxException {
        INBTBase iNBTBase = nBTPath.func_197143_a(iDataAccessor.func_198923_a());
        if (!(iNBTBase instanceof NBTPrimitive)) {
            throw field_198950_c.create((Object)nBTPath.toString());
        }
        int \u26032 = MathHelper.func_76128_c(((NBTPrimitive)iNBTBase).func_150286_g() * d);
        commandSource.func_197030_a(iDataAccessor.func_198922_a(nBTPath, d, \u26032), false);
        return \u26032;
    }

    private static int func_198947_a(CommandSource commandSource, IDataAccessor iDataAccessor) throws CommandSyntaxException {
        commandSource.func_197030_a(iDataAccessor.func_198924_b(iDataAccessor.func_198923_a()), false);
        return 1;
    }

    private static int func_198946_a(CommandSource commandSource, IDataAccessor iDataAccessor, NBTTagCompound nBTTagCompound) throws CommandSyntaxException {
        \u2603 = iDataAccessor.func_198923_a();
        if (\u2603.equals(\u2603 = \u2603.func_74737_b().func_197643_a(nBTTagCompound))) {
            throw field_198949_b.create();
        }
        iDataAccessor.func_198925_a(\u2603);
        commandSource.func_197030_a(iDataAccessor.func_198921_b(), true);
        return 1;
    }

    public static interface IDataProvider {
        public IDataAccessor func_198919_a(CommandContext<CommandSource> var1) throws CommandSyntaxException;

        public ArgumentBuilder<CommandSource, ?> func_198920_a(ArgumentBuilder<CommandSource, ?> var1, Function<ArgumentBuilder<CommandSource, ?>, ArgumentBuilder<CommandSource, ?>> var2);
    }
}

