/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.enchantment;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentArrowDamage;
import net.minecraft.enchantment.EnchantmentArrowFire;
import net.minecraft.enchantment.EnchantmentArrowInfinite;
import net.minecraft.enchantment.EnchantmentArrowKnockback;
import net.minecraft.enchantment.EnchantmentBindingCurse;
import net.minecraft.enchantment.EnchantmentChanneling;
import net.minecraft.enchantment.EnchantmentDamage;
import net.minecraft.enchantment.EnchantmentDigging;
import net.minecraft.enchantment.EnchantmentDurability;
import net.minecraft.enchantment.EnchantmentFireAspect;
import net.minecraft.enchantment.EnchantmentFishingSpeed;
import net.minecraft.enchantment.EnchantmentFrostWalker;
import net.minecraft.enchantment.EnchantmentImpaling;
import net.minecraft.enchantment.EnchantmentKnockback;
import net.minecraft.enchantment.EnchantmentLootBonus;
import net.minecraft.enchantment.EnchantmentLoyalty;
import net.minecraft.enchantment.EnchantmentMending;
import net.minecraft.enchantment.EnchantmentOxygen;
import net.minecraft.enchantment.EnchantmentProtection;
import net.minecraft.enchantment.EnchantmentRiptide;
import net.minecraft.enchantment.EnchantmentSweepingEdge;
import net.minecraft.enchantment.EnchantmentThorns;
import net.minecraft.enchantment.EnchantmentUntouching;
import net.minecraft.enchantment.EnchantmentVanishingCurse;
import net.minecraft.enchantment.EnchantmentWaterWalker;
import net.minecraft.enchantment.EnchantmentWaterWorker;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;

public abstract class Enchantment {
    private final EntityEquipmentSlot[] field_185263_a;
    private final Rarity field_77333_a;
    @Nullable
    public EnumEnchantmentType field_77351_y;
    @Nullable
    protected String field_77350_z;

    @Nullable
    public static Enchantment func_185262_c(int n) {
        return IRegistry.field_212628_q.func_148754_a(n);
    }

    protected Enchantment(Rarity rarity, EnumEnchantmentType enumEnchantmentType, EntityEquipmentSlot[] entityEquipmentSlotArray) {
        this.field_77333_a = rarity;
        this.field_77351_y = enumEnchantmentType;
        this.field_185263_a = entityEquipmentSlotArray;
    }

    public List<ItemStack> func_185260_a(EntityLivingBase entityLivingBase) {
        ArrayList arrayList = Lists.newArrayList();
        for (EntityEquipmentSlot entityEquipmentSlot : this.field_185263_a) {
            ItemStack itemStack = entityLivingBase.func_184582_a(entityEquipmentSlot);
            if (itemStack.func_190926_b()) continue;
            arrayList.add(itemStack);
        }
        return arrayList;
    }

    public Rarity func_77324_c() {
        return this.field_77333_a;
    }

    public int func_77319_d() {
        return 1;
    }

    public int func_77325_b() {
        return 1;
    }

    public int func_77321_a(int n) {
        return 1 + n * 10;
    }

    public int func_77317_b(int n) {
        return this.func_77321_a(n) + 5;
    }

    public int func_77318_a(int n, DamageSource damageSource) {
        return 0;
    }

    public float func_152376_a(int n, CreatureAttribute creatureAttribute) {
        return 0.0f;
    }

    public final boolean func_191560_c(Enchantment enchantment) {
        return this.func_77326_a(enchantment) && enchantment.func_77326_a(this);
    }

    protected boolean func_77326_a(Enchantment enchantment) {
        return this != enchantment;
    }

    protected String func_210771_f() {
        if (this.field_77350_z == null) {
            this.field_77350_z = Util.func_200697_a("enchantment", IRegistry.field_212628_q.func_177774_c(this));
        }
        return this.field_77350_z;
    }

    public String func_77320_a() {
        return this.func_210771_f();
    }

    public ITextComponent func_200305_d(int n) {
        TextComponentTranslation textComponentTranslation = new TextComponentTranslation(this.func_77320_a(), new Object[0]);
        if (this.func_190936_d()) {
            textComponentTranslation.func_211708_a(TextFormatting.RED);
        } else {
            textComponentTranslation.func_211708_a(TextFormatting.GRAY);
        }
        if (n != 1 || this.func_77325_b() != 1) {
            textComponentTranslation.func_150258_a(" ").func_150257_a(new TextComponentTranslation("enchantment.level." + n, new Object[0]));
        }
        return textComponentTranslation;
    }

    public boolean func_92089_a(ItemStack itemStack) {
        return this.field_77351_y.func_77557_a(itemStack.func_77973_b());
    }

    public void func_151368_a(EntityLivingBase entityLivingBase, Entity entity, int n) {
    }

    public void func_151367_b(EntityLivingBase entityLivingBase, Entity entity, int n) {
    }

    public boolean func_185261_e() {
        return false;
    }

    public boolean func_190936_d() {
        return false;
    }

    public static void func_185257_f() {
        EntityEquipmentSlot[] entityEquipmentSlotArray = new EntityEquipmentSlot[]{EntityEquipmentSlot.HEAD, EntityEquipmentSlot.CHEST, EntityEquipmentSlot.LEGS, EntityEquipmentSlot.FEET};
        Enchantment.func_210770_a("protection", new EnchantmentProtection(Rarity.COMMON, EnchantmentProtection.Type.ALL, entityEquipmentSlotArray));
        Enchantment.func_210770_a("fire_protection", new EnchantmentProtection(Rarity.UNCOMMON, EnchantmentProtection.Type.FIRE, entityEquipmentSlotArray));
        Enchantment.func_210770_a("feather_falling", new EnchantmentProtection(Rarity.UNCOMMON, EnchantmentProtection.Type.FALL, entityEquipmentSlotArray));
        Enchantment.func_210770_a("blast_protection", new EnchantmentProtection(Rarity.RARE, EnchantmentProtection.Type.EXPLOSION, entityEquipmentSlotArray));
        Enchantment.func_210770_a("projectile_protection", new EnchantmentProtection(Rarity.UNCOMMON, EnchantmentProtection.Type.PROJECTILE, entityEquipmentSlotArray));
        Enchantment.func_210770_a("respiration", new EnchantmentOxygen(Rarity.RARE, entityEquipmentSlotArray));
        Enchantment.func_210770_a("aqua_affinity", new EnchantmentWaterWorker(Rarity.RARE, entityEquipmentSlotArray));
        Enchantment.func_210770_a("thorns", new EnchantmentThorns(Rarity.VERY_RARE, entityEquipmentSlotArray));
        Enchantment.func_210770_a("depth_strider", new EnchantmentWaterWalker(Rarity.RARE, entityEquipmentSlotArray));
        Enchantment.func_210770_a("frost_walker", new EnchantmentFrostWalker(Rarity.RARE, EntityEquipmentSlot.FEET));
        Enchantment.func_210770_a("binding_curse", new EnchantmentBindingCurse(Rarity.VERY_RARE, entityEquipmentSlotArray));
        Enchantment.func_210770_a("sharpness", new EnchantmentDamage(Rarity.COMMON, 0, EntityEquipmentSlot.MAINHAND));
        Enchantment.func_210770_a("smite", new EnchantmentDamage(Rarity.UNCOMMON, 1, EntityEquipmentSlot.MAINHAND));
        Enchantment.func_210770_a("bane_of_arthropods", new EnchantmentDamage(Rarity.UNCOMMON, 2, EntityEquipmentSlot.MAINHAND));
        Enchantment.func_210770_a("knockback", new EnchantmentKnockback(Rarity.UNCOMMON, EntityEquipmentSlot.MAINHAND));
        Enchantment.func_210770_a("fire_aspect", new EnchantmentFireAspect(Rarity.RARE, EntityEquipmentSlot.MAINHAND));
        Enchantment.func_210770_a("looting", new EnchantmentLootBonus(Rarity.RARE, EnumEnchantmentType.WEAPON, EntityEquipmentSlot.MAINHAND));
        Enchantment.func_210770_a("sweeping", new EnchantmentSweepingEdge(Rarity.RARE, EntityEquipmentSlot.MAINHAND));
        Enchantment.func_210770_a("efficiency", new EnchantmentDigging(Rarity.COMMON, EntityEquipmentSlot.MAINHAND));
        Enchantment.func_210770_a("silk_touch", new EnchantmentUntouching(Rarity.VERY_RARE, EntityEquipmentSlot.MAINHAND));
        Enchantment.func_210770_a("unbreaking", new EnchantmentDurability(Rarity.UNCOMMON, EntityEquipmentSlot.MAINHAND));
        Enchantment.func_210770_a("fortune", new EnchantmentLootBonus(Rarity.RARE, EnumEnchantmentType.DIGGER, EntityEquipmentSlot.MAINHAND));
        Enchantment.func_210770_a("power", new EnchantmentArrowDamage(Rarity.COMMON, EntityEquipmentSlot.MAINHAND));
        Enchantment.func_210770_a("punch", new EnchantmentArrowKnockback(Rarity.RARE, EntityEquipmentSlot.MAINHAND));
        Enchantment.func_210770_a("flame", new EnchantmentArrowFire(Rarity.RARE, EntityEquipmentSlot.MAINHAND));
        Enchantment.func_210770_a("infinity", new EnchantmentArrowInfinite(Rarity.VERY_RARE, EntityEquipmentSlot.MAINHAND));
        Enchantment.func_210770_a("luck_of_the_sea", new EnchantmentLootBonus(Rarity.RARE, EnumEnchantmentType.FISHING_ROD, EntityEquipmentSlot.MAINHAND));
        Enchantment.func_210770_a("lure", new EnchantmentFishingSpeed(Rarity.RARE, EnumEnchantmentType.FISHING_ROD, EntityEquipmentSlot.MAINHAND));
        Enchantment.func_210770_a("loyalty", new EnchantmentLoyalty(Rarity.UNCOMMON, EntityEquipmentSlot.MAINHAND));
        Enchantment.func_210770_a("impaling", new EnchantmentImpaling(Rarity.RARE, EntityEquipmentSlot.MAINHAND));
        Enchantment.func_210770_a("riptide", new EnchantmentRiptide(Rarity.RARE, EntityEquipmentSlot.MAINHAND));
        Enchantment.func_210770_a("channeling", new EnchantmentChanneling(Rarity.VERY_RARE, EntityEquipmentSlot.MAINHAND));
        Enchantment.func_210770_a("mending", new EnchantmentMending(Rarity.RARE, EntityEquipmentSlot.values()));
        Enchantment.func_210770_a("vanishing_curse", new EnchantmentVanishingCurse(Rarity.VERY_RARE, EntityEquipmentSlot.values()));
    }

    private static void func_210770_a(String string, Enchantment enchantment) {
        IRegistry.field_212628_q.func_82595_a(new ResourceLocation(string), enchantment);
    }

    public static enum Rarity {
        COMMON(10),
        UNCOMMON(5),
        RARE(2),
        VERY_RARE(1);

        private final int field_185275_e;

        private Rarity(int n2) {
            this.field_185275_e = n2;
        }

        public int func_185270_a() {
            return this.field_185275_e;
        }
    }
}

