/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.BlockConcretePowder;
import net.minecraft.block.BlockFalling;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceFluidMode;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityFallingBlock
extends Entity {
    private IBlockState field_175132_d = Blocks.field_150354_m.func_176223_P();
    public int field_145812_b;
    public boolean field_145813_c = true;
    private boolean field_145808_f;
    private boolean field_145809_g;
    private int field_145815_h = 40;
    private float field_145816_i = 2.0f;
    public NBTTagCompound field_145810_d;
    protected static final DataParameter<BlockPos> field_184532_d = EntityDataManager.func_187226_a(EntityFallingBlock.class, DataSerializers.field_187200_j);

    public EntityFallingBlock(World world) {
        super(EntityType.field_200809_w, world);
    }

    public EntityFallingBlock(World world, double d, double d2, double d3, IBlockState iBlockState) {
        this(world);
        this.field_175132_d = iBlockState;
        this.field_70156_m = true;
        this.func_70105_a(0.98f, 0.98f);
        this.func_70107_b(d, d2 + (double)((1.0f - this.field_70131_O) / 2.0f), d3);
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70169_q = d;
        this.field_70167_r = d2;
        this.field_70166_s = d3;
        this.func_184530_a(new BlockPos(this));
    }

    @Override
    public boolean func_70075_an() {
        return false;
    }

    public void func_184530_a(BlockPos blockPos) {
        this.field_70180_af.func_187227_b(field_184532_d, blockPos);
    }

    public BlockPos func_184531_j() {
        return this.field_70180_af.func_187225_a(field_184532_d);
    }

    @Override
    protected boolean func_70041_e_() {
        return false;
    }

    @Override
    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(field_184532_d, BlockPos.field_177992_a);
    }

    @Override
    public boolean func_70067_L() {
        return !this.field_70128_L;
    }

    @Override
    public void func_70071_h_() {
        BlockPos blockPos;
        if (this.field_175132_d.func_196958_f()) {
            this.func_70106_y();
            return;
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        Block block = this.field_175132_d.func_177230_c();
        if (this.field_145812_b++ == 0) {
            blockPos = new BlockPos(this);
            if (this.field_70170_p.func_180495_p(blockPos).func_177230_c() == block) {
                this.field_70170_p.func_175698_g(blockPos);
            } else if (!this.field_70170_p.field_72995_K) {
                this.func_70106_y();
                return;
            }
        }
        if (!this.func_189652_ae()) {
            this.field_70181_x -= (double)0.04f;
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        if (!this.field_70170_p.field_72995_K) {
            blockPos = new BlockPos(this);
            boolean \u26032 = this.field_175132_d.func_177230_c() instanceof BlockConcretePowder;
            boolean \u26033 = \u26032 && this.field_70170_p.func_204610_c(blockPos).func_206884_a(FluidTags.field_206959_a);
            double \u26034 = this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y;
            if (\u26032 && \u26034 > 1.0 && (object = this.field_70170_p.func_200260_a(new Vec3d(this.field_70169_q, this.field_70167_r, this.field_70166_s), new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v), RayTraceFluidMode.SOURCE_ONLY)) != null && this.field_70170_p.func_204610_c(((RayTraceResult)object).func_178782_a()).func_206884_a(FluidTags.field_206959_a)) {
                blockPos = ((RayTraceResult)object).func_178782_a();
                \u26033 = true;
            }
            if (this.field_70122_E || \u26033) {
                Object object = this.field_70170_p.func_180495_p(blockPos);
                if (!\u26033 && BlockFalling.func_185759_i(this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u - (double)0.01f, this.field_70161_v)))) {
                    this.field_70122_E = false;
                    return;
                }
                this.field_70159_w *= (double)0.7f;
                this.field_70179_y *= (double)0.7f;
                this.field_70181_x *= -0.5;
                if (object.func_177230_c() != Blocks.field_196603_bb) {
                    this.func_70106_y();
                    if (!this.field_145808_f) {
                        if (object.func_185904_a().func_76222_j() && (\u26033 || !BlockFalling.func_185759_i(this.field_70170_p.func_180495_p(blockPos.func_177977_b()))) && this.field_70170_p.func_180501_a(blockPos, this.field_175132_d, 3)) {
                            if (block instanceof BlockFalling) {
                                ((BlockFalling)block).func_176502_a_(this.field_70170_p, blockPos, this.field_175132_d, (IBlockState)object);
                            }
                            if (this.field_145810_d != null && block instanceof ITileEntityProvider && (tileEntity = this.field_70170_p.func_175625_s(blockPos)) != null) {
                                TileEntity tileEntity;
                                NBTTagCompound nBTTagCompound = tileEntity.func_189515_b(new NBTTagCompound());
                                for (String string : this.field_145810_d.func_150296_c()) {
                                    INBTBase iNBTBase = this.field_145810_d.func_74781_a(string);
                                    if ("x".equals(string) || "y".equals(string) || "z".equals(string)) continue;
                                    nBTTagCompound.func_74782_a(string, iNBTBase.func_74737_b());
                                }
                                tileEntity.func_145839_a(nBTTagCompound);
                                tileEntity.func_70296_d();
                            }
                        } else if (this.field_145813_c && this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
                            this.func_199703_a(block);
                        }
                    } else if (block instanceof BlockFalling) {
                        ((BlockFalling)block).func_190974_b(this.field_70170_p, blockPos);
                    }
                }
            } else if (this.field_145812_b > 100 && !this.field_70170_p.field_72995_K && (blockPos.func_177956_o() < 1 || blockPos.func_177956_o() > 256) || this.field_145812_b > 600) {
                if (this.field_145813_c && this.field_70170_p.func_82736_K().func_82766_b("doEntityDrops")) {
                    this.func_199703_a(block);
                }
                this.func_70106_y();
            }
        }
        this.field_70159_w *= (double)0.98f;
        this.field_70181_x *= (double)0.98f;
        this.field_70179_y *= (double)0.98f;
    }

    @Override
    public void func_180430_e(float f, float f2) {
        if (this.field_145809_g && (n = MathHelper.func_76123_f(f - 1.0f)) > 0) {
            int n;
            ArrayList arrayList = Lists.newArrayList(this.field_70170_p.func_72839_b(this, this.func_174813_aQ()));
            boolean \u26032 = this.field_175132_d.func_203425_a(BlockTags.field_200572_k);
            DamageSource \u26033 = \u26032 ? DamageSource.field_82728_o : DamageSource.field_82729_p;
            for (Entity entity : arrayList) {
                entity.func_70097_a(\u26033, Math.min(MathHelper.func_76141_d((float)n * this.field_145816_i), this.field_145815_h));
            }
            if (\u26032 && (double)this.field_70146_Z.nextFloat() < (double)0.05f + (double)n * 0.05) {
                IBlockState iBlockState = BlockAnvil.func_196433_f(this.field_175132_d);
                if (iBlockState == null) {
                    this.field_145808_f = true;
                } else {
                    this.field_175132_d = iBlockState;
                }
            }
        }
    }

    @Override
    protected void func_70014_b(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.func_74782_a("BlockState", NBTUtil.func_190009_a(this.field_175132_d));
        nBTTagCompound.func_74768_a("Time", this.field_145812_b);
        nBTTagCompound.func_74757_a("DropItem", this.field_145813_c);
        nBTTagCompound.func_74757_a("HurtEntities", this.field_145809_g);
        nBTTagCompound.func_74776_a("FallHurtAmount", this.field_145816_i);
        nBTTagCompound.func_74768_a("FallHurtMax", this.field_145815_h);
        if (this.field_145810_d != null) {
            nBTTagCompound.func_74782_a("TileEntityData", this.field_145810_d);
        }
    }

    @Override
    protected void func_70037_a(NBTTagCompound nBTTagCompound) {
        this.field_175132_d = NBTUtil.func_190008_d(nBTTagCompound.func_74775_l("BlockState"));
        this.field_145812_b = nBTTagCompound.func_74762_e("Time");
        if (nBTTagCompound.func_150297_b("HurtEntities", 99)) {
            this.field_145809_g = nBTTagCompound.func_74767_n("HurtEntities");
            this.field_145816_i = nBTTagCompound.func_74760_g("FallHurtAmount");
            this.field_145815_h = nBTTagCompound.func_74762_e("FallHurtMax");
        } else if (this.field_175132_d.func_203425_a(BlockTags.field_200572_k)) {
            this.field_145809_g = true;
        }
        if (nBTTagCompound.func_150297_b("DropItem", 99)) {
            this.field_145813_c = nBTTagCompound.func_74767_n("DropItem");
        }
        if (nBTTagCompound.func_150297_b("TileEntityData", 10)) {
            this.field_145810_d = nBTTagCompound.func_74775_l("TileEntityData");
        }
        if (this.field_175132_d.func_196958_f()) {
            this.field_175132_d = Blocks.field_150354_m.func_176223_P();
        }
    }

    public World func_145807_e() {
        return this.field_70170_p;
    }

    public void func_145806_a(boolean bl) {
        this.field_145809_g = bl;
    }

    @Override
    public boolean func_90999_ad() {
        return false;
    }

    @Override
    public void func_85029_a(CrashReportCategory crashReportCategory) {
        super.func_85029_a(crashReportCategory);
        crashReportCategory.func_71507_a("Immitating BlockState", this.field_175132_d.toString());
    }

    public IBlockState func_195054_l() {
        return this.field_175132_d;
    }

    @Override
    public boolean func_184213_bq() {
        return true;
    }
}

