/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.item;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceFluidMode;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class EntityFireworkRocket
extends Entity {
    private static final DataParameter<ItemStack> field_184566_a = EntityDataManager.func_187226_a(EntityFireworkRocket.class, DataSerializers.field_187196_f);
    private static final DataParameter<Integer> field_191512_b = EntityDataManager.func_187226_a(EntityFireworkRocket.class, DataSerializers.field_187192_b);
    private int field_92056_a;
    private int field_92055_b;
    private EntityLivingBase field_191513_e;

    public EntityFireworkRocket(World world) {
        super(EntityType.field_200810_x, world);
        this.func_70105_a(0.25f, 0.25f);
    }

    @Override
    protected void func_70088_a() {
        this.field_70180_af.func_187214_a(field_184566_a, ItemStack.field_190927_a);
        this.field_70180_af.func_187214_a(field_191512_b, 0);
    }

    @Override
    public boolean func_70112_a(double d) {
        return d < 4096.0 && !this.func_191511_j();
    }

    @Override
    public boolean func_145770_h(double d, double d2, double d3) {
        return super.func_145770_h(d, d2, d3) && !this.func_191511_j();
    }

    public EntityFireworkRocket(World world, double d, double d2, double d3, ItemStack itemStack) {
        super(EntityType.field_200810_x, world);
        this.field_92056_a = 0;
        this.func_70105_a(0.25f, 0.25f);
        this.func_70107_b(d, d2, d3);
        int n = 1;
        if (!itemStack.func_190926_b() && itemStack.func_77942_o()) {
            this.field_70180_af.func_187227_b(field_184566_a, itemStack.func_77946_l());
            n += itemStack.func_190925_c("Fireworks").func_74771_c("Flight");
        }
        this.field_70159_w = this.field_70146_Z.nextGaussian() * 0.001;
        this.field_70179_y = this.field_70146_Z.nextGaussian() * 0.001;
        this.field_70181_x = 0.05;
        this.field_92055_b = 10 * n + this.field_70146_Z.nextInt(6) + this.field_70146_Z.nextInt(7);
    }

    public EntityFireworkRocket(World world, ItemStack itemStack, EntityLivingBase entityLivingBase) {
        this(world, entityLivingBase.field_70165_t, entityLivingBase.field_70163_u, entityLivingBase.field_70161_v, itemStack);
        this.field_70180_af.func_187227_b(field_191512_b, entityLivingBase.func_145782_y());
        this.field_191513_e = entityLivingBase;
    }

    @Override
    public void func_70016_h(double d, double d2, double d3) {
        this.field_70159_w = d;
        this.field_70181_x = d2;
        this.field_70179_y = d3;
        if (this.field_70127_C == 0.0f && this.field_70126_B == 0.0f) {
            float f = MathHelper.func_76133_a(d * d + d3 * d3);
            this.field_70177_z = (float)(MathHelper.func_181159_b(d, d3) * 57.2957763671875);
            this.field_70125_A = (float)(MathHelper.func_181159_b(d2, f) * 57.2957763671875);
            this.field_70126_B = this.field_70177_z;
            this.field_70127_C = this.field_70125_A;
        }
    }

    @Override
    public void func_70071_h_() {
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        super.func_70071_h_();
        if (this.func_191511_j()) {
            Object object;
            if (this.field_191513_e == null && (object = this.field_70170_p.func_73045_a(this.field_70180_af.func_187225_a(field_191512_b))) instanceof EntityLivingBase) {
                this.field_191513_e = (EntityLivingBase)object;
            }
            if (this.field_191513_e != null) {
                if (this.field_191513_e.func_184613_cA()) {
                    object = this.field_191513_e.func_70040_Z();
                    double d = 1.5;
                    \u2603 = 0.1;
                    this.field_191513_e.field_70159_w += ((Vec3d)object).field_72450_a * 0.1 + (((Vec3d)object).field_72450_a * 1.5 - this.field_191513_e.field_70159_w) * 0.5;
                    this.field_191513_e.field_70181_x += ((Vec3d)object).field_72448_b * 0.1 + (((Vec3d)object).field_72448_b * 1.5 - this.field_191513_e.field_70181_x) * 0.5;
                    this.field_191513_e.field_70179_y += ((Vec3d)object).field_72449_c * 0.1 + (((Vec3d)object).field_72449_c * 1.5 - this.field_191513_e.field_70179_y) * 0.5;
                }
                this.func_70107_b(this.field_191513_e.field_70165_t, this.field_191513_e.field_70163_u, this.field_191513_e.field_70161_v);
                this.field_70159_w = this.field_191513_e.field_70159_w;
                this.field_70181_x = this.field_191513_e.field_70181_x;
                this.field_70179_y = this.field_191513_e.field_70179_y;
            }
        } else {
            this.field_70159_w *= 1.15;
            this.field_70179_y *= 1.15;
            this.field_70181_x += 0.04;
            this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        }
        float f = MathHelper.func_76133_a(this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y);
        this.field_70177_z = (float)(MathHelper.func_181159_b(this.field_70159_w, this.field_70179_y) * 57.2957763671875);
        this.field_70125_A = (float)(MathHelper.func_181159_b(this.field_70181_x, f) * 57.2957763671875);
        while (this.field_70125_A - this.field_70127_C < -180.0f) {
            this.field_70127_C -= 360.0f;
        }
        while (this.field_70125_A - this.field_70127_C >= 180.0f) {
            this.field_70127_C += 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B < -180.0f) {
            this.field_70126_B -= 360.0f;
        }
        while (this.field_70177_z - this.field_70126_B >= 180.0f) {
            this.field_70126_B += 360.0f;
        }
        this.field_70125_A = this.field_70127_C + (this.field_70125_A - this.field_70127_C) * 0.2f;
        this.field_70177_z = this.field_70126_B + (this.field_70177_z - this.field_70126_B) * 0.2f;
        if (this.field_92056_a == 0 && !this.func_174814_R()) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187631_bo, SoundCategory.AMBIENT, 3.0f, 1.0f);
        }
        ++this.field_92056_a;
        if (this.field_70170_p.field_72995_K && this.field_92056_a % 2 < 2) {
            this.field_70170_p.func_195594_a(Particles.field_197629_v, this.field_70165_t, this.field_70163_u - 0.3, this.field_70161_v, this.field_70146_Z.nextGaussian() * 0.05, -this.field_70181_x * 0.5, this.field_70146_Z.nextGaussian() * 0.05);
        }
        if (!this.field_70170_p.field_72995_K && this.field_92056_a > this.field_92055_b) {
            this.field_70170_p.func_72960_a(this, (byte)17);
            this.func_191510_k();
            this.func_70106_y();
        }
    }

    private void func_191510_k() {
        float f = 0.0f;
        ItemStack \u26032 = this.field_70180_af.func_187225_a(field_184566_a);
        NBTTagCompound \u26033 = \u26032.func_190926_b() ? null : \u26032.func_179543_a("Fireworks");
        NBTTagList nBTTagList = \u2603 = \u26033 != null ? \u26033.func_150295_c("Explosions", 10) : null;
        if (\u2603 != null && !\u2603.isEmpty()) {
            f = 5 + \u2603.size() * 2;
        }
        if (f > 0.0f) {
            if (this.field_191513_e != null) {
                this.field_191513_e.func_70097_a(DamageSource.field_191552_t, 5 + \u2603.size() * 2);
            }
            double d = 5.0;
            Vec3d \u26034 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
            List<EntityLivingBase> \u26035 = this.field_70170_p.func_72872_a(EntityLivingBase.class, this.func_174813_aQ().func_186662_g(5.0));
            for (EntityLivingBase entityLivingBase : \u26035) {
                if (entityLivingBase == this.field_191513_e || this.func_70068_e(entityLivingBase) > 25.0) continue;
                boolean \u26036 = false;
                for (int i = 0; i < 2; ++i) {
                    RayTraceResult rayTraceResult = this.field_70170_p.func_200259_a(\u26034, new Vec3d(entityLivingBase.field_70165_t, entityLivingBase.field_70163_u + (double)entityLivingBase.field_70131_O * 0.5 * (double)i, entityLivingBase.field_70161_v), RayTraceFluidMode.NEVER, true, false);
                    if (rayTraceResult != null && rayTraceResult.field_72313_a != RayTraceResult.Type.MISS) continue;
                    \u26036 = true;
                    break;
                }
                if (!\u26036) continue;
                float f2 = f * (float)Math.sqrt((5.0 - (double)this.func_70032_d(entityLivingBase)) / 5.0);
                entityLivingBase.func_70097_a(DamageSource.field_191552_t, f2);
            }
        }
    }

    public boolean func_191511_j() {
        return this.field_70180_af.func_187225_a(field_191512_b) > 0;
    }

    @Override
    public void func_70103_a(byte by) {
        if (by == 17 && this.field_70170_p.field_72995_K) {
            ItemStack itemStack = this.field_70180_af.func_187225_a(field_184566_a);
            NBTTagCompound \u26032 = itemStack.func_190926_b() ? null : itemStack.func_179543_a("Fireworks");
            this.field_70170_p.func_92088_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70159_w, this.field_70181_x, this.field_70179_y, \u26032);
        }
        super.func_70103_a(by);
    }

    @Override
    public void func_70014_b(NBTTagCompound nBTTagCompound) {
        nBTTagCompound.func_74768_a("Life", this.field_92056_a);
        nBTTagCompound.func_74768_a("LifeTime", this.field_92055_b);
        ItemStack itemStack = this.field_70180_af.func_187225_a(field_184566_a);
        if (!itemStack.func_190926_b()) {
            nBTTagCompound.func_74782_a("FireworksItem", itemStack.func_77955_b(new NBTTagCompound()));
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nBTTagCompound) {
        this.field_92056_a = nBTTagCompound.func_74762_e("Life");
        this.field_92055_b = nBTTagCompound.func_74762_e("LifeTime");
        ItemStack itemStack = ItemStack.func_199557_a(nBTTagCompound.func_74775_l("FireworksItem"));
        if (!itemStack.func_190926_b()) {
            this.field_70180_af.func_187227_b(field_184566_a, itemStack);
        }
    }

    @Override
    public boolean func_70075_an() {
        return false;
    }
}

