/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.EntityIronGolem;
import net.minecraft.entity.monster.EntitySpellcasterIllager;
import net.minecraft.entity.monster.EntityVex;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityEvokerFangs;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityEvoker
extends EntitySpellcasterIllager {
    private EntitySheep field_190763_bw;

    public EntityEvoker(World world) {
        super(EntityType.field_200806_t, world);
        this.func_70105_a(0.6f, 1.95f);
        this.field_70728_aV = 10;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(1, new AICastingSpell());
        this.field_70714_bg.func_75776_a(2, new EntityAIAvoidEntity<EntityPlayer>(this, EntityPlayer.class, 8.0f, 0.6, 1.0));
        this.field_70714_bg.func_75776_a(4, new AISummonSpell());
        this.field_70714_bg.func_75776_a(5, new AIAttackSpell());
        this.field_70714_bg.func_75776_a(6, new AIWololoSpell());
        this.field_70714_bg.func_75776_a(8, new EntityAIWander(this, 0.6));
        this.field_70714_bg.func_75776_a(9, new EntityAIWatchClosest(this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(10, new EntityAIWatchClosest(this, EntityLiving.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, new EntityAIHurtByTarget((EntityCreature)this, true, EntityEvoker.class));
        this.field_70715_bh.func_75776_a(2, new EntityAINearestAttackableTarget<EntityPlayer>((EntityCreature)this, EntityPlayer.class, true).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, new EntityAINearestAttackableTarget<EntityVillager>((EntityCreature)this, EntityVillager.class, false).func_190882_b(300));
        this.field_70715_bh.func_75776_a(3, new EntityAINearestAttackableTarget<EntityIronGolem>((EntityCreature)this, EntityIronGolem.class, false));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(24.0);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
    }

    @Override
    public void func_70037_a(NBTTagCompound nBTTagCompound) {
        super.func_70037_a(nBTTagCompound);
    }

    @Override
    public void func_70014_b(NBTTagCompound nBTTagCompound) {
        super.func_70014_b(nBTTagCompound);
    }

    @Override
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_191185_au;
    }

    @Override
    protected void func_70619_bc() {
        super.func_70619_bc();
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
    }

    @Override
    public boolean func_184191_r(Entity entity) {
        if (entity == null) {
            return false;
        }
        if (entity == this) {
            return true;
        }
        if (super.func_184191_r(entity)) {
            return true;
        }
        if (entity instanceof EntityVex) {
            return this.func_184191_r(((EntityVex)entity).func_190645_o());
        }
        if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70668_bt() == CreatureAttribute.ILLAGER) {
            return this.func_96124_cp() == null && entity.func_96124_cp() == null;
        }
        return false;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_191243_bm;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_191245_bo;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_191246_bp;
    }

    private void func_190748_a(@Nullable EntitySheep entitySheep) {
        this.field_190763_bw = entitySheep;
    }

    @Nullable
    private EntitySheep func_190751_dj() {
        return this.field_190763_bw;
    }

    @Override
    protected SoundEvent func_193086_dk() {
        return SoundEvents.field_191244_bn;
    }

    public class AIWololoSpell
    extends EntitySpellcasterIllager.AIUseSpell {
        private final Predicate<EntitySheep> field_190879_a;

        public AIWololoSpell() {
            super(EntityEvoker.this);
            this.field_190879_a = entitySheep -> entitySheep.func_175509_cj() == EnumDyeColor.BLUE;
        }

        @Override
        public boolean func_75250_a() {
            if (EntityEvoker.this.func_70638_az() != null) {
                return false;
            }
            if (EntityEvoker.this.func_193082_dl()) {
                return false;
            }
            if (EntityEvoker.this.field_70173_aa < this.field_193322_d) {
                return false;
            }
            if (!EntityEvoker.this.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                return false;
            }
            List<EntitySheep> list = EntityEvoker.this.field_70170_p.func_175647_a(EntitySheep.class, EntityEvoker.this.func_174813_aQ().func_72314_b(16.0, 4.0, 16.0), this.field_190879_a);
            if (list.isEmpty()) {
                return false;
            }
            EntityEvoker.this.func_190748_a(list.get(EntityEvoker.this.field_70146_Z.nextInt(list.size())));
            return true;
        }

        @Override
        public boolean func_75253_b() {
            return EntityEvoker.this.func_190751_dj() != null && this.field_193321_c > 0;
        }

        @Override
        public void func_75251_c() {
            super.func_75251_c();
            EntityEvoker.this.func_190748_a(null);
        }

        @Override
        protected void func_190868_j() {
            EntitySheep entitySheep = EntityEvoker.this.func_190751_dj();
            if (entitySheep != null && entitySheep.func_70089_S()) {
                entitySheep.func_175512_b(EnumDyeColor.RED);
            }
        }

        @Override
        protected int func_190867_m() {
            return 40;
        }

        @Override
        protected int func_190869_f() {
            return 60;
        }

        @Override
        protected int func_190872_i() {
            return 140;
        }

        @Override
        protected SoundEvent func_190871_k() {
            return SoundEvents.field_191249_bs;
        }

        @Override
        protected EntitySpellcasterIllager.SpellType func_193320_l() {
            return EntitySpellcasterIllager.SpellType.WOLOLO;
        }
    }

    class AISummonSpell
    extends EntitySpellcasterIllager.AIUseSpell {
        private AISummonSpell() {
            super(EntityEvoker.this);
        }

        @Override
        public boolean func_75250_a() {
            if (!super.func_75250_a()) {
                return false;
            }
            int n = EntityEvoker.this.field_70170_p.func_72872_a(EntityVex.class, EntityEvoker.this.func_174813_aQ().func_186662_g(16.0)).size();
            return EntityEvoker.this.field_70146_Z.nextInt(8) + 1 > n;
        }

        @Override
        protected int func_190869_f() {
            return 100;
        }

        @Override
        protected int func_190872_i() {
            return 340;
        }

        @Override
        protected void func_190868_j() {
            for (int i = 0; i < 3; ++i) {
                BlockPos blockPos = new BlockPos(EntityEvoker.this).func_177982_a(-2 + EntityEvoker.this.field_70146_Z.nextInt(5), 1, -2 + EntityEvoker.this.field_70146_Z.nextInt(5));
                EntityVex \u26032 = new EntityVex(EntityEvoker.this.field_70170_p);
                \u26032.func_174828_a(blockPos, 0.0f, 0.0f);
                \u26032.func_204210_a(EntityEvoker.this.field_70170_p.func_175649_E(blockPos), null, null);
                \u26032.func_190658_a(EntityEvoker.this);
                \u26032.func_190651_g(blockPos);
                \u26032.func_190653_a(20 * (30 + EntityEvoker.this.field_70146_Z.nextInt(90)));
                EntityEvoker.this.field_70170_p.func_72838_d(\u26032);
            }
        }

        @Override
        protected SoundEvent func_190871_k() {
            return SoundEvents.field_191248_br;
        }

        @Override
        protected EntitySpellcasterIllager.SpellType func_193320_l() {
            return EntitySpellcasterIllager.SpellType.SUMMON_VEX;
        }
    }

    class AIAttackSpell
    extends EntitySpellcasterIllager.AIUseSpell {
        private AIAttackSpell() {
            super(EntityEvoker.this);
        }

        @Override
        protected int func_190869_f() {
            return 40;
        }

        @Override
        protected int func_190872_i() {
            return 100;
        }

        @Override
        protected void func_190868_j() {
            EntityLivingBase entityLivingBase = EntityEvoker.this.func_70638_az();
            double \u26032 = Math.min(entityLivingBase.field_70163_u, EntityEvoker.this.field_70163_u);
            double \u26033 = Math.max(entityLivingBase.field_70163_u, EntityEvoker.this.field_70163_u) + 1.0;
            float \u26034 = (float)MathHelper.func_181159_b(entityLivingBase.field_70161_v - EntityEvoker.this.field_70161_v, entityLivingBase.field_70165_t - EntityEvoker.this.field_70165_t);
            if (EntityEvoker.this.func_70068_e(entityLivingBase) < 9.0) {
                float f;
                int n;
                for (n = 0; n < 5; ++n) {
                    f = \u26034 + (float)n * (float)Math.PI * 0.4f;
                    this.func_190876_a(EntityEvoker.this.field_70165_t + (double)MathHelper.func_76134_b(f) * 1.5, EntityEvoker.this.field_70161_v + (double)MathHelper.func_76126_a(f) * 1.5, \u26032, \u26033, f, 0);
                }
                for (n = 0; n < 8; ++n) {
                    f = \u26034 + (float)n * (float)Math.PI * 2.0f / 8.0f + 1.2566371f;
                    this.func_190876_a(EntityEvoker.this.field_70165_t + (double)MathHelper.func_76134_b(f) * 2.5, EntityEvoker.this.field_70161_v + (double)MathHelper.func_76126_a(f) * 2.5, \u26032, \u26033, f, 3);
                }
            } else {
                for (int i = 0; i < 16; ++i) {
                    double d = 1.25 * (double)(i + 1);
                    int \u26035 = 1 * i;
                    this.func_190876_a(EntityEvoker.this.field_70165_t + (double)MathHelper.func_76134_b(\u26034) * d, EntityEvoker.this.field_70161_v + (double)MathHelper.func_76126_a(\u26034) * d, \u26032, \u26033, \u26034, \u26035);
                }
            }
        }

        private void func_190876_a(double d, double d2, double d3, double d4, float f, int n) {
            BlockPos blockPos = new BlockPos(d, d4, d2);
            boolean \u26032 = false;
            double \u26033 = 0.0;
            do {
                if (EntityEvoker.this.field_70170_p.func_195595_w(blockPos) || !EntityEvoker.this.field_70170_p.func_195595_w(blockPos.func_177977_b())) continue;
                if (!EntityEvoker.this.field_70170_p.func_175623_d(blockPos) && !(\u2603 = (object = EntityEvoker.this.field_70170_p.func_180495_p(blockPos)).func_196952_d(EntityEvoker.this.field_70170_p, blockPos)).func_197766_b()) {
                    \u26033 = \u2603.func_197758_c(EnumFacing.Axis.Y);
                }
                \u26032 = true;
                break;
            } while ((blockPos = blockPos.func_177977_b()).func_177956_o() >= MathHelper.func_76128_c(d3) - 1);
            if (\u26032) {
                Object object = new EntityEvokerFangs(EntityEvoker.this.field_70170_p, d, (double)blockPos.func_177956_o() + \u26033, d2, f, n, EntityEvoker.this);
                EntityEvoker.this.field_70170_p.func_72838_d((Entity)object);
            }
        }

        @Override
        protected SoundEvent func_190871_k() {
            return SoundEvents.field_191247_bq;
        }

        @Override
        protected EntitySpellcasterIllager.SpellType func_193320_l() {
            return EntitySpellcasterIllager.SpellType.FANGS;
        }
    }

    class AICastingSpell
    extends EntitySpellcasterIllager.AICastingApell {
        private AICastingSpell() {
            super(EntityEvoker.this);
        }

        @Override
        public void func_75246_d() {
            if (EntityEvoker.this.func_70638_az() != null) {
                EntityEvoker.this.func_70671_ap().func_75651_a(EntityEvoker.this.func_70638_az(), EntityEvoker.this.func_184649_cE(), EntityEvoker.this.func_70646_bf());
            } else if (EntityEvoker.this.func_190751_dj() != null) {
                EntityEvoker.this.func_70671_ap().func_75651_a(EntityEvoker.this.func_190751_dj(), EntityEvoker.this.func_184649_cE(), EntityEvoker.this.func_70646_bf());
            }
        }
    }
}

