/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.IJumpingMount;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAIRunAroundLikeCrazy;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ContainerHorseChest;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.IInventoryChangedListener;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;

public abstract class AbstractHorse
extends EntityAnimal
implements IInventoryChangedListener,
IJumpingMount {
    private static final Predicate<Entity> field_110276_bu = entity -> entity instanceof AbstractHorse && ((AbstractHorse)entity).func_110205_ce();
    protected static final IAttribute field_110271_bv = new RangedAttribute(null, "horse.jumpStrength", 0.7, 0.0, 2.0).func_111117_a("Jump Strength").func_111112_a(true);
    private static final DataParameter<Byte> field_184787_bE = EntityDataManager.func_187226_a(AbstractHorse.class, DataSerializers.field_187191_a);
    private static final DataParameter<Optional<UUID>> field_184790_bH = EntityDataManager.func_187226_a(AbstractHorse.class, DataSerializers.field_187203_m);
    private int field_190689_bJ;
    private int field_110290_bE;
    private int field_110295_bF;
    public int field_110278_bp;
    public int field_110279_bq;
    protected boolean field_110275_br;
    protected ContainerHorseChest field_110296_bG;
    protected int field_110274_bs;
    protected float field_110277_bt;
    private boolean field_110294_bI;
    private float field_110283_bJ;
    private float field_110284_bK;
    private float field_110281_bL;
    private float field_110282_bM;
    private float field_110287_bN;
    private float field_110288_bO;
    protected boolean field_190688_bE = true;
    protected int field_110285_bP;

    protected AbstractHorse(EntityType<?> entityType, World world) {
        super(entityType, world);
        this.func_70105_a(1.3964844f, 1.6f);
        this.field_70138_W = 1.0f;
        this.func_110226_cD();
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, new EntityAIPanic(this, 1.2));
        this.field_70714_bg.func_75776_a(1, new EntityAIRunAroundLikeCrazy(this, 1.2));
        this.field_70714_bg.func_75776_a(2, new EntityAIMate(this, 1.0, AbstractHorse.class));
        this.field_70714_bg.func_75776_a(4, new EntityAIFollowParent(this, 1.0));
        this.field_70714_bg.func_75776_a(6, new EntityAIWanderAvoidWater(this, 0.7));
        this.field_70714_bg.func_75776_a(7, new EntityAIWatchClosest(this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, new EntityAILookIdle(this));
        this.func_205714_dM();
    }

    protected void func_205714_dM() {
        this.field_70714_bg.func_75776_a(0, new EntityAISwimming(this));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184787_bE, (byte)0);
        this.field_70180_af.func_187214_a(field_184790_bH, Optional.empty());
    }

    protected boolean func_110233_w(int n) {
        return (this.field_70180_af.func_187225_a(field_184787_bE) & n) != 0;
    }

    protected void func_110208_b(int n, boolean bl) {
        byte by = this.field_70180_af.func_187225_a(field_184787_bE);
        if (bl) {
            this.field_70180_af.func_187227_b(field_184787_bE, (byte)(by | n));
        } else {
            this.field_70180_af.func_187227_b(field_184787_bE, (byte)(by & ~n));
        }
    }

    public boolean func_110248_bS() {
        return this.func_110233_w(2);
    }

    @Nullable
    public UUID func_184780_dh() {
        return this.field_70180_af.func_187225_a(field_184790_bH).orElse(null);
    }

    public void func_184779_b(@Nullable UUID uUID) {
        this.field_70180_af.func_187227_b(field_184790_bH, Optional.ofNullable(uUID));
    }

    public float func_110254_bY() {
        return 0.5f;
    }

    @Override
    public void func_98054_a(boolean bl) {
        this.func_98055_j(bl ? this.func_110254_bY() : 1.0f);
    }

    public boolean func_110246_bZ() {
        return this.field_110275_br;
    }

    public void func_110234_j(boolean bl) {
        this.func_110208_b(2, bl);
    }

    public void func_110255_k(boolean bl) {
        this.field_110275_br = bl;
    }

    @Override
    public boolean func_184652_a(EntityPlayer entityPlayer) {
        return super.func_184652_a(entityPlayer) && this.func_70668_bt() != CreatureAttribute.UNDEAD;
    }

    @Override
    protected void func_142017_o(float f) {
        if (f > 6.0f && this.func_110204_cc()) {
            this.func_110227_p(false);
        }
    }

    public boolean func_110204_cc() {
        return this.func_110233_w(16);
    }

    public boolean func_110209_cd() {
        return this.func_110233_w(32);
    }

    public boolean func_110205_ce() {
        return this.func_110233_w(8);
    }

    public void func_110242_l(boolean bl) {
        this.func_110208_b(8, bl);
    }

    public void func_110251_o(boolean bl) {
        this.func_110208_b(4, bl);
    }

    public int func_110252_cg() {
        return this.field_110274_bs;
    }

    public void func_110238_s(int n) {
        this.field_110274_bs = n;
    }

    public int func_110198_t(int n) {
        \u2603 = MathHelper.func_76125_a(this.func_110252_cg() + n, 0, this.func_190676_dC());
        this.func_110238_s(\u2603);
        return \u2603;
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float f) {
        Entity entity = damageSource.func_76346_g();
        if (this.func_184207_aI() && entity != null && this.func_184215_y(entity)) {
            return false;
        }
        return super.func_70097_a(damageSource, f);
    }

    @Override
    public boolean func_70104_M() {
        return !this.func_184207_aI();
    }

    private void func_110266_cB() {
        this.func_110249_cI();
        if (!this.func_174814_R()) {
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187711_cp, this.func_184176_by(), 1.0f, 1.0f + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f);
        }
    }

    @Override
    public void func_180430_e(float f, float f2) {
        int n;
        if (f > 1.0f) {
            this.func_184185_a(SoundEvents.field_187723_ct, 0.4f, 1.0f);
        }
        if ((n = MathHelper.func_76123_f((f * 0.5f - 3.0f) * f2)) <= 0) {
            return;
        }
        this.func_70097_a(DamageSource.field_76379_h, n);
        if (this.func_184207_aI()) {
            for (Entity entity : this.func_184182_bu()) {
                entity.func_70097_a(DamageSource.field_76379_h, n);
            }
        }
        IBlockState iBlockState = this.field_70170_p.func_180495_p(new BlockPos(this.field_70165_t, this.field_70163_u - 0.2 - (double)this.field_70126_B, this.field_70161_v));
        Block block = iBlockState.func_177230_c();
        if (!iBlockState.func_196958_f() && !this.func_174814_R()) {
            SoundType soundType = block.func_185467_w();
            this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, soundType.func_185844_d(), this.func_184176_by(), soundType.func_185843_a() * 0.5f, soundType.func_185847_b() * 0.75f);
        }
    }

    protected int func_190686_di() {
        return 2;
    }

    protected void func_110226_cD() {
        ContainerHorseChest containerHorseChest = this.field_110296_bG;
        this.field_110296_bG = new ContainerHorseChest(this.func_200200_C_(), this.func_190686_di());
        this.field_110296_bG.func_200228_a(this.func_200201_e());
        if (containerHorseChest != null) {
            containerHorseChest.func_110132_b(this);
            int n = Math.min(containerHorseChest.func_70302_i_(), this.field_110296_bG.func_70302_i_());
            for (\u2603 = 0; \u2603 < n; ++\u2603) {
                ItemStack itemStack = containerHorseChest.func_70301_a(\u2603);
                if (itemStack.func_190926_b()) continue;
                this.field_110296_bG.func_70299_a(\u2603, itemStack.func_77946_l());
            }
        }
        this.field_110296_bG.func_110134_a(this);
        this.func_110232_cE();
    }

    protected void func_110232_cE() {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        this.func_110251_o(!this.field_110296_bG.func_70301_a(0).func_190926_b() && this.func_190685_dA());
    }

    @Override
    public void func_76316_a(IInventory iInventory) {
        boolean bl = this.func_110257_ck();
        this.func_110232_cE();
        if (this.field_70173_aa > 20 && !bl && this.func_110257_ck()) {
            this.func_184185_a(SoundEvents.field_187726_cu, 0.5f, 1.0f);
        }
    }

    @Nullable
    protected AbstractHorse func_110250_a(Entity entity, double d) {
        \u2603 = Double.MAX_VALUE;
        Entity \u26033 = null;
        List<Entity> \u26032 = this.field_70170_p.func_175674_a(entity, entity.func_174813_aQ().func_72321_a(d, d, d), field_110276_bu);
        for (Entity entity2 : \u26032) {
            double d2 = entity2.func_70092_e(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
            if (!(d2 < \u2603)) continue;
            \u26033 = entity2;
            \u2603 = d2;
        }
        return (AbstractHorse)\u26033;
    }

    public double func_110215_cj() {
        return this.func_110148_a(field_110271_bv).func_111126_e();
    }

    @Override
    @Nullable
    protected SoundEvent func_184615_bR() {
        return null;
    }

    @Override
    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        if (this.field_70146_Z.nextInt(3) == 0) {
            this.func_110220_cK();
        }
        return null;
    }

    @Override
    @Nullable
    protected SoundEvent func_184639_G() {
        if (this.field_70146_Z.nextInt(10) == 0 && !this.func_70610_aX()) {
            this.func_110220_cK();
        }
        return null;
    }

    public boolean func_190685_dA() {
        return true;
    }

    public boolean func_110257_ck() {
        return this.func_110233_w(4);
    }

    @Nullable
    protected SoundEvent func_184785_dv() {
        this.func_110220_cK();
        return null;
    }

    @Override
    protected void func_180429_a(BlockPos blockPos, IBlockState iBlockState) {
        if (iBlockState.func_185904_a().func_76224_d()) {
            return;
        }
        SoundType soundType = iBlockState.func_177230_c().func_185467_w();
        if (this.field_70170_p.func_180495_p(blockPos.func_177984_a()).func_177230_c() == Blocks.field_150433_aE) {
            soundType = Blocks.field_150433_aE.func_185467_w();
        }
        if (this.func_184207_aI() && this.field_190688_bE) {
            ++this.field_110285_bP;
            if (this.field_110285_bP > 5 && this.field_110285_bP % 3 == 0) {
                this.func_190680_a(soundType);
            } else if (this.field_110285_bP <= 5) {
                this.func_184185_a(SoundEvents.field_187732_cw, soundType.func_185843_a() * 0.15f, soundType.func_185847_b());
            }
        } else if (soundType == SoundType.field_185848_a) {
            this.func_184185_a(SoundEvents.field_187732_cw, soundType.func_185843_a() * 0.15f, soundType.func_185847_b());
        } else {
            this.func_184185_a(SoundEvents.field_187729_cv, soundType.func_185843_a() * 0.15f, soundType.func_185847_b());
        }
    }

    protected void func_190680_a(SoundType soundType) {
        this.func_184185_a(SoundEvents.field_187714_cq, soundType.func_185843_a() * 0.15f, soundType.func_185847_b());
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(field_110271_bv);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(53.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.225f);
    }

    @Override
    public int func_70641_bl() {
        return 6;
    }

    public int func_190676_dC() {
        return 100;
    }

    @Override
    protected float func_70599_aP() {
        return 0.8f;
    }

    @Override
    public int func_70627_aG() {
        return 400;
    }

    public void func_110199_f(EntityPlayer entityPlayer) {
        if (!this.field_70170_p.field_72995_K && (!this.func_184207_aI() || this.func_184196_w(entityPlayer)) && this.func_110248_bS()) {
            this.field_110296_bG.func_200228_a(this.func_200201_e());
            entityPlayer.func_184826_a(this, this.field_110296_bG);
        }
    }

    protected boolean func_190678_b(EntityPlayer entityPlayer, ItemStack itemStack) {
        boolean bl = false;
        float \u26032 = 0.0f;
        int \u26033 = 0;
        int \u26034 = 0;
        Item \u26035 = itemStack.func_77973_b();
        if (\u26035 == Items.field_151015_O) {
            \u26032 = 2.0f;
            \u26033 = 20;
            \u26034 = 3;
        } else if (\u26035 == Items.field_151102_aT) {
            \u26032 = 1.0f;
            \u26033 = 30;
            \u26034 = 3;
        } else if (\u26035 == Blocks.field_150407_cf.func_199767_j()) {
            \u26032 = 20.0f;
            \u26033 = 180;
        } else if (\u26035 == Items.field_151034_e) {
            \u26032 = 3.0f;
            \u26033 = 60;
            \u26034 = 3;
        } else if (\u26035 == Items.field_151150_bK) {
            \u26032 = 4.0f;
            \u26033 = 60;
            \u26034 = 5;
            if (this.func_110248_bS() && this.func_70874_b() == 0 && !this.func_70880_s()) {
                bl = true;
                this.func_146082_f(entityPlayer);
            }
        } else if (\u26035 == Items.field_151153_ao || \u26035 == Items.field_196100_at) {
            \u26032 = 10.0f;
            \u26033 = 240;
            \u26034 = 10;
            if (this.func_110248_bS() && this.func_70874_b() == 0 && !this.func_70880_s()) {
                bl = true;
                this.func_146082_f(entityPlayer);
            }
        }
        if (this.func_110143_aJ() < this.func_110138_aP() && \u26032 > 0.0f) {
            this.func_70691_i(\u26032);
            bl = true;
        }
        if (this.func_70631_g_() && \u26033 > 0) {
            this.field_70170_p.func_195594_a(Particles.field_197632_y, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, 0.0, 0.0, 0.0);
            if (!this.field_70170_p.field_72995_K) {
                this.func_110195_a(\u26033);
            }
            bl = true;
        }
        if (\u26034 > 0 && (bl || !this.func_110248_bS()) && this.func_110252_cg() < this.func_190676_dC()) {
            bl = true;
            if (!this.field_70170_p.field_72995_K) {
                this.func_110198_t(\u26034);
            }
        }
        if (bl) {
            this.func_110266_cB();
        }
        return bl;
    }

    protected void func_110237_h(EntityPlayer entityPlayer) {
        this.func_110227_p(false);
        this.func_110219_q(false);
        if (!this.field_70170_p.field_72995_K) {
            entityPlayer.field_70177_z = this.field_70177_z;
            entityPlayer.field_70125_A = this.field_70125_A;
            entityPlayer.func_184220_m(this);
        }
    }

    @Override
    protected boolean func_70610_aX() {
        return super.func_70610_aX() && this.func_184207_aI() && this.func_110257_ck() || this.func_110204_cc() || this.func_110209_cd();
    }

    @Override
    public boolean func_70877_b(ItemStack itemStack) {
        return false;
    }

    private void func_110210_cH() {
        this.field_110278_bp = 1;
    }

    @Override
    public void func_70645_a(DamageSource damageSource) {
        super.func_70645_a(damageSource);
        if (this.field_70170_p.field_72995_K || this.field_110296_bG == null) {
            return;
        }
        for (int i = 0; i < this.field_110296_bG.func_70302_i_(); ++i) {
            ItemStack itemStack = this.field_110296_bG.func_70301_a(i);
            if (itemStack.func_190926_b()) continue;
            this.func_199701_a_(itemStack);
        }
    }

    @Override
    public void func_70636_d() {
        if (this.field_70146_Z.nextInt(200) == 0) {
            this.func_110210_cH();
        }
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.field_70146_Z.nextInt(900) == 0 && this.field_70725_aQ == 0) {
            this.func_70691_i(1.0f);
        }
        if (this.func_190684_dE()) {
            if (!this.func_110204_cc() && !this.func_184207_aI() && this.field_70146_Z.nextInt(300) == 0 && this.field_70170_p.func_180495_p(new BlockPos(MathHelper.func_76128_c(this.field_70165_t), MathHelper.func_76128_c(this.field_70163_u) - 1, MathHelper.func_76128_c(this.field_70161_v))).func_177230_c() == Blocks.field_196658_i) {
                this.func_110227_p(true);
            }
            if (this.func_110204_cc() && ++this.field_190689_bJ > 50) {
                this.field_190689_bJ = 0;
                this.func_110227_p(false);
            }
        }
        this.func_190679_dD();
    }

    protected void func_190679_dD() {
        AbstractHorse abstractHorse;
        if (this.func_110205_ce() && this.func_70631_g_() && !this.func_110204_cc() && (abstractHorse = this.func_110250_a(this, 16.0)) != null && this.func_70068_e(abstractHorse) > 4.0) {
            this.field_70699_by.func_75494_a(abstractHorse);
        }
    }

    public boolean func_190684_dE() {
        return true;
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_110290_bE > 0 && ++this.field_110290_bE > 30) {
            this.field_110290_bE = 0;
            this.func_110208_b(64, false);
        }
        if ((this.func_184186_bw() || this.func_70613_aW()) && this.field_110295_bF > 0 && ++this.field_110295_bF > 20) {
            this.field_110295_bF = 0;
            this.func_110219_q(false);
        }
        if (this.field_110278_bp > 0 && ++this.field_110278_bp > 8) {
            this.field_110278_bp = 0;
        }
        if (this.field_110279_bq > 0) {
            ++this.field_110279_bq;
            if (this.field_110279_bq > 300) {
                this.field_110279_bq = 0;
            }
        }
        this.field_110284_bK = this.field_110283_bJ;
        if (this.func_110204_cc()) {
            this.field_110283_bJ += (1.0f - this.field_110283_bJ) * 0.4f + 0.05f;
            if (this.field_110283_bJ > 1.0f) {
                this.field_110283_bJ = 1.0f;
            }
        } else {
            this.field_110283_bJ += (0.0f - this.field_110283_bJ) * 0.4f - 0.05f;
            if (this.field_110283_bJ < 0.0f) {
                this.field_110283_bJ = 0.0f;
            }
        }
        this.field_110282_bM = this.field_110281_bL;
        if (this.func_110209_cd()) {
            this.field_110284_bK = this.field_110283_bJ = 0.0f;
            this.field_110281_bL += (1.0f - this.field_110281_bL) * 0.4f + 0.05f;
            if (this.field_110281_bL > 1.0f) {
                this.field_110281_bL = 1.0f;
            }
        } else {
            this.field_110294_bI = false;
            this.field_110281_bL += (0.8f * this.field_110281_bL * this.field_110281_bL * this.field_110281_bL - this.field_110281_bL) * 0.6f - 0.05f;
            if (this.field_110281_bL < 0.0f) {
                this.field_110281_bL = 0.0f;
            }
        }
        this.field_110288_bO = this.field_110287_bN;
        if (this.func_110233_w(64)) {
            this.field_110287_bN += (1.0f - this.field_110287_bN) * 0.7f + 0.05f;
            if (this.field_110287_bN > 1.0f) {
                this.field_110287_bN = 1.0f;
            }
        } else {
            this.field_110287_bN += (0.0f - this.field_110287_bN) * 0.7f - 0.05f;
            if (this.field_110287_bN < 0.0f) {
                this.field_110287_bN = 0.0f;
            }
        }
    }

    private void func_110249_cI() {
        if (!this.field_70170_p.field_72995_K) {
            this.field_110290_bE = 1;
            this.func_110208_b(64, true);
        }
    }

    public void func_110227_p(boolean bl) {
        this.func_110208_b(16, bl);
    }

    public void func_110219_q(boolean bl) {
        if (bl) {
            this.func_110227_p(false);
        }
        this.func_110208_b(32, bl);
    }

    private void func_110220_cK() {
        if (this.func_184186_bw() || this.func_70613_aW()) {
            this.field_110295_bF = 1;
            this.func_110219_q(true);
        }
    }

    public void func_190687_dF() {
        this.func_110220_cK();
        SoundEvent soundEvent = this.func_184785_dv();
        if (soundEvent != null) {
            this.func_184185_a(soundEvent, this.func_70599_aP(), this.func_70647_i());
        }
    }

    public boolean func_110263_g(EntityPlayer entityPlayer) {
        this.func_184779_b(entityPlayer.func_110124_au());
        this.func_110234_j(true);
        if (entityPlayer instanceof EntityPlayerMP) {
            CriteriaTriggers.field_193136_w.func_193178_a((EntityPlayerMP)entityPlayer, this);
        }
        this.field_70170_p.func_72960_a(this, (byte)7);
        return true;
    }

    @Override
    public void func_191986_a(float \u260322, float f3, float \u260332) {
        if (!(this.func_184207_aI() && this.func_82171_bF() && this.func_110257_ck())) {
            this.field_70747_aH = 0.02f;
            super.func_191986_a(\u260322, f3, \u260332);
            return;
        }
        EntityLivingBase entityLivingBase = (EntityLivingBase)this.func_184179_bs();
        this.field_70126_B = this.field_70177_z = entityLivingBase.field_70177_z;
        this.field_70125_A = entityLivingBase.field_70125_A * 0.5f;
        this.func_70101_b(this.field_70177_z, this.field_70125_A);
        this.field_70759_as = this.field_70761_aq = this.field_70177_z;
        float \u260322 = entityLivingBase.field_70702_br * 0.5f;
        float \u260332 = entityLivingBase.field_191988_bg;
        if (\u260332 <= 0.0f) {
            \u260332 *= 0.25f;
            this.field_110285_bP = 0;
        }
        if (this.field_70122_E && this.field_110277_bt == 0.0f && this.func_110209_cd() && !this.field_110294_bI) {
            \u260322 = 0.0f;
            \u260332 = 0.0f;
        }
        if (this.field_110277_bt > 0.0f && !this.func_110246_bZ() && this.field_70122_E) {
            this.field_70181_x = this.func_110215_cj() * (double)this.field_110277_bt;
            if (this.func_70644_a(MobEffects.field_76430_j)) {
                this.field_70181_x += (double)((float)(this.func_70660_b(MobEffects.field_76430_j).func_76458_c() + 1) * 0.1f);
            }
            this.func_110255_k(true);
            this.field_70160_al = true;
            if (\u260332 > 0.0f) {
                float f2 = MathHelper.func_76126_a(this.field_70177_z * ((float)Math.PI / 180));
                \u2603 = MathHelper.func_76134_b(this.field_70177_z * ((float)Math.PI / 180));
                this.field_70159_w += (double)(-0.4f * f2 * this.field_110277_bt);
                this.field_70179_y += (double)(0.4f * \u2603 * this.field_110277_bt);
                this.func_205715_ee();
            }
            this.field_110277_bt = 0.0f;
        }
        this.field_70747_aH = this.func_70689_ay() * 0.1f;
        if (this.func_184186_bw()) {
            float f3;
            this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
            super.func_191986_a(\u260322, f3, \u260332);
        } else if (entityLivingBase instanceof EntityPlayer) {
            this.field_70159_w = 0.0;
            this.field_70181_x = 0.0;
            this.field_70179_y = 0.0;
        }
        if (this.field_70122_E) {
            this.field_110277_bt = 0.0f;
            this.func_110255_k(false);
        }
        this.field_184618_aE = this.field_70721_aZ;
        double \u26034 = this.field_70165_t - this.field_70169_q;
        double \u26035 = this.field_70161_v - this.field_70166_s;
        float \u26036 = MathHelper.func_76133_a(\u26034 * \u26034 + \u26035 * \u26035) * 4.0f;
        if (\u26036 > 1.0f) {
            \u26036 = 1.0f;
        }
        this.field_70721_aZ += (\u26036 - this.field_70721_aZ) * 0.4f;
        this.field_184619_aG += this.field_70721_aZ;
    }

    protected void func_205715_ee() {
        this.func_184185_a(SoundEvents.field_187720_cs, 0.4f, 1.0f);
    }

    @Override
    public void func_70014_b(NBTTagCompound nBTTagCompound) {
        super.func_70014_b(nBTTagCompound);
        nBTTagCompound.func_74757_a("EatingHaystack", this.func_110204_cc());
        nBTTagCompound.func_74757_a("Bred", this.func_110205_ce());
        nBTTagCompound.func_74768_a("Temper", this.func_110252_cg());
        nBTTagCompound.func_74757_a("Tame", this.func_110248_bS());
        if (this.func_184780_dh() != null) {
            nBTTagCompound.func_74778_a("OwnerUUID", this.func_184780_dh().toString());
        }
        if (!this.field_110296_bG.func_70301_a(0).func_190926_b()) {
            nBTTagCompound.func_74782_a("SaddleItem", this.field_110296_bG.func_70301_a(0).func_77955_b(new NBTTagCompound()));
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nBTTagCompound2) {
        Object \u26032;
        String \u26033;
        super.func_70037_a(nBTTagCompound2);
        this.func_110227_p(nBTTagCompound2.func_74767_n("EatingHaystack"));
        this.func_110242_l(nBTTagCompound2.func_74767_n("Bred"));
        this.func_110238_s(nBTTagCompound2.func_74762_e("Temper"));
        this.func_110234_j(nBTTagCompound2.func_74767_n("Tame"));
        if (nBTTagCompound2.func_150297_b("OwnerUUID", 8)) {
            \u26033 = nBTTagCompound2.func_74779_i("OwnerUUID");
        } else {
            NBTTagCompound nBTTagCompound2;
            \u26032 = nBTTagCompound2.func_74779_i("Owner");
            \u26033 = PreYggdrasilConverter.func_187473_a(this.func_184102_h(), (String)\u26032);
        }
        if (!\u26033.isEmpty()) {
            this.func_184779_b(UUID.fromString(\u26033));
        }
        if ((\u26032 = this.func_110140_aT().func_111152_a("Speed")) != null) {
            this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(\u26032.func_111125_b() * 0.25);
        }
        if (nBTTagCompound2.func_150297_b("SaddleItem", 10) && (\u2603 = ItemStack.func_199557_a(nBTTagCompound2.func_74775_l("SaddleItem"))).func_77973_b() == Items.field_151141_av) {
            this.field_110296_bG.func_70299_a(0, \u2603);
        }
        this.func_110232_cE();
    }

    @Override
    public boolean func_70878_b(EntityAnimal entityAnimal) {
        return false;
    }

    protected boolean func_110200_cJ() {
        return !this.func_184207_aI() && !this.func_184218_aH() && this.func_110248_bS() && !this.func_70631_g_() && this.func_110143_aJ() >= this.func_110138_aP() && this.func_70880_s();
    }

    @Override
    @Nullable
    public EntityAgeable func_90011_a(EntityAgeable entityAgeable) {
        return null;
    }

    protected void func_190681_a(EntityAgeable entityAgeable, AbstractHorse abstractHorse) {
        double d = this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() + entityAgeable.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111125_b() + (double)this.func_110267_cL();
        abstractHorse.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(d / 3.0);
        \u2603 = this.func_110148_a(field_110271_bv).func_111125_b() + entityAgeable.func_110148_a(field_110271_bv).func_111125_b() + this.func_110245_cM();
        abstractHorse.func_110148_a(field_110271_bv).func_111128_a(\u2603 / 3.0);
        \u2603 = this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b() + entityAgeable.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111125_b() + this.func_110203_cN();
        abstractHorse.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(\u2603 / 3.0);
    }

    @Override
    public boolean func_82171_bF() {
        return this.func_184179_bs() instanceof EntityLivingBase;
    }

    public float func_110258_o(float f) {
        return this.field_110284_bK + (this.field_110283_bJ - this.field_110284_bK) * f;
    }

    public float func_110223_p(float f) {
        return this.field_110282_bM + (this.field_110281_bL - this.field_110282_bM) * f;
    }

    public float func_110201_q(float f) {
        return this.field_110288_bO + (this.field_110287_bN - this.field_110288_bO) * f;
    }

    @Override
    public void func_110206_u(int n) {
        if (!this.func_110257_ck()) {
            return;
        }
        if (n < 0) {
            n = 0;
        } else {
            this.field_110294_bI = true;
            this.func_110220_cK();
        }
        this.field_110277_bt = n >= 90 ? 1.0f : 0.4f + 0.4f * (float)n / 90.0f;
    }

    @Override
    public boolean func_184776_b() {
        return this.func_110257_ck();
    }

    @Override
    public void func_184775_b(int n) {
        this.field_110294_bI = true;
        this.func_110220_cK();
    }

    @Override
    public void func_184777_r_() {
    }

    protected void func_110216_r(boolean bl) {
        BasicParticleType basicParticleType = bl ? Particles.field_197633_z : Particles.field_197601_L;
        for (int i = 0; i < 7; ++i) {
            double d = this.field_70146_Z.nextGaussian() * 0.02;
            \u2603 = this.field_70146_Z.nextGaussian() * 0.02;
            \u2603 = this.field_70146_Z.nextGaussian() * 0.02;
            this.field_70170_p.func_195594_a(basicParticleType, this.field_70165_t + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, this.field_70163_u + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.field_70131_O), this.field_70161_v + (double)(this.field_70146_Z.nextFloat() * this.field_70130_N * 2.0f) - (double)this.field_70130_N, d, \u2603, \u2603);
        }
    }

    @Override
    public void func_70103_a(byte by) {
        if (by == 7) {
            this.func_110216_r(true);
        } else if (by == 6) {
            this.func_110216_r(false);
        } else {
            super.func_70103_a(by);
        }
    }

    @Override
    public void func_184232_k(Entity entity) {
        super.func_184232_k(entity);
        if (entity instanceof EntityLiving) {
            EntityLiving entityLiving = (EntityLiving)entity;
            this.field_70761_aq = entityLiving.field_70761_aq;
        }
        if (this.field_110282_bM > 0.0f) {
            float f = MathHelper.func_76126_a(this.field_70761_aq * ((float)Math.PI / 180));
            \u2603 = MathHelper.func_76134_b(this.field_70761_aq * ((float)Math.PI / 180));
            \u2603 = 0.7f * this.field_110282_bM;
            \u2603 = 0.15f * this.field_110282_bM;
            entity.func_70107_b(this.field_70165_t + (double)(\u2603 * f), this.field_70163_u + this.func_70042_X() + entity.func_70033_W() + (double)\u2603, this.field_70161_v - (double)(\u2603 * \u2603));
            if (entity instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).field_70761_aq = this.field_70761_aq;
            }
        }
    }

    protected float func_110267_cL() {
        return 15.0f + (float)this.field_70146_Z.nextInt(8) + (float)this.field_70146_Z.nextInt(9);
    }

    protected double func_110245_cM() {
        return (double)0.4f + this.field_70146_Z.nextDouble() * 0.2 + this.field_70146_Z.nextDouble() * 0.2 + this.field_70146_Z.nextDouble() * 0.2;
    }

    protected double func_110203_cN() {
        return ((double)0.45f + this.field_70146_Z.nextDouble() * 0.3 + this.field_70146_Z.nextDouble() * 0.3 + this.field_70146_Z.nextDouble() * 0.3) * 0.25;
    }

    @Override
    public boolean func_70617_f_() {
        return false;
    }

    @Override
    public float func_70047_e() {
        return this.field_70131_O;
    }

    public boolean func_190677_dK() {
        return false;
    }

    public boolean func_190682_f(ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean func_174820_d(int n, ItemStack itemStack) {
        int n2 = n - 400;
        if (n2 >= 0 && n2 < 2 && n2 < this.field_110296_bG.func_70302_i_()) {
            if (n2 == 0 && itemStack.func_77973_b() != Items.field_151141_av) {
                return false;
            }
            if (!(n2 != 1 || this.func_190677_dK() && this.func_190682_f(itemStack))) {
                return false;
            }
            this.field_110296_bG.func_70299_a(n2, itemStack);
            this.func_110232_cE();
            return true;
        }
        \u2603 = n - 500 + 2;
        if (\u2603 >= 2 && \u2603 < this.field_110296_bG.func_70302_i_()) {
            this.field_110296_bG.func_70299_a(\u2603, itemStack);
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Entity func_184179_bs() {
        if (this.func_184188_bt().isEmpty()) {
            return null;
        }
        return this.func_184188_bt().get(0);
    }

    @Override
    @Nullable
    public IEntityLivingData func_204210_a(DifficultyInstance difficultyInstance, @Nullable IEntityLivingData iEntityLivingData2, @Nullable NBTTagCompound nBTTagCompound) {
        IEntityLivingData iEntityLivingData2 = super.func_204210_a(difficultyInstance, iEntityLivingData2, nBTTagCompound);
        if (this.field_70146_Z.nextInt(5) == 0) {
            this.func_70873_a(-24000);
        }
        return iEntityLivingData2;
    }
}

