/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCarrot;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIMoveToBlock;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityJumpHelper;
import net.minecraft.entity.ai.EntityMoveHelper;
import net.minecraft.entity.monster.EntityMob;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReaderBase;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityRabbit
extends EntityAnimal {
    private static final DataParameter<Integer> field_184773_bv = EntityDataManager.func_187226_a(EntityRabbit.class, DataSerializers.field_187192_b);
    private static final ResourceLocation field_200611_bx = new ResourceLocation("killer_bunny");
    private int field_175540_bm;
    private int field_175535_bn;
    private boolean field_175537_bp;
    private int field_175538_bq;
    private int field_175541_bs;

    public EntityRabbit(World world) {
        super(EntityType.field_200736_ab, world);
        this.func_70105_a(0.4f, 0.5f);
        this.field_70767_i = new RabbitJumpHelper(this);
        this.field_70765_h = new RabbitMoveHelper(this);
        this.func_175515_b(0.0);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(1, new AIPanic(this, 2.2));
        this.field_70714_bg.func_75776_a(2, new EntityAIMate(this, 0.8));
        this.field_70714_bg.func_75776_a(3, new EntityAITempt((EntityCreature)this, 1.0, Ingredient.func_199804_a(Items.field_151172_bF, Items.field_151150_bK, Blocks.field_196605_bc), false));
        this.field_70714_bg.func_75776_a(4, new AIAvoidEntity<EntityPlayer>(this, EntityPlayer.class, 8.0f, 2.2, 2.2));
        this.field_70714_bg.func_75776_a(4, new AIAvoidEntity<EntityWolf>(this, EntityWolf.class, 10.0f, 2.2, 2.2));
        this.field_70714_bg.func_75776_a(4, new AIAvoidEntity<EntityMob>(this, EntityMob.class, 4.0f, 2.2, 2.2));
        this.field_70714_bg.func_75776_a(5, new AIRaidFarm(this));
        this.field_70714_bg.func_75776_a(6, new EntityAIWanderAvoidWater(this, 0.6));
        this.field_70714_bg.func_75776_a(11, new EntityAIWatchClosest(this, EntityPlayer.class, 10.0f));
    }

    @Override
    protected float func_175134_bD() {
        if (this.field_70123_F || this.field_70765_h.func_75640_a() && this.field_70765_h.func_179919_e() > this.field_70163_u + 0.5) {
            return 0.5f;
        }
        Path path = this.field_70699_by.func_75505_d();
        if (path != null && path.func_75873_e() < path.func_75874_d()) {
            Vec3d vec3d = path.func_75878_a(this);
            if (vec3d.field_72448_b > this.field_70163_u + 0.5) {
                return 0.5f;
            }
        }
        if (this.field_70765_h.func_75638_b() <= 0.6) {
            return 0.2f;
        }
        return 0.3f;
    }

    @Override
    protected void func_70664_aZ() {
        super.func_70664_aZ();
        double d = this.field_70765_h.func_75638_b();
        if (d > 0.0 && (\u2603 = this.field_70159_w * this.field_70159_w + this.field_70179_y * this.field_70179_y) < 0.010000000000000002) {
            this.func_191958_b(0.0f, 0.0f, 1.0f, 0.1f);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72960_a(this, (byte)1);
        }
    }

    public float func_175521_o(float f) {
        if (this.field_175535_bn == 0) {
            return 0.0f;
        }
        return ((float)this.field_175540_bm + f) / (float)this.field_175535_bn;
    }

    public void func_175515_b(double d) {
        this.func_70661_as().func_75489_a(d);
        this.field_70765_h.func_75642_a(this.field_70765_h.func_179917_d(), this.field_70765_h.func_179919_e(), this.field_70765_h.func_179918_f(), d);
    }

    @Override
    public void func_70637_d(boolean bl) {
        super.func_70637_d(bl);
        if (bl) {
            this.func_184185_a(this.func_184771_da(), this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) * 0.8f);
        }
    }

    public void func_184770_cZ() {
        this.func_70637_d(true);
        this.field_175535_bn = 10;
        this.field_175540_bm = 0;
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184773_bv, 0);
    }

    @Override
    public void func_70619_bc() {
        if (this.field_175538_bq > 0) {
            --this.field_175538_bq;
        }
        if (this.field_175541_bs > 0) {
            this.field_175541_bs -= this.field_70146_Z.nextInt(3);
            if (this.field_175541_bs < 0) {
                this.field_175541_bs = 0;
            }
        }
        if (this.field_70122_E) {
            Object object;
            if (!this.field_175537_bp) {
                this.func_70637_d(false);
                this.func_175517_cu();
            }
            if (this.func_175531_cl() == 99 && this.field_175538_bq == 0 && (object = this.func_70638_az()) != null && this.func_70068_e((Entity)object) < 16.0) {
                this.func_175533_a(((EntityLivingBase)object).field_70165_t, ((EntityLivingBase)object).field_70161_v);
                this.field_70765_h.func_75642_a(((EntityLivingBase)object).field_70165_t, ((EntityLivingBase)object).field_70163_u, ((EntityLivingBase)object).field_70161_v, this.field_70765_h.func_75638_b());
                this.func_184770_cZ();
                this.field_175537_bp = true;
            }
            if (!((RabbitJumpHelper)(object = (RabbitJumpHelper)this.field_70767_i)).func_180067_c()) {
                if (this.field_70765_h.func_75640_a() && this.field_175538_bq == 0) {
                    Path path = this.field_70699_by.func_75505_d();
                    Vec3d \u26032 = new Vec3d(this.field_70765_h.func_179917_d(), this.field_70765_h.func_179919_e(), this.field_70765_h.func_179918_f());
                    if (path != null && path.func_75873_e() < path.func_75874_d()) {
                        \u26032 = path.func_75878_a(this);
                    }
                    this.func_175533_a(\u26032.field_72450_a, \u26032.field_72449_c);
                    this.func_184770_cZ();
                }
            } else if (!((RabbitJumpHelper)object).func_180065_d()) {
                this.func_175518_cr();
            }
        }
        this.field_175537_bp = this.field_70122_E;
    }

    @Override
    public void func_174830_Y() {
    }

    private void func_175533_a(double d, double d2) {
        this.field_70177_z = (float)(MathHelper.func_181159_b(d2 - this.field_70161_v, d - this.field_70165_t) * 57.2957763671875) - 90.0f;
    }

    private void func_175518_cr() {
        ((RabbitJumpHelper)this.field_70767_i).func_180066_a(true);
    }

    private void func_175520_cs() {
        ((RabbitJumpHelper)this.field_70767_i).func_180066_a(false);
    }

    private void func_175530_ct() {
        this.field_175538_bq = this.field_70765_h.func_75638_b() < 2.2 ? 10 : 1;
    }

    private void func_175517_cu() {
        this.func_175530_ct();
        this.func_175520_cs();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_175540_bm != this.field_175535_bn) {
            ++this.field_175540_bm;
        } else if (this.field_175535_bn != 0) {
            this.field_175540_bm = 0;
            this.field_175535_bn = 0;
            this.func_70637_d(false);
        }
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(3.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3f);
    }

    @Override
    public void func_70014_b(NBTTagCompound nBTTagCompound) {
        super.func_70014_b(nBTTagCompound);
        nBTTagCompound.func_74768_a("RabbitType", this.func_175531_cl());
        nBTTagCompound.func_74768_a("MoreCarrotTicks", this.field_175541_bs);
    }

    @Override
    public void func_70037_a(NBTTagCompound nBTTagCompound) {
        super.func_70037_a(nBTTagCompound);
        this.func_175529_r(nBTTagCompound.func_74762_e("RabbitType"));
        this.field_175541_bs = nBTTagCompound.func_74762_e("MoreCarrotTicks");
    }

    protected SoundEvent func_184771_da() {
        return SoundEvents.field_187824_en;
    }

    @Override
    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187816_ej;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187822_em;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187820_el;
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (this.func_175531_cl() == 99) {
            this.func_184185_a(SoundEvents.field_187818_ek, 1.0f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            return entity.func_70097_a(DamageSource.func_76358_a(this), 8.0f);
        }
        return entity.func_70097_a(DamageSource.func_76358_a(this), 3.0f);
    }

    @Override
    public SoundCategory func_184176_by() {
        return this.func_175531_cl() == 99 ? SoundCategory.HOSTILE : SoundCategory.NEUTRAL;
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource, float f) {
        if (this.func_180431_b(damageSource)) {
            return false;
        }
        return super.func_70097_a(damageSource, f);
    }

    @Override
    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_186393_A;
    }

    private boolean func_175525_a(Item item) {
        return item == Items.field_151172_bF || item == Items.field_151150_bK || item == Blocks.field_196605_bc.func_199767_j();
    }

    @Override
    public EntityRabbit func_90011_a(EntityAgeable entityAgeable) {
        EntityRabbit entityRabbit = new EntityRabbit(this.field_70170_p);
        int \u26032 = this.func_184772_dk();
        if (this.field_70146_Z.nextInt(20) != 0) {
            \u26032 = entityAgeable instanceof EntityRabbit && this.field_70146_Z.nextBoolean() ? ((EntityRabbit)entityAgeable).func_175531_cl() : this.func_175531_cl();
        }
        entityRabbit.func_175529_r(\u26032);
        return entityRabbit;
    }

    @Override
    public boolean func_70877_b(ItemStack itemStack) {
        return this.func_175525_a(itemStack.func_77973_b());
    }

    public int func_175531_cl() {
        return this.field_70180_af.func_187225_a(field_184773_bv);
    }

    public void func_175529_r(int n) {
        if (n == 99) {
            this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(8.0);
            this.field_70714_bg.func_75776_a(4, new AIEvilAttack(this));
            this.field_70715_bh.func_75776_a(1, new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
            this.field_70715_bh.func_75776_a(2, new EntityAINearestAttackableTarget<EntityPlayer>((EntityCreature)this, EntityPlayer.class, true));
            this.field_70715_bh.func_75776_a(2, new EntityAINearestAttackableTarget<EntityWolf>((EntityCreature)this, EntityWolf.class, true));
            if (!this.func_145818_k_()) {
                this.func_200203_b(new TextComponentTranslation(Util.func_200697_a("entity", field_200611_bx), new Object[0]));
            }
        }
        this.field_70180_af.func_187227_b(field_184773_bv, n);
    }

    @Override
    @Nullable
    public IEntityLivingData func_204210_a(DifficultyInstance difficultyInstance, @Nullable IEntityLivingData iEntityLivingData2, @Nullable NBTTagCompound nBTTagCompound) {
        IEntityLivingData iEntityLivingData2 = super.func_204210_a(difficultyInstance, iEntityLivingData2, nBTTagCompound);
        int \u26032 = this.func_184772_dk();
        boolean \u26033 = false;
        if (iEntityLivingData2 instanceof RabbitTypeData) {
            \u26032 = ((RabbitTypeData)iEntityLivingData2).field_179427_a;
            \u26033 = true;
        } else {
            iEntityLivingData2 = new RabbitTypeData(\u26032);
        }
        this.func_175529_r(\u26032);
        if (\u26033) {
            this.func_70873_a(-24000);
        }
        return iEntityLivingData2;
    }

    private int func_184772_dk() {
        Biome biome = this.field_70170_p.func_180494_b(new BlockPos(this));
        int \u26032 = this.field_70146_Z.nextInt(100);
        if (biome.func_201851_b() == Biome.RainType.SNOW) {
            return \u26032 < 80 ? 1 : 3;
        }
        if (biome.func_201856_r() == Biome.Category.DESERT) {
            return 4;
        }
        return \u26032 < 50 ? 0 : (\u26032 < 90 ? 5 : 2);
    }

    @Override
    public boolean func_205020_a(IWorld iWorld, boolean bl) {
        int n = MathHelper.func_76128_c(this.field_70165_t);
        BlockPos \u26032 = new BlockPos(n, \u2603 = MathHelper.func_76128_c(this.func_174813_aQ().field_72338_b), \u2603 = MathHelper.func_76128_c(this.field_70161_v));
        Block \u26033 = iWorld.func_180495_p(\u26032.func_177977_b()).func_177230_c();
        if (\u26033 == Blocks.field_150349_c || \u26033 == Blocks.field_150433_aE || \u26033 == Blocks.field_150354_m) {
            return true;
        }
        return super.func_205020_a(iWorld, bl);
    }

    private boolean func_175534_cv() {
        return this.field_175541_bs == 0;
    }

    @Override
    public void func_70103_a(byte by) {
        if (by == 1) {
            this.func_174808_Z();
            this.field_175535_bn = 10;
            this.field_175540_bm = 0;
        } else {
            super.func_70103_a(by);
        }
    }

    @Override
    public /* synthetic */ EntityAgeable func_90011_a(EntityAgeable entityAgeable) {
        return this.func_90011_a(entityAgeable);
    }

    static class AIEvilAttack
    extends EntityAIAttackMelee {
        public AIEvilAttack(EntityRabbit entityRabbit) {
            super(entityRabbit, 1.4, true);
        }

        @Override
        protected double func_179512_a(EntityLivingBase entityLivingBase) {
            return 4.0f + entityLivingBase.field_70130_N;
        }
    }

    static class AIPanic
    extends EntityAIPanic {
        private final EntityRabbit field_179486_b;

        public AIPanic(EntityRabbit entityRabbit, double d) {
            super(entityRabbit, d);
            this.field_179486_b = entityRabbit;
        }

        @Override
        public void func_75246_d() {
            super.func_75246_d();
            this.field_179486_b.func_175515_b(this.field_75265_b);
        }
    }

    static class AIRaidFarm
    extends EntityAIMoveToBlock {
        private final EntityRabbit field_179500_c;
        private boolean field_179498_d;
        private boolean field_179499_e;

        public AIRaidFarm(EntityRabbit entityRabbit) {
            super(entityRabbit, 0.7f, 16);
            this.field_179500_c = entityRabbit;
        }

        @Override
        public boolean func_75250_a() {
            if (this.field_179496_a <= 0) {
                if (!this.field_179500_c.field_70170_p.func_82736_K().func_82766_b("mobGriefing")) {
                    return false;
                }
                this.field_179499_e = false;
                this.field_179498_d = this.field_179500_c.func_175534_cv();
                this.field_179498_d = true;
            }
            return super.func_75250_a();
        }

        @Override
        public boolean func_75253_b() {
            return this.field_179499_e && super.func_75253_b();
        }

        @Override
        public void func_75246_d() {
            super.func_75246_d();
            this.field_179500_c.func_70671_ap().func_75650_a((double)this.field_179494_b.func_177958_n() + 0.5, this.field_179494_b.func_177956_o() + 1, (double)this.field_179494_b.func_177952_p() + 0.5, 10.0f, this.field_179500_c.func_70646_bf());
            if (this.func_179487_f()) {
                World world = this.field_179500_c.field_70170_p;
                BlockPos \u26032 = this.field_179494_b.func_177984_a();
                IBlockState \u26033 = world.func_180495_p(\u26032);
                Block \u26034 = \u26033.func_177230_c();
                if (this.field_179499_e && \u26034 instanceof BlockCarrot) {
                    Integer n = \u26033.func_177229_b(BlockCarrot.field_176488_a);
                    if (n == 0) {
                        world.func_180501_a(\u26032, Blocks.field_150350_a.func_176223_P(), 2);
                        world.func_175655_b(\u26032, true);
                    } else {
                        world.func_180501_a(\u26032, (IBlockState)\u26033.func_206870_a(BlockCarrot.field_176488_a, n - 1), 2);
                        world.func_175718_b(2001, \u26032, Block.func_196246_j(\u26033));
                    }
                    this.field_179500_c.field_175541_bs = 40;
                }
                this.field_179499_e = false;
                this.field_179496_a = 10;
            }
        }

        @Override
        protected boolean func_179488_a(IWorldReaderBase iWorldReaderBase, BlockPos blockPos) {
            Block block = iWorldReaderBase.func_180495_p(blockPos).func_177230_c();
            if (block == Blocks.field_150458_ak && this.field_179498_d && !this.field_179499_e && (block = (\u2603 = iWorldReaderBase.func_180495_p(blockPos = blockPos.func_177984_a())).func_177230_c()) instanceof BlockCarrot && ((BlockCarrot)block).func_185525_y(\u2603)) {
                this.field_179499_e = true;
                return true;
            }
            return false;
        }
    }

    static class AIAvoidEntity<T extends Entity>
    extends EntityAIAvoidEntity<T> {
        private final EntityRabbit field_179511_d;

        public AIAvoidEntity(EntityRabbit entityRabbit, Class<T> clazz, float f, double d, double d2) {
            super(entityRabbit, clazz, f, d, d2);
            this.field_179511_d = entityRabbit;
        }

        @Override
        public boolean func_75250_a() {
            return this.field_179511_d.func_175531_cl() != 99 && super.func_75250_a();
        }
    }

    static class RabbitMoveHelper
    extends EntityMoveHelper {
        private final EntityRabbit field_179929_g;
        private double field_188492_j;

        public RabbitMoveHelper(EntityRabbit entityRabbit) {
            super(entityRabbit);
            this.field_179929_g = entityRabbit;
        }

        @Override
        public void func_75641_c() {
            if (this.field_179929_g.field_70122_E && !this.field_179929_g.field_70703_bu && !((RabbitJumpHelper)this.field_179929_g.field_70767_i).func_180067_c()) {
                this.field_179929_g.func_175515_b(0.0);
            } else if (this.func_75640_a()) {
                this.field_179929_g.func_175515_b(this.field_188492_j);
            }
            super.func_75641_c();
        }

        @Override
        public void func_75642_a(double d, double d2, double d3, double d4) {
            if (this.field_179929_g.func_70090_H()) {
                d4 = 1.5;
            }
            super.func_75642_a(d, d2, d3, d4);
            if (d4 > 0.0) {
                this.field_188492_j = d4;
            }
        }
    }

    public class RabbitJumpHelper
    extends EntityJumpHelper {
        private final EntityRabbit field_180070_c;
        private boolean field_180068_d;

        public RabbitJumpHelper(EntityRabbit entityRabbit2) {
            super(entityRabbit2);
            this.field_180070_c = entityRabbit2;
        }

        public boolean func_180067_c() {
            return this.field_75662_b;
        }

        public boolean func_180065_d() {
            return this.field_180068_d;
        }

        public void func_180066_a(boolean bl) {
            this.field_180068_d = bl;
        }

        @Override
        public void func_75661_b() {
            if (this.field_75662_b) {
                this.field_180070_c.func_184770_cZ();
                this.field_75662_b = false;
            }
        }
    }

    public static class RabbitTypeData
    implements IEntityLivingData {
        public int field_179427_a;

        public RabbitTypeData(int n) {
            this.field_179427_a = n;
        }
    }
}

