/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.passive;

import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBeg;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAILeapAtTarget;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtByTarget;
import net.minecraft.entity.ai.EntityAIOwnerHurtTarget;
import net.minecraft.entity.ai.EntityAISit;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITargetNonTamed;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.monster.AbstractSkeleton;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.monster.EntityGhast;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.passive.EntityTurtle;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.init.Particles;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.storage.loot.LootTableList;

public class EntityWolf
extends EntityTameable {
    private static final DataParameter<Float> field_184759_bz = EntityDataManager.func_187226_a(EntityWolf.class, DataSerializers.field_187193_c);
    private static final DataParameter<Boolean> field_184760_bA = EntityDataManager.func_187226_a(EntityWolf.class, DataSerializers.field_187198_h);
    private static final DataParameter<Integer> field_184758_bB = EntityDataManager.func_187226_a(EntityWolf.class, DataSerializers.field_187192_b);
    private float field_70926_e;
    private float field_70924_f;
    private boolean field_70925_g;
    private boolean field_70928_h;
    private float field_70929_i;
    private float field_70927_j;

    public EntityWolf(World world) {
        super(EntityType.field_200724_aC, world);
        this.func_70105_a(0.6f, 0.85f);
        this.func_70903_f(false);
    }

    @Override
    protected void func_184651_r() {
        this.field_70911_d = new EntityAISit(this);
        this.field_70714_bg.func_75776_a(1, new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(2, this.field_70911_d);
        this.field_70714_bg.func_75776_a(3, new AIAvoidEntity<EntityLlama>(this, EntityLlama.class, 24.0f, 1.5, 1.5));
        this.field_70714_bg.func_75776_a(4, new EntityAILeapAtTarget(this, 0.4f));
        this.field_70714_bg.func_75776_a(5, new EntityAIAttackMelee(this, 1.0, true));
        this.field_70714_bg.func_75776_a(6, new EntityAIFollowOwner(this, 1.0, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(7, new EntityAIMate(this, 1.0));
        this.field_70714_bg.func_75776_a(8, new EntityAIWanderAvoidWater(this, 1.0));
        this.field_70714_bg.func_75776_a(9, new EntityAIBeg(this, 8.0f));
        this.field_70714_bg.func_75776_a(10, new EntityAIWatchClosest(this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(10, new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(1, new EntityAIOwnerHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, new EntityAIOwnerHurtTarget(this));
        this.field_70715_bh.func_75776_a(3, new EntityAIHurtByTarget((EntityCreature)this, true, new Class[0]));
        this.field_70715_bh.func_75776_a(4, new EntityAITargetNonTamed<EntityAnimal>(this, EntityAnimal.class, false, entityAnimal -> entityAnimal instanceof EntitySheep || entityAnimal instanceof EntityRabbit));
        this.field_70715_bh.func_75776_a(4, new EntityAITargetNonTamed<Entity>(this, EntityTurtle.class, false, EntityTurtle.field_203029_bx));
        this.field_70715_bh.func_75776_a(5, new EntityAINearestAttackableTarget<AbstractSkeleton>((EntityCreature)this, AbstractSkeleton.class, false));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3f);
        if (this.func_70909_n()) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        }
        this.func_110140_aT().func_111150_b(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
    }

    @Override
    public void func_70624_b(@Nullable EntityLivingBase entityLivingBase) {
        super.func_70624_b(entityLivingBase);
        if (entityLivingBase == null) {
            this.func_70916_h(false);
        } else if (!this.func_70909_n()) {
            this.func_70916_h(true);
        }
    }

    @Override
    protected void func_70619_bc() {
        this.field_70180_af.func_187227_b(field_184759_bz, Float.valueOf(this.func_110143_aJ()));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184759_bz, Float.valueOf(this.func_110143_aJ()));
        this.field_70180_af.func_187214_a(field_184760_bA, false);
        this.field_70180_af.func_187214_a(field_184758_bB, EnumDyeColor.RED.func_196059_a());
    }

    @Override
    protected void func_180429_a(BlockPos blockPos, IBlockState iBlockState) {
        this.func_184185_a(SoundEvents.field_187869_gK, 0.15f, 1.0f);
    }

    @Override
    public void func_70014_b(NBTTagCompound nBTTagCompound) {
        super.func_70014_b(nBTTagCompound);
        nBTTagCompound.func_74757_a("Angry", this.func_70919_bu());
        nBTTagCompound.func_74774_a("CollarColor", (byte)this.func_175546_cu().func_196059_a());
    }

    @Override
    public void func_70037_a(NBTTagCompound nBTTagCompound) {
        super.func_70037_a(nBTTagCompound);
        this.func_70916_h(nBTTagCompound.func_74767_n("Angry"));
        if (nBTTagCompound.func_150297_b("CollarColor", 99)) {
            this.func_175547_a(EnumDyeColor.func_196056_a(nBTTagCompound.func_74762_e("CollarColor")));
        }
    }

    @Override
    protected SoundEvent func_184639_G() {
        if (this.func_70919_bu()) {
            return SoundEvents.field_187861_gG;
        }
        if (this.field_70146_Z.nextInt(3) == 0) {
            if (this.func_70909_n() && this.field_70180_af.func_187225_a(field_184759_bz).floatValue() < 10.0f) {
                return SoundEvents.field_187871_gL;
            }
            return SoundEvents.field_187865_gI;
        }
        return SoundEvents.field_187857_gE;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.field_187863_gH;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187859_gF;
    }

    @Override
    protected float func_70599_aP() {
        return 0.4f;
    }

    @Override
    @Nullable
    protected ResourceLocation func_184647_J() {
        return LootTableList.field_186401_I;
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (!this.field_70170_p.field_72995_K && this.field_70925_g && !this.field_70928_h && !this.func_70781_l() && this.field_70122_E) {
            this.field_70928_h = true;
            this.field_70929_i = 0.0f;
            this.field_70927_j = 0.0f;
            this.field_70170_p.func_72960_a(this, (byte)8);
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() == null && this.func_70919_bu()) {
            this.func_70916_h(false);
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70924_f = this.field_70926_e;
        this.field_70926_e = this.func_70922_bv() ? (this.field_70926_e += (1.0f - this.field_70926_e) * 0.4f) : (this.field_70926_e += (0.0f - this.field_70926_e) * 0.4f);
        if (this.func_203008_ap()) {
            this.field_70925_g = true;
            this.field_70928_h = false;
            this.field_70929_i = 0.0f;
            this.field_70927_j = 0.0f;
        } else if ((this.field_70925_g || this.field_70928_h) && this.field_70928_h) {
            if (this.field_70929_i == 0.0f) {
                this.func_184185_a(SoundEvents.field_187867_gJ, this.func_70599_aP(), (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
            }
            this.field_70927_j = this.field_70929_i;
            this.field_70929_i += 0.05f;
            if (this.field_70927_j >= 2.0f) {
                this.field_70925_g = false;
                this.field_70928_h = false;
                this.field_70927_j = 0.0f;
                this.field_70929_i = 0.0f;
            }
            if (this.field_70929_i > 0.4f) {
                float f = (float)this.func_174813_aQ().field_72338_b;
                int \u26032 = (int)(MathHelper.func_76126_a((this.field_70929_i - 0.4f) * (float)Math.PI) * 7.0f);
                for (int i = 0; i < \u26032; ++i) {
                    float f2 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N * 0.5f;
                    \u2603 = (this.field_70146_Z.nextFloat() * 2.0f - 1.0f) * this.field_70130_N * 0.5f;
                    this.field_70170_p.func_195594_a(Particles.field_197606_Q, this.field_70165_t + (double)f2, f + 0.8f, this.field_70161_v + (double)\u2603, this.field_70159_w, this.field_70181_x, this.field_70179_y);
                }
            }
        }
    }

    public boolean func_70921_u() {
        return this.field_70925_g;
    }

    public float func_70915_j(float f) {
        return 0.75f + (this.field_70927_j + (this.field_70929_i - this.field_70927_j) * f) / 2.0f * 0.25f;
    }

    public float func_70923_f(float f, float f2) {
        \u2603 = (this.field_70927_j + (this.field_70929_i - this.field_70927_j) * f + f2) / 1.8f;
        if (\u2603 < 0.0f) {
            \u2603 = 0.0f;
        } else if (\u2603 > 1.0f) {
            \u2603 = 1.0f;
        }
        return MathHelper.func_76126_a(\u2603 * (float)Math.PI) * MathHelper.func_76126_a(\u2603 * (float)Math.PI * 11.0f) * 0.15f * (float)Math.PI;
    }

    public float func_70917_k(float f) {
        return (this.field_70924_f + (this.field_70926_e - this.field_70924_f) * f) * 0.15f * (float)Math.PI;
    }

    @Override
    public float func_70047_e() {
        return this.field_70131_O * 0.8f;
    }

    @Override
    public int func_70646_bf() {
        if (this.func_70906_o()) {
            return 20;
        }
        return super.func_70646_bf();
    }

    @Override
    public boolean func_70097_a(DamageSource damageSource2, float f2) {
        DamageSource damageSource2;
        if (this.func_180431_b(damageSource2)) {
            return false;
        }
        Entity entity = damageSource2.func_76346_g();
        if (this.field_70911_d != null) {
            this.field_70911_d.func_75270_a(false);
        }
        if (entity != null && !(entity instanceof EntityPlayer) && !(entity instanceof EntityArrow)) {
            float f2 = (f2 + 1.0f) / 2.0f;
        }
        return super.func_70097_a(damageSource2, f2);
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        boolean bl = entity.func_70097_a(DamageSource.func_76358_a(this), (int)this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
        if (bl) {
            this.func_174815_a(this, entity);
        }
        return bl;
    }

    @Override
    public void func_70903_f(boolean bl) {
        super.func_70903_f(bl);
        if (bl) {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(20.0);
        } else {
            this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        }
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(4.0);
    }

    @Override
    public boolean func_184645_a(EntityPlayer entityPlayer2, EnumHand enumHand) {
        EntityPlayer entityPlayer2;
        ItemStack itemStack = entityPlayer2.func_184586_b(enumHand);
        Item \u26032 = itemStack.func_77973_b();
        if (this.func_70909_n()) {
            if (!itemStack.func_190926_b()) {
                EnumDyeColor enumDyeColor;
                if (\u26032 instanceof ItemFood) {
                    ItemFood itemFood = (ItemFood)\u26032;
                    if (itemFood.func_77845_h() && this.field_70180_af.func_187225_a(field_184759_bz).floatValue() < 20.0f) {
                        if (!entityPlayer2.field_71075_bZ.field_75098_d) {
                            itemStack.func_190918_g(1);
                        }
                        this.func_70691_i(itemFood.func_150905_g(itemStack));
                        return true;
                    }
                } else if (\u26032 instanceof ItemDye && (enumDyeColor = ((ItemDye)\u26032).func_195962_g()) != this.func_175546_cu()) {
                    this.func_175547_a(enumDyeColor);
                    if (!entityPlayer2.field_71075_bZ.field_75098_d) {
                        itemStack.func_190918_g(1);
                    }
                    return true;
                }
            }
            if (this.func_152114_e(entityPlayer2) && !this.field_70170_p.field_72995_K && !this.func_70877_b(itemStack)) {
                this.field_70911_d.func_75270_a(!this.func_70906_o());
                this.field_70703_bu = false;
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
            }
        } else if (\u26032 == Items.field_151103_aS && !this.func_70919_bu()) {
            if (!entityPlayer2.field_71075_bZ.field_75098_d) {
                itemStack.func_190918_g(1);
            }
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(3) == 0) {
                    this.func_193101_c(entityPlayer2);
                    this.field_70699_by.func_75499_g();
                    this.func_70624_b(null);
                    this.field_70911_d.func_75270_a(true);
                    this.func_70606_j(20.0f);
                    this.func_70908_e(true);
                    this.field_70170_p.func_72960_a(this, (byte)7);
                } else {
                    this.func_70908_e(false);
                    this.field_70170_p.func_72960_a(this, (byte)6);
                }
            }
            return true;
        }
        return super.func_184645_a(entityPlayer2, enumHand);
    }

    @Override
    public void func_70103_a(byte by) {
        if (by == 8) {
            this.field_70928_h = true;
            this.field_70929_i = 0.0f;
            this.field_70927_j = 0.0f;
        } else {
            super.func_70103_a(by);
        }
    }

    public float func_70920_v() {
        if (this.func_70919_bu()) {
            return 1.5393804f;
        }
        if (this.func_70909_n()) {
            return (0.55f - (this.func_110138_aP() - this.field_70180_af.func_187225_a(field_184759_bz).floatValue()) * 0.02f) * (float)Math.PI;
        }
        return 0.62831855f;
    }

    @Override
    public boolean func_70877_b(ItemStack itemStack) {
        Item item = itemStack.func_77973_b();
        return item instanceof ItemFood && ((ItemFood)item).func_77845_h();
    }

    @Override
    public int func_70641_bl() {
        return 8;
    }

    public boolean func_70919_bu() {
        return ((Byte)this.field_70180_af.func_187225_a(field_184755_bv) & 2) != 0;
    }

    public void func_70916_h(boolean bl) {
        byte by = (Byte)this.field_70180_af.func_187225_a(field_184755_bv);
        if (bl) {
            this.field_70180_af.func_187227_b(field_184755_bv, (byte)(by | 2));
        } else {
            this.field_70180_af.func_187227_b(field_184755_bv, (byte)(by & 0xFFFFFFFD));
        }
    }

    public EnumDyeColor func_175546_cu() {
        return EnumDyeColor.func_196056_a(this.field_70180_af.func_187225_a(field_184758_bB));
    }

    public void func_175547_a(EnumDyeColor enumDyeColor) {
        this.field_70180_af.func_187227_b(field_184758_bB, enumDyeColor.func_196059_a());
    }

    @Override
    public EntityWolf func_90011_a(EntityAgeable entityAgeable) {
        EntityWolf entityWolf = new EntityWolf(this.field_70170_p);
        UUID \u26032 = this.func_184753_b();
        if (\u26032 != null) {
            entityWolf.func_184754_b(\u26032);
            entityWolf.func_70903_f(true);
        }
        return entityWolf;
    }

    public void func_70918_i(boolean bl) {
        this.field_70180_af.func_187227_b(field_184760_bA, bl);
    }

    @Override
    public boolean func_70878_b(EntityAnimal entityAnimal) {
        if (entityAnimal == this) {
            return false;
        }
        if (!this.func_70909_n()) {
            return false;
        }
        if (!(entityAnimal instanceof EntityWolf)) {
            return false;
        }
        EntityWolf entityWolf = (EntityWolf)entityAnimal;
        if (!entityWolf.func_70909_n()) {
            return false;
        }
        if (entityWolf.func_70906_o()) {
            return false;
        }
        return this.func_70880_s() && entityWolf.func_70880_s();
    }

    public boolean func_70922_bv() {
        return this.field_70180_af.func_187225_a(field_184760_bA);
    }

    @Override
    public boolean func_142018_a(EntityLivingBase entityLivingBase, EntityLivingBase entityLivingBase2) {
        if (entityLivingBase instanceof EntityCreeper || entityLivingBase instanceof EntityGhast) {
            return false;
        }
        if (entityLivingBase instanceof EntityWolf && (\u2603 = (EntityWolf)entityLivingBase).func_70909_n() && \u2603.func_70902_q() == entityLivingBase2) {
            return false;
        }
        if (entityLivingBase instanceof EntityPlayer && entityLivingBase2 instanceof EntityPlayer && !((EntityPlayer)entityLivingBase2).func_96122_a((EntityPlayer)entityLivingBase)) {
            return false;
        }
        return !(entityLivingBase instanceof AbstractHorse) || !((AbstractHorse)entityLivingBase).func_110248_bS();
    }

    @Override
    public boolean func_184652_a(EntityPlayer entityPlayer) {
        return !this.func_70919_bu() && super.func_184652_a(entityPlayer);
    }

    @Override
    public /* synthetic */ EntityAgeable func_90011_a(EntityAgeable entityAgeable) {
        return this.func_90011_a(entityAgeable);
    }

    class AIAvoidEntity<T extends Entity>
    extends EntityAIAvoidEntity<T> {
        private final EntityWolf field_190856_d;

        public AIAvoidEntity(EntityWolf entityWolf2, Class<T> clazz, float f, double d, double d2) {
            super(entityWolf2, clazz, f, d, d2);
            this.field_190856_d = entityWolf2;
        }

        @Override
        public boolean func_75250_a() {
            if (super.func_75250_a() && this.field_75376_d instanceof EntityLlama) {
                return !this.field_190856_d.func_70909_n() && this.func_190854_a((EntityLlama)this.field_75376_d);
            }
            return false;
        }

        private boolean func_190854_a(EntityLlama entityLlama) {
            return entityLlama.func_190707_dL() >= EntityWolf.this.field_70146_Z.nextInt(5);
        }

        @Override
        public void func_75249_e() {
            EntityWolf.this.func_70624_b(null);
            super.func_75249_e();
        }

        @Override
        public void func_75246_d() {
            EntityWolf.this.func_70624_b(null);
            super.func_75246_d();
        }
    }
}

