/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.player;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.crash.ReportedException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.RecipeItemHelper;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.tags.Tag;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;

public class InventoryPlayer
implements IInventory {
    public final NonNullList<ItemStack> field_70462_a = NonNullList.func_191197_a(36, ItemStack.field_190927_a);
    public final NonNullList<ItemStack> field_70460_b = NonNullList.func_191197_a(4, ItemStack.field_190927_a);
    public final NonNullList<ItemStack> field_184439_c = NonNullList.func_191197_a(1, ItemStack.field_190927_a);
    private final List<NonNullList<ItemStack>> field_184440_g = ImmutableList.of(this.field_70462_a, this.field_70460_b, this.field_184439_c);
    public int field_70461_c;
    public EntityPlayer field_70458_d;
    private ItemStack field_70457_g = ItemStack.field_190927_a;
    private int field_194017_h;

    public InventoryPlayer(EntityPlayer entityPlayer) {
        this.field_70458_d = entityPlayer;
    }

    public ItemStack func_70448_g() {
        if (InventoryPlayer.func_184435_e(this.field_70461_c)) {
            return this.field_70462_a.get(this.field_70461_c);
        }
        return ItemStack.field_190927_a;
    }

    public static int func_70451_h() {
        return 9;
    }

    private boolean func_184436_a(ItemStack itemStack, ItemStack itemStack2) {
        return !itemStack.func_190926_b() && this.func_184431_b(itemStack, itemStack2) && itemStack.func_77985_e() && itemStack.func_190916_E() < itemStack.func_77976_d() && itemStack.func_190916_E() < this.func_70297_j_();
    }

    private boolean func_184431_b(ItemStack itemStack, ItemStack itemStack2) {
        return itemStack.func_77973_b() == itemStack2.func_77973_b() && ItemStack.func_77970_a(itemStack, itemStack2);
    }

    public int func_70447_i() {
        for (int i = 0; i < this.field_70462_a.size(); ++i) {
            if (!this.field_70462_a.get(i).func_190926_b()) continue;
            return i;
        }
        return -1;
    }

    public void func_184434_a(ItemStack itemStack) {
        int n = this.func_184429_b(itemStack);
        if (InventoryPlayer.func_184435_e(n)) {
            this.field_70461_c = n;
            return;
        }
        if (n == -1) {
            this.field_70461_c = this.func_184433_k();
            if (!this.field_70462_a.get(this.field_70461_c).func_190926_b() && (\u2603 = this.func_70447_i()) != -1) {
                this.field_70462_a.set(\u2603, this.field_70462_a.get(this.field_70461_c));
            }
            this.field_70462_a.set(this.field_70461_c, itemStack);
        } else {
            this.func_184430_d(n);
        }
    }

    public void func_184430_d(int n) {
        this.field_70461_c = this.func_184433_k();
        ItemStack itemStack = this.field_70462_a.get(this.field_70461_c);
        this.field_70462_a.set(this.field_70461_c, this.field_70462_a.get(n));
        this.field_70462_a.set(n, itemStack);
    }

    public static boolean func_184435_e(int n) {
        return n >= 0 && n < 9;
    }

    public int func_184429_b(ItemStack itemStack) {
        for (int i = 0; i < this.field_70462_a.size(); ++i) {
            if (this.field_70462_a.get(i).func_190926_b() || !this.func_184431_b(itemStack, this.field_70462_a.get(i))) continue;
            return i;
        }
        return -1;
    }

    public int func_194014_c(ItemStack itemStack) {
        for (int i = 0; i < this.field_70462_a.size(); ++i) {
            ItemStack itemStack2 = this.field_70462_a.get(i);
            if (this.field_70462_a.get(i).func_190926_b() || !this.func_184431_b(itemStack, this.field_70462_a.get(i)) || this.field_70462_a.get(i).func_77951_h() || itemStack2.func_77948_v() || itemStack2.func_82837_s()) continue;
            return i;
        }
        return -1;
    }

    public int func_184433_k() {
        int n;
        for (n = 0; n < 9; ++n) {
            \u2603 = (this.field_70461_c + n) % 9;
            if (!this.field_70462_a.get(\u2603).func_190926_b()) continue;
            return \u2603;
        }
        for (n = 0; n < 9; ++n) {
            \u2603 = (this.field_70461_c + n) % 9;
            if (this.field_70462_a.get(\u2603).func_77948_v()) continue;
            return \u2603;
        }
        return this.field_70461_c;
    }

    public void func_195409_a(double d) {
        if (d > 0.0) {
            d = 1.0;
        }
        if (d < 0.0) {
            d = -1.0;
        }
        this.field_70461_c = (int)((double)this.field_70461_c - d);
        while (this.field_70461_c < 0) {
            this.field_70461_c += 9;
        }
        while (this.field_70461_c >= 9) {
            this.field_70461_c -= 9;
        }
    }

    public int func_195408_a(Predicate<ItemStack> predicate, int n) {
        int n2;
        n2 = 0;
        for (n3 = 0; n3 < this.func_70302_i_(); ++n3) {
            ItemStack itemStack = this.func_70301_a(n3);
            if (itemStack.func_190926_b() || !predicate.test(itemStack)) continue;
            int \u26032 = n <= 0 ? itemStack.func_190916_E() : Math.min(n - n2, itemStack.func_190916_E());
            n2 += \u26032;
            if (n == 0) continue;
            itemStack.func_190918_g(\u26032);
            if (itemStack.func_190926_b()) {
                this.func_70299_a(n3, ItemStack.field_190927_a);
            }
            if (n <= 0 || n2 < n) continue;
            return n2;
        }
        if (!this.field_70457_g.func_190926_b() && predicate.test(this.field_70457_g)) {
            int n3 = n <= 0 ? this.field_70457_g.func_190916_E() : Math.min(n - n2, this.field_70457_g.func_190916_E());
            n2 += n3;
            if (n != 0) {
                this.field_70457_g.func_190918_g(n3);
                if (this.field_70457_g.func_190926_b()) {
                    this.field_70457_g = ItemStack.field_190927_a;
                }
                if (n > 0 && n2 >= n) {
                    return n2;
                }
            }
        }
        return n2;
    }

    private int func_70452_e(ItemStack itemStack) {
        int n = this.func_70432_d(itemStack);
        if (n == -1) {
            n = this.func_70447_i();
        }
        if (n == -1) {
            return itemStack.func_190916_E();
        }
        return this.func_191973_d(n, itemStack);
    }

    private int func_191973_d(int n, ItemStack itemStack) {
        int n2;
        Item item = itemStack.func_77973_b();
        int \u26032 = itemStack.func_190916_E();
        ItemStack \u26033 = this.func_70301_a(n);
        if (\u26033.func_190926_b()) {
            \u26033 = new ItemStack(item, 0);
            if (itemStack.func_77942_o()) {
                \u26033.func_77982_d(itemStack.func_77978_p().func_74737_b());
            }
            this.func_70299_a(n, \u26033);
        }
        if ((n2 = \u26032) > \u26033.func_77976_d() - \u26033.func_190916_E()) {
            n2 = \u26033.func_77976_d() - \u26033.func_190916_E();
        }
        if (n2 > this.func_70297_j_() - \u26033.func_190916_E()) {
            n2 = this.func_70297_j_() - \u26033.func_190916_E();
        }
        if (n2 == 0) {
            return \u26032;
        }
        \u26033.func_190917_f(n2);
        \u26033.func_190915_d(5);
        return \u26032 -= n2;
    }

    public int func_70432_d(ItemStack itemStack) {
        if (this.func_184436_a(this.func_70301_a(this.field_70461_c), itemStack)) {
            return this.field_70461_c;
        }
        if (this.func_184436_a(this.func_70301_a(40), itemStack)) {
            return 40;
        }
        for (int i = 0; i < this.field_70462_a.size(); ++i) {
            if (!this.func_184436_a(this.field_70462_a.get(i), itemStack)) continue;
            return i;
        }
        return -1;
    }

    public void func_70429_k() {
        for (NonNullList<ItemStack> nonNullList : this.field_184440_g) {
            for (int i = 0; i < nonNullList.size(); ++i) {
                if (nonNullList.get(i).func_190926_b()) continue;
                nonNullList.get(i).func_77945_a(this.field_70458_d.field_70170_p, this.field_70458_d, i, this.field_70461_c == i);
            }
        }
    }

    public boolean func_70441_a(ItemStack itemStack) {
        return this.func_191971_c(-1, itemStack);
    }

    public boolean func_191971_c(int n2, ItemStack itemStack2) {
        if (itemStack2.func_190926_b()) {
            return false;
        }
        try {
            int n2;
            if (!itemStack2.func_77951_h()) {
                ItemStack itemStack2;
                do {
                    int n3 = itemStack2.func_190916_E();
                    if (n2 == -1) {
                        itemStack2.func_190920_e(this.func_70452_e(itemStack2));
                        continue;
                    }
                    itemStack2.func_190920_e(this.func_191973_d(n2, itemStack2));
                } while (!itemStack2.func_190926_b() && itemStack2.func_190916_E() < n3);
                if (itemStack2.func_190916_E() == n3 && this.field_70458_d.field_71075_bZ.field_75098_d) {
                    itemStack2.func_190920_e(0);
                    return true;
                }
                return itemStack2.func_190916_E() < n3;
            }
            if (n2 == -1) {
                n2 = this.func_70447_i();
            }
            if (n2 >= 0) {
                this.field_70462_a.set(n2, itemStack2.func_77946_l());
                this.field_70462_a.get(n2).func_190915_d(5);
                itemStack2.func_190920_e(0);
                return true;
            }
            if (this.field_70458_d.field_71075_bZ.field_75098_d) {
                itemStack2.func_190920_e(0);
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.func_85055_a(throwable, "Adding item to inventory");
            CrashReportCategory \u26032 = crashReport.func_85058_a("Item being added");
            \u26032.func_71507_a("Item ID", Item.func_150891_b(itemStack2.func_77973_b()));
            \u26032.func_71507_a("Item data", itemStack2.func_77952_i());
            \u26032.func_189529_a("Item name", () -> itemStack2.func_200301_q().getString());
            throw new ReportedException(crashReport);
        }
    }

    public void func_191975_a(World world, ItemStack itemStack) {
        if (world.field_72995_K) {
            return;
        }
        while (!itemStack.func_190926_b()) {
            int n = this.func_70432_d(itemStack);
            if (n == -1) {
                n = this.func_70447_i();
            }
            if (n == -1) {
                this.field_70458_d.func_71019_a(itemStack, false);
                break;
            }
            \u2603 = itemStack.func_77976_d() - this.func_70301_a(n).func_190916_E();
            if (!this.func_191971_c(n, itemStack.func_77979_a(\u2603))) continue;
            ((EntityPlayerMP)this.field_70458_d).field_71135_a.func_147359_a(new SPacketSetSlot(-2, n, this.func_70301_a(n)));
        }
    }

    @Override
    public ItemStack func_70298_a(int n, int n2) {
        NonNullList<ItemStack> nonNullList = null;
        for (NonNullList<ItemStack> nonNullList2 : this.field_184440_g) {
            if (n < nonNullList2.size()) {
                nonNullList = nonNullList2;
                break;
            }
            n -= nonNullList2.size();
        }
        if (nonNullList != null && !((ItemStack)nonNullList.get(n)).func_190926_b()) {
            return ItemStackHelper.func_188382_a(nonNullList, n, n2);
        }
        return ItemStack.field_190927_a;
    }

    public void func_184437_d(ItemStack itemStack) {
        block0: for (NonNullList<ItemStack> nonNullList : this.field_184440_g) {
            for (int i = 0; i < nonNullList.size(); ++i) {
                if (nonNullList.get(i) != itemStack) continue;
                nonNullList.set(i, ItemStack.field_190927_a);
                continue block0;
            }
        }
    }

    @Override
    public ItemStack func_70304_b(int n) {
        NonNullList<ItemStack> nonNullList = null;
        for (NonNullList<ItemStack> nonNullList2 : this.field_184440_g) {
            if (n < nonNullList2.size()) {
                nonNullList = nonNullList2;
                break;
            }
            n -= nonNullList2.size();
        }
        if (nonNullList != null && !((ItemStack)nonNullList.get(n)).func_190926_b()) {
            ItemStack itemStack = nonNullList.get(n);
            nonNullList.set(n, ItemStack.field_190927_a);
            return itemStack;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void func_70299_a(int n, ItemStack itemStack) {
        NonNullList<ItemStack> nonNullList = null;
        for (NonNullList<ItemStack> nonNullList2 : this.field_184440_g) {
            if (n < nonNullList2.size()) {
                nonNullList = nonNullList2;
                break;
            }
            n -= nonNullList2.size();
        }
        if (nonNullList != null) {
            nonNullList.set(n, itemStack);
        }
    }

    public float func_184438_a(IBlockState iBlockState) {
        return this.field_70462_a.get(this.field_70461_c).func_150997_a(iBlockState);
    }

    public NBTTagList func_70442_a(NBTTagList nBTTagList2) {
        NBTTagList nBTTagList2;
        NBTTagCompound nBTTagCompound;
        int n;
        for (n = 0; n < this.field_70462_a.size(); ++n) {
            if (this.field_70462_a.get(n).func_190926_b()) continue;
            nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74774_a("Slot", (byte)n);
            this.field_70462_a.get(n).func_77955_b(nBTTagCompound);
            nBTTagList2.add(nBTTagCompound);
        }
        for (n = 0; n < this.field_70460_b.size(); ++n) {
            if (this.field_70460_b.get(n).func_190926_b()) continue;
            nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74774_a("Slot", (byte)(n + 100));
            this.field_70460_b.get(n).func_77955_b(nBTTagCompound);
            nBTTagList2.add(nBTTagCompound);
        }
        for (n = 0; n < this.field_184439_c.size(); ++n) {
            if (this.field_184439_c.get(n).func_190926_b()) continue;
            nBTTagCompound = new NBTTagCompound();
            nBTTagCompound.func_74774_a("Slot", (byte)(n + 150));
            this.field_184439_c.get(n).func_77955_b(nBTTagCompound);
            nBTTagList2.add(nBTTagCompound);
        }
        return nBTTagList2;
    }

    public void func_70443_b(NBTTagList nBTTagList) {
        this.field_70462_a.clear();
        this.field_70460_b.clear();
        this.field_184439_c.clear();
        for (int i = 0; i < nBTTagList.size(); ++i) {
            NBTTagCompound nBTTagCompound = nBTTagList.func_150305_b(i);
            int \u26032 = nBTTagCompound.func_74771_c("Slot") & 0xFF;
            ItemStack \u26033 = ItemStack.func_199557_a(nBTTagCompound);
            if (\u26033.func_190926_b()) continue;
            if (\u26032 >= 0 && \u26032 < this.field_70462_a.size()) {
                this.field_70462_a.set(\u26032, \u26033);
                continue;
            }
            if (\u26032 >= 100 && \u26032 < this.field_70460_b.size() + 100) {
                this.field_70460_b.set(\u26032 - 100, \u26033);
                continue;
            }
            if (\u26032 < 150 || \u26032 >= this.field_184439_c.size() + 150) continue;
            this.field_184439_c.set(\u26032 - 150, \u26033);
        }
    }

    @Override
    public int func_70302_i_() {
        return this.field_70462_a.size() + this.field_70460_b.size() + this.field_184439_c.size();
    }

    @Override
    public boolean func_191420_l() {
        for (ItemStack itemStack : this.field_70462_a) {
            if (itemStack.func_190926_b()) continue;
            return false;
        }
        for (ItemStack itemStack : this.field_70460_b) {
            if (itemStack.func_190926_b()) continue;
            return false;
        }
        for (ItemStack itemStack : this.field_184439_c) {
            if (itemStack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ItemStack func_70301_a(int n) {
        NonNullList<ItemStack> nonNullList = null;
        for (NonNullList<ItemStack> nonNullList2 : this.field_184440_g) {
            if (n < nonNullList2.size()) {
                nonNullList = nonNullList2;
                break;
            }
            n -= nonNullList2.size();
        }
        return nonNullList == null ? ItemStack.field_190927_a : (ItemStack)nonNullList.get(n);
    }

    @Override
    public ITextComponent func_200200_C_() {
        return new TextComponentTranslation("container.inventory", new Object[0]);
    }

    @Override
    @Nullable
    public ITextComponent func_200201_e() {
        return null;
    }

    @Override
    public boolean func_145818_k_() {
        return false;
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    public boolean func_184432_b(IBlockState iBlockState) {
        return this.func_70301_a(this.field_70461_c).func_150998_b(iBlockState);
    }

    public ItemStack func_70440_f(int n) {
        return this.field_70460_b.get(n);
    }

    public void func_70449_g(float f) {
        if (f <= 0.0f) {
            return;
        }
        if ((f /= 4.0f) < 1.0f) {
            f = 1.0f;
        }
        for (int i = 0; i < this.field_70460_b.size(); ++i) {
            ItemStack itemStack = this.field_70460_b.get(i);
            if (!(itemStack.func_77973_b() instanceof ItemArmor)) continue;
            itemStack.func_77972_a((int)f, this.field_70458_d);
        }
    }

    public void func_70436_m() {
        for (List list : this.field_184440_g) {
            for (int i = 0; i < list.size(); ++i) {
                ItemStack itemStack = (ItemStack)list.get(i);
                if (itemStack.func_190926_b()) continue;
                this.field_70458_d.func_146097_a(itemStack, true, false);
                list.set(i, ItemStack.field_190927_a);
            }
        }
    }

    @Override
    public void func_70296_d() {
        ++this.field_194017_h;
    }

    public int func_194015_p() {
        return this.field_194017_h;
    }

    public void func_70437_b(ItemStack itemStack) {
        this.field_70457_g = itemStack;
    }

    public ItemStack func_70445_o() {
        return this.field_70457_g;
    }

    @Override
    public boolean func_70300_a(EntityPlayer entityPlayer) {
        if (this.field_70458_d.field_70128_L) {
            return false;
        }
        return !(entityPlayer.func_70068_e(this.field_70458_d) > 64.0);
    }

    public boolean func_70431_c(ItemStack itemStack) {
        for (List list : this.field_184440_g) {
            for (ItemStack itemStack2 : list) {
                if (itemStack2.func_190926_b() || !itemStack2.func_77969_a(itemStack)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean func_199712_a(Tag<Item> tag) {
        for (List list : this.field_184440_g) {
            for (ItemStack itemStack : list) {
                if (itemStack.func_190926_b() || !tag.func_199685_a_(itemStack.func_77973_b())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void func_174889_b(EntityPlayer entityPlayer) {
    }

    @Override
    public void func_174886_c(EntityPlayer entityPlayer) {
    }

    @Override
    public boolean func_94041_b(int n, ItemStack itemStack) {
        return true;
    }

    public void func_70455_b(InventoryPlayer inventoryPlayer2) {
        InventoryPlayer inventoryPlayer2;
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            this.func_70299_a(i, inventoryPlayer2.func_70301_a(i));
        }
        this.field_70461_c = inventoryPlayer2.field_70461_c;
    }

    @Override
    public int func_174887_a_(int n) {
        return 0;
    }

    @Override
    public void func_174885_b(int n, int n2) {
    }

    @Override
    public int func_174890_g() {
        return 0;
    }

    @Override
    public void func_174888_l() {
        for (List list : this.field_184440_g) {
            list.clear();
        }
    }

    public void func_201571_a(RecipeItemHelper recipeItemHelper) {
        for (ItemStack itemStack : this.field_70462_a) {
            recipeItemHelper.func_195932_a(itemStack);
        }
    }
}

