/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.entity.EntityAreaEffectCloud;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.monster.EntityBlaze;
import net.minecraft.entity.monster.EntityEnderman;
import net.minecraft.entity.projectile.EntityThrowable;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EntityPotion
extends EntityThrowable {
    private static final DataParameter<ItemStack> field_184545_d = EntityDataManager.func_187226_a(EntityPotion.class, DataSerializers.field_187196_f);
    private static final Logger field_184546_e = LogManager.getLogger();
    public static final Predicate<EntityLivingBase> field_190546_d = EntityPotion::func_190544_c;

    public EntityPotion(World world) {
        super(EntityType.field_200754_at, world);
    }

    public EntityPotion(World world, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        super(EntityType.field_200754_at, entityLivingBase, world);
        this.func_184541_a(itemStack);
    }

    public EntityPotion(World world, double d, double d2, double d3, ItemStack itemStack) {
        super(EntityType.field_200754_at, d, d2, d3, world);
        if (!itemStack.func_190926_b()) {
            this.func_184541_a(itemStack);
        }
    }

    @Override
    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(field_184545_d, ItemStack.field_190927_a);
    }

    public ItemStack func_184543_l() {
        ItemStack itemStack = this.func_184212_Q().func_187225_a(field_184545_d);
        if (itemStack.func_77973_b() != Items.field_185155_bH && itemStack.func_77973_b() != Items.field_185156_bI) {
            if (this.field_70170_p != null) {
                field_184546_e.error("ThrownPotion entity {} has no item?!", (Object)this.func_145782_y());
            }
            return new ItemStack(Items.field_185155_bH);
        }
        return itemStack;
    }

    public void func_184541_a(ItemStack itemStack) {
        this.func_184212_Q().func_187227_b(field_184545_d, itemStack);
    }

    @Override
    protected float func_70185_h() {
        return 0.05f;
    }

    @Override
    protected void func_70184_a(RayTraceResult rayTraceResult) {
        boolean bl;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        ItemStack itemStack = this.func_184543_l();
        PotionType \u26032 = PotionUtils.func_185191_c(itemStack);
        List<PotionEffect> \u26033 = PotionUtils.func_185189_a(itemStack);
        boolean bl2 = bl = \u26032 == PotionTypes.field_185230_b && \u26033.isEmpty();
        if (rayTraceResult.field_72313_a == RayTraceResult.Type.BLOCK && bl) {
            BlockPos blockPos = rayTraceResult.func_178782_a().func_177972_a(rayTraceResult.field_178784_b);
            this.func_184542_a(blockPos, rayTraceResult.field_178784_b);
            for (EnumFacing enumFacing : EnumFacing.Plane.HORIZONTAL) {
                this.func_184542_a(blockPos.func_177972_a(enumFacing), enumFacing);
            }
        }
        if (bl) {
            this.func_190545_n();
        } else if (!\u26033.isEmpty()) {
            if (this.func_184544_n()) {
                this.func_190542_a(itemStack, \u26032);
            } else {
                this.func_190543_a(rayTraceResult, \u26033);
            }
        }
        int \u26034 = \u26032.func_185172_c() ? 2007 : 2002;
        this.field_70170_p.func_175718_b(\u26034, new BlockPos(this), PotionUtils.func_190932_c(itemStack));
        this.func_70106_y();
    }

    private void func_190545_n() {
        AxisAlignedBB axisAlignedBB = this.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0);
        List<EntityLivingBase> \u26032 = this.field_70170_p.func_175647_a(EntityLivingBase.class, axisAlignedBB, field_190546_d);
        if (!\u26032.isEmpty()) {
            for (EntityLivingBase entityLivingBase : \u26032) {
                double d = this.func_70068_e(entityLivingBase);
                if (!(d < 16.0) || !EntityPotion.func_190544_c(entityLivingBase)) continue;
                entityLivingBase.func_70097_a(DamageSource.field_76369_e, 1.0f);
            }
        }
    }

    private void func_190543_a(RayTraceResult rayTraceResult, List<PotionEffect> list) {
        AxisAlignedBB axisAlignedBB = this.func_174813_aQ().func_72314_b(4.0, 2.0, 4.0);
        List<EntityLivingBase> \u26032 = this.field_70170_p.func_72872_a(EntityLivingBase.class, axisAlignedBB);
        if (!\u26032.isEmpty()) {
            for (EntityLivingBase entityLivingBase : \u26032) {
                if (!entityLivingBase.func_184603_cC() || !((\u2603 = this.func_70068_e(entityLivingBase)) < 16.0)) continue;
                double d = 1.0 - Math.sqrt(\u2603) / 4.0;
                if (entityLivingBase == rayTraceResult.field_72308_g) {
                    d = 1.0;
                }
                for (PotionEffect potionEffect : list) {
                    Potion potion = potionEffect.func_188419_a();
                    if (potion.func_76403_b()) {
                        potion.func_180793_a(this, this.func_85052_h(), entityLivingBase, potionEffect.func_76458_c(), d);
                        continue;
                    }
                    int \u26033 = (int)(d * (double)potionEffect.func_76459_b() + 0.5);
                    if (\u26033 <= 20) continue;
                    entityLivingBase.func_195064_c(new PotionEffect(potion, \u26033, potionEffect.func_76458_c(), potionEffect.func_82720_e(), potionEffect.func_188418_e()));
                }
            }
        }
    }

    private void func_190542_a(ItemStack itemStack2, PotionType potionType) {
        ItemStack itemStack2;
        EntityAreaEffectCloud entityAreaEffectCloud = new EntityAreaEffectCloud(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v);
        entityAreaEffectCloud.func_184481_a(this.func_85052_h());
        entityAreaEffectCloud.func_184483_a(3.0f);
        entityAreaEffectCloud.func_184495_b(-0.5f);
        entityAreaEffectCloud.func_184485_d(10);
        entityAreaEffectCloud.func_184487_c(-entityAreaEffectCloud.func_184490_j() / (float)entityAreaEffectCloud.func_184489_o());
        entityAreaEffectCloud.func_184484_a(potionType);
        for (PotionEffect potionEffect : PotionUtils.func_185190_b(itemStack2)) {
            entityAreaEffectCloud.func_184496_a(new PotionEffect(potionEffect));
        }
        NBTTagCompound \u26032 = itemStack2.func_77978_p();
        if (\u26032 != null && \u26032.func_150297_b("CustomPotionColor", 99)) {
            entityAreaEffectCloud.func_184482_a(\u26032.func_74762_e("CustomPotionColor"));
        }
        this.field_70170_p.func_72838_d(entityAreaEffectCloud);
    }

    private boolean func_184544_n() {
        return this.func_184543_l().func_77973_b() == Items.field_185156_bI;
    }

    private void func_184542_a(BlockPos blockPos, EnumFacing enumFacing) {
        if (this.field_70170_p.func_180495_p(blockPos).func_177230_c() == Blocks.field_150480_ab) {
            this.field_70170_p.func_175719_a(null, blockPos.func_177972_a(enumFacing), enumFacing.func_176734_d());
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nBTTagCompound) {
        super.func_70037_a(nBTTagCompound);
        ItemStack itemStack = ItemStack.func_199557_a(nBTTagCompound.func_74775_l("Potion"));
        if (itemStack.func_190926_b()) {
            this.func_70106_y();
        } else {
            this.func_184541_a(itemStack);
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound nBTTagCompound) {
        super.func_70014_b(nBTTagCompound);
        ItemStack itemStack = this.func_184543_l();
        if (!itemStack.func_190926_b()) {
            nBTTagCompound.func_74782_a("Potion", itemStack.func_77955_b(new NBTTagCompound()));
        }
    }

    private static boolean func_190544_c(EntityLivingBase entityLivingBase) {
        return entityLivingBase instanceof EntityEnderman || entityLivingBase instanceof EntityBlaze;
    }
}

