/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.projectile;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.init.Particles;
import net.minecraft.init.PotionTypes;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.World;

public class EntityTippedArrow
extends EntityArrow {
    private static final DataParameter<Integer> field_184559_f = EntityDataManager.func_187226_a(EntityTippedArrow.class, DataSerializers.field_187192_b);
    private PotionType field_184560_g = PotionTypes.field_185229_a;
    private final Set<PotionEffect> field_184561_h = Sets.newHashSet();
    private boolean field_191509_at;

    public EntityTippedArrow(World world) {
        super(EntityType.field_200790_d, world);
    }

    public EntityTippedArrow(World world, double d, double d2, double d3) {
        super(EntityType.field_200790_d, d, d2, d3, world);
    }

    public EntityTippedArrow(World world, EntityLivingBase entityLivingBase) {
        super(EntityType.field_200790_d, entityLivingBase, world);
    }

    public void func_184555_a(ItemStack itemStack2) {
        ItemStack itemStack2;
        if (itemStack2.func_77973_b() == Items.field_185167_i) {
            int n;
            this.field_184560_g = PotionUtils.func_185191_c(itemStack2);
            List<PotionEffect> list = PotionUtils.func_185190_b(itemStack2);
            if (!list.isEmpty()) {
                for (PotionEffect potionEffect : list) {
                    this.field_184561_h.add(new PotionEffect(potionEffect));
                }
            }
            if ((n = EntityTippedArrow.func_191508_b(itemStack2)) == -1) {
                this.func_190548_o();
            } else {
                this.func_191507_d(n);
            }
        } else if (itemStack2.func_77973_b() == Items.field_151032_g) {
            this.field_184560_g = PotionTypes.field_185229_a;
            this.field_184561_h.clear();
            this.field_70180_af.func_187227_b(field_184559_f, -1);
        }
    }

    public static int func_191508_b(ItemStack itemStack) {
        NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
        if (nBTTagCompound != null && nBTTagCompound.func_150297_b("CustomPotionColor", 99)) {
            return nBTTagCompound.func_74762_e("CustomPotionColor");
        }
        return -1;
    }

    private void func_190548_o() {
        this.field_191509_at = false;
        this.field_70180_af.func_187227_b(field_184559_f, PotionUtils.func_185181_a(PotionUtils.func_185186_a(this.field_184560_g, this.field_184561_h)));
    }

    public void func_184558_a(PotionEffect potionEffect) {
        this.field_184561_h.add(potionEffect);
        this.func_184212_Q().func_187227_b(field_184559_f, PotionUtils.func_185181_a(PotionUtils.func_185186_a(this.field_184560_g, this.field_184561_h)));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(field_184559_f, -1);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            if (this.field_70254_i) {
                if (this.field_184552_b % 5 == 0) {
                    this.func_184556_b(1);
                }
            } else {
                this.func_184556_b(2);
            }
        } else if (this.field_70254_i && this.field_184552_b != 0 && !this.field_184561_h.isEmpty() && this.field_184552_b >= 600) {
            this.field_70170_p.func_72960_a(this, (byte)0);
            this.field_184560_g = PotionTypes.field_185229_a;
            this.field_184561_h.clear();
            this.field_70180_af.func_187227_b(field_184559_f, -1);
        }
    }

    private void func_184556_b(int n) {
        \u2603 = this.func_184557_n();
        if (\u2603 == -1 || n <= 0) {
            return;
        }
        double d = (double)(\u2603 >> 16 & 0xFF) / 255.0;
        \u2603 = (double)(\u2603 >> 8 & 0xFF) / 255.0;
        \u2603 = (double)(\u2603 >> 0 & 0xFF) / 255.0;
        for (int i = 0; i < n; ++i) {
            this.field_70170_p.func_195594_a(Particles.field_197625_r, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, d, \u2603, \u2603);
        }
    }

    public int func_184557_n() {
        return this.field_70180_af.func_187225_a(field_184559_f);
    }

    private void func_191507_d(int n) {
        this.field_191509_at = true;
        this.field_70180_af.func_187227_b(field_184559_f, n);
    }

    @Override
    public void func_70014_b(NBTTagCompound nBTTagCompound2) {
        super.func_70014_b(nBTTagCompound2);
        if (this.field_184560_g != PotionTypes.field_185229_a && this.field_184560_g != null) {
            nBTTagCompound2.func_74778_a("Potion", IRegistry.field_212621_j.func_177774_c(this.field_184560_g).toString());
        }
        if (this.field_191509_at) {
            nBTTagCompound2.func_74768_a("Color", this.func_184557_n());
        }
        if (!this.field_184561_h.isEmpty()) {
            NBTTagCompound nBTTagCompound2;
            NBTTagList nBTTagList = new NBTTagList();
            for (PotionEffect potionEffect : this.field_184561_h) {
                nBTTagList.add(potionEffect.func_82719_a(new NBTTagCompound()));
            }
            nBTTagCompound2.func_74782_a("CustomPotionEffects", nBTTagList);
        }
    }

    @Override
    public void func_70037_a(NBTTagCompound nBTTagCompound2) {
        NBTTagCompound nBTTagCompound2;
        super.func_70037_a(nBTTagCompound2);
        if (nBTTagCompound2.func_150297_b("Potion", 8)) {
            this.field_184560_g = PotionUtils.func_185187_c(nBTTagCompound2);
        }
        for (PotionEffect potionEffect : PotionUtils.func_185192_b(nBTTagCompound2)) {
            this.func_184558_a(potionEffect);
        }
        if (nBTTagCompound2.func_150297_b("Color", 99)) {
            this.func_191507_d(nBTTagCompound2.func_74762_e("Color"));
        } else {
            this.func_190548_o();
        }
    }

    @Override
    protected void func_184548_a(EntityLivingBase entityLivingBase) {
        super.func_184548_a(entityLivingBase);
        for (PotionEffect potionEffect : this.field_184560_g.func_185170_a()) {
            entityLivingBase.func_195064_c(new PotionEffect(potionEffect.func_188419_a(), Math.max(potionEffect.func_76459_b() / 8, 1), potionEffect.func_76458_c(), potionEffect.func_82720_e(), potionEffect.func_188418_e()));
        }
        if (!this.field_184561_h.isEmpty()) {
            for (PotionEffect potionEffect : this.field_184561_h) {
                entityLivingBase.func_195064_c(potionEffect);
            }
        }
    }

    @Override
    protected ItemStack func_184550_j() {
        if (this.field_184561_h.isEmpty() && this.field_184560_g == PotionTypes.field_185229_a) {
            return new ItemStack(Items.field_151032_g);
        }
        ItemStack itemStack = new ItemStack(Items.field_185167_i);
        PotionUtils.func_185188_a(itemStack, this.field_184560_g);
        PotionUtils.func_185184_a(itemStack, this.field_184561_h);
        if (this.field_191509_at) {
            itemStack.func_196082_o().func_74768_a("CustomPotionColor", this.func_184557_n());
        }
        return itemStack;
    }

    @Override
    public void func_70103_a(byte by2) {
        if (by2 == 0) {
            int n = this.func_184557_n();
            if (n != -1) {
                double d = (double)(n >> 16 & 0xFF) / 255.0;
                \u2603 = (double)(n >> 8 & 0xFF) / 255.0;
                \u2603 = (double)(n >> 0 & 0xFF) / 255.0;
                for (int i = 0; i < 20; ++i) {
                    this.field_70170_p.func_195594_a(Particles.field_197625_r, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N, d, \u2603, \u2603);
                }
            }
        } else {
            byte by2;
            super.func_70103_a(by2);
        }
    }
}

