/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemFireworkStar;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemFireworkRocket
extends Item {
    public ItemFireworkRocket(Item.Properties properties) {
        super(properties);
    }

    @Override
    public EnumActionResult func_195939_a(ItemUseContext itemUseContext) {
        World world = itemUseContext.func_195991_k();
        if (!world.field_72995_K) {
            BlockPos blockPos = itemUseContext.func_195995_a();
            ItemStack \u26032 = itemUseContext.func_195996_i();
            EntityFireworkRocket \u26033 = new EntityFireworkRocket(world, (float)blockPos.func_177958_n() + itemUseContext.func_195997_m(), (float)blockPos.func_177956_o() + itemUseContext.func_195993_n(), (float)blockPos.func_177952_p() + itemUseContext.func_195994_o(), \u26032);
            world.func_72838_d(\u26033);
            \u26032.func_190918_g(1);
        }
        return EnumActionResult.SUCCESS;
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer entityPlayer2, EnumHand enumHand) {
        EntityPlayer entityPlayer2;
        if (entityPlayer2.func_184613_cA()) {
            ItemStack itemStack = entityPlayer2.func_184586_b(enumHand);
            if (!world.field_72995_K) {
                EntityFireworkRocket entityFireworkRocket = new EntityFireworkRocket(world, itemStack, entityPlayer2);
                world.func_72838_d(entityFireworkRocket);
                if (!entityPlayer2.field_71075_bZ.field_75098_d) {
                    itemStack.func_190918_g(1);
                }
            }
            return new ActionResult<ItemStack>(EnumActionResult.SUCCESS, entityPlayer2.func_184586_b(enumHand));
        }
        return new ActionResult<ItemStack>(EnumActionResult.PASS, entityPlayer2.func_184586_b(enumHand));
    }

    @Override
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> list2, ITooltipFlag iTooltipFlag) {
        NBTTagCompound nBTTagCompound = itemStack.func_179543_a("Fireworks");
        if (nBTTagCompound == null) {
            return;
        }
        if (nBTTagCompound.func_150297_b("Flight", 99)) {
            list2.add(new TextComponentTranslation("item.minecraft.firework_rocket.flight", new Object[0]).func_150258_a(" ").func_150258_a(String.valueOf(nBTTagCompound.func_74771_c("Flight"))).func_211708_a(TextFormatting.GRAY));
        }
        if (!(\u2603 = nBTTagCompound.func_150295_c("Explosions", 10)).isEmpty()) {
            for (int i = 0; i < \u2603.size(); ++i) {
                List<ITextComponent> list2;
                NBTTagCompound nBTTagCompound2 = \u2603.func_150305_b(i);
                ArrayList \u26032 = Lists.newArrayList();
                ItemFireworkStar.func_195967_a(nBTTagCompound2, \u26032);
                if (\u26032.isEmpty()) continue;
                for (int j = 1; j < \u26032.size(); ++j) {
                    \u26032.set(j, new TextComponentString("  ").func_150257_a((ITextComponent)\u26032.get(j)).func_211708_a(TextFormatting.GRAY));
                }
                list2.addAll(\u26032);
            }
        }
    }

    public static enum Shape {
        SMALL_BALL(0, "small_ball"),
        LARGE_BALL(1, "large_ball"),
        STAR(2, "star"),
        CREEPER(3, "creeper"),
        BURST(4, "burst");

        private static final Shape[] field_196077_f;
        private final int field_196078_g;
        private final String field_196079_h;

        private Shape(int n2, String string2) {
            this.field_196078_g = n2;
            this.field_196079_h = string2;
        }

        public int func_196071_a() {
            return this.field_196078_g;
        }

        public String func_196068_b() {
            return this.field_196079_h;
        }

        public static Shape func_196070_a(int n) {
            if (n < 0 || n >= field_196077_f.length) {
                return SMALL_BALL;
            }
            return field_196077_f[n];
        }

        static {
            field_196077_f = (Shape[])Arrays.stream(Shape.values()).sorted(Comparator.comparingInt(shape -> shape.field_196078_g)).toArray(Shape[]::new);
        }
    }
}

