/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.fluid.IFluidState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMapBase;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.storage.MapData;

public class ItemMap
extends ItemMapBase {
    public ItemMap(Item.Properties properties) {
        super(properties);
    }

    public static ItemStack func_195952_a(World world, int n, int n2, byte by, boolean bl, boolean bl2) {
        ItemStack itemStack = new ItemStack(Items.field_151098_aY);
        ItemMap.func_195951_a(itemStack, world, n, n2, by, bl, bl2, world.field_73011_w.func_186058_p());
        return itemStack;
    }

    @Nullable
    public static MapData func_195950_a(ItemStack itemStack, World world) {
        MapData mapData = ItemMap.func_195953_a(world, "map_" + ItemMap.func_195949_f(itemStack));
        if (mapData == null && !world.field_72995_K) {
            mapData = ItemMap.func_195951_a(itemStack, world, world.func_72912_H().func_76079_c(), world.func_72912_H().func_76074_e(), 3, false, false, world.field_73011_w.func_186058_p());
        }
        return mapData;
    }

    public static int func_195949_f(ItemStack itemStack) {
        NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
        return nBTTagCompound != null && nBTTagCompound.func_150297_b("map", 99) ? nBTTagCompound.func_74762_e("map") : 0;
    }

    private static MapData func_195951_a(ItemStack itemStack, World world, int n, int n2, int n3, boolean bl, boolean bl2, DimensionType dimensionType) {
        int n4 = world.func_212410_a(DimensionType.OVERWORLD, "map");
        MapData \u26032 = new MapData("map_" + n4);
        \u26032.func_212440_a(n, n2, n3, bl, bl2, dimensionType);
        world.func_212409_a(DimensionType.OVERWORLD, \u26032.func_195925_e(), \u26032);
        itemStack.func_196082_o().func_74768_a("map", n4);
        return \u26032;
    }

    @Nullable
    public static MapData func_195953_a(IWorld iWorld, String string) {
        return iWorld.func_212411_a(DimensionType.OVERWORLD, MapData::new, string);
    }

    public void func_77872_a(World world2, Entity entity, MapData mapData) {
        if (world2.field_73011_w.func_186058_p() != mapData.field_76200_c || !(entity instanceof EntityPlayer)) {
            return;
        }
        int n = 1 << mapData.field_76197_d;
        \u2603 = mapData.field_76201_a;
        \u2603 = mapData.field_76199_b;
        \u2603 = MathHelper.func_76128_c(entity.field_70165_t - (double)\u2603) / n + 64;
        \u2603 = MathHelper.func_76128_c(entity.field_70161_v - (double)\u2603) / n + 64;
        \u2603 = 128 / n;
        if (world2.field_73011_w.func_177495_o()) {
            \u2603 /= 2;
        }
        MapData.MapInfo \u26032 = mapData.func_82568_a((EntityPlayer)entity);
        ++\u26032.field_82569_d;
        boolean \u26033 = false;
        for (\u2603 = \u2603 - \u2603 + 1; \u2603 < \u2603 + \u2603; ++\u2603) {
            if ((\u2603 & 0xF) != (\u26032.field_82569_d & 0xF) && !\u26033) continue;
            \u26033 = false;
            double d = 0.0;
            for (int i = \u2603 - \u2603 - 1; i < \u2603 + \u2603; ++i) {
                if (\u2603 < 0 || i < -1 || \u2603 >= 128 || i >= 128) continue;
                \u2603 = \u2603 - \u2603;
                \u2603 = i - \u2603;
                boolean bl = \u2603 * \u2603 + \u2603 * \u2603 > (\u2603 - 2) * (\u2603 - 2);
                int \u26034 = (\u2603 / n + \u2603 - 64) * n;
                int \u26035 = (\u2603 / n + i - 64) * n;
                LinkedHashMultiset \u26036 = LinkedHashMultiset.create();
                Chunk \u26037 = world2.func_175726_f(new BlockPos(\u26034, 0, \u26035));
                if (\u26037.func_76621_g()) continue;
                int \u26038 = \u26034 & 0xF;
                int \u26039 = \u26035 & 0xF;
                int \u260310 = 0;
                double \u260311 = 0.0;
                if (world2.field_73011_w.func_177495_o()) {
                    int n2 = \u26034 + \u26035 * 231871;
                    if (((n2 = n2 * n2 * 31287121 + n2 * 11) >> 20 & 1) == 0) {
                        \u26036.add((Object)Blocks.field_150346_d.func_176223_P().func_185909_g(world2, BlockPos.field_177992_a), 10);
                    } else {
                        \u26036.add((Object)Blocks.field_150348_b.func_176223_P().func_185909_g(world2, BlockPos.field_177992_a), 100);
                    }
                    \u260311 = 100.0;
                } else {
                    BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
                    for (int j = 0; j < n; ++j) {
                        for (\u260313 = 0; \u260313 < n; ++\u260313) {
                            IBlockState \u260312;
                            n3 = \u26037.func_201576_a(Heightmap.Type.WORLD_SURFACE, j + \u26038, \u260313 + \u26039) + 1;
                            if (n3 > 1) {
                                int n3;
                                do {
                                    \u260312 = \u26037.func_186032_a(j + \u26038, --n3, \u260313 + \u26039);
                                    mutableBlockPos.func_181079_c((\u26037.field_76635_g << 4) + j + \u26038, n3, (\u26037.field_76647_h << 4) + \u260313 + \u26039);
                                } while (\u260312.func_185909_g(world2, mutableBlockPos) == MaterialColor.field_151660_b && n3 > 0);
                                if (n3 > 0 && !\u260312.func_204520_s().func_206888_e()) {
                                    World world2;
                                    \u2603 = n3 - 1;
                                    do {
                                        IBlockState iBlockState = \u26037.func_186032_a(j + \u26038, \u2603--, \u260313 + \u26039);
                                        ++\u260310;
                                    } while (\u2603 > 0 && !iBlockState.func_204520_s().func_206888_e());
                                    \u260312 = this.func_211698_a(world2, \u260312, mutableBlockPos);
                                }
                            } else {
                                \u260312 = Blocks.field_150357_h.func_176223_P();
                            }
                            mapData.func_204268_a(world2, (\u26037.field_76635_g << 4) + j + \u26038, (\u26037.field_76647_h << 4) + \u260313 + \u26039);
                            \u260311 += (double)n3 / (double)(n * n);
                            \u26036.add((Object)\u260312.func_185909_g(world2, mutableBlockPos));
                        }
                    }
                }
                \u260310 /= n * n;
                double d2 = (\u260311 - d) * 4.0 / (double)(n + 4) + ((double)(\u2603 + i & 1) - 0.5) * 0.4;
                int \u260313 = 1;
                if (d2 > 0.6) {
                    \u260313 = 2;
                }
                if (d2 < -0.6) {
                    \u260313 = 0;
                }
                if ((\u2603 = (MaterialColor)Iterables.getFirst((Iterable)Multisets.copyHighestCountFirst((Multiset)\u26036), (Object)MaterialColor.field_151660_b)) == MaterialColor.field_151662_n) {
                    d2 = (double)\u260310 * 0.1 + (double)(\u2603 + i & 1) * 0.2;
                    \u260313 = 1;
                    if (d2 < 0.5) {
                        \u260313 = 2;
                    }
                    if (d2 > 0.9) {
                        \u260313 = 0;
                    }
                }
                d = \u260311;
                if (i < 0 || \u2603 * \u2603 + \u2603 * \u2603 >= \u2603 * \u2603 || bl && (\u2603 + i & 1) == 0 || (\u2603 = mapData.field_76198_e[\u2603 + i * 128]) == (\u2603 = (int)((byte)(\u2603.field_76290_q * 4 + \u260313)))) continue;
                mapData.field_76198_e[\u2603 + i * 128] = \u2603;
                mapData.func_176053_a(\u2603, i);
                \u26033 = true;
            }
        }
    }

    private IBlockState func_211698_a(World world, IBlockState iBlockState, BlockPos blockPos) {
        IFluidState iFluidState = iBlockState.func_204520_s();
        if (!iFluidState.func_206888_e() && !Block.func_208061_a(iBlockState.func_196952_d(world, blockPos), EnumFacing.UP)) {
            return iFluidState.func_206883_i();
        }
        return iBlockState;
    }

    private static boolean func_195954_a(Biome[] biomeArray, int n, int n2, int n3) {
        return biomeArray[n2 * n + n3 * n * 128 * n].func_185355_j() >= 0.0f;
    }

    public static void func_190905_a(World world, ItemStack itemStack) {
        MapData mapData = ItemMap.func_195950_a(itemStack, world);
        if (mapData == null) {
            return;
        }
        if (world.field_73011_w.func_186058_p() != mapData.field_76200_c) {
            return;
        }
        int \u26032 = 1 << mapData.field_76197_d;
        int \u26033 = mapData.field_76201_a;
        int \u26034 = mapData.field_76199_b;
        Biome[] \u26035 = world.func_72863_F().func_201711_g().func_202090_b().func_201537_a((\u26033 / \u26032 - 64) * \u26032, (\u26034 / \u26032 - 64) * \u26032, 128 * \u26032, 128 * \u26032, false);
        for (int i = 0; i < 128; ++i) {
            for (\u2603 = 0; \u2603 < 128; ++\u2603) {
                if (i <= 0 || \u2603 <= 0 || i >= 127 || \u2603 >= 127) continue;
                Biome biome = \u26035[i * \u26032 + \u2603 * \u26032 * 128 * \u26032];
                int \u26036 = 8;
                if (ItemMap.func_195954_a(\u26035, \u26032, i - 1, \u2603 - 1)) {
                    --\u26036;
                }
                if (ItemMap.func_195954_a(\u26035, \u26032, i - 1, \u2603 + 1)) {
                    --\u26036;
                }
                if (ItemMap.func_195954_a(\u26035, \u26032, i - 1, \u2603)) {
                    --\u26036;
                }
                if (ItemMap.func_195954_a(\u26035, \u26032, i + 1, \u2603 - 1)) {
                    --\u26036;
                }
                if (ItemMap.func_195954_a(\u26035, \u26032, i + 1, \u2603 + 1)) {
                    --\u26036;
                }
                if (ItemMap.func_195954_a(\u26035, \u26032, i + 1, \u2603)) {
                    --\u26036;
                }
                if (ItemMap.func_195954_a(\u26035, \u26032, i, \u2603 - 1)) {
                    --\u26036;
                }
                if (ItemMap.func_195954_a(\u26035, \u26032, i, \u2603 + 1)) {
                    --\u26036;
                }
                int \u26037 = 3;
                MaterialColor \u26038 = MaterialColor.field_151660_b;
                if (biome.func_185355_j() < 0.0f) {
                    \u26038 = MaterialColor.field_151676_q;
                    if (\u26036 > 7 && \u2603 % 2 == 0) {
                        \u26037 = (i + (int)(MathHelper.func_76126_a((float)\u2603 + 0.0f) * 7.0f)) / 8 % 5;
                        if (\u26037 == 3) {
                            \u26037 = 1;
                        } else if (\u26037 == 4) {
                            \u26037 = 0;
                        }
                    } else if (\u26036 > 7) {
                        \u26038 = MaterialColor.field_151660_b;
                    } else if (\u26036 > 5) {
                        \u26037 = 1;
                    } else if (\u26036 > 3) {
                        \u26037 = 0;
                    } else if (\u26036 > 1) {
                        \u26037 = 0;
                    }
                } else if (\u26036 > 0) {
                    \u26038 = MaterialColor.field_151650_B;
                    \u26037 = \u26036 > 3 ? 1 : 3;
                }
                if (\u26038 == MaterialColor.field_151660_b) continue;
                mapData.field_76198_e[i + \u2603 * 128] = (byte)(\u26038.field_76290_q * 4 + \u26037);
                mapData.func_176053_a(i, \u2603);
            }
        }
    }

    @Override
    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int n, boolean bl2) {
        boolean bl2;
        if (world.field_72995_K) {
            return;
        }
        MapData mapData = ItemMap.func_195950_a(itemStack, world);
        if (entity instanceof EntityPlayer) {
            EntityPlayer entityPlayer = (EntityPlayer)entity;
            mapData.func_76191_a(entityPlayer, itemStack);
        }
        if (bl2 || entity instanceof EntityPlayer && ((EntityPlayer)entity).func_184592_cb() == itemStack) {
            this.func_77872_a(world, entity, mapData);
        }
    }

    @Override
    @Nullable
    public Packet<?> func_150911_c(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        return ItemMap.func_195950_a(itemStack, world).func_176052_a(itemStack, world, entityPlayer);
    }

    @Override
    public void func_77622_d(ItemStack itemStack, World world, EntityPlayer entityPlayer) {
        NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
        if (nBTTagCompound != null && nBTTagCompound.func_150297_b("map_scale_direction", 99)) {
            ItemMap.func_185063_a(itemStack, world, nBTTagCompound.func_74762_e("map_scale_direction"));
            nBTTagCompound.func_82580_o("map_scale_direction");
        }
    }

    protected static void func_185063_a(ItemStack itemStack, World world, int n) {
        MapData mapData = ItemMap.func_195950_a(itemStack, world);
        if (mapData != null) {
            ItemMap.func_195951_a(itemStack, world, mapData.field_76201_a, mapData.field_76199_b, MathHelper.func_76125_a(mapData.field_76197_d + n, 0, 4), mapData.field_186210_e, mapData.field_191096_f, mapData.field_76200_c);
        }
    }

    @Override
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> list, ITooltipFlag iTooltipFlag) {
        if (iTooltipFlag.func_194127_a()) {
            MapData mapData = \u2603 = world == null ? null : ItemMap.func_195950_a(itemStack, world);
            if (\u2603 != null) {
                list.add(new TextComponentTranslation("filled_map.id", ItemMap.func_195949_f(itemStack)).func_211708_a(TextFormatting.GRAY));
                list.add(new TextComponentTranslation("filled_map.scale", 1 << \u2603.field_76197_d).func_211708_a(TextFormatting.GRAY));
                list.add(new TextComponentTranslation("filled_map.level", \u2603.field_76197_d, 4).func_211708_a(TextFormatting.GRAY));
            } else {
                list.add(new TextComponentTranslation("filled_map.unknown", new Object[0]).func_211708_a(TextFormatting.GRAY));
            }
        }
    }

    public static int func_190907_h(ItemStack itemStack) {
        NBTTagCompound nBTTagCompound = itemStack.func_179543_a("display");
        if (nBTTagCompound != null && nBTTagCompound.func_150297_b("MapColor", 99)) {
            int n = nBTTagCompound.func_74762_e("MapColor");
            return 0xFF000000 | n & 0xFFFFFF;
        }
        return -12173266;
    }

    @Override
    public EnumActionResult func_195939_a(ItemUseContext itemUseContext2) {
        ItemUseContext itemUseContext2;
        IBlockState iBlockState = itemUseContext2.func_195991_k().func_180495_p(itemUseContext2.func_195995_a());
        if (iBlockState.func_203425_a(BlockTags.field_202897_p)) {
            if (!itemUseContext2.field_196006_g.field_72995_K) {
                MapData mapData = ItemMap.func_195950_a(itemUseContext2.func_195996_i(), itemUseContext2.func_195991_k());
                mapData.func_204269_a(itemUseContext2.func_195991_k(), itemUseContext2.func_195995_a());
            }
            return EnumActionResult.SUCCESS;
        }
        return super.func_195939_a(itemUseContext2);
    }
}

