/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.gson.JsonParseException;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockWorldState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.arguments.BlockPredicateArgument;
import net.minecraft.command.arguments.BlockStateParser;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentDurability;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.EntityItemFrame;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemMap;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.INBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.stats.StatList;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.NetworkTagManager;
import net.minecraft.tags.Tag;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.World;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class ItemStack {
    private static final Logger field_199558_c = LogManager.getLogger();
    public static final ItemStack field_190927_a = new ItemStack((IItemProvider)null);
    public static final DecimalFormat field_111284_a = ItemStack.func_208306_D();
    private int field_77994_a;
    private int field_77992_b;
    @Deprecated
    private final Item field_151002_e;
    private NBTTagCompound field_77990_d;
    private boolean field_190928_g;
    private EntityItemFrame field_82843_f;
    private BlockWorldState field_179552_h;
    private boolean field_179553_i;
    private BlockWorldState field_179550_j;
    private boolean field_179551_k;

    private static DecimalFormat func_208306_D() {
        DecimalFormat decimalFormat = new DecimalFormat("#.##");
        decimalFormat.setDecimalFormatSymbols(DecimalFormatSymbols.getInstance(Locale.ROOT));
        return decimalFormat;
    }

    public ItemStack(IItemProvider iItemProvider) {
        this(iItemProvider, 1);
    }

    public ItemStack(IItemProvider iItemProvider, int n) {
        this.field_151002_e = iItemProvider == null ? null : iItemProvider.func_199767_j();
        this.field_77994_a = n;
        this.func_190923_F();
    }

    private void func_190923_F() {
        this.field_190928_g = false;
        this.field_190928_g = this.func_190926_b();
    }

    private ItemStack(NBTTagCompound nBTTagCompound) {
        Item item = IRegistry.field_212630_s.func_212608_b(new ResourceLocation(nBTTagCompound.func_74779_i("id")));
        this.field_151002_e = item == null ? Items.field_190931_a : item;
        this.field_77994_a = nBTTagCompound.func_74771_c("Count");
        if (nBTTagCompound.func_150297_b("tag", 10)) {
            this.field_77990_d = nBTTagCompound.func_74775_l("tag");
            this.func_77973_b().func_179215_a(nBTTagCompound);
        }
        if (this.func_77973_b().func_77645_m()) {
            this.func_196085_b(this.func_77952_i());
        }
        this.func_190923_F();
    }

    public static ItemStack func_199557_a(NBTTagCompound nBTTagCompound) {
        try {
            return new ItemStack(nBTTagCompound);
        }
        catch (RuntimeException runtimeException) {
            field_199558_c.debug("Tried to load invalid item: {}", (Object)nBTTagCompound, (Object)runtimeException);
            return field_190927_a;
        }
    }

    public boolean func_190926_b() {
        if (this == field_190927_a) {
            return true;
        }
        if (this.func_77973_b() == null || this.func_77973_b() == Items.field_190931_a) {
            return true;
        }
        return this.field_77994_a <= 0;
    }

    public ItemStack func_77979_a(int n) {
        \u2603 = Math.min(n, this.field_77994_a);
        ItemStack itemStack = this.func_77946_l();
        itemStack.func_190920_e(\u2603);
        this.func_190918_g(\u2603);
        return itemStack;
    }

    public Item func_77973_b() {
        return this.field_190928_g ? Items.field_190931_a : this.field_151002_e;
    }

    public EnumActionResult func_196084_a(ItemUseContext itemUseContext) {
        EntityPlayer entityPlayer = itemUseContext.func_195999_j();
        BlockPos \u26032 = itemUseContext.func_195995_a();
        BlockWorldState \u26033 = new BlockWorldState(itemUseContext.func_195991_k(), \u26032, false);
        if (entityPlayer != null && !entityPlayer.field_71075_bZ.field_75099_e && !this.func_206847_b(itemUseContext.func_195991_k().func_205772_D(), \u26033)) {
            return EnumActionResult.PASS;
        }
        Item \u26034 = this.func_77973_b();
        EnumActionResult \u26035 = \u26034.func_195939_a(itemUseContext);
        if (entityPlayer != null && \u26035 == EnumActionResult.SUCCESS) {
            entityPlayer.func_71029_a(StatList.field_75929_E.func_199076_b(\u26034));
        }
        return \u26035;
    }

    public float func_150997_a(IBlockState iBlockState) {
        return this.func_77973_b().func_150893_a(this, iBlockState);
    }

    public ActionResult<ItemStack> func_77957_a(World world, EntityPlayer entityPlayer, EnumHand enumHand) {
        return this.func_77973_b().func_77659_a(world, entityPlayer, enumHand);
    }

    public ItemStack func_77950_b(World world, EntityLivingBase entityLivingBase) {
        return this.func_77973_b().func_77654_b(this, world, entityLivingBase);
    }

    public NBTTagCompound func_77955_b(NBTTagCompound nBTTagCompound) {
        ResourceLocation resourceLocation = IRegistry.field_212630_s.func_177774_c(this.func_77973_b());
        nBTTagCompound.func_74778_a("id", resourceLocation == null ? "minecraft:air" : resourceLocation.toString());
        nBTTagCompound.func_74774_a("Count", (byte)this.field_77994_a);
        if (this.field_77990_d != null) {
            nBTTagCompound.func_74782_a("tag", this.field_77990_d);
        }
        return nBTTagCompound;
    }

    public int func_77976_d() {
        return this.func_77973_b().func_77639_j();
    }

    public boolean func_77985_e() {
        return this.func_77976_d() > 1 && (!this.func_77984_f() || !this.func_77951_h());
    }

    public boolean func_77984_f() {
        if (this.field_190928_g || this.func_77973_b().func_77612_l() <= 0) {
            return false;
        }
        NBTTagCompound nBTTagCompound = this.func_77978_p();
        return nBTTagCompound == null || !nBTTagCompound.func_74767_n("Unbreakable");
    }

    public boolean func_77951_h() {
        return this.func_77984_f() && this.func_77952_i() > 0;
    }

    public int func_77952_i() {
        return this.field_77990_d == null ? 0 : this.field_77990_d.func_74762_e("Damage");
    }

    public void func_196085_b(int n) {
        this.func_196082_o().func_74768_a("Damage", Math.max(0, n));
    }

    public int func_77958_k() {
        return this.func_77973_b().func_77612_l();
    }

    public boolean func_96631_a(int n, Random random, @Nullable EntityPlayerMP entityPlayerMP2) {
        EntityPlayerMP entityPlayerMP2;
        int \u26032;
        if (!this.func_77984_f()) {
            return false;
        }
        if (n > 0) {
            \u26032 = EnchantmentHelper.func_77506_a(Enchantments.field_185307_s, this);
            \u2603 = 0;
            for (\u2603 = 0; \u26032 > 0 && \u2603 < n; ++\u2603) {
                if (!EnchantmentDurability.func_92097_a(this, \u26032, random)) continue;
                ++\u2603;
            }
            if ((n -= \u2603) <= 0) {
                return false;
            }
        }
        if (entityPlayerMP2 != null && n != 0) {
            CriteriaTriggers.field_193132_s.func_193158_a(entityPlayerMP2, this, this.func_77952_i() + n);
        }
        \u26032 = this.func_77952_i() + n;
        this.func_196085_b(\u26032);
        return \u26032 >= this.func_77958_k();
    }

    public void func_77972_a(int n, EntityLivingBase entityLivingBase) {
        if (entityLivingBase instanceof EntityPlayer && ((EntityPlayer)entityLivingBase).field_71075_bZ.field_75098_d) {
            return;
        }
        if (!this.func_77984_f()) {
            return;
        }
        if (this.func_96631_a(n, entityLivingBase.func_70681_au(), entityLivingBase instanceof EntityPlayerMP ? (EntityPlayerMP)entityLivingBase : null)) {
            entityLivingBase.func_70669_a(this);
            Item item = this.func_77973_b();
            this.func_190918_g(1);
            if (entityLivingBase instanceof EntityPlayer) {
                ((EntityPlayer)entityLivingBase).func_71029_a(StatList.field_199088_e.func_199076_b(item));
            }
            this.func_196085_b(0);
        }
    }

    public void func_77961_a(EntityLivingBase entityLivingBase, EntityPlayer entityPlayer) {
        Item item = this.func_77973_b();
        if (item.func_77644_a(this, entityLivingBase, entityPlayer)) {
            entityPlayer.func_71029_a(StatList.field_75929_E.func_199076_b(item));
        }
    }

    public void func_179548_a(World world, IBlockState iBlockState, BlockPos blockPos, EntityPlayer entityPlayer) {
        Item item = this.func_77973_b();
        if (item.func_179218_a(this, world, iBlockState, blockPos, entityPlayer)) {
            entityPlayer.func_71029_a(StatList.field_75929_E.func_199076_b(item));
        }
    }

    public boolean func_150998_b(IBlockState iBlockState) {
        return this.func_77973_b().func_150897_b(iBlockState);
    }

    public boolean func_111282_a(EntityPlayer entityPlayer, EntityLivingBase entityLivingBase, EnumHand enumHand) {
        return this.func_77973_b().func_111207_a(this, entityPlayer, entityLivingBase, enumHand);
    }

    public ItemStack func_77946_l() {
        ItemStack itemStack = new ItemStack(this.func_77973_b(), this.field_77994_a);
        itemStack.func_190915_d(this.func_190921_D());
        if (this.field_77990_d != null) {
            itemStack.field_77990_d = this.field_77990_d.func_74737_b();
        }
        return itemStack;
    }

    public static boolean func_77970_a(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack.func_190926_b() && itemStack2.func_190926_b()) {
            return true;
        }
        if (itemStack.func_190926_b() || itemStack2.func_190926_b()) {
            return false;
        }
        if (itemStack.field_77990_d == null && itemStack2.field_77990_d != null) {
            return false;
        }
        return itemStack.field_77990_d == null || itemStack.field_77990_d.equals(itemStack2.field_77990_d);
    }

    public static boolean func_77989_b(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack.func_190926_b() && itemStack2.func_190926_b()) {
            return true;
        }
        if (itemStack.func_190926_b() || itemStack2.func_190926_b()) {
            return false;
        }
        return itemStack.func_77959_d(itemStack2);
    }

    private boolean func_77959_d(ItemStack itemStack) {
        if (this.field_77994_a != itemStack.field_77994_a) {
            return false;
        }
        if (this.func_77973_b() != itemStack.func_77973_b()) {
            return false;
        }
        if (this.field_77990_d == null && itemStack.field_77990_d != null) {
            return false;
        }
        return this.field_77990_d == null || this.field_77990_d.equals(itemStack.field_77990_d);
    }

    public static boolean func_179545_c(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack == itemStack2) {
            return true;
        }
        if (!itemStack.func_190926_b() && !itemStack2.func_190926_b()) {
            return itemStack.func_77969_a(itemStack2);
        }
        return false;
    }

    public static boolean func_185132_d(ItemStack itemStack, ItemStack itemStack2) {
        if (itemStack == itemStack2) {
            return true;
        }
        if (!itemStack.func_190926_b() && !itemStack2.func_190926_b()) {
            return itemStack.func_185136_b(itemStack2);
        }
        return false;
    }

    public boolean func_77969_a(ItemStack itemStack) {
        return !itemStack.func_190926_b() && this.func_77973_b() == itemStack.func_77973_b();
    }

    public boolean func_185136_b(ItemStack itemStack) {
        if (this.func_77984_f()) {
            return !itemStack.func_190926_b() && this.func_77973_b() == itemStack.func_77973_b();
        }
        return this.func_77969_a(itemStack);
    }

    public String func_77977_a() {
        return this.func_77973_b().func_77667_c(this);
    }

    public String toString() {
        return this.field_77994_a + "x" + this.func_77973_b().func_77658_a();
    }

    public void func_77945_a(World world, Entity entity, int n, boolean bl) {
        if (this.field_77992_b > 0) {
            --this.field_77992_b;
        }
        if (this.func_77973_b() != null) {
            this.func_77973_b().func_77663_a(this, world, entity, n, bl);
        }
    }

    public void func_77980_a(World world, EntityPlayer entityPlayer, int n) {
        entityPlayer.func_71064_a(StatList.field_188066_af.func_199076_b(this.func_77973_b()), n);
        this.func_77973_b().func_77622_d(this, world, entityPlayer);
    }

    public int func_77988_m() {
        return this.func_77973_b().func_77626_a(this);
    }

    public EnumAction func_77975_n() {
        return this.func_77973_b().func_77661_b(this);
    }

    public void func_77974_b(World world, EntityLivingBase entityLivingBase, int n) {
        this.func_77973_b().func_77615_a(this, world, entityLivingBase, n);
    }

    public boolean func_77942_o() {
        return !this.field_190928_g && this.field_77990_d != null && !this.field_77990_d.isEmpty();
    }

    @Nullable
    public NBTTagCompound func_77978_p() {
        return this.field_77990_d;
    }

    public NBTTagCompound func_196082_o() {
        if (this.field_77990_d == null) {
            this.func_77982_d(new NBTTagCompound());
        }
        return this.field_77990_d;
    }

    public NBTTagCompound func_190925_c(String string2) {
        String string2;
        if (this.field_77990_d == null || !this.field_77990_d.func_150297_b(string2, 10)) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            this.func_77983_a(string2, nBTTagCompound);
            return nBTTagCompound;
        }
        return this.field_77990_d.func_74775_l(string2);
    }

    @Nullable
    public NBTTagCompound func_179543_a(String string) {
        if (this.field_77990_d == null || !this.field_77990_d.func_150297_b(string, 10)) {
            return null;
        }
        return this.field_77990_d.func_74775_l(string);
    }

    public void func_196083_e(String string) {
        if (this.field_77990_d != null && this.field_77990_d.func_74764_b(string)) {
            this.field_77990_d.func_82580_o(string);
            if (this.field_77990_d.isEmpty()) {
                this.field_77990_d = null;
            }
        }
    }

    public NBTTagList func_77986_q() {
        if (this.field_77990_d != null) {
            return this.field_77990_d.func_150295_c("Enchantments", 10);
        }
        return new NBTTagList();
    }

    public void func_77982_d(@Nullable NBTTagCompound nBTTagCompound) {
        this.field_77990_d = nBTTagCompound;
    }

    public ITextComponent func_200301_q() {
        NBTTagCompound nBTTagCompound = this.func_179543_a("display");
        if (nBTTagCompound != null && nBTTagCompound.func_150297_b("Name", 8)) {
            try {
                ITextComponent iTextComponent = ITextComponent.Serializer.func_150699_a(nBTTagCompound.func_74779_i("Name"));
                if (iTextComponent != null) {
                    return iTextComponent;
                }
                nBTTagCompound.func_82580_o("Name");
            }
            catch (JsonParseException jsonParseException) {
                nBTTagCompound.func_82580_o("Name");
            }
        }
        return this.func_77973_b().func_200295_i(this);
    }

    public ItemStack func_200302_a(@Nullable ITextComponent iTextComponent) {
        NBTTagCompound nBTTagCompound = this.func_190925_c("display");
        if (iTextComponent != null) {
            nBTTagCompound.func_74778_a("Name", ITextComponent.Serializer.func_150696_a(iTextComponent));
        } else {
            nBTTagCompound.func_82580_o("Name");
        }
        return this;
    }

    public void func_135074_t() {
        NBTTagCompound nBTTagCompound = this.func_179543_a("display");
        if (nBTTagCompound != null) {
            nBTTagCompound.func_82580_o("Name");
            if (nBTTagCompound.isEmpty()) {
                this.func_196083_e("display");
            }
        }
        if (this.field_77990_d != null && this.field_77990_d.isEmpty()) {
            this.field_77990_d = null;
        }
    }

    public boolean func_82837_s() {
        NBTTagCompound nBTTagCompound = this.func_179543_a("display");
        return nBTTagCompound != null && nBTTagCompound.func_150297_b("Name", 8);
    }

    public List<ITextComponent> func_82840_a(@Nullable EntityPlayer entityPlayer, ITooltipFlag iTooltipFlag) {
        Object \u26034;
        int \u260352;
        Object object;
        ArrayList arrayList = Lists.newArrayList();
        ITextComponent \u26032 = new TextComponentString("").func_150257_a(this.func_200301_q()).func_211708_a(this.func_77953_t().field_77937_e);
        if (this.func_82837_s()) {
            \u26032.func_211708_a(TextFormatting.ITALIC);
        }
        arrayList.add(\u26032);
        if (!iTooltipFlag.func_194127_a() && !this.func_82837_s() && this.func_77973_b() == Items.field_151098_aY) {
            arrayList.add(new TextComponentString("#" + ItemMap.func_195949_f(this)).func_211708_a(TextFormatting.GRAY));
        }
        int \u26033 = 0;
        if (this.func_77942_o() && this.field_77990_d.func_150297_b("HideFlags", 99)) {
            \u26033 = this.field_77990_d.func_74762_e("HideFlags");
        }
        if ((\u26033 & 0x20) == 0) {
            this.func_77973_b().func_77624_a(this, entityPlayer == null ? null : entityPlayer.field_70170_p, arrayList, iTooltipFlag);
        }
        if (this.func_77942_o()) {
            if ((\u26033 & 1) == 0) {
                object = this.func_77986_q();
                for (\u260352 = 0; \u260352 < ((NBTTagList)object).size(); ++\u260352) {
                    NBTTagCompound nBTTagCompound = ((NBTTagList)object).func_150305_b(\u260352);
                    \u26034 = IRegistry.field_212628_q.func_212608_b(ResourceLocation.func_208304_a(nBTTagCompound.func_74779_i("id")));
                    if (\u26034 == null) continue;
                    arrayList.add(((Enchantment)\u26034).func_200305_d(nBTTagCompound.func_74762_e("lvl")));
                }
            }
            if (this.field_77990_d.func_150297_b("display", 10)) {
                object = this.field_77990_d.func_74775_l("display");
                if (((NBTTagCompound)object).func_150297_b("color", 3)) {
                    if (iTooltipFlag.func_194127_a()) {
                        arrayList.add(new TextComponentTranslation("item.color", String.format("#%06X", ((NBTTagCompound)object).func_74762_e("color"))).func_211708_a(TextFormatting.GRAY));
                    } else {
                        arrayList.add(new TextComponentTranslation("item.dyed", new Object[0]).func_211709_a(TextFormatting.GRAY, TextFormatting.ITALIC));
                    }
                }
                if (((NBTTagCompound)object).func_150299_b("Lore") == 9) {
                    NBTTagList \u260352 = ((NBTTagCompound)object).func_150295_c("Lore", 8);
                    for (int i = 0; i < \u260352.size(); ++i) {
                        arrayList.add(new TextComponentString(\u260352.func_150307_f(i)).func_211709_a(TextFormatting.DARK_PURPLE, TextFormatting.ITALIC));
                    }
                }
            }
        }
        object = EntityEquipmentSlot.values();
        \u260352 = ((EntityEquipmentSlot[])object).length;
        for (int i = 0; i < \u260352; ++i) {
            \u26034 = object[i];
            Multimap<String, AttributeModifier> multimap = this.func_111283_C((EntityEquipmentSlot)((Object)\u26034));
            if (multimap.isEmpty() || (\u26033 & 2) != 0) continue;
            arrayList.add(new TextComponentString(""));
            arrayList.add(new TextComponentTranslation("item.modifiers." + ((EntityEquipmentSlot)((Object)\u26034)).func_188450_d(), new Object[0]).func_211708_a(TextFormatting.GRAY));
            for (Map.Entry entry : multimap.entries()) {
                AttributeModifier attributeModifier = (AttributeModifier)entry.getValue();
                double \u26036 = attributeModifier.func_111164_d();
                boolean \u26037 = false;
                if (entityPlayer != null) {
                    if (attributeModifier.func_111167_a() == Item.field_111210_e) {
                        \u26036 += entityPlayer.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111125_b();
                        \u26036 += (double)EnchantmentHelper.func_152377_a(this, CreatureAttribute.UNDEFINED);
                        \u26037 = true;
                    } else if (attributeModifier.func_111167_a() == Item.field_185050_h) {
                        \u26036 += entityPlayer.func_110148_a(SharedMonsterAttributes.field_188790_f).func_111125_b();
                        \u26037 = true;
                    }
                }
                double \u26038 = attributeModifier.func_111169_c() == 1 || attributeModifier.func_111169_c() == 2 ? \u26036 * 100.0 : \u26036;
                if (\u26037) {
                    arrayList.add(new TextComponentString(" ").func_150257_a(new TextComponentTranslation("attribute.modifier.equals." + attributeModifier.func_111169_c(), field_111284_a.format(\u26038), new TextComponentTranslation("attribute.name." + (String)entry.getKey(), new Object[0]))).func_211708_a(TextFormatting.DARK_GREEN));
                    continue;
                }
                if (\u26036 > 0.0) {
                    arrayList.add(new TextComponentTranslation("attribute.modifier.plus." + attributeModifier.func_111169_c(), field_111284_a.format(\u26038), new TextComponentTranslation("attribute.name." + (String)entry.getKey(), new Object[0])).func_211708_a(TextFormatting.BLUE));
                    continue;
                }
                if (!(\u26036 < 0.0)) continue;
                arrayList.add(new TextComponentTranslation("attribute.modifier.take." + attributeModifier.func_111169_c(), field_111284_a.format(\u26038 *= -1.0), new TextComponentTranslation("attribute.name." + (String)entry.getKey(), new Object[0])).func_211708_a(TextFormatting.RED));
            }
        }
        if (this.func_77942_o() && this.func_77978_p().func_74767_n("Unbreakable") && (\u26033 & 4) == 0) {
            arrayList.add(new TextComponentTranslation("item.unbreakable", new Object[0]).func_211708_a(TextFormatting.BLUE));
        }
        if (this.func_77942_o() && this.field_77990_d.func_150297_b("CanDestroy", 9) && (\u26033 & 8) == 0 && !((NBTTagList)(object = this.field_77990_d.func_150295_c("CanDestroy", 8))).isEmpty()) {
            arrayList.add(new TextComponentString(""));
            arrayList.add(new TextComponentTranslation("item.canBreak", new Object[0]).func_211708_a(TextFormatting.GRAY));
            for (\u260352 = 0; \u260352 < ((NBTTagList)object).size(); ++\u260352) {
                arrayList.addAll(ItemStack.func_206845_f(((NBTTagList)object).func_150307_f(\u260352)));
            }
        }
        if (this.func_77942_o() && this.field_77990_d.func_150297_b("CanPlaceOn", 9) && (\u26033 & 0x10) == 0 && !((NBTTagList)(object = this.field_77990_d.func_150295_c("CanPlaceOn", 8))).isEmpty()) {
            arrayList.add(new TextComponentString(""));
            arrayList.add(new TextComponentTranslation("item.canPlace", new Object[0]).func_211708_a(TextFormatting.GRAY));
            for (\u260352 = 0; \u260352 < ((NBTTagList)object).size(); ++\u260352) {
                arrayList.addAll(ItemStack.func_206845_f(((NBTTagList)object).func_150307_f(\u260352)));
            }
        }
        if (iTooltipFlag.func_194127_a()) {
            if (this.func_77951_h()) {
                arrayList.add(new TextComponentTranslation("item.durability", this.func_77958_k() - this.func_77952_i(), this.func_77958_k()));
            }
            arrayList.add(new TextComponentString(IRegistry.field_212630_s.func_177774_c(this.func_77973_b()).toString()).func_211708_a(TextFormatting.DARK_GRAY));
            if (this.func_77942_o()) {
                arrayList.add(new TextComponentTranslation("item.nbt_tags", this.func_77978_p().func_150296_c().size()).func_211708_a(TextFormatting.DARK_GRAY));
            }
        }
        return arrayList;
    }

    private static Collection<ITextComponent> func_206845_f(String string) {
        try {
            BlockStateParser blockStateParser = new BlockStateParser(new StringReader(string), true).func_197243_a(true);
            IBlockState \u26032 = blockStateParser.func_197249_b();
            ResourceLocation \u26033 = blockStateParser.func_199829_d();
            boolean \u26034 = \u26032 != null;
            boolean bl = \u2603 = \u26033 != null;
            if (\u26034 || \u2603) {
                if (\u26034) {
                    return Lists.newArrayList((Iterable)\u26032.func_177230_c().func_200291_n().func_211708_a(TextFormatting.DARK_GRAY));
                }
                Tag<Block> tag = BlockTags.func_199896_a().func_199910_a(\u26033);
                if (tag != null && !(\u2603 = tag.func_199885_a()).isEmpty()) {
                    return \u2603.stream().map(Block::func_200291_n).map(iTextComponent -> iTextComponent.func_211708_a(TextFormatting.DARK_GRAY)).collect(Collectors.toList());
                }
            }
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return Lists.newArrayList((Iterable)new TextComponentString("missingno").func_211708_a(TextFormatting.DARK_GRAY));
    }

    public boolean func_77962_s() {
        return this.func_77973_b().func_77636_d(this);
    }

    public EnumRarity func_77953_t() {
        return this.func_77973_b().func_77613_e(this);
    }

    public boolean func_77956_u() {
        if (!this.func_77973_b().func_77616_k(this)) {
            return false;
        }
        return !this.func_77948_v();
    }

    public void func_77966_a(Enchantment enchantment, int n) {
        this.func_196082_o();
        if (!this.field_77990_d.func_150297_b("Enchantments", 9)) {
            this.field_77990_d.func_74782_a("Enchantments", new NBTTagList());
        }
        NBTTagList nBTTagList = this.field_77990_d.func_150295_c("Enchantments", 10);
        NBTTagCompound \u26032 = new NBTTagCompound();
        \u26032.func_74778_a("id", String.valueOf(IRegistry.field_212628_q.func_177774_c(enchantment)));
        \u26032.func_74777_a("lvl", (byte)n);
        nBTTagList.add(\u26032);
    }

    public boolean func_77948_v() {
        if (this.field_77990_d != null && this.field_77990_d.func_150297_b("Enchantments", 9)) {
            return !this.field_77990_d.func_150295_c("Enchantments", 10).isEmpty();
        }
        return false;
    }

    public void func_77983_a(String string, INBTBase iNBTBase) {
        this.func_196082_o().func_74782_a(string, iNBTBase);
    }

    public boolean func_82839_y() {
        return this.field_82843_f != null;
    }

    public void func_82842_a(@Nullable EntityItemFrame entityItemFrame) {
        this.field_82843_f = entityItemFrame;
    }

    @Nullable
    public EntityItemFrame func_82836_z() {
        return this.field_190928_g ? null : this.field_82843_f;
    }

    public int func_82838_A() {
        if (this.func_77942_o() && this.field_77990_d.func_150297_b("RepairCost", 3)) {
            return this.field_77990_d.func_74762_e("RepairCost");
        }
        return 0;
    }

    public void func_82841_c(int n) {
        this.func_196082_o().func_74768_a("RepairCost", n);
    }

    public Multimap<String, AttributeModifier> func_111283_C(EntityEquipmentSlot entityEquipmentSlot) {
        HashMultimap hashMultimap;
        if (this.func_77942_o() && this.field_77990_d.func_150297_b("AttributeModifiers", 9)) {
            hashMultimap = HashMultimap.create();
            NBTTagList \u26032 = this.field_77990_d.func_150295_c("AttributeModifiers", 10);
            for (int i = 0; i < \u26032.size(); ++i) {
                NBTTagCompound nBTTagCompound = \u26032.func_150305_b(i);
                AttributeModifier \u26033 = SharedMonsterAttributes.func_111259_a(nBTTagCompound);
                if (\u26033 == null || nBTTagCompound.func_150297_b("Slot", 8) && !nBTTagCompound.func_74779_i("Slot").equals(entityEquipmentSlot.func_188450_d()) || \u26033.func_111167_a().getLeastSignificantBits() == 0L || \u26033.func_111167_a().getMostSignificantBits() == 0L) continue;
                hashMultimap.put((Object)nBTTagCompound.func_74779_i("AttributeName"), (Object)\u26033);
            }
        } else {
            hashMultimap = this.func_77973_b().func_111205_h(entityEquipmentSlot);
        }
        return hashMultimap;
    }

    public void func_185129_a(String string, AttributeModifier attributeModifier, @Nullable EntityEquipmentSlot entityEquipmentSlot) {
        this.func_196082_o();
        if (!this.field_77990_d.func_150297_b("AttributeModifiers", 9)) {
            this.field_77990_d.func_74782_a("AttributeModifiers", new NBTTagList());
        }
        NBTTagList nBTTagList = this.field_77990_d.func_150295_c("AttributeModifiers", 10);
        NBTTagCompound \u26032 = SharedMonsterAttributes.func_111262_a(attributeModifier);
        \u26032.func_74778_a("AttributeName", string);
        if (entityEquipmentSlot != null) {
            \u26032.func_74778_a("Slot", entityEquipmentSlot.func_188450_d());
        }
        nBTTagList.add(\u26032);
    }

    public ITextComponent func_151000_E() {
        ITextComponent iTextComponent;
        ITextComponent iTextComponent2 = new TextComponentString("").func_150257_a(this.func_200301_q());
        if (this.func_82837_s()) {
            iTextComponent2.func_211708_a(TextFormatting.ITALIC);
        }
        iTextComponent = TextComponentUtils.func_197676_a(iTextComponent2);
        if (!this.field_190928_g) {
            NBTTagCompound nBTTagCompound = this.func_77955_b(new NBTTagCompound());
            iTextComponent.func_211708_a(this.func_77953_t().field_77937_e).func_211710_a(style -> style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_ITEM, new TextComponentString(nBTTagCompound.toString()))));
        }
        return iTextComponent;
    }

    private static boolean func_206846_a(BlockWorldState blockWorldState, @Nullable BlockWorldState blockWorldState2) {
        if (blockWorldState2 == null || blockWorldState.func_177509_a() != blockWorldState2.func_177509_a()) {
            return false;
        }
        if (blockWorldState.func_177507_b() == null && blockWorldState2.func_177507_b() == null) {
            return true;
        }
        if (blockWorldState.func_177507_b() == null || blockWorldState2.func_177507_b() == null) {
            return false;
        }
        return Objects.equals(blockWorldState.func_177507_b().func_189515_b(new NBTTagCompound()), blockWorldState2.func_177507_b().func_189515_b(new NBTTagCompound()));
    }

    public boolean func_206848_a(NetworkTagManager networkTagManager, BlockWorldState blockWorldState) {
        if (ItemStack.func_206846_a(blockWorldState, this.field_179552_h)) {
            return this.field_179553_i;
        }
        this.field_179552_h = blockWorldState;
        if (this.func_77942_o() && this.field_77990_d.func_150297_b("CanDestroy", 9)) {
            NBTTagList nBTTagList = this.field_77990_d.func_150295_c("CanDestroy", 8);
            for (int i = 0; i < nBTTagList.size(); ++i) {
                String string = nBTTagList.func_150307_f(i);
                try {
                    Predicate<BlockWorldState> predicate = BlockPredicateArgument.func_199824_a().parse(new StringReader(string)).create(networkTagManager);
                    if (predicate.test(blockWorldState)) {
                        this.field_179553_i = true;
                        return true;
                    }
                    continue;
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
            }
        }
        this.field_179553_i = false;
        return false;
    }

    public boolean func_206847_b(NetworkTagManager networkTagManager, BlockWorldState blockWorldState) {
        if (ItemStack.func_206846_a(blockWorldState, this.field_179550_j)) {
            return this.field_179551_k;
        }
        this.field_179550_j = blockWorldState;
        if (this.func_77942_o() && this.field_77990_d.func_150297_b("CanPlaceOn", 9)) {
            NBTTagList nBTTagList = this.field_77990_d.func_150295_c("CanPlaceOn", 8);
            for (int i = 0; i < nBTTagList.size(); ++i) {
                String string = nBTTagList.func_150307_f(i);
                try {
                    Predicate<BlockWorldState> predicate = BlockPredicateArgument.func_199824_a().parse(new StringReader(string)).create(networkTagManager);
                    if (predicate.test(blockWorldState)) {
                        this.field_179551_k = true;
                        return true;
                    }
                    continue;
                }
                catch (CommandSyntaxException commandSyntaxException) {
                    // empty catch block
                }
            }
        }
        this.field_179551_k = false;
        return false;
    }

    public int func_190921_D() {
        return this.field_77992_b;
    }

    public void func_190915_d(int n) {
        this.field_77992_b = n;
    }

    public int func_190916_E() {
        return this.field_190928_g ? 0 : this.field_77994_a;
    }

    public void func_190920_e(int n) {
        this.field_77994_a = n;
        this.func_190923_F();
    }

    public void func_190917_f(int n) {
        this.func_190920_e(this.field_77994_a + n);
    }

    public void func_190918_g(int n) {
        this.func_190917_f(-n);
    }
}

