/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemWritableBook;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.play.server.SPacketSetSlot;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.StringUtils;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemWrittenBook
extends Item {
    public ItemWrittenBook(Item.Properties properties) {
        super(properties);
    }

    public static boolean func_77828_a(@Nullable NBTTagCompound nBTTagCompound) {
        if (!ItemWritableBook.func_150930_a(nBTTagCompound)) {
            return false;
        }
        if (!nBTTagCompound.func_150297_b("title", 8)) {
            return false;
        }
        String string = nBTTagCompound.func_74779_i("title");
        if (string.length() > 32) {
            return false;
        }
        return nBTTagCompound.func_150297_b("author", 8);
    }

    public static int func_179230_h(ItemStack itemStack) {
        return itemStack.func_77978_p().func_74762_e("generation");
    }

    @Override
    public ITextComponent func_200295_i(ItemStack itemStack) {
        if (itemStack.func_77942_o() && !StringUtils.func_151246_b(\u2603 = (\u2603 = itemStack.func_77978_p()).func_74779_i("title"))) {
            return new TextComponentString(\u2603);
        }
        return super.func_200295_i(itemStack);
    }

    @Override
    public void func_77624_a(ItemStack itemStack, @Nullable World world, List<ITextComponent> list, ITooltipFlag iTooltipFlag) {
        if (itemStack.func_77942_o()) {
            NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
            String \u26032 = nBTTagCompound.func_74779_i("author");
            if (!StringUtils.func_151246_b(\u26032)) {
                list.add(new TextComponentTranslation("book.byAuthor", \u26032).func_211708_a(TextFormatting.GRAY));
            }
            list.add(new TextComponentTranslation("book.generation." + nBTTagCompound.func_74762_e("generation"), new Object[0]).func_211708_a(TextFormatting.GRAY));
        }
    }

    @Override
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer entityPlayer, EnumHand enumHand) {
        ItemStack itemStack = entityPlayer.func_184586_b(enumHand);
        if (!world.field_72995_K) {
            this.func_179229_a(itemStack, entityPlayer);
        }
        entityPlayer.func_184814_a(itemStack, enumHand);
        entityPlayer.func_71029_a(StatList.field_75929_E.func_199076_b(this));
        return new ActionResult<ItemStack>(EnumActionResult.SUCCESS, itemStack);
    }

    private void func_179229_a(ItemStack itemStack, EntityPlayer entityPlayer) {
        NBTTagCompound nBTTagCompound = itemStack.func_77978_p();
        if (nBTTagCompound == null || nBTTagCompound.func_74767_n("resolved")) {
            return;
        }
        nBTTagCompound.func_74757_a("resolved", true);
        if (!ItemWrittenBook.func_77828_a(nBTTagCompound)) {
            return;
        }
        NBTTagList \u26032 = nBTTagCompound.func_150295_c("pages", 8);
        for (int i = 0; i < \u26032.size(); ++i) {
            ITextComponent iTextComponent;
            String string = \u26032.func_150307_f(i);
            try {
                iTextComponent = ITextComponent.Serializer.func_186877_b(string);
                iTextComponent = TextComponentUtils.func_197680_a(entityPlayer.func_195051_bN(), iTextComponent, entityPlayer);
            }
            catch (Exception exception) {
                iTextComponent = new TextComponentString(string);
            }
            \u26032.set(i, new NBTTagString(ITextComponent.Serializer.func_150696_a(iTextComponent)));
        }
        nBTTagCompound.func_74782_a("pages", \u26032);
        if (entityPlayer instanceof EntityPlayerMP && entityPlayer.func_184614_ca() == itemStack) {
            Slot slot = entityPlayer.field_71070_bA.func_75147_a(entityPlayer.field_71071_by, entityPlayer.field_71071_by.field_70461_c);
            ((EntityPlayerMP)entityPlayer).field_71135_a.func_147359_a(new SPacketSetSlot(0, slot.field_75222_d, itemStack));
        }
    }

    @Override
    public boolean func_77636_d(ItemStack itemStack) {
        return true;
    }
}

