/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.item.crafting;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeSerializers;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.IRegistry;
import net.minecraft.world.World;

public class ShapedRecipe
implements IRecipe {
    private final int field_77576_b;
    private final int field_77577_c;
    private final NonNullList<Ingredient> field_77574_d;
    private final ItemStack field_77575_e;
    private final ResourceLocation field_199561_e;
    private final String field_194137_e;

    public ShapedRecipe(ResourceLocation resourceLocation, String string, int n, int n2, NonNullList<Ingredient> nonNullList, ItemStack itemStack) {
        this.field_199561_e = resourceLocation;
        this.field_194137_e = string;
        this.field_77576_b = n;
        this.field_77577_c = n2;
        this.field_77574_d = nonNullList;
        this.field_77575_e = itemStack;
    }

    @Override
    public ResourceLocation func_199560_c() {
        return this.field_199561_e;
    }

    @Override
    public IRecipeSerializer<?> func_199559_b() {
        return RecipeSerializers.field_199575_a;
    }

    @Override
    public String func_193358_e() {
        return this.field_194137_e;
    }

    @Override
    public ItemStack func_77571_b() {
        return this.field_77575_e;
    }

    @Override
    public NonNullList<Ingredient> func_192400_c() {
        return this.field_77574_d;
    }

    @Override
    public boolean func_194133_a(int n, int n2) {
        return n >= this.field_77576_b && n2 >= this.field_77577_c;
    }

    @Override
    public boolean func_77569_a(IInventory iInventory, World world) {
        if (!(iInventory instanceof InventoryCrafting)) {
            return false;
        }
        for (int i = 0; i <= iInventory.func_174922_i() - this.field_77576_b; ++i) {
            for (\u2603 = 0; \u2603 <= iInventory.func_174923_h() - this.field_77577_c; ++\u2603) {
                if (this.func_77573_a(iInventory, i, \u2603, true)) {
                    return true;
                }
                if (!this.func_77573_a(iInventory, i, \u2603, false)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean func_77573_a(IInventory iInventory, int n, int n2, boolean bl) {
        for (int i = 0; i < iInventory.func_174922_i(); ++i) {
            for (\u2603 = 0; \u2603 < iInventory.func_174923_h(); ++\u2603) {
                \u2603 = i - n;
                \u2603 = \u2603 - n2;
                Ingredient ingredient = Ingredient.field_193370_a;
                if (\u2603 >= 0 && \u2603 >= 0 && \u2603 < this.field_77576_b && \u2603 < this.field_77577_c) {
                    ingredient = bl ? this.field_77574_d.get(this.field_77576_b - \u2603 - 1 + \u2603 * this.field_77576_b) : this.field_77574_d.get(\u2603 + \u2603 * this.field_77576_b);
                }
                if (ingredient.test(iInventory.func_70301_a(i + \u2603 * iInventory.func_174922_i()))) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public ItemStack func_77572_b(IInventory iInventory) {
        return this.func_77571_b().func_77946_l();
    }

    public int func_192403_f() {
        return this.field_77576_b;
    }

    public int func_192404_g() {
        return this.field_77577_c;
    }

    private static NonNullList<Ingredient> func_192402_a(String[] stringArray, Map<String, Ingredient> map, int n, int n2) {
        NonNullList<Ingredient> nonNullList = NonNullList.func_191197_a(n * n2, Ingredient.field_193370_a);
        HashSet \u26032 = Sets.newHashSet(map.keySet());
        \u26032.remove(" ");
        for (int i = 0; i < stringArray.length; ++i) {
            for (\u2603 = 0; \u2603 < stringArray[i].length(); ++\u2603) {
                String string = stringArray[i].substring(\u2603, \u2603 + 1);
                Ingredient \u26033 = map.get(string);
                if (\u26033 == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + string + "' but it's not defined in the key");
                }
                \u26032.remove(string);
                nonNullList.set(\u2603 + n * i, \u26033);
            }
        }
        if (!\u26032.isEmpty()) {
            throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + \u26032);
        }
        return nonNullList;
    }

    @VisibleForTesting
    static String[] func_194134_a(String ... stringArray) {
        int \u26035;
        int \u26034;
        int \u26032 = Integer.MAX_VALUE;
        \u26034 = 0;
        \u2603 = 0;
        \u26035 = 0;
        for (\u2603 = 0; \u2603 < stringArray.length; ++\u2603) {
            String string = stringArray[\u2603];
            \u26032 = Math.min(\u26032, ShapedRecipe.func_194135_a(string));
            int \u26033 = ShapedRecipe.func_194136_b(string);
            \u26034 = Math.max(\u26034, \u26033);
            if (\u26033 < 0) {
                if (\u2603 == \u2603) {
                    ++\u2603;
                }
                ++\u26035;
                continue;
            }
            \u26035 = 0;
        }
        if (stringArray.length == \u26035) {
            return new String[0];
        }
        String[] stringArray2 = new String[stringArray.length - \u26035 - \u2603];
        for (int i = 0; i < stringArray2.length; ++i) {
            stringArray2[i] = stringArray[i + \u2603].substring(\u26032, \u26034 + 1);
        }
        return stringArray2;
    }

    private static int func_194135_a(String string) {
        int n;
        for (n = 0; n < string.length() && string.charAt(n) == ' '; ++n) {
        }
        return n;
    }

    private static int func_194136_b(String string) {
        int n;
        for (n = string.length() - 1; n >= 0 && string.charAt(n) == ' '; --n) {
        }
        return n;
    }

    private static String[] func_192407_a(JsonArray jsonArray) {
        String[] stringArray = new String[jsonArray.size()];
        if (stringArray.length > 3) {
            throw new JsonSyntaxException("Invalid pattern: too many rows, 3 is maximum");
        }
        if (stringArray.length == 0) {
            throw new JsonSyntaxException("Invalid pattern: empty pattern not allowed");
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = JsonUtils.func_151206_a(jsonArray.get(i), "pattern[" + i + "]");
            if (string.length() > 3) {
                throw new JsonSyntaxException("Invalid pattern: too many columns, 3 is maximum");
            }
            if (i > 0 && stringArray[0].length() != string.length()) {
                throw new JsonSyntaxException("Invalid pattern: each row must be the same width");
            }
            stringArray[i] = string;
        }
        return stringArray;
    }

    private static Map<String, Ingredient> func_192408_a(JsonObject jsonObject) {
        HashMap hashMap = Maps.newHashMap();
        for (Map.Entry entry : jsonObject.entrySet()) {
            if (((String)entry.getKey()).length() != 1) {
                throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 character only).");
            }
            if (" ".equals(entry.getKey())) {
                throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
            }
            hashMap.put(entry.getKey(), Ingredient.func_199802_a((JsonElement)entry.getValue()));
        }
        hashMap.put(" ", Ingredient.field_193370_a);
        return hashMap;
    }

    public static ItemStack func_199798_a(JsonObject jsonObject) {
        String string = JsonUtils.func_151200_h(jsonObject, "item");
        Item \u26032 = IRegistry.field_212630_s.func_212608_b(new ResourceLocation(string));
        if (\u26032 == null) {
            throw new JsonSyntaxException("Unknown item '" + string + "'");
        }
        if (jsonObject.has("data")) {
            throw new JsonParseException("Disallowed data tag found");
        }
        int \u26033 = JsonUtils.func_151208_a(jsonObject, "count", 1);
        return new ItemStack(\u26032, \u26033);
    }

    public static class Serializer
    implements IRecipeSerializer<ShapedRecipe> {
        @Override
        public ShapedRecipe func_199425_a_(ResourceLocation resourceLocation, JsonObject jsonObject) {
            String string = JsonUtils.func_151219_a(jsonObject, "group", "");
            Map \u26032 = ShapedRecipe.func_192408_a(JsonUtils.func_152754_s(jsonObject, "key"));
            String[] \u26033 = ShapedRecipe.func_194134_a(ShapedRecipe.func_192407_a(JsonUtils.func_151214_t(jsonObject, "pattern")));
            int \u26034 = \u26033[0].length();
            int \u26035 = \u26033.length;
            NonNullList \u26036 = ShapedRecipe.func_192402_a(\u26033, \u26032, \u26034, \u26035);
            ItemStack \u26037 = ShapedRecipe.func_199798_a(JsonUtils.func_152754_s(jsonObject, "result"));
            return new ShapedRecipe(resourceLocation, string, \u26034, \u26035, \u26036, \u26037);
        }

        @Override
        public String func_199567_a() {
            return "crafting_shaped";
        }

        @Override
        public ShapedRecipe func_199426_a_(ResourceLocation resourceLocation, PacketBuffer packetBuffer) {
            int n = packetBuffer.func_150792_a();
            \u2603 = packetBuffer.func_150792_a();
            String \u26032 = packetBuffer.func_150789_c(Short.MAX_VALUE);
            NonNullList<Ingredient> \u26033 = NonNullList.func_191197_a(n * \u2603, Ingredient.field_193370_a);
            for (\u2603 = 0; \u2603 < \u26033.size(); ++\u2603) {
                \u26033.set(\u2603, Ingredient.func_199566_b(packetBuffer));
            }
            ItemStack \u26034 = packetBuffer.func_150791_c();
            return new ShapedRecipe(resourceLocation, \u26032, n, \u2603, \u26033, \u26034);
        }

        @Override
        public void func_199427_a_(PacketBuffer packetBuffer2, ShapedRecipe shapedRecipe) {
            PacketBuffer packetBuffer2;
            packetBuffer2.func_150787_b(shapedRecipe.field_77576_b);
            packetBuffer2.func_150787_b(shapedRecipe.field_77577_c);
            packetBuffer2.func_180714_a(shapedRecipe.field_194137_e);
            for (Ingredient ingredient : shapedRecipe.field_77574_d) {
                ingredient.func_199564_a(packetBuffer2);
            }
            packetBuffer2.func_150788_a(shapedRecipe.field_77575_e);
        }

        @Override
        public /* synthetic */ IRecipe func_199426_a_(ResourceLocation resourceLocation, PacketBuffer packetBuffer) {
            return this.func_199426_a_(resourceLocation, packetBuffer);
        }

        @Override
        public /* synthetic */ IRecipe func_199425_a_(ResourceLocation resourceLocation, JsonObject jsonObject) {
            return this.func_199425_a_(resourceLocation, jsonObject);
        }
    }
}

